/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.JmmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.NetworkTopologyEvent;
import javax.jmdns.NetworkTopologyListener;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.NetworkTopologyEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class JmmDNSImpl
implements JmmDNS,
NetworkTopologyListener,
ServiceInfoImpl.Delegate {
    private static Logger logger = Logger.getLogger(JmmDNSImpl.class.getName());
    private final Set<NetworkTopologyListener> _networkListeners = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<InetAddress, JmDNS> _knownMDNS = new ConcurrentHashMap<InetAddress, JmDNS>();
    private final ConcurrentMap<String, ServiceInfo> _services = new ConcurrentHashMap<String, ServiceInfo>(20);
    private final ExecutorService _ListenerExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService _jmDNSExecutor = Executors.newCachedThreadPool();
    private final Timer _timer = new Timer("Multihommed mDNS.Timer", true);

    public JmmDNSImpl() {
        new NetworkChecker(this, NetworkTopologyDiscovery.Factory.getInstance()).start(this._timer);
    }

    @Override
    public void close() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cancelling JmmDNS: " + this);
        }
        this._timer.cancel();
        this._ListenerExecutor.shutdown();
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (final JmDNS jmDNS : this._knownMDNS.values()) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        jmDNS.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "Exception ", interruptedException);
        }
        this._knownMDNS.clear();
    }

    @Override
    public String[] getNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            hashSet.add(jmDNS.getName());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public String[] getHostNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            hashSet.add(jmDNS.getHostName());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public InetAddress[] getInterfaces() throws IOException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            hashSet.add(jmDNS.getInterface());
        }
        return hashSet.toArray(new InetAddress[hashSet.size()]);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String string, String string2) {
        return this.getServiceInfos(string, string2, false, 6000L);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String string, String string2, long l) {
        return this.getServiceInfos(string, string2, false, l);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String string, String string2, boolean bl) {
        return this.getServiceInfos(string, string2, bl, 6000L);
    }

    @Override
    public ServiceInfo[] getServiceInfos(final String string, final String string2, final boolean bl, final long l) {
        final Set set = Collections.synchronizedSet(new HashSet(this._knownMDNS.size()));
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (final JmDNS jmDNS : this._knownMDNS.values()) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    set.add(jmDNS.getServiceInfo(string, string2, bl, l));
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "Exception ", interruptedException);
        }
        return set.toArray(new ServiceInfo[set.size()]);
    }

    @Override
    public void requestServiceInfo(String string, String string2) {
        this.requestServiceInfo(string, string2, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String string, String string2, boolean bl) {
        this.requestServiceInfo(string, string2, bl, 6000L);
    }

    @Override
    public void requestServiceInfo(String string, String string2, long l) {
        this.requestServiceInfo(string, string2, false, l);
    }

    @Override
    public void requestServiceInfo(final String string, final String string2, final boolean bl, final long l) {
        for (final JmDNS jmDNS : this._knownMDNS.values()) {
            this._jmDNSExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    jmDNS.requestServiceInfo(string, string2, bl, l);
                }
            });
        }
    }

    @Override
    public void addServiceTypeListener(ServiceTypeListener serviceTypeListener) throws IOException {
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            jmDNS.addServiceTypeListener(serviceTypeListener);
        }
    }

    @Override
    public void removeServiceTypeListener(ServiceTypeListener serviceTypeListener) {
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            jmDNS.removeServiceTypeListener(serviceTypeListener);
        }
    }

    @Override
    public void addServiceListener(String string, ServiceListener serviceListener) {
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            jmDNS.addServiceListener(string, serviceListener);
        }
    }

    @Override
    public void removeServiceListener(String string, ServiceListener serviceListener) {
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            jmDNS.removeServiceListener(string, serviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void textValueUpdated(ServiceInfo serviceInfo, byte[] byArray) {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS jmDNS : this._knownMDNS.values()) {
                ServiceInfo serviceInfo2 = ((JmDNSImpl)jmDNS).getServices().get(serviceInfo.getQualifiedName());
                if (serviceInfo2 != null) {
                    serviceInfo2.setText(byArray);
                    continue;
                }
                logger.warning("We have a mDNS that does not know about the service info being updated.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(ServiceInfo serviceInfo) throws IOException {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS jmDNS : this._knownMDNS.values()) {
                jmDNS.registerService(serviceInfo.clone());
            }
            ((ServiceInfoImpl)serviceInfo).setDelegate(this);
            this._services.put(serviceInfo.getQualifiedName(), serviceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(ServiceInfo serviceInfo) {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS jmDNS : this._knownMDNS.values()) {
                jmDNS.unregisterService(serviceInfo);
            }
            ((ServiceInfoImpl)serviceInfo).setDelegate(null);
            this._services.remove(serviceInfo.getQualifiedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllServices() {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS jmDNS : this._knownMDNS.values()) {
                jmDNS.unregisterAllServices();
            }
            this._services.clear();
        }
    }

    @Override
    public void registerServiceType(String string) {
        for (JmDNS jmDNS : this._knownMDNS.values()) {
            jmDNS.registerServiceType(string);
        }
    }

    @Override
    public ServiceInfo[] list(String string) {
        return this.list(string, 6000L);
    }

    @Override
    public ServiceInfo[] list(final String string, final long l) {
        final Set set = Collections.synchronizedSet(new HashSet(this._knownMDNS.size() * 5));
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (final JmDNS jmDNS : this._knownMDNS.values()) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    set.addAll(Arrays.asList(jmDNS.list(string, l)));
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "Exception ", interruptedException);
        }
        return set.toArray(new ServiceInfo[set.size()]);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String string) {
        return this.listBySubtype(string, 6000L);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String string, long l) {
        HashMap hashMap = new HashMap(5);
        for (ServiceInfo object : this.list(string, l)) {
            String string2 = object.getSubtype();
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, new ArrayList(10));
            }
            ((List)hashMap.get(string2)).add(object);
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (String string3 : hashMap.keySet()) {
            List list = (List)hashMap.get(string3);
            hashMap2.put(string3, list.toArray(new ServiceInfo[list.size()]));
        }
        return hashMap2;
    }

    @Override
    public void addNetworkTopologyListener(NetworkTopologyListener networkTopologyListener) {
        this._networkListeners.add(networkTopologyListener);
    }

    @Override
    public void removeNetworkTopologyListener(NetworkTopologyListener networkTopologyListener) {
        this._networkListeners.remove(networkTopologyListener);
    }

    @Override
    public NetworkTopologyListener[] networkListeners() {
        return this._networkListeners.toArray(new NetworkTopologyListener[this._networkListeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inetAddressAdded(NetworkTopologyEvent networkTopologyEvent) {
        InetAddress inetAddress = networkTopologyEvent.getInetAddress();
        try {
            JmmDNSImpl jmmDNSImpl = this;
            synchronized (jmmDNSImpl) {
                if (!this._knownMDNS.containsKey(inetAddress)) {
                    this._knownMDNS.put(inetAddress, JmDNS.create(inetAddress));
                    final NetworkTopologyEventImpl networkTopologyEventImpl = new NetworkTopologyEventImpl((JmDNS)this._knownMDNS.get(inetAddress), inetAddress);
                    for (final NetworkTopologyListener networkTopologyListener : this.networkListeners()) {
                        this._ListenerExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                networkTopologyListener.inetAddressAdded(networkTopologyEventImpl);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.warning("Unexpected unhandled exception: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inetAddressRemoved(NetworkTopologyEvent networkTopologyEvent) {
        InetAddress inetAddress = networkTopologyEvent.getInetAddress();
        try {
            JmmDNSImpl jmmDNSImpl = this;
            synchronized (jmmDNSImpl) {
                if (this._knownMDNS.containsKey(inetAddress)) {
                    JmDNS jmDNS = (JmDNS)this._knownMDNS.remove(inetAddress);
                    jmDNS.close();
                    final NetworkTopologyEventImpl networkTopologyEventImpl = new NetworkTopologyEventImpl(jmDNS, inetAddress);
                    for (final NetworkTopologyListener networkTopologyListener : this.networkListeners()) {
                        this._ListenerExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                networkTopologyListener.inetAddressRemoved(networkTopologyEventImpl);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.warning("Unexpected unhandled exception: " + exception);
        }
    }

    static class NetworkChecker
    extends TimerTask {
        private static Logger logger1 = Logger.getLogger(NetworkChecker.class.getName());
        private final NetworkTopologyListener _mmDNS;
        private final NetworkTopologyDiscovery _topology;
        private Set<InetAddress> _knownAddresses;

        public NetworkChecker(NetworkTopologyListener networkTopologyListener, NetworkTopologyDiscovery networkTopologyDiscovery) {
            this._mmDNS = networkTopologyListener;
            this._topology = networkTopologyDiscovery;
            this._knownAddresses = Collections.synchronizedSet(new HashSet());
        }

        public void start(Timer timer) {
            timer.schedule((TimerTask)this, 0L, 10000L);
        }

        @Override
        public void run() {
            try {
                InetAddress[] inetAddressArray = this._topology.getInetAddresses();
                HashSet<InetAddress> hashSet = new HashSet<InetAddress>(inetAddressArray.length);
                for (InetAddress inetAddress : inetAddressArray) {
                    hashSet.add(inetAddress);
                    if (this._knownAddresses.contains(inetAddress)) continue;
                    NetworkTopologyEventImpl networkTopologyEventImpl = new NetworkTopologyEventImpl(this._mmDNS, inetAddress);
                    this._mmDNS.inetAddressAdded(networkTopologyEventImpl);
                }
                for (InetAddress inetAddress : this._knownAddresses) {
                    if (hashSet.contains(inetAddress)) continue;
                    NetworkTopologyEventImpl networkTopologyEventImpl = new NetworkTopologyEventImpl(this._mmDNS, inetAddress);
                    this._mmDNS.inetAddressRemoved(networkTopologyEventImpl);
                }
                this._knownAddresses = hashSet;
            }
            catch (Exception exception) {
                logger1.warning("Unexpected unhandled exception: " + exception);
            }
        }
    }
}

