/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.menus;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindow;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindowManager;
import net.java.sip.communicator.impl.gui.main.chatroomslist.ChatRoomTableDialog;
import net.java.sip.communicator.impl.gui.main.menus.FileMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatFileMenu
extends FileMenu
implements ActionListener,
Skinnable {
    private JMenuItem historyItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.HISTORY"), new ImageIcon(ImageLoader.getImage(ImageLoader.HISTORY_16x16_ICON)));
    private JMenuItem closeMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CLOSE"), new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSE_ICON)));
    private ChatWindow chatWindow;

    public ChatFileMenu(ChatWindow chatWindow) {
        super((Frame)((Object)chatWindow), true);
        this.chatWindow = chatWindow;
        this.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.FILE"));
        this.add(this.historyItem);
        this.addSeparator();
        this.add(this.closeMenuItem);
        this.historyItem.setName("history");
        this.closeMenuItem.setName("close");
        this.historyItem.addActionListener(this);
        this.closeMenuItem.addActionListener(this);
        this.historyItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.HISTORY"));
        this.closeMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CLOSE"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemText = menuItem.getName();
        if (itemText.equalsIgnoreCase("close")) {
            this.chatWindow.setVisible(false);
            this.chatWindow.dispose();
            return;
        }
        super.actionPerformed(e);
        if (itemText.equalsIgnoreCase("myChatRooms")) {
            ChatRoomTableDialog.showChatRoomTableDialog();
        } else if (itemText.equals("history")) {
            ChatPanel chatPanel;
            ChatSession chatSession;
            HistoryWindowManager historyWindowManager = GuiActivator.getUIService().getHistoryWindowManager();
            if (historyWindowManager.containsHistoryWindowForContact((chatSession = (chatPanel = this.chatWindow.getCurrentChat()).getChatSession()).getDescriptor())) {
                HistoryWindow history = historyWindowManager.getHistoryWindowForContact(chatSession.getDescriptor());
                if (history.getState() == 1) {
                    history.setState(0);
                }
                history.toFront();
            } else {
                HistoryWindow history = new HistoryWindow(chatPanel.getChatSession().getDescriptor());
                history.setVisible(true);
                historyWindowManager.addHistoryWindowForContact(chatSession.getDescriptor(), history);
            }
        }
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        if (this.historyItem != null) {
            this.historyItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HISTORY_ICON)));
        }
        if (this.closeMenuItem != null) {
            this.closeMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSE_ICON)));
        }
    }
}

