/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.InviteUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ProtocolContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.StringContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.utils.InviteDialog;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class MembersListDialog
extends InviteDialog
implements ActionListener {
    private final ChatRoomWrapper chatRoomWrapper;
    private StringContactSourceServiceImpl currentStringContactSource;

    public MembersListDialog(ChatRoomWrapper chatRoomWrapper, String title, boolean enableReason) {
        super(title, enableReason);
        this.chatRoomWrapper = chatRoomWrapper;
        this.inviteButton.setText(GuiActivator.getResources().getI18NString("service.gui.SAVE"));
        this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_CONFIGURATION_MEMBERS_EDIT_DESCRIPTION"));
        this.infoTextArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.initContactListData(chatRoomWrapper.getParentProvider().getProtocolProvider());
        this.addInviteButtonListener(this);
        this.addCancelButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MembersListDialog.this.dispose();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection selectedContacts = this.destContactList.getContacts(null);
        ArrayList<String> selectedMembers = new ArrayList<String>();
        if (selectedContacts != null) {
            for (UIContact c : selectedContacts) {
                Iterator contactDetailsIter = c.getContactDetailsForOperationSet(OperationSetMultiUserChat.class).iterator();
                if (!contactDetailsIter.hasNext()) continue;
                UIContactDetail inviteDetail = (UIContactDetail)contactDetailsIter.next();
                selectedMembers.add(inviteDetail.getAddress());
            }
            this.chatRoomWrapper.getChatRoom().setMembersWhiteList(selectedMembers);
            this.dispose();
        }
    }

    private void initContactListData(final ProtocolProviderService protocolProvider) {
        this.setCurrentProvider(protocolProvider);
        this.srcContactList.removeAllContactSources();
        ProtocolContactSourceServiceImpl currentProviderContactSource = new ProtocolContactSourceServiceImpl(protocolProvider, OperationSetMultiUserChat.class);
        this.currentStringContactSource = new StringContactSourceServiceImpl(protocolProvider, OperationSetMultiUserChat.class);
        this.currentStringContactSource.setDisableDisplayDetails(false);
        this.srcContactList.addContactSource((ContactSourceService)currentProviderContactSource);
        this.srcContactList.addContactSource((ContactSourceService)this.currentStringContactSource);
        this.srcContactList.applyDefaultFilter();
        new Thread(new Runnable(){

            @Override
            public void run() {
                List membersWhiteList = MembersListDialog.this.chatRoomWrapper.getChatRoom().getMembersWhiteList();
                UIContactSource uiContactSource = MembersListDialog.this.srcContactList.getContactSource((ContactSourceService)MembersListDialog.this.currentStringContactSource);
                for (String member : membersWhiteList) {
                    SourceContact newSourceContact = MembersListDialog.this.currentStringContactSource.createSourceContact(member);
                    MembersListDialog.this.destContactList.addContact((UIContact)new InviteUIContact(uiContactSource.createUIContact(newSourceContact), protocolProvider), null, false, false);
                }
            }
        }).start();
    }
}

