/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.contactsource;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.DataObject;

public class GenericSourceContact
extends DataObject
implements SourceContact {
    protected final List<ContactDetail> contactDetails;
    private final ContactSourceService contactSource;
    private String displayName;
    private String displayDetails;
    private PresenceStatus presenceStatus;
    private byte[] image;
    private String contactAddress = null;

    public GenericSourceContact(ContactSourceService contactSource, String displayName, List<ContactDetail> contactDetails) {
        this.contactSource = contactSource;
        this.displayName = displayName;
        this.contactDetails = contactDetails;
    }

    @Override
    public String getContactAddress() {
        return this.contactAddress;
    }

    @Override
    public List<ContactDetail> getContactDetails() {
        return Collections.unmodifiableList(this.contactDetails);
    }

    @Override
    public List<ContactDetail> getContactDetails(Class<? extends OperationSet> operationSet) {
        LinkedList<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
        for (ContactDetail contactDetail : this.getContactDetails()) {
            List<Class<? extends OperationSet>> supportedOperationSets = contactDetail.getSupportedOperationSets();
            if (supportedOperationSets == null || !supportedOperationSets.contains(operationSet)) continue;
            contactDetails.add(contactDetail);
        }
        return contactDetails;
    }

    @Override
    public List<ContactDetail> getContactDetails(ContactDetail.Category category) {
        LinkedList<ContactDetail> contactDetails = new LinkedList<ContactDetail>();
        for (ContactDetail contactDetail : this.getContactDetails()) {
            ContactDetail.Category detailCategory;
            if (contactDetail == null || (detailCategory = contactDetail.getCategory()) == null || !detailCategory.equals((Object)category)) continue;
            contactDetails.add(contactDetail);
        }
        return contactDetails;
    }

    @Override
    public ContactSourceService getContactSource() {
        return this.contactSource;
    }

    @Override
    public String getDisplayDetails() {
        return this.displayDetails;
    }

    @Override
    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String setDisplayDetails(String displayDetails) {
        this.displayDetails = displayDetails;
        return this.displayDetails;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public byte[] getImage() {
        return this.image;
    }

    @Override
    public ContactDetail getPreferredContactDetail(Class<? extends OperationSet> operationSet) {
        List<ContactDetail> contactDetails = this.getContactDetails(operationSet);
        return contactDetails.isEmpty() ? null : contactDetails.get(0);
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    @Override
    public boolean isDefaultImage() {
        return false;
    }

    @Override
    public PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    public void setPresenceStatus(PresenceStatus presenceStatus) {
        this.presenceStatus = presenceStatus;
    }

    @Override
    public int getIndex() {
        return -1;
    }
}

