/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.propertieseditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.propertieseditor.ButtonsPanel;
import net.java.sip.communicator.plugin.propertieseditor.PropertiesEditorActivator;
import net.java.sip.communicator.plugin.propertieseditor.PropsTableModel;
import net.java.sip.communicator.plugin.propertieseditor.SearchField;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class PropertiesEditorPanel
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private final ButtonsPanel buttonsPanel;
    private final JPanel centerPanel;
    private final JTable propsTable;

    public PropertiesEditorPanel() {
        super((LayoutManager)new BorderLayout());
        ResourceManagementService r = PropertiesEditorActivator.getResourceManagementService();
        String[] columnNames = new String[]{r.getI18NString("service.gui.NAME"), r.getI18NString("service.gui.VALUE")};
        this.propsTable = new JTable(new PropsTableModel(this.initTableModel(), columnNames));
        this.propsTable.setRowSorter(new TableRowSorter<TableModel>(this.propsTable.getModel()));
        this.propsTable.setSelectionMode(0);
        PropsListSelectionListener selectionListener = new PropsListSelectionListener();
        this.propsTable.getSelectionModel().addListSelectionListener(selectionListener);
        this.propsTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        JScrollPane scrollPane = new JScrollPane(this.propsTable);
        SearchField searchField = new SearchField("", this.propsTable);
        this.buttonsPanel = new ButtonsPanel(this.propsTable, searchField);
        this.centerPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.centerPanel.add((Component)scrollPane, "Center");
        this.centerPanel.add((Component)((Object)this.buttonsPanel), "East");
        JLabel needRestart = new JLabel(r.getI18NString("plugin.propertieseditor.NEED_RESTART"));
        needRestart.setForeground(Color.RED);
        TransparentPanel searchPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 0));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        searchPanel.add((Component)((Object)searchField), (Object)"Center");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add((Component)searchPanel, "North");
        this.add(this.centerPanel, "Center");
        this.add(needRestart, "South");
    }

    private Object[][] initTableModel() {
        ConfigurationService confService = PropertiesEditorActivator.getConfigurationService();
        List properties = confService.getAllPropertyNames();
        Object[][] data = new Object[properties.size()][];
        int i = 0;
        for (String property : properties) {
            data[i++] = new Object[]{property, confService.getProperty(property)};
        }
        return data;
    }

    private class PropsListSelectionListener
    implements ListSelectionListener {
        private PropsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = PropertiesEditorPanel.this.propsTable.getSelectedRow();
            if (selectedRow == -1) {
                PropertiesEditorPanel.this.buttonsPanel.defaultButtonState();
            } else {
                PropertiesEditorPanel.this.buttonsPanel.enableDeleteButton(true);
            }
        }
    }
}

