/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ActiveCallsRepositorySipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.DesktopSharingCallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.DesktopSharingProtocolSipImpl;
import net.java.sip.communicator.impl.protocol.sip.EventPackageNotifier;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.AbstractOperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.util.Logger;

public class OperationSetDesktopSharingClientSipImpl
extends AbstractOperationSetDesktopSharingClient<ProtocolProviderServiceSipImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetDesktopSharingClientSipImpl.class);
    private final CallPeerListener callPeerListener = new CallPeerAdapter(){

        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeer peer = evt.getSourceCallPeer();
            CallPeerState state = peer.getState();
            if (CallPeerState.DISCONNECTED.equals(state) || CallPeerState.FAILED.equals(state)) {
                try {
                    OperationSetDesktopSharingClientSipImpl.this.notifier.removeSubscription(((ProtocolProviderServiceSipImpl)OperationSetDesktopSharingClientSipImpl.this.parentProvider).parseAddressString(peer.getAddress()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    };
    private final EventPackageNotifier notifier;
    private final TimerScheduler timer = new TimerScheduler();
    private final Queue<String> inputEvents = new LinkedList<String>();
    private final Object inputSync = new Object();

    public OperationSetDesktopSharingClientSipImpl(ProtocolProviderServiceSipImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        final boolean desktopControlOutOfDialogEnabled = SipActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.sip.ENABLE_OUTOFDIALOG_DESKTOP_CONTROL_PROP", false);
        this.notifier = new EventPackageNotifier((ProtocolProviderServiceSipImpl)this.parentProvider, "remote-control", 3600, "remote-control+xml", this.timer){
            private String dssid;
            {
                super(protocolProvider, eventPackage, subscriptionDuration, contentSubType, timer);
                this.dssid = null;
            }

            @Override
            protected EventPackageNotifier.Subscription createSubscription(Address fromAddress, String eventId) {
                RemoteControlNotifierSubscription rcNotifierSubscription = new RemoteControlNotifierSubscription(fromAddress, eventId);
                if (this.dssid != null) {
                    rcNotifierSubscription.setDSSID(this.dssid);
                }
                return rcNotifierSubscription;
            }

            @Override
            public boolean processRequest(RequestEvent requestEvent) {
                Header dssidHeader;
                if (desktopControlOutOfDialogEnabled && (dssidHeader = requestEvent.getRequest().getHeader("DSSID")) != null) {
                    this.dssid = dssidHeader.toString().replaceAll(dssidHeader.getName() + ":", "").trim();
                }
                boolean ret = super.processRequest(requestEvent);
                if (requestEvent == null || requestEvent.getDialog() == null || requestEvent.getDialog().getCallId() == null) {
                    return ret;
                }
                String callId = requestEvent.getDialog().getCallId().getCallId();
                EventPackageNotifier.Subscription subs = this.getSubscription(callId);
                if (subs instanceof RemoteControlNotifierSubscription) {
                    RemoteControlNotifierSubscription rcnSub = (RemoteControlNotifierSubscription)subs;
                    OperationSetDesktopSharingClientSipImpl.this.fireRemoteControlGranted((CallPeer)rcnSub.getCallPeer());
                    if (this.dssid != null) {
                        rcnSub.setDSSID(this.dssid);
                    }
                }
                return ret;
            }

            @Override
            protected void removeSubscription(Response response, String eventId, ClientTransaction clientTransaction) {
                CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
                String callId = callIdHeader.getCallId();
                EventPackageNotifier.Subscription ret = this.getSubscription(callId);
                if (ret instanceof RemoteControlNotifierSubscription) {
                    OperationSetDesktopSharingClientSipImpl.this.fireRemoteControlRevoked((CallPeer)((RemoteControlNotifierSubscription)ret).getCallPeer());
                }
                super.removeSubscription(response, eventId, clientTransaction);
            }

            @Override
            protected ClientTransaction createNotify(Dialog dialog, byte[] content, String subscriptionState, String reason) throws OperationFailedException {
                ClientTransaction res = super.createNotify(dialog, content, subscriptionState, reason);
                if (desktopControlOutOfDialogEnabled) {
                    try {
                        Header dssidHeader = ((ProtocolProviderServiceSipImpl)OperationSetDesktopSharingClientSipImpl.this.parentProvider).getHeaderFactory().createHeader("DSSID", this.dssid);
                        res.getRequest().setHeader(dssidHeader);
                    }
                    catch (ParseException ex) {
                        logger.error((Object)"error ", (Throwable)ex);
                    }
                }
                return res;
            }
        };
    }

    private void notifySubscriptions(final CallPeer callPeer) {
        EventPackageNotifier.SubscriptionFilter subscriptionFilter = new EventPackageNotifier.SubscriptionFilter(){

            @Override
            public boolean accept(EventPackageNotifier.Subscription subscription) {
                return subscription instanceof RemoteControlNotifierSubscription && callPeer.getAddress().equals(((RemoteControlNotifierSubscription)subscription).getCallPeer().getAddress());
            }
        };
        try {
            this.notifier.notifyAll("active", null, subscriptionFilter);
        }
        catch (OperationFailedException ofe) {
            logger.error((Object)"Failed to notify the remote-control subscriptions", (Throwable)ofe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeyboardEvent(CallPeer callPeer, KeyEvent event) {
        String msg;
        int keyCode;
        int keyChar = event.getKeyChar();
        int n = keyCode = keyChar == 65535 ? event.getKeyCode() : keyChar;
        if (keyCode == 0) {
            return;
        }
        switch (event.getID()) {
            case 400: {
                msg = DesktopSharingProtocolSipImpl.getKeyTypedXML(keyCode);
                break;
            }
            case 401: {
                msg = DesktopSharingProtocolSipImpl.getKeyPressedXML(keyCode);
                break;
            }
            case 402: {
                msg = DesktopSharingProtocolSipImpl.getKeyReleasedXML(keyCode);
                break;
            }
            default: {
                return;
            }
        }
        Object object = this.inputSync;
        synchronized (object) {
            this.inputEvents.add(msg);
            this.notifySubscriptions(callPeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseEvent(CallPeer callPeer, MouseEvent event, Dimension videoPanelSize) {
        String msg = null;
        if (event.getID() != 503 && event.getID() != 506) {
            this.sendMouseEvent(callPeer, event);
            return;
        }
        Point p = event.getPoint();
        double x = p.getX() / (double)videoPanelSize.width;
        double y = p.getY() / (double)videoPanelSize.height;
        msg = DesktopSharingProtocolSipImpl.getMouseMovedXML(x, y);
        Object object = this.inputSync;
        synchronized (object) {
            this.inputEvents.add(msg);
            this.notifySubscriptions(callPeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseEvent(CallPeer callPeer, MouseEvent event) {
        String msg = null;
        switch (event.getID()) {
            case 501: {
                msg = DesktopSharingProtocolSipImpl.getMousePressedXML(event.getModifiers());
                break;
            }
            case 502: {
                msg = DesktopSharingProtocolSipImpl.getMouseReleasedXML(event.getModifiers());
                break;
            }
            case 507: {
                MouseWheelEvent evt = (MouseWheelEvent)event;
                msg = DesktopSharingProtocolSipImpl.getMouseWheelXML(evt.getWheelRotation());
                break;
            }
            default: {
                return;
            }
        }
        Object object = this.inputSync;
        synchronized (object) {
            this.inputEvents.add(msg);
            this.notifySubscriptions(callPeer);
        }
    }

    private class RemoteControlNotifierSubscription
    extends EventPackageNotifier.Subscription {
        private CallPeerSipImpl callPeer;
        private String dssid;

        public RemoteControlNotifierSubscription(Address fromAddress, String eventId) {
            super(fromAddress, eventId);
            this.callPeer = null;
            this.dssid = null;
        }

        @Override
        protected byte[] createNotifyContent(String subscriptionState, String reason) {
            CallPeerSipImpl callPeer = this.getCallPeer();
            if (callPeer == null) {
                logger.error((Object)("Failed to find the CallPeer of the remote-controlsubscription " + this));
                return null;
            }
            String xml = null;
            byte[] notifyContent = null;
            xml = (String)OperationSetDesktopSharingClientSipImpl.this.inputEvents.poll();
            if (xml == null) {
                xml = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><remote-control />");
            }
            try {
                notifyContent = xml.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                logger.warn((Object)"Failed to gets bytes from String for the UTF-8 charset", (Throwable)uee);
                notifyContent = xml.getBytes();
            }
            return notifyContent;
        }

        private CallPeerSipImpl getCallPeer() {
            OperationSetBasicTelephony basicTelephony;
            Dialog dialog;
            if (this.callPeer == null && (dialog = this.getDialog()) != null && (basicTelephony = (OperationSetBasicTelephony)((ProtocolProviderServiceSipImpl)OperationSetDesktopSharingClientSipImpl.this.parentProvider).getOperationSet(OperationSetBasicTelephony.class)) != null) {
                ActiveCallsRepositorySipImpl callRepo = ((OperationSetBasicTelephonySipImpl)basicTelephony).getActiveCallsRepository();
                this.callPeer = callRepo.findCallPeer(dialog);
                if (this.callPeer == null && this.dssid != null) {
                    this.callPeer = this.findCallPeerByDSSID(callRepo);
                }
                if (this.callPeer != null) {
                    this.callPeer.addCallPeerListener(OperationSetDesktopSharingClientSipImpl.this.callPeerListener);
                }
            }
            return this.callPeer;
        }

        public void setDSSID(String value) {
            this.dssid = value;
        }

        public CallPeerSipImpl findCallPeerByDSSID(ActiveCallsRepositorySipImpl callRepo) {
            if (this.dssid == null) {
                return null;
            }
            Iterator activeCalls = callRepo.getActiveCalls();
            while (activeCalls.hasNext()) {
                DesktopSharingCallSipImpl dsCall;
                CallSipImpl call = (CallSipImpl)((Object)activeCalls.next());
                if (!(call instanceof DesktopSharingCallSipImpl) || (dsCall = (DesktopSharingCallSipImpl)call).getDesktopSharingSessionID() == null || !dsCall.getDesktopSharingSessionID().equals(this.dssid)) continue;
                return (CallPeerSipImpl)((Object)dsCall.getCallPeers().next());
            }
            return null;
        }
    }
}

