/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.LightGrayFilter;
import net.java.sip.communicator.plugin.desktoputil.OrderedComponent;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class SIPCommToggleButton
extends JToggleButton
implements OrderedComponent {
    private static final long serialVersionUID = 0L;
    private Image bgImage;
    private Image bgRolloverImage;
    private Image iconImage;
    private Image pressedImage;
    private Image pressedIconImage;
    private int index = -1;

    public SIPCommToggleButton() {
        this.setBorder(null);
        MouseRolloverHandler mouseHandler = new MouseRolloverHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public SIPCommToggleButton(Image bgImage, Image rolloverImage) {
        this(bgImage, rolloverImage, null, null);
    }

    public SIPCommToggleButton(Image bgImage, Image rolloverImage, Image iconImage, Image pressedImage) {
        this(bgImage, rolloverImage, iconImage, pressedImage, null);
    }

    public SIPCommToggleButton(Image bgImage, Image rolloverImage, Image iconImage, Image pressedImage, Image pressedIconImage) {
        this();
        this.bgImage = bgImage;
        this.bgRolloverImage = rolloverImage;
        this.iconImage = iconImage;
        this.pressedImage = pressedImage;
        this.pressedIconImage = pressedIconImage;
        this.setPreferredSize(new Dimension(this.bgImage.getWidth(null), this.bgImage.getHeight(null)));
        if (iconImage != null) {
            this.setIcon(new ImageIcon(this.iconImage));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        int bgHeight;
        float visibility;
        AntialiasingManager.activateAntialiasing(g);
        if (this.bgImage != null) {
            if (!this.isEnabled()) {
                Image disabledImage = new ImageIcon(LightGrayFilter.createDisabledImage(this.bgImage)).getImage();
                g.drawImage(disabledImage, 0, 0, this);
            } else {
                g.drawImage(this.bgImage, 0, 0, this);
            }
        }
        if (this.getModel().isRollover() && this.bgRolloverImage != null) {
            g.drawImage(this.bgRolloverImage, 0, 0, this);
        }
        if (this.getModel().isSelected() && this.pressedImage != null) {
            g.drawImage(this.pressedImage, 0, 0, this);
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = this.getModel().isRollover() ? 1.0f : 0.0f;
        if (fadeTracker.isTracked(this, FadeKind.ROLLOVER)) {
            visibility = fadeTracker.getFade(this, FadeKind.ROLLOVER);
        }
        g.setColor(new Color(1.0f, 1.0f, 1.0f, visibility /= 2.0f));
        if (this.bgImage != null) {
            g.fillRoundRect(this.getWidth() / 2 - this.bgImage.getWidth(null) / 2, this.getHeight() / 2 - this.bgImage.getHeight(null) / 2, this.bgImage.getWidth(null), this.bgImage.getHeight(null), 10, 10);
        } else if (this.isContentAreaFilled() || visibility != 0.0f) {
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
        }
        Image iconImageFinal = null;
        if (this.getModel().isSelected() && this.pressedIconImage != null) {
            iconImageFinal = this.pressedIconImage;
        } else if (this.iconImage != null) {
            iconImageFinal = !this.isEnabled() ? new ImageIcon(LightGrayFilter.createDisabledImage(this.iconImage)).getImage() : this.iconImage;
        }
        int bgWidth = this.bgImage != null ? this.bgImage.getWidth(null) : this.getWidth();
        int n = bgHeight = this.bgImage != null ? this.bgImage.getHeight(null) : this.getHeight();
        if (iconImageFinal != null) {
            g.drawImage(iconImageFinal, (bgWidth - iconImageFinal.getWidth(null)) / 2, (bgHeight - iconImageFinal.getHeight(null)) / 2, this);
        }
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(Image bgImage) {
        this.bgImage = bgImage;
        this.setPreferredSize(new Dimension(this.bgImage.getWidth(null), this.bgImage.getHeight(null)));
    }

    public Image getBgRolloverImage() {
        return this.bgRolloverImage;
    }

    public void setBgRolloverImage(Image bgRolloverImage) {
        this.bgRolloverImage = bgRolloverImage;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public void setIconImage(Image iconImage) {
        this.iconImage = iconImage;
        this.repaint();
    }

    public void setPressedIconImage(Image iconImage) {
        this.pressedIconImage = iconImage;
        this.repaint();
    }

    public void setPressedImage(Image pressedImage) {
        this.pressedImage = pressedImage;
        this.repaint();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseRolloverHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SIPCommToggleButton.this.isEnabled()) {
                SIPCommToggleButton.this.getModel().setRollover(false);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeKind.ROLLOVER, SIPCommToggleButton.this, true, new ButtonRepaintCallback());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SIPCommToggleButton.this.isEnabled()) {
                SIPCommToggleButton.this.getModel().setRollover(true);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeIn(FadeKind.ROLLOVER, SIPCommToggleButton.this, true, new ButtonRepaintCallback());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class ButtonRepaintCallback
    implements FadeTrackerCallback {
        private ButtonRepaintCallback() {
        }

        @Override
        public void fadeEnded(FadeKind arg0) {
            this.repaintLater();
        }

        @Override
        public void fadePerformed(FadeKind arg0, float arg1) {
            this.repaintLater();
        }

        private void repaintLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SIPCommToggleButton.this.repaint();
                }
            });
        }

        @Override
        public void fadeReversed(FadeKind arg0, boolean arg1, float arg2) {
        }
    }
}

