/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.javax.sdp.fields.SDPField;
import java.util.Date;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.Time;

public class TimeField
extends SDPField
implements Time {
    protected long startTime;
    protected long stopTime;

    public TimeField() {
        super("t=");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public Date getStart() throws SdpParseException {
        return new Date((this.startTime - 2208988800L) * 1000L);
    }

    public Date getStop() throws SdpParseException {
        return new Date((this.stopTime - 2208988800L) * 1000L);
    }

    public void setStop(Date stop) throws SdpException {
        if (stop == null) {
            throw new SdpException("The date is null");
        }
        this.stopTime = stop.getTime() / 1000L + 2208988800L;
    }

    public void setStart(Date start) throws SdpException {
        if (start == null) {
            throw new SdpException("The date is null");
        }
        this.startTime = start.getTime() / 1000L + 2208988800L;
    }

    public boolean getTypedTime() {
        return false;
    }

    public void setTypedTime(boolean typedTime) {
    }

    public boolean isZero() {
        return this.getStartTime() == 0L && this.getStopTime() == 0L;
    }

    public void setZero() {
        this.setStopTime(0L);
        this.setStartTime(0L);
    }

    @Override
    public String encode() {
        return "t=" + this.startTime + " " + this.stopTime + "\r\n";
    }
}

