/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauthproxy;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class OAuthProxyRequest
extends HashMap<String, String> {
    public static final String DEFAULT_ACCESS_TOKEN_URL = "https://www.google.com/accounts/OAuthGetAccessToken";
    public static final String DEFAULT_AUTHORIZATION_URL = "https://www.google.com/accounts/OAuthAuthorizeToken";
    public static final String DEFAULT_REQUEST_TOKEN_URL = "https://www.google.com/accounts/OAuthGetRequestToken";
    public static final String DEFAULT_SERVICE_NAME = "google";
    public static final String DEFAULT_USE_TOKEN = "always";
    private String scope;
    private String requestTokenUrl;

    public OAuthProxyRequest() {
        this.setAccessTokenUrl(DEFAULT_ACCESS_TOKEN_URL);
        this.setAuthorizationUrl(DEFAULT_AUTHORIZATION_URL);
        this.setRequestTokenUrl(DEFAULT_REQUEST_TOKEN_URL);
        this.setServiceName(DEFAULT_SERVICE_NAME);
        this.setUseToken(DEFAULT_USE_TOKEN);
    }

    public String getAcessTokenUrl() {
        return (String)this.get("x_oauth_access_token_url");
    }

    public void setAccessTokenUrl(String value) {
        this.put("x_oauth_access_token_url", value);
    }

    public String getAuthorizationUrl() {
        return (String)this.get("x_oauth_authorization_url");
    }

    public void setAuthorizationUrl(String value) {
        this.put("x_oauth_authorization_url", value);
    }

    public String getDesiredCallbackUrl() {
        return (String)this.get("x_oauth_desired_callback_url");
    }

    public void setDesiredCallbackUrl(String value) {
        this.put("x_oauth_desired_callback_url", value);
    }

    public String getReceivedCallbackUrl() {
        return (String)this.get("x_oauth_received_callback_url");
    }

    public void setReceivedCallbackUrl(String value) {
        this.put("x_oauth_received_callback_url", value);
    }

    public String getRequestTokenUrl() {
        return (String)this.get("x_oauth_request_token_url");
    }

    public void setRequestTokenUrl(String value) {
        this.requestTokenUrl = value;
        this.storeRequestTokenUrl();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String value) {
        this.scope = value;
        this.storeRequestTokenUrl();
    }

    public String getServiceName() {
        return (String)this.get("x_oauth_service_name");
    }

    public void setServiceName(String value) {
        this.put("x_oauth_service_name", value);
    }

    public String getState() {
        return (String)this.get("x_oauth_state");
    }

    public void setState(String value) {
        this.put("x_oauth_state", value);
    }

    public String getTokenName() {
        return (String)this.get("x_oauth_token_name");
    }

    public void setTokenName(String value) {
        this.put("x_oauth_token_name", value);
    }

    public String getUseToken() {
        return (String)this.get("x_oauth_use_token");
    }

    public void setUseToken(String value) {
        this.put("x_oauth_use_token", value);
    }

    private void storeRequestTokenUrl() {
        if (this.requestTokenUrl != null && this.scope != null) {
            this.requestTokenUrl = this.requestTokenUrl + (this.requestTokenUrl.indexOf(63) == -1 ? "?" : "&");
            try {
                this.requestTokenUrl = this.requestTokenUrl + "scope=" + URLEncoder.encode(this.scope, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.put("x_oauth_request_token_url", this.requestTokenUrl);
    }
}

