/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.contactlist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.contactlist.MetaContactGroupImpl;
import net.java.sip.communicator.impl.contactlist.MetaContactImpl;
import net.java.sip.communicator.impl.contactlist.MetaContactListServiceImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.event.MetaContactAvatarUpdateEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactGroupEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactlist.event.MetaContactModifiedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactMovedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactRenamedEvent;
import net.java.sip.communicator.service.contactlist.event.ProtoContactEvent;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FailSafeTransaction;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.util.xml.XMLException;
import org.jitsi.util.xml.XMLUtils;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MclStorageManager
implements MetaContactListListener {
    private static final Logger logger = Logger.getLogger(MclStorageManager.class);
    private static final String MULTI_TENANT_MODE_PROP = "net.java.sip.communicator.impl.contactlist.MULTI_TENANT_MODE";
    private boolean multiTenantMode = false;
    private boolean started = false;
    private boolean isModified = false;
    private BundleContext bundleContext = null;
    private FileAccessService faService = null;
    private static final String FILE_NAME_PROPERTY = "net.java.sip.communicator.CONTACTLIST_FILE_NAME";
    private Document contactListDocument = null;
    private File contactlistFile = null;
    private FailSafeTransaction contactlistTrans = null;
    private MetaContactListServiceImpl mclServiceImpl = null;
    private static final String DEFAULT_FILE_NAME = "contactlist.xml";
    private static String DOCUMENT_ROOT_NAME = "sip-communicator";
    private static final String GROUP_NODE_NAME = "group";
    private static final String SUBGROUPS_NODE_NAME = "subgroups";
    private static final String GROUP_NAME_ATTR_NAME = "name";
    private static final String GROUP_UID_ATTR_NAME = "uid";
    private static final String PROTO_GROUPS_NODE_NAME = "proto-groups";
    private static final String PROTO_GROUP_NODE_NAME = "proto-group";
    private static final String UID_ATTR_NAME = "uid";
    private static final String PARENT_PROTO_GROUP_UID_ATTR_NAME = "parent-proto-group-uid";
    private static final String ACCOUNT_ID_ATTR_NAME = "account-id";
    private static final String META_CONTACT_NODE_NAME = "meta-contact";
    private static final String META_CONTACT_DISPLAY_NAME_NODE_NAME = "display-name";
    private static final String USER_DEFINED_DISPLAY_NAME_ATTR_NAME = "user-defined";
    private static final String META_CONTACT_DETAIL_NAME_NODE_NAME = "detail";
    private static final String DETAIL_NAME_ATTR_NAME = "name";
    private static final String DETAIL_VALUE_ATTR_NAME = "value";
    private static final String PROTO_CONTACT_NODE_NAME = "contact";
    private static final String PROTO_CONTACT_ADDRESS_ATTR_NAME = "address";
    private static final String PERSISTENT_DATA_NODE_NAME = "persistent-data";
    private static final String CHILD_CONTACTS_NODE_NAME = "child-contacts";
    private static final Object contactListRWLock = new Object();

    boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Stopping the MCL XML storage manager.");
        }
        this.started = false;
        Object object = contactListRWLock;
        synchronized (object) {
            contactListRWLock.notifyAll();
        }
    }

    void start(BundleContext bc, MetaContactListServiceImpl mclServImpl) throws IOException, XMLException {
        this.bundleContext = bc;
        this.faService = (FileAccessService)ServiceUtils.getService((BundleContext)this.bundleContext, FileAccessService.class);
        ConfigurationService configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)this.bundleContext, ConfigurationService.class);
        String fileName = configurationService.getString(FILE_NAME_PROPERTY);
        if (fileName == null && (fileName = System.getProperty(FILE_NAME_PROPERTY)) == null) {
            fileName = DEFAULT_FILE_NAME;
        }
        try {
            this.contactlistFile = this.faService.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
            if (!this.contactlistFile.exists() && !this.contactlistFile.createNewFile()) {
                throw new IOException("Failed to create file" + this.contactlistFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get a reference to the contact list file.", (Throwable)ex);
            throw new IOException("Failed to get a reference to the contact list file=" + fileName + ". error was:" + ex.getMessage());
        }
        this.multiTenantMode = configurationService.getBoolean(MULTI_TENANT_MODE_PROP, this.multiTenantMode);
        try {
            this.contactlistTrans = this.faService.createFailSafeTransaction(this.contactlistFile);
            this.contactlistTrans.restoreFile();
        }
        catch (NullPointerException e) {
            logger.error((Object)"the contactlist file is null", (Throwable)e);
        }
        catch (IllegalStateException e) {
            logger.error((Object)"The contactlist file can't be found", (Throwable)e);
        }
        try {
            DocumentBuilder builder = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder();
            if (this.contactlistFile.length() == 0L) {
                this.contactListDocument = builder.newDocument();
                this.initVirginDocument(mclServImpl, this.contactListDocument);
                this.storeContactList0();
            } else {
                try {
                    this.contactListDocument = builder.parse(this.contactlistFile);
                }
                catch (Throwable ex) {
                    logger.error((Object)"Error parsing configuration file", ex);
                    logger.error((Object)"Creating replacement file");
                    this.contactlistFile.delete();
                    this.contactlistFile.createNewFile();
                    this.contactListDocument = builder.newDocument();
                    this.initVirginDocument(mclServImpl, this.contactListDocument);
                    this.storeContactList0();
                }
            }
        }
        catch (ParserConfigurationException ex) {
            logger.error((Object)"Error finding configuration for default parsers", (Throwable)ex);
        }
        mclServImpl.addMetaContactListListener(this);
        this.mclServiceImpl = mclServImpl;
        this.started = true;
        this.launchStorageThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleContactListStorage() throws IOException {
        Object object = contactListRWLock;
        synchronized (object) {
            if (!this.isStarted()) {
                return;
            }
            this.isModified = true;
            contactListRWLock.notifyAll();
        }
    }

    private void storeContactList0() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("storing contact list. because is started ==" + this.isStarted()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("storing contact list. because is modified ==" + this.isModified));
        }
        if (this.isStarted()) {
            try {
                this.contactlistTrans.beginTransaction();
            }
            catch (IllegalStateException e) {
                logger.error((Object)"the contactlist file is missing", (Throwable)e);
            }
            FileOutputStream stream = new FileOutputStream(this.contactlistFile);
            XMLUtils.indentedWriteXML((Document)this.contactListDocument, (OutputStream)stream);
            ((OutputStream)stream).close();
            try {
                this.contactlistTrans.commit();
            }
            catch (IllegalStateException e) {
                logger.error((Object)"the contactlist file is missing", (Throwable)e);
            }
        }
    }

    private void launchStorageThread() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = contactListRWLock;
                    synchronized (object) {
                        while (MclStorageManager.this.isStarted()) {
                            contactListRWLock.wait(5000L);
                            if (!MclStorageManager.this.isModified) continue;
                            MclStorageManager.this.storeContactList0();
                            MclStorageManager.this.isModified = false;
                        }
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)"Storing contact list failed", (Throwable)ex);
                    MclStorageManager.this.started = false;
                }
                catch (InterruptedException ex) {
                    logger.error((Object)"Storing contact list failed", (Throwable)ex);
                    MclStorageManager.this.started = false;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeContactListAndStopStorageManager() {
        Object object = contactListRWLock;
        synchronized (object) {
            if (!this.isStarted()) {
                return;
            }
            this.started = false;
            contactListRWLock.notifyAll();
            try {
                this.storeContactList0();
            }
            catch (IOException ex) {
                logger.debug((Object)"Failed to store contact list before stopping", (Throwable)ex);
            }
        }
    }

    private void updatePersistentDataForMetaContact(MetaContact metaContact) {
        Element metaContactNode = this.findMetaContactNode(metaContact.getMetaUID());
        Iterator iter = metaContact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            String persistentData = item.getPersistentData();
            if (persistentData == null) continue;
            Element currentNode = XMLUtils.locateElement((Element)metaContactNode, (String)PROTO_CONTACT_NODE_NAME, (String)PROTO_CONTACT_ADDRESS_ATTR_NAME, (String)item.getAddress());
            Element persistentDataNode = XMLUtils.findChild((Element)currentNode, (String)PERSISTENT_DATA_NODE_NAME);
            if (persistentDataNode == null) {
                persistentDataNode = this.contactListDocument.createElement(PERSISTENT_DATA_NODE_NAME);
                currentNode.appendChild(persistentDataNode);
            }
            XMLUtils.setText((Element)persistentDataNode, (String)persistentData);
        }
    }

    private void initVirginDocument(MetaContactListServiceImpl mclServImpl, Document contactListDoc) {
        Element root = contactListDoc.createElement(DOCUMENT_ROOT_NAME);
        contactListDoc.appendChild(root);
        Element rootGroup = this.createMetaContactGroupNode(mclServImpl.getRoot());
        root.appendChild(rootGroup);
    }

    void extractContactsForAccount(String accountID) throws XMLException {
        if (!this.isStarted()) {
            return;
        }
        this.mclServiceImpl.removeMetaContactListListener(this);
        try {
            Element root = this.findMetaContactGroupNode(this.mclServiceImpl.getRoot().getMetaUID());
            if (root == null) {
                logger.fatal((Object)"The contactlist file is recreated cause its broken");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.contactListDocument = builder.newDocument();
                this.initVirginDocument(this.mclServiceImpl, this.contactListDocument);
                this.storeContactList0();
            } else {
                this.processGroupXmlNode(this.mclServiceImpl, accountID, root, null, null);
                this.scheduleContactListStorage();
            }
        }
        catch (Throwable exc) {
            throw new XMLException("Failed to extract contacts for account " + accountID, exc);
        }
        finally {
            this.mclServiceImpl.addMetaContactListListener(this);
        }
    }

    private void processGroupXmlNode(MetaContactListServiceImpl mclServImpl, String accountID, Element groupNode, MetaContactGroupImpl parentGroup, Map<String, ContactGroup> parentProtoGroups) {
        int i;
        MetaContactGroupImpl currentMetaGroup = null;
        Hashtable<String, ContactGroup> protoGroupsMap = new Hashtable<String, ContactGroup>();
        if (parentGroup == null) {
            currentMetaGroup = mclServImpl.rootMetaGroup;
        } else {
            String groupMetaUID = XMLUtils.getAttribute((Node)groupNode, (String)"uid");
            String groupDisplayName = XMLUtils.getAttribute((Node)groupNode, (String)"name");
            if (!this.multiTenantMode) {
                currentMetaGroup = mclServImpl.loadStoredMetaContactGroup(parentGroup, groupMetaUID, groupDisplayName);
            }
            Element protoGroupsNode = XMLUtils.findChild((Element)groupNode, (String)PROTO_GROUPS_NODE_NAME);
            NodeList protoGroups = protoGroupsNode.getChildNodes();
            for (i = 0; i < protoGroups.getLength(); ++i) {
                String groupAccountID;
                Node currentProtoGroupNode = protoGroups.item(i);
                if (currentProtoGroupNode.getNodeType() != 1 || !accountID.equals(groupAccountID = XMLUtils.getAttribute((Node)currentProtoGroupNode, (String)ACCOUNT_ID_ATTR_NAME))) continue;
                String protoGroupUID = XMLUtils.getAttribute((Node)currentProtoGroupNode, (String)"uid");
                String parentProtoGroupUID = XMLUtils.getAttribute((Node)currentProtoGroupNode, (String)PARENT_PROTO_GROUP_UID_ATTR_NAME);
                Element persistentDataNode = XMLUtils.findChild((Element)((Element)currentProtoGroupNode), (String)PERSISTENT_DATA_NODE_NAME);
                String persistentData = "";
                if (persistentDataNode != null) {
                    persistentData = XMLUtils.getText((Element)persistentDataNode);
                }
                ContactGroup parentProtoGroup = null;
                if (parentProtoGroups != null && parentProtoGroups.size() > 0) {
                    parentProtoGroup = parentProtoGroups.get(parentProtoGroupUID);
                }
                if (this.multiTenantMode && currentMetaGroup == null) {
                    currentMetaGroup = mclServImpl.loadStoredMetaContactGroup(parentGroup, groupMetaUID, groupDisplayName);
                }
                ContactGroup newProtoGroup = mclServImpl.loadStoredContactGroup(currentMetaGroup, protoGroupUID, parentProtoGroup, persistentData, accountID);
                protoGroupsMap.put(protoGroupUID, newProtoGroup);
            }
            if (protoGroupsMap.size() == 0) {
                return;
            }
        }
        Element childContactsNode = XMLUtils.findChild((Element)groupNode, (String)CHILD_CONTACTS_NODE_NAME);
        NodeList childContacts = childContactsNode == null ? null : childContactsNode.getChildNodes();
        for (int i2 = 0; childContacts != null && i2 < childContacts.getLength(); ++i2) {
            Node currentMetaContactNode = childContacts.item(i2);
            if (currentMetaContactNode.getNodeType() != 1) continue;
            try {
                String uid = XMLUtils.getAttribute((Node)currentMetaContactNode, (String)"uid");
                Element displayNameNode = XMLUtils.findChild((Element)((Element)currentMetaContactNode), (String)META_CONTACT_DISPLAY_NAME_NODE_NAME);
                String displayName = XMLUtils.getText((Element)displayNameNode);
                boolean isDisplayNameUserDefined = Boolean.valueOf(displayNameNode.getAttribute(USER_DEFINED_DISPLAY_NAME_ATTR_NAME));
                List<StoredProtoContactDescriptor> protoContacts = this.extractProtoContacts((Element)currentMetaContactNode, accountID, protoGroupsMap);
                if (protoContacts.size() < 1) continue;
                Hashtable<String, List<String>> details = null;
                try {
                    List detailsNodes = XMLUtils.findChildren((Element)((Element)currentMetaContactNode), (String)META_CONTACT_DETAIL_NAME_NODE_NAME);
                    if (detailsNodes.size() > 0) {
                        details = new Hashtable<String, List<String>>();
                        for (Element e : detailsNodes) {
                            String name = e.getAttribute("name");
                            String value = e.getAttribute(DETAIL_VALUE_ATTR_NAME);
                            List detailsObj = (List)details.get(name);
                            if (detailsObj == null) {
                                ArrayList<String> ds = new ArrayList<String>();
                                ds.add(value);
                                details.put(name, ds);
                                continue;
                            }
                            detailsObj.add(value);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Cannot load details for contact node " + currentMetaContactNode), (Throwable)ex);
                }
                MetaContactImpl mc = mclServImpl.loadStoredMetaContact(currentMetaGroup, uid, displayName, details, protoContacts, accountID);
                if (!isDisplayNameUserDefined) continue;
                mc.setDisplayNameUserDefined(true);
                continue;
            }
            catch (Throwable thr) {
                logger.warn((Object)("Failed to parse meta contact " + currentMetaContactNode + ". Will remove and continue with other contacts"), thr);
                if (currentMetaContactNode.getParentNode() == null) continue;
                try {
                    currentMetaContactNode.getParentNode().removeChild(currentMetaContactNode);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Failed to remove meta contact node " + currentMetaContactNode), throwable);
                }
            }
        }
        Element subgroupsNode = XMLUtils.findChild((Element)groupNode, (String)SUBGROUPS_NODE_NAME);
        if (subgroupsNode == null) {
            return;
        }
        NodeList subgroups = subgroupsNode.getChildNodes();
        for (i = 0; i < subgroups.getLength(); ++i) {
            Node currentGroupNode = subgroups.item(i);
            if (currentGroupNode.getNodeType() != 1 || !currentGroupNode.getNodeName().equals(GROUP_NODE_NAME)) continue;
            try {
                this.processGroupXmlNode(mclServImpl, accountID, (Element)currentGroupNode, currentMetaGroup, protoGroupsMap);
                continue;
            }
            catch (Throwable throwable) {
                logger.error((Object)("Failed to process group node " + currentGroupNode + ". Removing."), throwable);
                if (currentGroupNode.getParentNode() == null) continue;
                try {
                    currentGroupNode.getParentNode().removeChild(currentGroupNode);
                    continue;
                }
                catch (Throwable thr) {
                    logger.error((Object)("Failed to remove group node " + currentGroupNode), thr);
                }
            }
        }
    }

    private List<StoredProtoContactDescriptor> extractProtoContacts(Element metaContactNode, String accountID, Map<String, ContactGroup> protoGroups) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Extracting proto contacts for " + XMLUtils.getAttribute((Node)metaContactNode, (String)"uid")));
        }
        LinkedList<StoredProtoContactDescriptor> protoContacts = new LinkedList<StoredProtoContactDescriptor>();
        NodeList children = metaContactNode.getChildNodes();
        LinkedList<Node> duplicates = new LinkedList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            String contactAccountID;
            Node currentNode = children.item(i);
            if (currentNode.getNodeName() == null || currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals(PROTO_CONTACT_NODE_NAME) || !accountID.equals(contactAccountID = XMLUtils.getAttribute((Node)currentNode, (String)ACCOUNT_ID_ATTR_NAME))) continue;
            String contactAddress = XMLUtils.getAttribute((Node)currentNode, (String)PROTO_CONTACT_ADDRESS_ATTR_NAME);
            if (StoredProtoContactDescriptor.findContactInList(contactAddress, protoContacts) != null) {
                duplicates.add(currentNode);
                continue;
            }
            String protoGroupUID = XMLUtils.getAttribute((Node)currentNode, (String)PARENT_PROTO_GROUP_UID_ATTR_NAME);
            Element persistentDataNode = XMLUtils.findChild((Element)((Element)currentNode), (String)PERSISTENT_DATA_NODE_NAME);
            String persistentData = persistentDataNode == null ? "" : XMLUtils.getText((Element)persistentDataNode);
            protoContacts.add(new StoredProtoContactDescriptor(contactAddress, persistentData, protoGroups.get(protoGroupUID)));
        }
        for (Node node : duplicates) {
            metaContactNode.removeChild(node);
        }
        return protoContacts;
    }

    private Element createProtoContactNode(Contact protoContact) {
        Element protoContactElement = this.contactListDocument.createElement(PROTO_CONTACT_NODE_NAME);
        protoContactElement.setAttribute(PROTO_CONTACT_ADDRESS_ATTR_NAME, protoContact.getAddress());
        protoContactElement.setAttribute(ACCOUNT_ID_ATTR_NAME, protoContact.getProtocolProvider().getAccountID().getAccountUniqueID());
        if (logger.isInfoEnabled() && protoContact.getParentContactGroup() == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("the following contact looks weird:" + protoContact));
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("group:" + protoContact.getParentContactGroup()));
            }
        }
        if (protoContact.getParentContactGroup() == null) {
            return null;
        }
        protoContactElement.setAttribute(PARENT_PROTO_GROUP_UID_ATTR_NAME, protoContact.getParentContactGroup().getUID());
        String persistentData = protoContact.getPersistentData();
        if (persistentData != null && persistentData.length() != 0) {
            Element persDataNode = this.contactListDocument.createElement(PERSISTENT_DATA_NODE_NAME);
            XMLUtils.setText((Element)persDataNode, (String)persistentData);
            protoContactElement.appendChild(persDataNode);
        }
        return protoContactElement;
    }

    private Element createProtoContactGroupNode(ContactGroup protoGroup) {
        String persistentData;
        Element protoGroupElement = this.contactListDocument.createElement(PROTO_GROUP_NODE_NAME);
        protoGroupElement.setAttribute("uid", protoGroup.getUID());
        protoGroupElement.setAttribute(ACCOUNT_ID_ATTR_NAME, protoGroup.getProtocolProvider().getAccountID().getAccountUniqueID());
        ContactGroup parentContactGroup = protoGroup.getParentContactGroup();
        if (parentContactGroup != null) {
            protoGroupElement.setAttribute(PARENT_PROTO_GROUP_UID_ATTR_NAME, parentContactGroup.getUID());
        }
        if ((persistentData = protoGroup.getPersistentData()) != null && persistentData.length() != 0) {
            Element persDataNode = this.contactListDocument.createElement(PERSISTENT_DATA_NODE_NAME);
            XMLUtils.setText((Element)persDataNode, (String)persistentData);
            protoGroupElement.appendChild(persDataNode);
        }
        return protoGroupElement;
    }

    private Element createMetaContactNode(MetaContact metaContact) {
        Element metaContactElement = this.contactListDocument.createElement(META_CONTACT_NODE_NAME);
        metaContactElement.setAttribute("uid", metaContact.getMetaUID());
        Element displayNameNode = this.contactListDocument.createElement(META_CONTACT_DISPLAY_NAME_NODE_NAME);
        displayNameNode.appendChild(this.contactListDocument.createTextNode(metaContact.getDisplayName()));
        if (((MetaContactImpl)metaContact).isDisplayNameUserDefined()) {
            displayNameNode.setAttribute(USER_DEFINED_DISPLAY_NAME_ATTR_NAME, Boolean.TRUE.toString());
        }
        metaContactElement.appendChild(displayNameNode);
        Iterator contacts = metaContact.getContacts();
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            Element contactElement = this.createProtoContactNode(contact);
            if (contactElement == null) continue;
            metaContactElement.appendChild(contactElement);
        }
        return metaContactElement;
    }

    private Element createMetaContactGroupNode(MetaContactGroup metaGroup) {
        Element metaGroupElement = this.contactListDocument.createElement(GROUP_NODE_NAME);
        metaGroupElement.setAttribute("name", metaGroup.getGroupName());
        metaGroupElement.setAttribute("uid", metaGroup.getMetaUID());
        Element protoGroupsElement = this.contactListDocument.createElement(PROTO_GROUPS_NODE_NAME);
        metaGroupElement.appendChild(protoGroupsElement);
        Iterator protoGroups = metaGroup.getContactGroups();
        while (protoGroups.hasNext()) {
            ContactGroup group = (ContactGroup)protoGroups.next();
            if (!group.isPersistent()) continue;
            Element protoGroupEl = this.createProtoContactGroupNode(group);
            protoGroupsElement.appendChild(protoGroupEl);
        }
        Element subgroupsElement = this.contactListDocument.createElement(SUBGROUPS_NODE_NAME);
        metaGroupElement.appendChild(subgroupsElement);
        Iterator subgroups = metaGroup.getSubgroups();
        while (subgroups.hasNext()) {
            MetaContactGroup subgroup = (MetaContactGroup)subgroups.next();
            Element subgroupEl = this.createMetaContactGroupNode(subgroup);
            subgroupsElement.appendChild(subgroupEl);
        }
        Element childContactsElement = this.contactListDocument.createElement(CHILD_CONTACTS_NODE_NAME);
        metaGroupElement.appendChild(childContactsElement);
        Iterator childContacts = metaGroup.getChildContacts();
        while (childContacts.hasNext()) {
            MetaContact metaContact = (MetaContact)childContacts.next();
            Element metaContactEl = this.createMetaContactNode(metaContact);
            childContactsElement.appendChild(metaContactEl);
        }
        return metaGroupElement;
    }

    public void metaContactAdded(MetaContactEvent evt) {
        if (!evt.getParentGroup().isPersistent()) {
            return;
        }
        Element parentGroupNode = this.findMetaContactGroupNode(evt.getParentGroup().getMetaUID());
        if (parentGroupNode == null) {
            logger.error((Object)("Couldn't find parent of a newly added contact: " + evt.getSourceMetaContact()));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"The above exception occurred with the following stack trace: ", (Throwable)new Exception());
            }
            return;
        }
        parentGroupNode = XMLUtils.findChild((Element)parentGroupNode, (String)CHILD_CONTACTS_NODE_NAME);
        Element metaContactElement = this.createMetaContactNode(evt.getSourceMetaContact());
        parentGroupNode.appendChild(metaContactElement);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after adding contact " + evt.getSourceMetaContact()), (Throwable)ex);
        }
    }

    public void metaContactGroupAdded(MetaContactGroupEvent evt) {
        if (evt.getSourceProtoGroup() != null && !evt.getSourceProtoGroup().isPersistent()) {
            return;
        }
        MetaContactGroup parentGroup = evt.getSourceMetaContactGroup().getParentMetaContactGroup();
        Element parentGroupNode = this.findMetaContactGroupNode(parentGroup.getMetaUID());
        if (parentGroupNode == null) {
            logger.error((Object)("Couldn't find parent of a newly added group: " + parentGroup));
            return;
        }
        Element newGroupElement = this.createMetaContactGroupNode(evt.getSourceMetaContactGroup());
        Element subgroupsNode = XMLUtils.findChild((Element)parentGroupNode, (String)SUBGROUPS_NODE_NAME);
        subgroupsNode.appendChild(newGroupElement);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after adding contact " + evt.getSourceMetaContactGroup()), (Throwable)ex);
        }
    }

    public void metaContactGroupRemoved(MetaContactGroupEvent evt) {
        Element metaContactGroupNode = this.findMetaContactGroupNode(evt.getSourceMetaContactGroup().getMetaUID());
        if (metaContactGroupNode == null) {
            logger.error((Object)("Save after removing an MN group. Groupt not found: " + evt.getSourceMetaContactGroup()));
            return;
        }
        metaContactGroupNode.getParentNode().removeChild(metaContactGroupNode);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after removing group " + evt.getSourceMetaContactGroup()), (Throwable)ex);
        }
    }

    public void metaContactMoved(MetaContactMovedEvent evt) {
        Element metaContactNode = this.findMetaContactNode(evt.getSourceMetaContact().getMetaUID());
        Element newParentNode = this.findMetaContactGroupNode(evt.getNewParent().getMetaUID());
        if (newParentNode == null) {
            logger.error((Object)("Save after metacontact moved. new parent not found: " + evt.getNewParent()));
            if (logger.isTraceEnabled()) {
                logger.error((Object)"The above exception has occurred with the following stack trace", (Throwable)new Exception());
            }
            return;
        }
        if (metaContactNode == null) {
            metaContactNode = this.createMetaContactNode(evt.getSourceMetaContact());
        } else {
            metaContactNode.getParentNode().removeChild(metaContactNode);
        }
        this.updateParentsForMetaContactNode(metaContactNode, evt.getNewParent());
        Element childContacts = XMLUtils.findChild((Element)newParentNode, (String)CHILD_CONTACTS_NODE_NAME);
        childContacts.appendChild(metaContactNode);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after moving " + evt.getSourceMetaContact()), (Throwable)ex);
        }
    }

    private void updateParentsForMetaContactNode(Element metaContactNode, MetaContactGroup newParent) {
        NodeList children = metaContactNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element contactElement;
            String attribute;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals(PROTO_CONTACT_NODE_NAME) || (attribute = (contactElement = (Element)currentNode).getAttribute(PARENT_PROTO_GROUP_UID_ATTR_NAME)) == null || attribute.trim().length() == 0) continue;
            String contactAccountID = contactElement.getAttribute(ACCOUNT_ID_ATTR_NAME);
            Iterator possibleParents = newParent.getContactGroupsForAccountID(contactAccountID);
            String newParentUID = ((ContactGroup)possibleParents.next()).getUID();
            contactElement.setAttribute(PARENT_PROTO_GROUP_UID_ATTR_NAME, newParentUID);
        }
    }

    public void metaContactRemoved(MetaContactEvent evt) {
        Element metaContactNode = this.findMetaContactNode(evt.getSourceMetaContact().getMetaUID());
        if (metaContactNode == null) {
            logger.error((Object)("Save after metacontact removed. Contact not found: " + evt.getSourceMetaContact()));
            return;
        }
        metaContactNode.getParentNode().removeChild(metaContactNode);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after removing " + evt.getSourceMetaContact()), (Throwable)ex);
        }
    }

    public void metaContactRenamed(MetaContactRenamedEvent evt) {
        Element metaContactNode = this.findMetaContactNode(evt.getSourceMetaContact().getMetaUID());
        if (metaContactNode == null) {
            logger.error((Object)("Save after renam failed. Contact not found: " + evt.getSourceMetaContact()));
            return;
        }
        Element displayNameNode = XMLUtils.findChild((Element)metaContactNode, (String)META_CONTACT_DISPLAY_NAME_NODE_NAME);
        if (((MetaContactImpl)evt.getSourceMetaContact()).isDisplayNameUserDefined()) {
            displayNameNode.setAttribute(USER_DEFINED_DISPLAY_NAME_ATTR_NAME, Boolean.TRUE.toString());
        } else {
            displayNameNode.removeAttribute(USER_DEFINED_DISPLAY_NAME_ATTR_NAME);
        }
        XMLUtils.setText((Element)displayNameNode, (String)evt.getNewDisplayName());
        this.updatePersistentDataForMetaContact(evt.getSourceMetaContact());
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after rename of " + evt.getSourceMetaContact()), (Throwable)ex);
        }
    }

    public void protoContactModified(ProtoContactEvent evt) {
        Element metaContactNode = this.findMetaContactNode(evt.getParent().getMetaUID());
        if (metaContactNode == null) {
            logger.error((Object)("Save after proto contact modification failed. Contact not found: " + evt.getParent()));
            return;
        }
        this.updatePersistentDataForMetaContact(evt.getParent());
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after rename of " + evt.getParent()), (Throwable)ex);
        }
    }

    public void metaContactModified(MetaContactModifiedEvent evt) {
        List nodes;
        String name = evt.getModificationName();
        Element metaContactNode = this.findMetaContactNode(evt.getSourceMetaContact().getMetaUID());
        if (metaContactNode == null) {
            logger.error((Object)("Save after rename failed. Contact not found: " + evt.getSourceMetaContact()));
            return;
        }
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        boolean isChanged = false;
        if (oldValue == null && newValue != null) {
            if (!(newValue instanceof String)) {
                return;
            }
            Element detailElement = this.contactListDocument.createElement(META_CONTACT_DETAIL_NAME_NODE_NAME);
            detailElement.setAttribute("name", name);
            detailElement.setAttribute(DETAIL_VALUE_ATTR_NAME, (String)newValue);
            metaContactNode.appendChild(detailElement);
            isChanged = true;
        } else if (oldValue != null && newValue == null) {
            if (oldValue instanceof List) {
                List valuesToRemove = (List)oldValue;
                List nodes2 = XMLUtils.locateElements((Element)metaContactNode, (String)META_CONTACT_DETAIL_NAME_NODE_NAME, (String)"name", (String)name);
                ArrayList<Element> nodesToRemove = new ArrayList<Element>();
                for (Element e : nodes2) {
                    if (!valuesToRemove.contains(e.getAttribute(DETAIL_VALUE_ATTR_NAME))) continue;
                    nodesToRemove.add(e);
                }
                for (Element e : nodesToRemove) {
                    metaContactNode.removeChild(e);
                }
                if (nodesToRemove.size() > 0) {
                    isChanged = true;
                }
            } else if (oldValue instanceof String) {
                nodes = XMLUtils.locateElements((Element)metaContactNode, (String)META_CONTACT_DETAIL_NAME_NODE_NAME, (String)"name", (String)name);
                Element elementToRemove = null;
                for (Element e : nodes) {
                    if (!e.getAttribute(DETAIL_VALUE_ATTR_NAME).equals(oldValue)) continue;
                    elementToRemove = e;
                    break;
                }
                if (elementToRemove == null) {
                    return;
                }
                metaContactNode.removeChild(elementToRemove);
                isChanged = true;
            }
        } else if (oldValue != null && newValue != null) {
            nodes = XMLUtils.locateElements((Element)metaContactNode, (String)META_CONTACT_DETAIL_NAME_NODE_NAME, (String)"name", (String)name);
            Element changedElement = null;
            for (Element e : nodes) {
                if (!e.getAttribute(DETAIL_VALUE_ATTR_NAME).equals(oldValue)) continue;
                changedElement = e;
                break;
            }
            if (changedElement == null) {
                return;
            }
            changedElement.setAttribute(DETAIL_VALUE_ATTR_NAME, (String)newValue);
            isChanged = true;
        }
        if (!isChanged) {
            return;
        }
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after rename of " + evt.getSourceMetaContact()), (Throwable)ex);
        }
    }

    public void protoContactRemoved(ProtoContactEvent evt) {
        Element oldMcNode = this.findMetaContactNode(evt.getOldParent().getMetaUID());
        if (oldMcNode == null) {
            logger.error((Object)("Failed to find meta contact (old parent): " + oldMcNode));
            return;
        }
        Element protoNode = XMLUtils.locateElement((Element)oldMcNode, (String)PROTO_CONTACT_NODE_NAME, (String)PROTO_CONTACT_ADDRESS_ATTR_NAME, (String)evt.getProtoContact().getAddress());
        protoNode.getParentNode().removeChild(protoNode);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after removing proto contact " + evt.getProtoContact()), (Throwable)ex);
        }
    }

    public void childContactsReordered(MetaContactGroupEvent evt) {
    }

    public void metaContactGroupModified(MetaContactGroupEvent evt) {
        MetaContactGroup mcGroup = evt.getSourceMetaContactGroup();
        Element mcGroupNode = this.findMetaContactGroupNode(mcGroup.getMetaUID());
        if (mcGroupNode == null) {
            logger.error((Object)("Failed to find meta contact group: " + mcGroup));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"The above error occurred with the following stack trace: ", (Throwable)new Exception());
            }
            return;
        }
        switch (evt.getEventID()) {
            case 3: 
            case 5: 
            case 6: {
                Node parentNode = mcGroupNode.getParentNode();
                parentNode.removeChild(mcGroupNode);
                Element newGroupElement = this.createMetaContactGroupNode(mcGroup);
                parentNode.appendChild(newGroupElement);
                try {
                    this.scheduleContactListStorage();
                }
                catch (IOException ex) {
                    logger.error((Object)("Writing CL failed after adding contact " + mcGroup), (Throwable)ex);
                }
                break;
            }
            case 7: {
                mcGroupNode.setAttribute("name", mcGroup.getGroupName());
            }
        }
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after removing proto group " + mcGroup.getGroupName()), (Throwable)ex);
        }
    }

    public void protoContactAdded(ProtoContactEvent evt) {
        Element mcNode = this.findMetaContactNode(evt.getParent().getMetaUID());
        if (mcNode == null) {
            logger.error((Object)("Failed to find meta contact: " + evt.getParent()));
            return;
        }
        Element protoNode = this.createProtoContactNode(evt.getProtoContact());
        if (protoNode == null) {
            logger.error((Object)("Failed to create proto contact node for: " + evt.getProtoContact()));
            return;
        }
        mcNode.appendChild(protoNode);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after adding proto contact " + evt.getProtoContact()), (Throwable)ex);
        }
    }

    public void protoContactMoved(ProtoContactEvent evt) {
        Element newMcNode = this.findMetaContactNode(evt.getNewParent().getMetaUID());
        Element oldMcNode = this.findMetaContactNode(evt.getOldParent().getMetaUID());
        if (oldMcNode == null) {
            logger.error((Object)("Failed to find meta contact (old parent): " + oldMcNode));
            return;
        }
        if (newMcNode == null) {
            logger.error((Object)("Failed to find meta contact (old parent): " + newMcNode));
            return;
        }
        Element protoNode = XMLUtils.locateElement((Element)oldMcNode, (String)PROTO_CONTACT_NODE_NAME, (String)PROTO_CONTACT_ADDRESS_ATTR_NAME, (String)evt.getProtoContact().getAddress());
        protoNode.getParentNode().removeChild(protoNode);
        protoNode.setAttribute(PARENT_PROTO_GROUP_UID_ATTR_NAME, evt.getProtoContact().getParentContactGroup().getUID());
        newMcNode.appendChild(protoNode);
        try {
            this.scheduleContactListStorage();
        }
        catch (IOException ex) {
            logger.error((Object)("Writing CL failed after moving proto contact " + evt.getProtoContact()), (Throwable)ex);
        }
    }

    private Element findMetaContactNode(String metaContactUID) {
        Element root = (Element)this.contactListDocument.getFirstChild();
        return XMLUtils.locateElement((Element)root, (String)META_CONTACT_NODE_NAME, (String)"uid", (String)metaContactUID);
    }

    private Element findMetaContactGroupNode(String metaContactGroupUID) {
        Element root = (Element)this.contactListDocument.getFirstChild();
        return XMLUtils.locateElement((Element)root, (String)GROUP_NODE_NAME, (String)"uid", (String)metaContactGroupUID);
    }

    void removeContactListFile() {
        this.contactlistFile.delete();
    }

    public void metaContactAvatarUpdated(MetaContactAvatarUpdateEvent evt) {
    }

    static class StoredProtoContactDescriptor {
        String contactAddress = null;
        String persistentData = null;
        ContactGroup parentProtoGroup = null;

        StoredProtoContactDescriptor(String contactAddress, String persistentData, ContactGroup parentProtoGroup) {
            this.contactAddress = contactAddress;
            this.persistentData = persistentData;
            this.parentProtoGroup = parentProtoGroup;
        }

        public String toString() {
            return "StoredProtocoContactDescriptor[  contactAddress=" + this.contactAddress + " persistenData=" + this.persistentData + " parentProtoGroup=" + (this.parentProtoGroup == null ? "" : this.parentProtoGroup.getGroupName()) + "]";
        }

        private static StoredProtoContactDescriptor findContactInList(String contactAddress, List<StoredProtoContactDescriptor> list) {
            if (list != null && list.size() > 0) {
                for (StoredProtoContactDescriptor desc : list) {
                    if (!desc.contactAddress.equals(contactAddress)) continue;
                    return desc;
                }
            }
            return null;
        }
    }
}

