/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.Buffer;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import org.ice4j.util.QueueStatistics;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.rtp.translator.PushSourceStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.SourcePacket;
import org.jitsi.util.Logger;

class PushSourceStreamImpl
implements PushSourceStream,
Runnable,
SourceTransferHandler {
    private static final Logger logger = Logger.getLogger(PushSourceStreamImpl.class);
    private boolean closed = false;
    private final RTPConnectorImpl connector;
    private final boolean data;
    private boolean _read = false;
    private final Queue<SourcePacket> readQ;
    private final int readQCapacity;
    private final QueueStatistics readQStats;
    private int numDroppedPackets = 0;
    private final Queue<SourcePacket> sourcePacketPool = new LinkedBlockingQueue<SourcePacket>(RTPConnectorOutputStream.POOL_CAPACITY);
    private final List<PushSourceStreamDesc> streams = new LinkedList<PushSourceStreamDesc>();
    private Thread transferDataThread;
    private SourceTransferHandler _transferHandler;

    public PushSourceStreamImpl(RTPConnectorImpl connector, boolean data) {
        this.connector = connector;
        this.data = data;
        this.readQCapacity = RTPConnectorOutputStream.PACKET_QUEUE_CAPACITY;
        this.readQ = new ArrayBlockingQueue<SourcePacket>(this.readQCapacity);
        this.readQStats = logger.isTraceEnabled() ? new QueueStatistics(this.getClass().getSimpleName() + "-" + this.hashCode()) : null;
        this.transferDataThread = new Thread((Runnable)this, this.getClass().getName());
        this.transferDataThread.setDaemon(true);
        this.transferDataThread.start();
    }

    public synchronized void addStream(RTPConnectorDesc connectorDesc, PushSourceStream stream) {
        for (PushSourceStreamDesc streamDesc : this.streams) {
            if (streamDesc.connectorDesc != connectorDesc || streamDesc.stream != stream) continue;
            return;
        }
        this.streams.add(new PushSourceStreamDesc(connectorDesc, stream, this.data));
        stream.setTransferHandler((SourceTransferHandler)this);
    }

    public void close() {
        this.closed = true;
        this.sourcePacketPool.clear();
    }

    public boolean endOfStream() {
        return false;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    public synchronized int getMinimumTransferSize() {
        int minimumTransferSize = 0;
        for (PushSourceStreamDesc streamDesc : this.streams) {
            int streamMinimumTransferSize = streamDesc.stream.getMinimumTransferSize();
            if (minimumTransferSize >= streamMinimumTransferSize) continue;
            minimumTransferSize = streamMinimumTransferSize;
        }
        return minimumTransferSize;
    }

    private RTPTranslatorImpl getTranslator() {
        return this.connector.translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        RTPTranslatorImpl translator;
        int pktLength;
        SourcePacket pkt;
        if (this.closed) {
            return -1;
        }
        Queue<SourcePacket> queue = this.readQ;
        synchronized (queue) {
            pkt = this.readQ.peek();
            if (pkt == null) {
                return 0;
            }
            pktLength = pkt.getLength();
            if (length < pktLength) {
                throw new IOException("Length " + length + " is insufficient. Must be at least " + pktLength + ".");
            }
            this.readQ.remove();
            if (this.readQStats != null) {
                this.readQStats.remove(System.currentTimeMillis());
            }
            this._read = true;
            this.readQ.notifyAll();
        }
        System.arraycopy(pkt.getBuffer(), pkt.getOffset(), buffer, offset, pktLength);
        PushSourceStreamDesc streamDesc = pkt.streamDesc;
        int read = pktLength;
        int flags = pkt.getFlags();
        pkt.streamDesc = null;
        this.sourcePacketPool.offer(pkt);
        if (read > 0 && (translator = this.getTranslator()) != null) {
            read = translator.didRead(streamDesc, buffer, offset, read, flags);
        }
        return read;
    }

    public synchronized void removeStreams(RTPConnectorDesc connectorDesc) {
        Iterator<PushSourceStreamDesc> streamIter = this.streams.iterator();
        while (streamIter.hasNext()) {
            PushSourceStreamDesc streamDesc = streamIter.next();
            if (streamDesc.connectorDesc != connectorDesc) continue;
            streamDesc.stream.setTransferHandler(null);
            streamIter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            block10: while (true) {
                while (!this.closed) {
                    SourceTransferHandler transferHandler = this._transferHandler;
                    Queue<SourcePacket> queue = this.readQ;
                    synchronized (queue) {
                        if (this.readQ.isEmpty() || transferHandler == null) {
                            try {
                                this.readQ.wait(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    try {
                        transferHandler.transferData((PushSourceStream)this);
                        continue block10;
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn("An RTP packet may have not been fully handled.", t);
                    }
                }
                break block15;
                {
                    continue block10;
                    break;
                }
                break;
            }
            finally {
                if (Thread.currentThread().equals(this.transferDataThread)) {
                    this.transferDataThread = null;
                }
            }
        }
    }

    public synchronized void setTransferHandler(SourceTransferHandler transferHandler) {
        if (this._transferHandler != transferHandler) {
            this._transferHandler = transferHandler;
            for (PushSourceStreamDesc streamDesc : this.streams) {
                streamDesc.stream.setTransferHandler((SourceTransferHandler)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferData(PushSourceStream stream) {
        SourcePacket pkt;
        block55: {
            boolean yield;
            byte[] buf;
            if (this.closed) {
                return;
            }
            PushSourceStreamDesc streamDesc = null;
            PushSourceStreamImpl pushSourceStreamImpl = this;
            synchronized (pushSourceStreamImpl) {
                for (PushSourceStreamDesc aStreamDesc : this.streams) {
                    if (aStreamDesc.stream != stream) continue;
                    streamDesc = aStreamDesc;
                    break;
                }
            }
            if (streamDesc == null) {
                return;
            }
            int len = stream.getMinimumTransferSize();
            if (len < 1) {
                len = 2048;
            }
            if ((pkt = this.sourcePacketPool.poll()) == null || (buf = pkt.getBuffer()).length < len) {
                buf = new byte[len];
                pkt = new SourcePacket(buf, 0, 0);
            } else {
                len = buf.length;
                pkt.setFlags(0);
                pkt.setLength(0);
                pkt.setOffset(0);
            }
            int read = 0;
            try {
                PushBufferStream streamAsPushBufferStream = streamDesc.streamAsPushBufferStream;
                if (streamAsPushBufferStream == null) {
                    read = stream.read(buf, 0, len);
                } else {
                    streamAsPushBufferStream.read((Buffer)pkt);
                    if (pkt.isDiscard()) {
                        read = 0;
                    } else {
                        read = pkt.getLength();
                        if (read < 1 && (pkt.getFlags() & 1) == 1) {
                            read = -1;
                        }
                    }
                }
                if (read <= 0) break block55;
            }
            catch (IOException ioe) {
                block56: {
                    boolean yield2;
                    try {
                        logger.error("Failed to read from an RTP stream!", ioe);
                        if (read <= 0) break block56;
                    }
                    catch (Throwable throwable) {
                        if (read > 0) {
                            boolean yield3;
                            pkt.setLength(read);
                            pkt.streamDesc = streamDesc;
                            Queue<SourcePacket> queue = this.readQ;
                            synchronized (queue) {
                                int readQSize = this.readQ.size();
                                yield3 = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this._read : true);
                                if (yield3) {
                                    this.readQ.notifyAll();
                                }
                            }
                            if (yield3) {
                                Thread.yield();
                            }
                            queue = this.readQ;
                            synchronized (queue) {
                                long now = System.currentTimeMillis();
                                if (this.readQ.size() >= this.readQCapacity) {
                                    this.readQ.remove();
                                    if (this.readQStats != null) {
                                        this.readQStats.remove(now);
                                    }
                                    ++this.numDroppedPackets;
                                    if (RTPConnectorOutputStream.logDroppedPacket(this.numDroppedPackets)) {
                                        logger.warn("Dropped " + this.numDroppedPackets + " packets hashCode=" + this.hashCode() + "): ");
                                    }
                                }
                                if (this.readQ.offer(pkt) && this.readQStats != null) {
                                    this.readQStats.add(now);
                                }
                                this.readQ.notifyAll();
                            }
                        }
                        pkt.streamDesc = null;
                        this.sourcePacketPool.offer(pkt);
                        throw throwable;
                    }
                    pkt.setLength(read);
                    pkt.streamDesc = streamDesc;
                    Queue<SourcePacket> queue = this.readQ;
                    synchronized (queue) {
                        int readQSize = this.readQ.size();
                        yield2 = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this._read : true);
                        if (yield2) {
                            this.readQ.notifyAll();
                        }
                    }
                    if (yield2) {
                        Thread.yield();
                    }
                    queue = this.readQ;
                    synchronized (queue) {
                        long now = System.currentTimeMillis();
                        if (this.readQ.size() >= this.readQCapacity) {
                            this.readQ.remove();
                            if (this.readQStats != null) {
                                this.readQStats.remove(now);
                            }
                            ++this.numDroppedPackets;
                            if (RTPConnectorOutputStream.logDroppedPacket(this.numDroppedPackets)) {
                                logger.warn("Dropped " + this.numDroppedPackets + " packets hashCode=" + this.hashCode() + "): ");
                            }
                        }
                        if (this.readQ.offer(pkt) && this.readQStats != null) {
                            this.readQStats.add(now);
                        }
                        this.readQ.notifyAll();
                    }
                }
                pkt.streamDesc = null;
                this.sourcePacketPool.offer(pkt);
            }
            pkt.setLength(read);
            pkt.streamDesc = streamDesc;
            Queue<SourcePacket> queue = this.readQ;
            synchronized (queue) {
                int readQSize = this.readQ.size();
                yield = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this._read : true);
                if (yield) {
                    this.readQ.notifyAll();
                }
            }
            if (yield) {
                Thread.yield();
            }
            queue = this.readQ;
            synchronized (queue) {
                long now = System.currentTimeMillis();
                if (this.readQ.size() >= this.readQCapacity) {
                    this.readQ.remove();
                    if (this.readQStats != null) {
                        this.readQStats.remove(now);
                    }
                    ++this.numDroppedPackets;
                    if (RTPConnectorOutputStream.logDroppedPacket(this.numDroppedPackets)) {
                        logger.warn("Dropped " + this.numDroppedPackets + " packets hashCode=" + this.hashCode() + "): ");
                    }
                }
                if (this.readQ.offer(pkt) && this.readQStats != null) {
                    this.readQStats.add(now);
                }
                this.readQ.notifyAll();
            }
        }
        pkt.streamDesc = null;
        this.sourcePacketPool.offer(pkt);
    }
}

