/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.util;

import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Stream<E>
implements Iterable<E> {
    private final E[] elements;
    private int offset = 0;

    public Stream(E[] EArray) {
        this.elements = (Object[])EArray.clone();
    }

    public E consume() {
        if (this.offset >= this.elements.length) {
            return null;
        }
        return this.elements[this.offset++];
    }

    public <T extends ElementType<E>> E consume(T ... TArray) {
        E e = this.lookahead(1);
        for (T t : TArray) {
            if (!t.isMatchedBy(e)) continue;
            return this.consume();
        }
        throw new UnexpectedElementException(e, this.offset, (ElementType<?>[])TArray);
    }

    public void pushBack() {
        if (this.offset > 0) {
            --this.offset;
        }
    }

    public E lookahead() {
        return this.lookahead(1);
    }

    public E lookahead(int n) {
        int n2 = this.offset + n - 1;
        if (n2 < this.elements.length) {
            return this.elements[n2];
        }
        return null;
    }

    public int currentOffset() {
        return this.offset;
    }

    public <T extends ElementType<E>> boolean positiveLookahead(T ... TArray) {
        for (T t : TArray) {
            if (!t.isMatchedBy(this.lookahead(1))) continue;
            return true;
        }
        return false;
    }

    public <T extends ElementType<E>> boolean positiveLookaheadBefore(ElementType<E> elementType, T ... TArray) {
        E e;
        for (int i = 1; i <= this.elements.length && !elementType.isMatchedBy(e = this.lookahead(i)); ++i) {
            for (T t : TArray) {
                if (!t.isMatchedBy(e)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends ElementType<E>> boolean positiveLookaheadUntil(int n, T ... TArray) {
        for (int i = 1; i <= n; ++i) {
            for (T t : TArray) {
                if (!t.isMatchedBy(this.lookahead(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index;
            {
                this.index = Stream.this.offset;
            }

            @Override
            public boolean hasNext() {
                return this.index < Stream.this.elements.length;
            }

            @Override
            public E next() {
                if (this.index >= Stream.this.elements.length) {
                    throw new NoSuchElementException();
                }
                return Stream.this.elements[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public E[] toArray() {
        return Arrays.copyOfRange(this.elements, this.offset, this.elements.length);
    }

    public static interface ElementType<E> {
        public boolean isMatchedBy(E var1);
    }
}

