/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;

public class PropertyBuilder {
    private static final Object NO_DEFAULT_MARKER = Boolean.FALSE;
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;
    protected final JsonInclude.Value _defaultInclusion;
    protected final boolean _useRealPropertyDefaults;

    public PropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        this._config = serializationConfig;
        this._beanDesc = beanDescription;
        JsonInclude.Value value = JsonInclude.Value.merge((JsonInclude.Value)beanDescription.findPropertyInclusion(JsonInclude.Value.empty()), (JsonInclude.Value)serializationConfig.getDefaultPropertyInclusion(beanDescription.getBeanClass(), JsonInclude.Value.empty()));
        this._defaultInclusion = JsonInclude.Value.merge((JsonInclude.Value)serializationConfig.getDefaultPropertyInclusion(), (JsonInclude.Value)value);
        this._useRealPropertyDefaults = value.getValueInclusion() == JsonInclude.Include.NON_DEFAULT;
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) throws JsonMappingException {
        NameTransformer nameTransformer;
        Object object;
        Object object2;
        JavaType javaType2;
        try {
            javaType2 = this.findSerializationType(annotatedMember, bl, javaType);
        }
        catch (JsonMappingException jsonMappingException) {
            return (BeanPropertyWriter)serializerProvider.reportBadPropertyDefinition(this._beanDesc, beanPropertyDefinition, jsonMappingException.getMessage(), new Object[0]);
        }
        if (typeSerializer2 != null) {
            if (javaType2 == null) {
                javaType2 = javaType;
            }
            if ((object2 = javaType2.getContentType()) == null) {
                serializerProvider.reportBadPropertyDefinition(this._beanDesc, beanPropertyDefinition, "serialization type " + javaType2 + " has no content", new Object[0]);
            }
            javaType2 = javaType2.withContentTypeHandler(typeSerializer2);
            object2 = javaType2.getContentType();
        }
        object2 = null;
        boolean bl2 = false;
        JavaType javaType3 = javaType2 == null ? javaType : javaType2;
        JsonInclude.Value value = this._config.getDefaultPropertyInclusion(javaType3.getRawClass(), this._defaultInclusion);
        JsonInclude.Include include = (value = value.withOverrides(beanPropertyDefinition.findInclusion())).getValueInclusion();
        if (include == JsonInclude.Include.USE_DEFAULTS) {
            include = JsonInclude.Include.ALWAYS;
        }
        switch (include) {
            case NON_DEFAULT: {
                if (this._useRealPropertyDefaults && (object = this.getDefaultBean()) != null) {
                    if (serializerProvider.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                        annotatedMember.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                    }
                    try {
                        object2 = annotatedMember.getValue(object);
                    }
                    catch (Exception exception) {
                        this._throwWrapped(exception, beanPropertyDefinition.getName(), object);
                    }
                } else {
                    object2 = this.getDefaultValue(javaType3);
                    bl2 = true;
                }
                if (object2 == null) {
                    bl2 = true;
                    break;
                }
                if (!object2.getClass().isArray()) break;
                object2 = ArrayBuilders.getArrayComparator(object2);
                break;
            }
            case NON_ABSENT: {
                bl2 = true;
                if (!javaType3.isReferenceType()) break;
                object2 = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case NON_EMPTY: {
                bl2 = true;
                object2 = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case NON_NULL: {
                bl2 = true;
            }
            default: {
                if (!javaType3.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                object2 = BeanPropertyWriter.MARKER_FOR_EMPTY;
            }
        }
        object = new BeanPropertyWriter(beanPropertyDefinition, annotatedMember, this._beanDesc.getClassAnnotations(), javaType, jsonSerializer, typeSerializer, javaType2, bl2, object2);
        Object object3 = this._annotationIntrospector.findNullSerializer(annotatedMember);
        if (object3 != null) {
            ((BeanPropertyWriter)object).assignNullSerializer(serializerProvider.serializerInstance(annotatedMember, object3));
        }
        if ((nameTransformer = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedMember)) != null) {
            object = ((BeanPropertyWriter)object).unwrappingWriter(nameTransformer);
        }
        return object;
    }

    protected JavaType findSerializationType(Annotated annotated, boolean bl, JavaType javaType) throws JsonMappingException {
        Object object;
        JavaType javaType2 = this._annotationIntrospector.refineSerializationType(this._config, annotated, javaType);
        if (javaType2 != javaType) {
            Class<?> clazz;
            object = javaType2.getRawClass();
            if (!((Class)object).isAssignableFrom(clazz = javaType.getRawClass()) && !clazz.isAssignableFrom((Class<?>)object)) {
                throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + annotated.getName() + "': class " + ((Class)object).getName() + " not a super-type of (declared) class " + clazz.getName());
            }
            bl = true;
            javaType = javaType2;
        }
        if ((object = this._annotationIntrospector.findSerializationTyping(annotated)) != null && object != JsonSerialize.Typing.DEFAULT_TYPING) {
            boolean bl2 = bl = object == JsonSerialize.Typing.STATIC;
        }
        if (bl) {
            return javaType.withStaticTyping();
        }
        return null;
    }

    protected Object getDefaultBean() {
        Object object = this._defaultBean;
        if (object == null) {
            object = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (object == null) {
                object = NO_DEFAULT_MARKER;
            }
            this._defaultBean = object;
        }
        return object == NO_DEFAULT_MARKER ? null : this._defaultBean;
    }

    @Deprecated
    protected Object getPropertyDefaultValue(String string, AnnotatedMember annotatedMember, JavaType javaType) {
        Object object = this.getDefaultBean();
        if (object == null) {
            return this.getDefaultValue(javaType);
        }
        try {
            return annotatedMember.getValue(object);
        }
        catch (Exception exception) {
            return this._throwWrapped(exception, string, object);
        }
    }

    protected Object getDefaultValue(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        Class<?> clazz2 = ClassUtil.primitiveType(clazz);
        if (clazz2 != null) {
            return ClassUtil.defaultValue(clazz2);
        }
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (clazz == String.class) {
            return "";
        }
        return null;
    }

    protected Object _throwWrapped(Exception exception, String string, Object object) {
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new IllegalArgumentException("Failed to get property '" + string + "' of default " + object.getClass().getName() + " instance");
    }
}

