/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUtil;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.ProviderUtil;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public class Persistence {
    @Deprecated
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    @Deprecated
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
    static final String PERSISTENCE_PROVIDER_PROPERTY = "javax.persistence.provider";
    static final String PERSISTENCE_PROVIDER_SERVICE = "META-INF/services/" + PersistenceProvider.class.getName();

    public static EntityManagerFactory createEntityManagerFactory(String string) {
        return Persistence.createEntityManagerFactory(string, Collections.EMPTY_MAP);
    }

    public static EntityManagerFactory createEntityManagerFactory(String string, Map map) {
        CharSequence charSequence;
        EntityManagerFactory entityManagerFactory = null;
        Map map2 = map;
        if (map2 == null) {
            map2 = Collections.EMPTY_MAP;
        }
        PersistenceProviderResolver persistenceProviderResolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List<PersistenceProvider> list = persistenceProviderResolver.getPersistenceProviders();
        Object v = map2.get(PERSISTENCE_PROVIDER_PROPERTY);
        if (v != null && v instanceof String) {
            boolean bl = false;
            charSequence = v.toString();
            for (PersistenceProvider persistenceProvider : list) {
                if (persistenceProvider.getClass().getName().compareTo((String)charSequence) != 0) continue;
                bl = true;
                break;
            }
            if (!bl && (entityManagerFactory = Persistence.createFactory(((String)charSequence).toString(), string, map2)) != null) {
                return entityManagerFactory;
            }
        }
        HashMap<String, Throwable> hashMap = new HashMap<String, Throwable>();
        charSequence = null;
        for (PersistenceProvider persistenceProvider : list) {
            String string2 = persistenceProvider.getClass().getName();
            try {
                entityManagerFactory = persistenceProvider.createEntityManagerFactory(string, map2);
            }
            catch (Exception exception) {
                hashMap.put(string2, exception);
            }
            if (entityManagerFactory != null) {
                return entityManagerFactory;
            }
            if (charSequence == null) {
                charSequence = new StringBuffer(string2);
                continue;
            }
            ((StringBuffer)charSequence).append(", ");
            ((StringBuffer)charSequence).append(string2);
        }
        if (charSequence == null) {
            charSequence = new StringBuffer("NONE");
        }
        if (hashMap.isEmpty()) {
            throw new PersistenceException("No persistence providers available for \"" + string + "\" after trying the following discovered implementations: " + charSequence);
        }
        throw Persistence.createPersistenceException("Explicit persistence provider error(s) occurred for \"" + string + "\" after trying the following discovered implementations: " + charSequence, hashMap);
    }

    private static EntityManagerFactory createFactory(String string, String string2, Map map) throws PersistenceException {
        Class clazz;
        ClassLoader classLoader = PrivClassLoader.get(null);
        if (classLoader == null) {
            classLoader = PrivClassLoader.get(Persistence.class);
        }
        try {
            clazz = ProviderLocator.loadClass((String)string, Persistence.class, (ClassLoader)classLoader);
        }
        catch (Exception exception) {
            throw new PersistenceException("Invalid or inaccessible explicit provider class: " + string, exception);
        }
        try {
            PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
            return persistenceProvider.createEntityManagerFactory(string2, map);
        }
        catch (Exception exception) {
            throw new PersistenceException("Explicit error returned from provider: " + string + " for PU: " + string2, exception);
        }
    }

    private static PersistenceException createPersistenceException(String string, Map<String, Throwable> map) {
        String string2 = System.getProperty("line.separator");
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(string);
        if (map.size() <= 1) {
            Throwable throwable = null;
            Iterator<String> iterator = map.keySet().iterator();
            if (iterator.hasNext()) {
                String string3 = iterator.next();
                throwable = map.get(string3);
                stringWriter.append(" from provider: ");
                stringWriter.append(string3);
            }
            return new PersistenceException(stringWriter.toString(), throwable);
        }
        stringWriter.append(" with the following failures:");
        stringWriter.append(string2);
        for (String string4 : map.keySet()) {
            stringWriter.append(string4);
            stringWriter.append(" returned: ");
            map.get(string4).printStackTrace(new PrintWriter(stringWriter));
        }
        stringWriter.append(string2);
        return new PersistenceException(stringWriter.toString());
    }

    public static PersistenceUtil getPersistenceUtil() {
        return new PersistenceUtilImpl();
    }

    private static class PrivClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> c;

        public static ClassLoader get(Class<?> clazz) {
            PrivClassLoader privClassLoader = new PrivClassLoader(clazz);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(privClassLoader);
            }
            return privClassLoader.run();
        }

        private PrivClassLoader(Class<?> clazz) {
            this.c = clazz;
        }

        @Override
        public ClassLoader run() {
            if (this.c != null) {
                return this.c.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PersistenceUtilImpl
    implements PersistenceUtil {
        private PersistenceUtilImpl() {
        }

        @Override
        public boolean isLoaded(Object object, String string) {
            LoadState loadState;
            ProviderUtil providerUtil;
            boolean bl = true;
            PersistenceProviderResolver persistenceProviderResolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            List<PersistenceProvider> list = persistenceProviderResolver.getPersistenceProviders();
            for (PersistenceProvider persistenceProvider : list) {
                try {
                    providerUtil = persistenceProvider.getProviderUtil();
                    loadState = providerUtil.isLoadedWithoutReference(object, string);
                    if (loadState == LoadState.LOADED) {
                        return true;
                    }
                    if (loadState != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable throwable) {
                }
            }
            for (PersistenceProvider persistenceProvider : list) {
                try {
                    providerUtil = persistenceProvider.getProviderUtil();
                    loadState = providerUtil.isLoadedWithReference(object, string);
                    if (loadState == LoadState.LOADED) {
                        return true;
                    }
                    if (loadState != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable throwable) {
                }
            }
            return true;
        }

        @Override
        public boolean isLoaded(Object object) {
            PersistenceProviderResolver persistenceProviderResolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            List<PersistenceProvider> list = persistenceProviderResolver.getPersistenceProviders();
            for (PersistenceProvider persistenceProvider : list) {
                try {
                    ProviderUtil providerUtil = persistenceProvider.getProviderUtil();
                    LoadState loadState = providerUtil.isLoaded(object);
                    if (loadState == LoadState.LOADED) {
                        return true;
                    }
                    if (loadState != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable throwable) {
                }
            }
            return true;
        }
    }
}

