/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.pop3;

import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.commons.net.io.DotTerminatedMessageReader;
import org.apache.commons.net.pop3.POP3;
import org.apache.commons.net.pop3.POP3MessageInfo;

public class POP3Client
extends POP3 {
    private static POP3MessageInfo __parseStatus(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreElements()) {
                return null;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new POP3MessageInfo(n2, n);
    }

    private static POP3MessageInfo __parseUID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreElements()) {
                return null;
            }
            string = stringTokenizer.nextToken();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new POP3MessageInfo(n, string);
    }

    public boolean capa() throws IOException {
        if (this.sendCommand(12) == 0) {
            this.getAdditionalReply();
            return true;
        }
        return false;
    }

    public boolean login(String string, String string2) throws IOException {
        if (this.getState() != 0) {
            return false;
        }
        if (this.sendCommand(0, string) != 0) {
            return false;
        }
        if (this.sendCommand(1, string2) != 0) {
            return false;
        }
        this.setState(1);
        return true;
    }

    public boolean login(String string, String string2, String string3) throws IOException, NoSuchAlgorithmException {
        if (this.getState() != 0) {
            return false;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        string2 = string2 + string3;
        byte[] byArray = messageDigest.digest(string2.getBytes(this.getCharsetName()));
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n <= 15) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        StringBuilder stringBuilder2 = new StringBuilder(256);
        stringBuilder2.append(string);
        stringBuilder2.append(' ');
        stringBuilder2.append(stringBuilder.toString());
        if (this.sendCommand(9, stringBuilder2.toString()) != 0) {
            return false;
        }
        this.setState(1);
        return true;
    }

    public boolean logout() throws IOException {
        if (this.getState() == 1) {
            this.setState(2);
        }
        this.sendCommand(2);
        return this._replyCode == 0;
    }

    public boolean noop() throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(7) == 0;
        }
        return false;
    }

    public boolean deleteMessage(int n) throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(6, Integer.toString(n)) == 0;
        }
        return false;
    }

    public boolean reset() throws IOException {
        if (this.getState() == 1) {
            return this.sendCommand(8) == 0;
        }
        return false;
    }

    public POP3MessageInfo status() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(3) != 0) {
            return null;
        }
        return POP3Client.__parseStatus(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo listMessage(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(4, Integer.toString(n)) != 0) {
            return null;
        }
        return POP3Client.__parseStatus(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo[] listMessages() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(4) != 0) {
            return null;
        }
        this.getAdditionalReply();
        POP3MessageInfo[] pOP3MessageInfoArray = new POP3MessageInfo[this._replyLines.size() - 2];
        ListIterator listIterator = this._replyLines.listIterator(1);
        for (int i = 0; i < pOP3MessageInfoArray.length; ++i) {
            pOP3MessageInfoArray[i] = POP3Client.__parseStatus((String)listIterator.next());
        }
        return pOP3MessageInfoArray;
    }

    public POP3MessageInfo listUniqueIdentifier(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(11, Integer.toString(n)) != 0) {
            return null;
        }
        return POP3Client.__parseUID(this._lastReplyLine.substring(3));
    }

    public POP3MessageInfo[] listUniqueIdentifiers() throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(11) != 0) {
            return null;
        }
        this.getAdditionalReply();
        POP3MessageInfo[] pOP3MessageInfoArray = new POP3MessageInfo[this._replyLines.size() - 2];
        ListIterator listIterator = this._replyLines.listIterator(1);
        for (int i = 0; i < pOP3MessageInfoArray.length; ++i) {
            pOP3MessageInfoArray[i] = POP3Client.__parseUID((String)listIterator.next());
        }
        return pOP3MessageInfoArray;
    }

    public Reader retrieveMessage(int n) throws IOException {
        if (this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(5, Integer.toString(n)) != 0) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader);
    }

    public Reader retrieveMessageTop(int n, int n2) throws IOException {
        if (n2 < 0 || this.getState() != 1) {
            return null;
        }
        if (this.sendCommand(10, Integer.toString(n) + " " + Integer.toString(n2)) != 0) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader);
    }
}

