/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.net.nntp.Threadable;

public class Article
implements Threadable {
    private long articleNumber = -1L;
    private String subject;
    private String date;
    private String articleId;
    private String simplifiedSubject;
    private String from;
    private ArrayList<String> references;
    private boolean isReply = false;
    public Article kid;
    public Article next;

    public void addReference(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.references == null) {
            this.references = new ArrayList();
        }
        this.isReply = true;
        for (String string2 : string.split(" ")) {
            this.references.add(string2);
        }
    }

    public String[] getReferences() {
        if (this.references == null) {
            return new String[0];
        }
        return this.references.toArray(new String[this.references.size()]);
    }

    private void simplifySubject() {
        int n = 0;
        String string = this.getSubject();
        int n2 = string.length();
        boolean bl = false;
        while (!bl) {
            int n3;
            bl = true;
            while (n < n2 && string.charAt(n) == ' ') {
                ++n;
            }
            if (!(n >= n2 - 2 || string.charAt(n) != 'r' && string.charAt(n) != 'R' || string.charAt(n + 1) != 'e' && string.charAt(n + 1) != 'E')) {
                if (string.charAt(n + 2) == ':') {
                    n += 3;
                    bl = false;
                } else if (n < n2 - 2 && (string.charAt(n + 2) == '[' || string.charAt(n + 2) == '(')) {
                    for (n3 = n + 3; n3 < n2 && string.charAt(n3) >= '0' && string.charAt(n3) <= '9'; ++n3) {
                    }
                    if (n3 < n2 - 1 && (string.charAt(n3) == ']' || string.charAt(n3) == ')') && string.charAt(n3 + 1) == ':') {
                        n = n3 + 2;
                        bl = false;
                    }
                }
            }
            if ("(no subject)".equals(this.simplifiedSubject)) {
                this.simplifiedSubject = "";
            }
            for (n3 = n2; n3 > n && string.charAt(n3 - 1) < ' '; --n3) {
            }
            if (n == 0 && n3 == n2) {
                this.simplifiedSubject = string;
                continue;
            }
            this.simplifiedSubject = string.substring(n, n3);
        }
    }

    public static void printThread(Article article) {
        Article.printThread(article, 0, System.out);
    }

    public static void printThread(Article article, PrintStream printStream) {
        Article.printThread(article, 0, printStream);
    }

    public static void printThread(Article article, int n) {
        Article.printThread(article, n, System.out);
    }

    public static void printThread(Article article, int n, PrintStream printStream) {
        for (int i = 0; i < n; ++i) {
            printStream.print("==>");
        }
        printStream.println(article.getSubject() + "\t" + article.getFrom() + "\t" + article.getArticleId());
        if (article.kid != null) {
            Article.printThread(article.kid, n + 1);
        }
        if (article.next != null) {
            Article.printThread(article.next, n);
        }
    }

    public String getArticleId() {
        return this.articleId;
    }

    public long getArticleNumberLong() {
        return this.articleNumber;
    }

    public String getDate() {
        return this.date;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setArticleId(String string) {
        this.articleId = string;
    }

    public void setArticleNumber(long l) {
        this.articleNumber = l;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    @Override
    public boolean isDummy() {
        return this.articleNumber == -1L;
    }

    @Override
    public String messageThreadId() {
        return this.articleId;
    }

    @Override
    public String[] messageThreadReferences() {
        return this.getReferences();
    }

    @Override
    public String simplifiedSubject() {
        if (this.simplifiedSubject == null) {
            this.simplifySubject();
        }
        return this.simplifiedSubject;
    }

    @Override
    public boolean subjectIsReply() {
        return this.isReply;
    }

    @Override
    public void setChild(Threadable threadable) {
        this.kid = (Article)threadable;
        this.flushSubjectCache();
    }

    private void flushSubjectCache() {
        this.simplifiedSubject = null;
    }

    @Override
    public void setNext(Threadable threadable) {
        this.next = (Article)threadable;
        this.flushSubjectCache();
    }

    @Override
    public Threadable makeDummy() {
        return new Article();
    }

    public String toString() {
        return this.articleNumber + " " + this.articleId + " " + this.subject;
    }

    @Deprecated
    public int getArticleNumber() {
        return (int)this.articleNumber;
    }

    @Deprecated
    public void setArticleNumber(int n) {
        this.articleNumber = n;
    }

    @Deprecated
    public void addHeaderField(String string, String string2) {
    }
}

