/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.imap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.MalformedServerReplyException;

public final class IMAPReply {
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int BAD = 2;
    public static final int CONT = 3;
    public static final int PARTIAL = 3;
    private static final String IMAP_OK = "OK";
    private static final String IMAP_NO = "NO";
    private static final String IMAP_BAD = "BAD";
    private static final String IMAP_UNTAGGED_PREFIX = "* ";
    private static final String IMAP_CONTINUATION_PREFIX = "+";
    private static final String TAGGED_RESPONSE = "^\\w+ (\\S+).*";
    private static final Pattern TAGGED_PATTERN = Pattern.compile("^\\w+ (\\S+).*");
    private static final String UNTAGGED_RESPONSE = "^\\* (\\S+).*";
    private static final Pattern UNTAGGED_PATTERN = Pattern.compile("^\\* (\\S+).*");
    private static final Pattern LITERAL_PATTERN = Pattern.compile("\\{(\\d+)\\}$");

    private IMAPReply() {
    }

    public static boolean isUntagged(String string) {
        return string.startsWith(IMAP_UNTAGGED_PREFIX);
    }

    public static boolean isContinuation(String string) {
        return string.startsWith(IMAP_CONTINUATION_PREFIX);
    }

    public static int getReplyCode(String string) throws IOException {
        return IMAPReply.getReplyCode(string, TAGGED_PATTERN);
    }

    public static int literalCount(String string) {
        Matcher matcher = LITERAL_PATTERN.matcher(string);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public static int getUntaggedReplyCode(String string) throws IOException {
        return IMAPReply.getReplyCode(string, UNTAGGED_PATTERN);
    }

    private static int getReplyCode(String string, Pattern pattern) throws IOException {
        if (IMAPReply.isContinuation(string)) {
            return 3;
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            if (string2.equals(IMAP_OK)) {
                return 0;
            }
            if (string2.equals(IMAP_BAD)) {
                return 2;
            }
            if (string2.equals(IMAP_NO)) {
                return 1;
            }
        }
        throw new MalformedServerReplyException("Received unexpected IMAP protocol response from server: '" + string + "'.");
    }

    public static boolean isSuccess(int n) {
        return n == 0;
    }

    public static boolean isContinuation(int n) {
        return n == 3;
    }
}

