/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.util.ParameterFormatter;

public class RFC2109Spec
extends CookieSpecBase {
    private final ParameterFormatter formatter = new ParameterFormatter();
    public static final String SET_COOKIE_KEY = "set-cookie";

    public RFC2109Spec() {
        this.formatter.setAlwaysUseQuotes(true);
    }

    @Override
    public void parseAttribute(NameValuePair nameValuePair, Cookie cookie) throws MalformedCookieException {
        if (nameValuePair == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String string = nameValuePair.getName().toLowerCase();
        String string2 = nameValuePair.getValue();
        if (string.equals("path")) {
            if (string2 == null) {
                throw new MalformedCookieException("Missing value for path attribute");
            }
            if (string2.trim().equals("")) {
                throw new MalformedCookieException("Blank value for path attribute");
            }
            cookie.setPath(string2);
            cookie.setPathAttributeSpecified(true);
        } else if (string.equals("version")) {
            if (string2 == null) {
                throw new MalformedCookieException("Missing value for version attribute");
            }
            try {
                cookie.setVersion(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedCookieException("Invalid version: " + numberFormatException.getMessage());
            }
        } else {
            super.parseAttribute(nameValuePair, cookie);
        }
    }

    @Override
    public void validate(String string, int n, String string2, boolean bl, Cookie cookie) throws MalformedCookieException {
        LOG.trace((Object)"enter RFC2109Spec.validate(String, int, String, boolean, Cookie)");
        super.validate(string, n, string2, bl, cookie);
        if (cookie.getName().indexOf(32) != -1) {
            throw new MalformedCookieException("Cookie name may not contain blanks");
        }
        if (cookie.getName().startsWith("$")) {
            throw new MalformedCookieException("Cookie name may not start with $");
        }
        if (cookie.isDomainAttributeSpecified() && !cookie.getDomain().equals(string)) {
            if (!cookie.getDomain().startsWith(".")) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: domain must start with a dot");
            }
            int n2 = cookie.getDomain().indexOf(46, 1);
            if (n2 < 0 || n2 == cookie.getDomain().length() - 1) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (!(string = string.toLowerCase()).endsWith(cookie.getDomain())) {
                throw new MalformedCookieException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + string + "\"");
            }
            String string3 = string.substring(0, string.length() - cookie.getDomain().length());
            if (string3.indexOf(46) != -1) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    @Override
    public boolean domainMatch(String string, String string2) {
        boolean bl = string.equals(string2) || string2.startsWith(".") && string.endsWith(string2);
        return bl;
    }

    private void formatParam(StringBuffer stringBuffer, NameValuePair nameValuePair, int n) {
        if (n < 1) {
            stringBuffer.append(nameValuePair.getName());
            stringBuffer.append("=");
            if (nameValuePair.getValue() != null) {
                stringBuffer.append(nameValuePair.getValue());
            }
        } else {
            this.formatter.format(stringBuffer, nameValuePair);
        }
    }

    private void formatCookieAsVer(StringBuffer stringBuffer, Cookie cookie, int n) {
        String string = cookie.getValue();
        if (string == null) {
            string = "";
        }
        this.formatParam(stringBuffer, new NameValuePair(cookie.getName(), string), n);
        if (cookie.getPath() != null && cookie.isPathAttributeSpecified()) {
            stringBuffer.append("; ");
            this.formatParam(stringBuffer, new NameValuePair("$Path", cookie.getPath()), n);
        }
        if (cookie.getDomain() != null && cookie.isDomainAttributeSpecified()) {
            stringBuffer.append("; ");
            this.formatParam(stringBuffer, new NameValuePair("$Domain", cookie.getDomain()), n);
        }
    }

    @Override
    public String formatCookie(Cookie cookie) {
        LOG.trace((Object)"enter RFC2109Spec.formatCookie(Cookie)");
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        int n = cookie.getVersion();
        StringBuffer stringBuffer = new StringBuffer();
        this.formatParam(stringBuffer, new NameValuePair("$Version", Integer.toString(n)), n);
        stringBuffer.append("; ");
        this.formatCookieAsVer(stringBuffer, cookie, n);
        return stringBuffer.toString();
    }

    @Override
    public String formatCookies(Cookie[] cookieArray) {
        LOG.trace((Object)"enter RFC2109Spec.formatCookieHeader(Cookie[])");
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < cookieArray.length; ++i) {
            Cookie cookie = cookieArray[i];
            if (cookie.getVersion() >= n) continue;
            n = cookie.getVersion();
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.formatParam(stringBuffer, new NameValuePair("$Version", Integer.toString(n)), n);
        for (int i = 0; i < cookieArray.length; ++i) {
            stringBuffer.append("; ");
            this.formatCookieAsVer(stringBuffer, cookieArray[i], n);
        }
        return stringBuffer.toString();
    }
}

