/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.type1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.encoding.BuiltInEncoding;
import org.apache.fontbox.encoding.StandardEncoding;
import org.apache.fontbox.type1.Token;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.type1.Type1Lexer;

final class Type1Parser {
    private static final int EEXEC_KEY = 55665;
    private static final int CHARSTRING_KEY = 4330;
    private Type1Lexer lexer;
    private Type1Font font;

    Type1Parser() {
    }

    public Type1Font parse(byte[] byArray, byte[] byArray2) throws IOException {
        this.font = new Type1Font(byArray, byArray2);
        this.parseASCII(byArray);
        if (byArray2.length > 0) {
            this.parseBinary(byArray2);
        }
        return this.font;
    }

    private void parseASCII(byte[] byArray) throws IOException {
        Token token;
        if (byArray.length == 0) {
            throw new IllegalArgumentException("byte[] is empty");
        }
        if (byArray.length < 2 || byArray[0] != 37 && byArray[1] != 33) {
            throw new IOException("Invalid start of ASCII segment");
        }
        this.lexer = new Type1Lexer(byArray);
        if (this.lexer.peekToken().getText().equals("FontDirectory")) {
            this.read(Token.NAME, "FontDirectory");
            this.read(Token.LITERAL);
            this.read(Token.NAME, "known");
            this.read(Token.START_PROC);
            this.readProc();
            this.read(Token.START_PROC);
            this.readProc();
            this.read(Token.NAME, "ifelse");
        }
        int n = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.readMaybe(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        for (int i = 0; i < n && ((token = this.lexer.peekToken()).getKind() != Token.NAME || !token.getText().equals("currentdict") && !token.getText().equals("end")); ++i) {
            String string = this.read(Token.LITERAL).getText();
            if (string.equals("FontInfo")) {
                this.readFontInfo(this.readSimpleDict());
                continue;
            }
            if (string.equals("Metrics")) {
                this.readSimpleDict();
                continue;
            }
            if (string.equals("Encoding")) {
                this.readEncoding();
                continue;
            }
            this.readSimpleValue(string);
        }
        this.readMaybe(Token.NAME, "currentdict");
        this.read(Token.NAME, "end");
        this.read(Token.NAME, "currentfile");
        this.read(Token.NAME, "eexec");
    }

    private void readSimpleValue(String string) throws IOException {
        List<Token> list = this.readDictValue();
        if (string.equals("FontName")) {
            this.font.fontName = list.get(0).getText();
        } else if (string.equals("PaintType")) {
            this.font.paintType = list.get(0).intValue();
        } else if (string.equals("FontType")) {
            this.font.fontType = list.get(0).intValue();
        } else if (string.equals("FontMatrix")) {
            this.font.fontMatrix = this.arrayToNumbers(list);
        } else if (string.equals("FontBBox")) {
            this.font.fontBBox = this.arrayToNumbers(list);
        } else if (string.equals("UniqueID")) {
            this.font.uniqueID = list.get(0).intValue();
        } else if (string.equals("StrokeWidth")) {
            this.font.strokeWidth = list.get(0).floatValue();
        } else if (string.equals("FID")) {
            this.font.fontID = list.get(0).getText();
        }
    }

    private void readEncoding() throws IOException {
        if (this.lexer.peekToken().getKind() == Token.NAME) {
            String string = this.lexer.nextToken().getText();
            if (!string.equals("StandardEncoding")) {
                throw new IOException("Unknown encoding: " + string);
            }
            this.font.encoding = StandardEncoding.INSTANCE;
            this.readMaybe(Token.NAME, "readonly");
            this.read(Token.NAME, "def");
        } else {
            this.read(Token.INTEGER).intValue();
            this.readMaybe(Token.NAME, "array");
            while (this.lexer.peekToken().getKind() != Token.NAME || !this.lexer.peekToken().getText().equals("dup") && !this.lexer.peekToken().getText().equals("readonly") && !this.lexer.peekToken().getText().equals("def")) {
                this.lexer.nextToken();
            }
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            while (this.lexer.peekToken().getKind() == Token.NAME && this.lexer.peekToken().getText().equals("dup")) {
                this.read(Token.NAME, "dup");
                int n = this.read(Token.INTEGER).intValue();
                String string = this.read(Token.LITERAL).getText();
                this.read(Token.NAME, "put");
                hashMap.put(n, string);
            }
            this.font.encoding = new BuiltInEncoding(hashMap);
            this.readMaybe(Token.NAME, "readonly");
            this.read(Token.NAME, "def");
        }
    }

    private List<Number> arrayToNumbers(List<Token> list) throws IOException {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        int n = list.size() - 1;
        for (int i = 1; i < n; ++i) {
            Token token = list.get(i);
            if (token.getKind() == Token.REAL) {
                arrayList.add(Float.valueOf(token.floatValue()));
                continue;
            }
            if (token.getKind() == Token.INTEGER) {
                arrayList.add(token.intValue());
                continue;
            }
            throw new IOException("Expected INTEGER or REAL but got " + (Object)((Object)token.getKind()));
        }
        return arrayList;
    }

    private void readFontInfo(Map<String, List<Token>> map) {
        for (Map.Entry<String, List<Token>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<Token> list = entry.getValue();
            if (string.equals("version")) {
                this.font.version = list.get(0).getText();
                continue;
            }
            if (string.equals("Notice")) {
                this.font.notice = list.get(0).getText();
                continue;
            }
            if (string.equals("FullName")) {
                this.font.fullName = list.get(0).getText();
                continue;
            }
            if (string.equals("FamilyName")) {
                this.font.familyName = list.get(0).getText();
                continue;
            }
            if (string.equals("Weight")) {
                this.font.weight = list.get(0).getText();
                continue;
            }
            if (string.equals("ItalicAngle")) {
                this.font.italicAngle = list.get(0).floatValue();
                continue;
            }
            if (string.equals("isFixedPitch")) {
                this.font.isFixedPitch = list.get(0).booleanValue();
                continue;
            }
            if (string.equals("UnderlinePosition")) {
                this.font.underlinePosition = list.get(0).floatValue();
                continue;
            }
            if (!string.equals("UnderlineThickness")) continue;
            this.font.underlineThickness = list.get(0).floatValue();
        }
    }

    private Map<String, List<Token>> readSimpleDict() throws IOException {
        HashMap<String, List<Token>> hashMap = new HashMap<String, List<Token>>();
        int n = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.readMaybe(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        for (int i = 0; i < n; ++i) {
            if (this.lexer.peekToken().getKind() == Token.NAME && !this.lexer.peekToken().getText().equals("end")) {
                this.read(Token.NAME);
            }
            if (this.lexer.peekToken().getKind() == Token.NAME && this.lexer.peekToken().getText().equals("end")) break;
            String string = this.read(Token.LITERAL).getText();
            List<Token> list = this.readDictValue();
            hashMap.put(string, list);
        }
        this.read(Token.NAME, "end");
        this.readMaybe(Token.NAME, "readonly");
        this.read(Token.NAME, "def");
        return hashMap;
    }

    private List<Token> readDictValue() throws IOException {
        List<Token> list = this.readValue();
        this.readDef();
        return list;
    }

    private List<Token> readValue() throws IOException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token = this.lexer.nextToken();
        arrayList.add(token);
        if (token.getKind() == Token.START_ARRAY) {
            int n = 1;
            do {
                if (this.lexer.peekToken().getKind() == Token.START_ARRAY) {
                    ++n;
                }
                token = this.lexer.nextToken();
                arrayList.add(token);
            } while (token.getKind() != Token.END_ARRAY || --n != 0);
        } else if (token.getKind() == Token.START_PROC) {
            arrayList.addAll(this.readProc());
        } else if (token.getKind() == Token.START_DICT) {
            this.read(Token.END_DICT);
            return arrayList;
        }
        if (this.lexer.peekToken().getText().equals("systemdict")) {
            this.read(Token.NAME, "systemdict");
            this.read(Token.LITERAL, "internaldict");
            this.read(Token.NAME, "known");
            this.read(Token.START_PROC);
            this.readProc();
            this.read(Token.START_PROC);
            this.readProc();
            this.read(Token.NAME, "ifelse");
            this.read(Token.START_PROC);
            this.read(Token.NAME, "pop");
            arrayList.clear();
            arrayList.addAll(this.readValue());
            this.read(Token.END_PROC);
            this.read(Token.NAME, "if");
        }
        return arrayList;
    }

    private List<Token> readProc() throws IOException {
        Token token;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = 1;
        do {
            if (this.lexer.peekToken().getKind() == Token.START_PROC) {
                ++n;
            }
            token = this.lexer.nextToken();
            arrayList.add(token);
        } while (token.getKind() != Token.END_PROC || --n != 0);
        token = this.readMaybe(Token.NAME, "executeonly");
        if (token != null) {
            arrayList.add(token);
        }
        return arrayList;
    }

    private void parseBinary(byte[] byArray) throws IOException {
        byte[] byArray2 = this.isBinary(byArray) ? this.decrypt(byArray, 55665, 4) : this.decrypt(this.hexToBinary(byArray), 55665, 4);
        this.lexer = new Type1Lexer(byArray2);
        Token token = this.lexer.peekToken();
        while (token != null && !token.getText().equals("Private")) {
            this.lexer.nextToken();
            token = this.lexer.peekToken();
        }
        if (token == null) {
            throw new IOException("/Private token not found");
        }
        this.read(Token.LITERAL, "Private");
        int n = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.readMaybe(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        int n2 = 4;
        for (int i = 0; i < n && this.lexer.peekToken().getKind() == Token.LITERAL; ++i) {
            String string = this.read(Token.LITERAL).getText();
            if ("Subrs".equals(string)) {
                this.readSubrs(n2);
                continue;
            }
            if ("OtherSubrs".equals(string)) {
                this.readOtherSubrs();
                continue;
            }
            if ("lenIV".equals(string)) {
                n2 = this.readDictValue().get(0).intValue();
                continue;
            }
            if ("ND".equals(string)) {
                this.read(Token.START_PROC);
                this.readMaybe(Token.NAME, "noaccess");
                this.read(Token.NAME, "def");
                this.read(Token.END_PROC);
                this.readMaybe(Token.NAME, "executeonly");
                this.read(Token.NAME, "def");
                continue;
            }
            if ("NP".equals(string)) {
                this.read(Token.START_PROC);
                this.readMaybe(Token.NAME, "noaccess");
                this.read(Token.NAME);
                this.read(Token.END_PROC);
                this.readMaybe(Token.NAME, "executeonly");
                this.read(Token.NAME, "def");
                continue;
            }
            if ("RD".equals(string)) {
                this.read(Token.START_PROC);
                this.readProc();
                this.readMaybe(Token.NAME, "bind");
                this.readMaybe(Token.NAME, "executeonly");
                this.read(Token.NAME, "def");
                continue;
            }
            this.readPrivate(string, this.readDictValue());
        }
        while (this.lexer.peekToken().getKind() != Token.LITERAL || !this.lexer.peekToken().getText().equals("CharStrings")) {
            this.lexer.nextToken();
        }
        this.read(Token.LITERAL, "CharStrings");
        this.readCharStrings(n2);
    }

    private void readPrivate(String string, List<Token> list) throws IOException {
        if (string.equals("BlueValues")) {
            this.font.blueValues = this.arrayToNumbers(list);
        } else if (string.equals("OtherBlues")) {
            this.font.otherBlues = this.arrayToNumbers(list);
        } else if (string.equals("FamilyBlues")) {
            this.font.familyBlues = this.arrayToNumbers(list);
        } else if (string.equals("FamilyOtherBlues")) {
            this.font.familyOtherBlues = this.arrayToNumbers(list);
        } else if (string.equals("BlueScale")) {
            this.font.blueScale = list.get(0).floatValue();
        } else if (string.equals("BlueShift")) {
            this.font.blueShift = list.get(0).intValue();
        } else if (string.equals("BlueFuzz")) {
            this.font.blueFuzz = list.get(0).intValue();
        } else if (string.equals("StdHW")) {
            this.font.stdHW = this.arrayToNumbers(list);
        } else if (string.equals("StdVW")) {
            this.font.stdVW = this.arrayToNumbers(list);
        } else if (string.equals("StemSnapH")) {
            this.font.stemSnapH = this.arrayToNumbers(list);
        } else if (string.equals("StemSnapV")) {
            this.font.stemSnapV = this.arrayToNumbers(list);
        } else if (string.equals("ForceBold")) {
            this.font.forceBold = list.get(0).booleanValue();
        } else if (string.equals("LanguageGroup")) {
            this.font.languageGroup = list.get(0).intValue();
        }
    }

    private void readSubrs(int n) throws IOException {
        int n2;
        int n3 = this.read(Token.INTEGER).intValue();
        for (n2 = 0; n2 < n3; ++n2) {
            this.font.subrs.add(null);
        }
        this.read(Token.NAME, "array");
        for (n2 = 0; n2 < n3 && this.lexer.peekToken().getKind() == Token.NAME && this.lexer.peekToken().getText().equals("dup"); ++n2) {
            this.read(Token.NAME, "dup");
            Token token = this.read(Token.INTEGER);
            this.read(Token.INTEGER);
            Token token2 = this.read(Token.CHARSTRING);
            this.font.subrs.set(token.intValue(), this.decrypt(token2.getData(), 4330, n));
            this.readPut();
        }
        this.readDef();
    }

    private void readOtherSubrs() throws IOException {
        if (this.lexer.peekToken().getKind() == Token.START_ARRAY) {
            this.readValue();
            this.readDef();
        } else {
            int n = this.read(Token.INTEGER).intValue();
            this.read(Token.NAME, "array");
            for (int i = 0; i < n; ++i) {
                this.read(Token.NAME, "dup");
                this.read(Token.INTEGER);
                this.readValue();
                this.readPut();
            }
            this.readDef();
        }
    }

    private void readCharStrings(int n) throws IOException {
        int n2 = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.read(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        for (int i = 0; !(i >= n2 || this.lexer.peekToken().getKind() == Token.NAME && this.lexer.peekToken().getText().equals("end")); ++i) {
            String string = this.read(Token.LITERAL).getText();
            this.read(Token.INTEGER);
            Token token = this.read(Token.CHARSTRING);
            this.font.charstrings.put(string, this.decrypt(token.getData(), 4330, n));
            this.readDef();
        }
        this.read(Token.NAME, "end");
    }

    private void readDef() throws IOException {
        this.readMaybe(Token.NAME, "readonly");
        this.readMaybe(Token.NAME, "noaccess");
        Token token = this.read(Token.NAME);
        if (token.getText().equals("ND") || token.getText().equals("|-")) {
            return;
        }
        if (token.getText().equals("noaccess")) {
            token = this.read(Token.NAME);
        }
        if (token.getText().equals("def")) {
            return;
        }
        throw new IOException("Found " + token + " but expected ND");
    }

    private void readPut() throws IOException {
        this.readMaybe(Token.NAME, "readonly");
        Token token = this.read(Token.NAME);
        if (token.getText().equals("NP") || token.getText().equals("|")) {
            return;
        }
        if (token.getText().equals("noaccess")) {
            token = this.read(Token.NAME);
        }
        if (token.getText().equals("put")) {
            return;
        }
        throw new IOException("Found " + token + " but expected NP");
    }

    private Token read(Token.Kind kind) throws IOException {
        Token token = this.lexer.nextToken();
        if (token == null || token.getKind() != kind) {
            throw new IOException("Found " + token + " but expected " + (Object)((Object)kind));
        }
        return token;
    }

    private void read(Token.Kind kind, String string) throws IOException {
        Token token = this.read(kind);
        if (!token.getText().equals(string)) {
            throw new IOException("Found " + token + " but expected " + string);
        }
    }

    private Token readMaybe(Token.Kind kind, String string) throws IOException {
        Token token = this.lexer.peekToken();
        if (token.getKind() == kind && token.getText().equals(string)) {
            return this.lexer.nextToken();
        }
        return null;
    }

    private byte[] decrypt(byte[] byArray, int n, int n2) {
        if (n2 == -1) {
            return byArray;
        }
        if (byArray.length == 0 || n2 > byArray.length) {
            return new byte[0];
        }
        int n3 = 52845;
        int n4 = 22719;
        byte[] byArray2 = new byte[byArray.length - n2];
        for (int i = 0; i < byArray.length; ++i) {
            int n5 = byArray[i] & 0xFF;
            int n6 = n5 ^ n >> 8;
            if (i >= n2) {
                byArray2[i - n2] = (byte)n6;
            }
            n = (n5 + n) * n3 + n4 & 0xFFFF;
        }
        return byArray2;
    }

    private boolean isBinary(byte[] byArray) {
        if (byArray.length < 4) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            byte by = byArray[i];
            if (by == 10 || by == 13 || by == 32 || by == 9 || Character.digit((char)by, 16) != -1) continue;
            return true;
        }
        return false;
    }

    private byte[] hexToBinary(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (Character.digit((char)byArray[i], 16) == -1) continue;
            ++n;
        }
        byte[] byArray2 = new byte[n / 2];
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < byArray.length; ++i) {
            int n4 = Character.digit((char)byArray[i], 16);
            if (n4 == -1) continue;
            if (n3 == -1) {
                n3 = n4;
                continue;
            }
            byArray2[n2++] = (byte)(n3 * 16 + n4);
            n3 = -1;
        }
        return byArray2;
    }
}

