/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CodespaceRange;

public class CMap {
    private int wmode = 0;
    private String cmapName = null;
    private String cmapVersion = null;
    private int cmapType = -1;
    private String registry = null;
    private String ordering = null;
    private int supplement = 0;
    private int minCodeLength = 4;
    private int maxCodeLength;
    private final List<CodespaceRange> codespaceRanges = new ArrayList<CodespaceRange>();
    private final Map<Integer, String> charToUnicode = new HashMap<Integer, String>();
    private final Map<Integer, Integer> codeToCid = new HashMap<Integer, Integer>();
    private final List<CIDRange> codeToCidRanges = new ArrayList<CIDRange>();
    private static final String SPACE = " ";
    private int spaceMapping = -1;

    CMap() {
    }

    public boolean hasCIDMappings() {
        return !this.codeToCid.isEmpty() || !this.codeToCidRanges.isEmpty();
    }

    public boolean hasUnicodeMappings() {
        return !this.charToUnicode.isEmpty();
    }

    public String toUnicode(int n) {
        return this.charToUnicode.get(n);
    }

    public int readCode(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.maxCodeLength];
        inputStream.read(byArray, 0, this.minCodeLength);
        for (int i = this.minCodeLength - 1; i < this.maxCodeLength; ++i) {
            int n = i + 1;
            for (CodespaceRange codespaceRange : this.codespaceRanges) {
                if (!codespaceRange.isFullMatch(byArray, n)) continue;
                return CMap.toInt(byArray, n);
            }
            if (n >= this.maxCodeLength) continue;
            byArray[n] = (byte)inputStream.read();
        }
        throw new IOException("CMap is invalid");
    }

    static int toInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 8;
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    public int toCID(int n) {
        Integer n2 = this.codeToCid.get(n);
        if (n2 != null) {
            return n2;
        }
        for (CIDRange cIDRange : this.codeToCidRanges) {
            int n3 = cIDRange.map((char)n);
            if (n3 == -1) continue;
            return n3;
        }
        return 0;
    }

    private int getCodeFromArray(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= (byArray[n + i] + 256) % 256;
        }
        return n3;
    }

    void addCharMapping(byte[] byArray, String string) {
        int n = this.getCodeFromArray(byArray, 0, byArray.length);
        this.charToUnicode.put(n, string);
        if (SPACE.equals(string)) {
            this.spaceMapping = n;
        }
    }

    void addCIDMapping(int n, int n2) {
        this.codeToCid.put(n2, n);
    }

    void addCIDRange(char c, char c2, int n) {
        this.codeToCidRanges.add(new CIDRange(c, c2, n));
    }

    void addCodespaceRange(CodespaceRange codespaceRange) {
        this.codespaceRanges.add(codespaceRange);
        this.maxCodeLength = Math.max(this.maxCodeLength, codespaceRange.getCodeLength());
        this.minCodeLength = Math.min(this.minCodeLength, codespaceRange.getCodeLength());
    }

    void useCmap(CMap cMap) {
        for (CodespaceRange codespaceRange : cMap.codespaceRanges) {
            this.addCodespaceRange(codespaceRange);
        }
        this.charToUnicode.putAll(cMap.charToUnicode);
        this.codeToCid.putAll(cMap.codeToCid);
        this.codeToCidRanges.addAll(cMap.codeToCidRanges);
    }

    public int getWMode() {
        return this.wmode;
    }

    public void setWMode(int n) {
        this.wmode = n;
    }

    public String getName() {
        return this.cmapName;
    }

    public void setName(String string) {
        this.cmapName = string;
    }

    public String getVersion() {
        return this.cmapVersion;
    }

    public void setVersion(String string) {
        this.cmapVersion = string;
    }

    public int getType() {
        return this.cmapType;
    }

    public void setType(int n) {
        this.cmapType = n;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String string) {
        this.registry = string;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String string) {
        this.ordering = string;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int n) {
        this.supplement = n;
    }

    public int getSpaceMapping() {
        return this.spaceMapping;
    }

    public String toString() {
        return this.cmapName;
    }
}

