/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "showmouse_options.h"

ShowmouseOptions::ShowmouseOptions (bool init /* = true */) :
    mOptions (ShowmouseOptions::OptionNum),
    mNotify (ShowmouseOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ShowmouseOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;
    unsigned short color[4];

    // activate_at_startup
    mOptions[ShowmouseOptions::ActivateAtStartup].setName ("activate_at_startup", CompOption::TypeBool);
    mOptions[ShowmouseOptions::ActivateAtStartup].value().set(false);

    // initiate
    mOptions[ShowmouseOptions::Initiate].setName ("initiate", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>k");
    mOptions[ShowmouseOptions::Initiate].value().set (action);
    if (screen) screen->addAction (&mOptions[ShowmouseOptions::Initiate].value ().action ());

    // initiate_button
    mOptions[ShowmouseOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShowmouseOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShowmouseOptions::InitiateButton].value ().action ());

    // initiate_edge
    mOptions[ShowmouseOptions::InitiateEdge].setName ("initiate_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[ShowmouseOptions::InitiateEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ShowmouseOptions::InitiateEdge].value ().action ());

    // guide_thickness
    mOptions[ShowmouseOptions::GuideThickness].setName ("guide_thickness", CompOption::TypeInt);
    mOptions[ShowmouseOptions::GuideThickness].rest ().set (0, 20);
    mOptions[ShowmouseOptions::GuideThickness].value().set((int) 12);

    // guide_empty_radius
    mOptions[ShowmouseOptions::GuideEmptyRadius].setName ("guide_empty_radius", CompOption::TypeInt);
    mOptions[ShowmouseOptions::GuideEmptyRadius].rest ().set (0, 100);
    mOptions[ShowmouseOptions::GuideEmptyRadius].value().set((int) 20);

    // guide_color
    mOptions[ShowmouseOptions::GuideColor].setName ("guide_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0x0));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0x9999));
    mOptions[ShowmouseOptions::GuideColor].value().set(color);

    // rotation_speed
    mOptions[ShowmouseOptions::RotationSpeed].setName ("rotation_speed", CompOption::TypeFloat);
    mOptions[ShowmouseOptions::RotationSpeed].rest ().set (0.1, 10.0, 0.1);
    mOptions[ShowmouseOptions::RotationSpeed].value().set((float) 0.5);

    // radius
    mOptions[ShowmouseOptions::Radius].setName ("radius", CompOption::TypeInt);
    mOptions[ShowmouseOptions::Radius].rest ().set (10, 1000);
    mOptions[ShowmouseOptions::Radius].value().set((int) 100);

    // emitters
    mOptions[ShowmouseOptions::Emitters].setName ("emitters", CompOption::TypeInt);
    mOptions[ShowmouseOptions::Emitters].rest ().set (0, 10);
    mOptions[ShowmouseOptions::Emitters].value().set((int) 0);

    // num_particles
    mOptions[ShowmouseOptions::NumParticles].setName ("num_particles", CompOption::TypeInt);
    mOptions[ShowmouseOptions::NumParticles].rest ().set (10, 2000);
    mOptions[ShowmouseOptions::NumParticles].value().set((int) 500);

    // size
    mOptions[ShowmouseOptions::Size].setName ("size", CompOption::TypeFloat);
    mOptions[ShowmouseOptions::Size].rest ().set (0.1, 20, 0.1);
    mOptions[ShowmouseOptions::Size].value().set((float) 10.0);

    // slowdown
    mOptions[ShowmouseOptions::Slowdown].setName ("slowdown", CompOption::TypeFloat);
    mOptions[ShowmouseOptions::Slowdown].rest ().set (0.1, 10, 0.1);
    mOptions[ShowmouseOptions::Slowdown].value().set((float) 1.0);

    // life
    mOptions[ShowmouseOptions::Life].setName ("life", CompOption::TypeFloat);
    mOptions[ShowmouseOptions::Life].rest ().set (0.1, 0.9490, 0.1);
    mOptions[ShowmouseOptions::Life].value().set((float) 0.7);

    // darken
    mOptions[ShowmouseOptions::Darken].setName ("darken", CompOption::TypeFloat);
    mOptions[ShowmouseOptions::Darken].rest ().set (0.0, 1.0, 0.1);
    mOptions[ShowmouseOptions::Darken].value().set((float) 0.9);

    // blend
    mOptions[ShowmouseOptions::Blend].setName ("blend", CompOption::TypeBool);
    mOptions[ShowmouseOptions::Blend].value().set(true);

    // color
    mOptions[ShowmouseOptions::Color].setName ("color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xdfff));
    color[2] = MAX (0, MIN (0xffff, 0x3fff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[ShowmouseOptions::Color].value().set(color);

    // random
    mOptions[ShowmouseOptions::Random].setName ("random", CompOption::TypeBool);
    mOptions[ShowmouseOptions::Random].value().set(false);

}

ShowmouseOptions::~ShowmouseOptions ()
{
}


CompOption::Vector &
ShowmouseOptions::getOptions ()
{
    return mOptions;
}

bool
ShowmouseOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ShowmouseOptions::ActivateAtStartup:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::ActivateAtStartup].empty ())
                    mNotify[ShowmouseOptions::ActivateAtStartup] (o, ShowmouseOptions::ActivateAtStartup);
                return true;
            }
            break;
        case ShowmouseOptions::Initiate:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Initiate].empty ())
                    mNotify[ShowmouseOptions::Initiate] (o, ShowmouseOptions::Initiate);
                return true;
            }
            break;
        case ShowmouseOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::InitiateButton].empty ())
                    mNotify[ShowmouseOptions::InitiateButton] (o, ShowmouseOptions::InitiateButton);
                return true;
            }
            break;
        case ShowmouseOptions::InitiateEdge:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::InitiateEdge].empty ())
                    mNotify[ShowmouseOptions::InitiateEdge] (o, ShowmouseOptions::InitiateEdge);
                return true;
            }
            break;
        case ShowmouseOptions::GuideThickness:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::GuideThickness].empty ())
                    mNotify[ShowmouseOptions::GuideThickness] (o, ShowmouseOptions::GuideThickness);
                return true;
            }
            break;
        case ShowmouseOptions::GuideEmptyRadius:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::GuideEmptyRadius].empty ())
                    mNotify[ShowmouseOptions::GuideEmptyRadius] (o, ShowmouseOptions::GuideEmptyRadius);
                return true;
            }
            break;
        case ShowmouseOptions::GuideColor:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::GuideColor].empty ())
                    mNotify[ShowmouseOptions::GuideColor] (o, ShowmouseOptions::GuideColor);
                return true;
            }
            break;
        case ShowmouseOptions::RotationSpeed:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::RotationSpeed].empty ())
                    mNotify[ShowmouseOptions::RotationSpeed] (o, ShowmouseOptions::RotationSpeed);
                return true;
            }
            break;
        case ShowmouseOptions::Radius:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Radius].empty ())
                    mNotify[ShowmouseOptions::Radius] (o, ShowmouseOptions::Radius);
                return true;
            }
            break;
        case ShowmouseOptions::Emitters:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Emitters].empty ())
                    mNotify[ShowmouseOptions::Emitters] (o, ShowmouseOptions::Emitters);
                return true;
            }
            break;
        case ShowmouseOptions::NumParticles:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::NumParticles].empty ())
                    mNotify[ShowmouseOptions::NumParticles] (o, ShowmouseOptions::NumParticles);
                return true;
            }
            break;
        case ShowmouseOptions::Size:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Size].empty ())
                    mNotify[ShowmouseOptions::Size] (o, ShowmouseOptions::Size);
                return true;
            }
            break;
        case ShowmouseOptions::Slowdown:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Slowdown].empty ())
                    mNotify[ShowmouseOptions::Slowdown] (o, ShowmouseOptions::Slowdown);
                return true;
            }
            break;
        case ShowmouseOptions::Life:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Life].empty ())
                    mNotify[ShowmouseOptions::Life] (o, ShowmouseOptions::Life);
                return true;
            }
            break;
        case ShowmouseOptions::Darken:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Darken].empty ())
                    mNotify[ShowmouseOptions::Darken] (o, ShowmouseOptions::Darken);
                return true;
            }
            break;
        case ShowmouseOptions::Blend:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Blend].empty ())
                    mNotify[ShowmouseOptions::Blend] (o, ShowmouseOptions::Blend);
                return true;
            }
            break;
        case ShowmouseOptions::Color:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Color].empty ())
                    mNotify[ShowmouseOptions::Color] (o, ShowmouseOptions::Color);
                return true;
            }
            break;
        case ShowmouseOptions::Random:
            if (o->set (value))
            {
                if (!mNotify[ShowmouseOptions::Random].empty ())
                    mNotify[ShowmouseOptions::Random] (o, ShowmouseOptions::Random);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

