/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "mag_options.h"

MagOptions::MagOptions (bool init /* = true */) :
    mOptions (MagOptions::OptionNum),
    mNotify (MagOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
MagOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // initiate
    mOptions[MagOptions::Initiate].setName ("initiate", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>m");
    mOptions[MagOptions::Initiate].value().set (action);
    if (screen) screen->addAction (&mOptions[MagOptions::Initiate].value ().action ());

    // zoom_in_button
    mOptions[MagOptions::ZoomInButton].setName ("zoom_in_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Shift>Button4");
    mOptions[MagOptions::ZoomInButton].value().set (action);
    if (screen) screen->addAction (&mOptions[MagOptions::ZoomInButton].value ().action ());

    // zoom_out_button
    mOptions[MagOptions::ZoomOutButton].setName ("zoom_out_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Shift>Button5");
    mOptions[MagOptions::ZoomOutButton].value().set (action);
    if (screen) screen->addAction (&mOptions[MagOptions::ZoomOutButton].value ().action ());

    // mode
    mOptions[MagOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[MagOptions::Mode].rest ().set (0, 2);
    mOptions[MagOptions::Mode].value().set((int) 0);

    // zoom_factor
    mOptions[MagOptions::ZoomFactor].setName ("zoom_factor", CompOption::TypeFloat);
    mOptions[MagOptions::ZoomFactor].rest ().set (1.1, 32.0, 0.1);
    mOptions[MagOptions::ZoomFactor].value().set((float) 2.0);

    // speed
    mOptions[MagOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[MagOptions::Speed].rest ().set (0.1, 50, 0.1);
    mOptions[MagOptions::Speed].value().set((float) 1.5);

    // timestep
    mOptions[MagOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[MagOptions::Timestep].rest ().set (0.1, 50, 0.1);
    mOptions[MagOptions::Timestep].value().set((float) 1.2);

    // keep_screen
    mOptions[MagOptions::KeepScreen].setName ("keep_screen", CompOption::TypeBool);
    mOptions[MagOptions::KeepScreen].value().set(true);

    // box_width
    mOptions[MagOptions::BoxWidth].setName ("box_width", CompOption::TypeInt);
    mOptions[MagOptions::BoxWidth].rest ().set (20, 1000);
    mOptions[MagOptions::BoxWidth].value().set((int) 300);

    // box_height
    mOptions[MagOptions::BoxHeight].setName ("box_height", CompOption::TypeInt);
    mOptions[MagOptions::BoxHeight].rest ().set (20, 1000);
    mOptions[MagOptions::BoxHeight].value().set((int) 200);

    // border
    mOptions[MagOptions::Border].setName ("border", CompOption::TypeInt);
    mOptions[MagOptions::Border].rest ().set (0, 20);
    mOptions[MagOptions::Border].value().set((int) 2);

    // box_color
    mOptions[MagOptions::BoxColor].setName ("box_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0));
    color[1] = MAX (0, MIN (0xffff, 0x0));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[MagOptions::BoxColor].value().set(color);

    // overlay
    mOptions[MagOptions::Overlay].setName ("overlay", CompOption::TypeString);
    mOptions[MagOptions::Overlay].value().set(CompString ("Gnome/overlay.png"));

    // mask
    mOptions[MagOptions::Mask].setName ("mask", CompOption::TypeString);
    mOptions[MagOptions::Mask].value().set(CompString ("Gnome/mask.png"));

    // x_offset
    mOptions[MagOptions::XOffset].setName ("x_offset", CompOption::TypeInt);
    mOptions[MagOptions::XOffset].rest ().set (0, 1000);
    mOptions[MagOptions::XOffset].value().set((int) 155);

    // y_offset
    mOptions[MagOptions::YOffset].setName ("y_offset", CompOption::TypeInt);
    mOptions[MagOptions::YOffset].rest ().set (0, 1000);
    mOptions[MagOptions::YOffset].value().set((int) 155);

    // radius
    mOptions[MagOptions::Radius].setName ("radius", CompOption::TypeInt);
    mOptions[MagOptions::Radius].rest ().set (10, 1000);
    mOptions[MagOptions::Radius].value().set((int) 200);

}

MagOptions::~MagOptions ()
{
}


CompOption::Vector &
MagOptions::getOptions ()
{
    return mOptions;
}

bool
MagOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case MagOptions::Initiate:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Initiate].empty ())
                    mNotify[MagOptions::Initiate] (o, MagOptions::Initiate);
                return true;
            }
            break;
        case MagOptions::ZoomInButton:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::ZoomInButton].empty ())
                    mNotify[MagOptions::ZoomInButton] (o, MagOptions::ZoomInButton);
                return true;
            }
            break;
        case MagOptions::ZoomOutButton:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::ZoomOutButton].empty ())
                    mNotify[MagOptions::ZoomOutButton] (o, MagOptions::ZoomOutButton);
                return true;
            }
            break;
        case MagOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Mode].empty ())
                    mNotify[MagOptions::Mode] (o, MagOptions::Mode);
                return true;
            }
            break;
        case MagOptions::ZoomFactor:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::ZoomFactor].empty ())
                    mNotify[MagOptions::ZoomFactor] (o, MagOptions::ZoomFactor);
                return true;
            }
            break;
        case MagOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Speed].empty ())
                    mNotify[MagOptions::Speed] (o, MagOptions::Speed);
                return true;
            }
            break;
        case MagOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Timestep].empty ())
                    mNotify[MagOptions::Timestep] (o, MagOptions::Timestep);
                return true;
            }
            break;
        case MagOptions::KeepScreen:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::KeepScreen].empty ())
                    mNotify[MagOptions::KeepScreen] (o, MagOptions::KeepScreen);
                return true;
            }
            break;
        case MagOptions::BoxWidth:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::BoxWidth].empty ())
                    mNotify[MagOptions::BoxWidth] (o, MagOptions::BoxWidth);
                return true;
            }
            break;
        case MagOptions::BoxHeight:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::BoxHeight].empty ())
                    mNotify[MagOptions::BoxHeight] (o, MagOptions::BoxHeight);
                return true;
            }
            break;
        case MagOptions::Border:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Border].empty ())
                    mNotify[MagOptions::Border] (o, MagOptions::Border);
                return true;
            }
            break;
        case MagOptions::BoxColor:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::BoxColor].empty ())
                    mNotify[MagOptions::BoxColor] (o, MagOptions::BoxColor);
                return true;
            }
            break;
        case MagOptions::Overlay:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Overlay].empty ())
                    mNotify[MagOptions::Overlay] (o, MagOptions::Overlay);
                return true;
            }
            break;
        case MagOptions::Mask:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Mask].empty ())
                    mNotify[MagOptions::Mask] (o, MagOptions::Mask);
                return true;
            }
            break;
        case MagOptions::XOffset:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::XOffset].empty ())
                    mNotify[MagOptions::XOffset] (o, MagOptions::XOffset);
                return true;
            }
            break;
        case MagOptions::YOffset:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::YOffset].empty ())
                    mNotify[MagOptions::YOffset] (o, MagOptions::YOffset);
                return true;
            }
            break;
        case MagOptions::Radius:
            if (o->set (value))
            {
                if (!mNotify[MagOptions::Radius].empty ())
                    mNotify[MagOptions::Radius] (o, MagOptions::Radius);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

