/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "animation_options.h"

AnimationOptions::AnimationOptions (bool init /* = true */) :
    mOptions (AnimationOptions::OptionNum),
    mNotify (AnimationOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
AnimationOptions::initOptions ()
{
    CompOption::Value::Vector list;
    CompOption::Value value;

    // open_effects
    mOptions[AnimationOptions::OpenEffects].setName ("open_effects", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("animation:Zoom"));
    list.push_back (value);
    value.set(CompString ("animation:Fade"));
    list.push_back (value);
    value.set(CompString ("animation:Fade"));
    list.push_back (value);
    mOptions[AnimationOptions::OpenEffects].value().set (CompOption::TypeString, list);

    // open_durations
    mOptions[AnimationOptions::OpenDurations].setName ("open_durations", CompOption::TypeList);
    mOptions[AnimationOptions::OpenDurations].rest ().set (50, 4000);
    list.clear ();
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    mOptions[AnimationOptions::OpenDurations].value().set (CompOption::TypeInt, list);

    // open_matches
    mOptions[AnimationOptions::OpenMatches].setName ("open_matches", CompOption::TypeList);
    list.clear ();
    value.set(CompMatch ("(type=Normal | Dialog | ModalDialog | Unknown) & !(name=gnome-screensaver)"));
    value.match ().update ();
    list.push_back (value);
    value.set(CompMatch ("(type=Menu | PopupMenu | DropdownMenu | Combo)"));
    value.match ().update ();
    list.push_back (value);
    value.set(CompMatch ("(type=Tooltip | Notification | Utility) & !(name=compiz) & !(title=notify-osd)"));
    value.match ().update ();
    list.push_back (value);
    mOptions[AnimationOptions::OpenMatches].value().set (CompOption::TypeMatch, list);

    // open_options
    mOptions[AnimationOptions::OpenOptions].setName ("open_options", CompOption::TypeList);
    list.clear ();
    value.set(CompString (""));
    list.push_back (value);
    value.set(CompString (""));
    list.push_back (value);
    value.set(CompString (""));
    list.push_back (value);
    mOptions[AnimationOptions::OpenOptions].value().set (CompOption::TypeString, list);

    // open_random_effects
    mOptions[AnimationOptions::OpenRandomEffects].setName ("open_random_effects", CompOption::TypeList);
    list.clear ();
    mOptions[AnimationOptions::OpenRandomEffects].value().set (CompOption::TypeString, list);

    // close_effects
    mOptions[AnimationOptions::CloseEffects].setName ("close_effects", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("animation:Zoom"));
    list.push_back (value);
    value.set(CompString ("animation:Fade"));
    list.push_back (value);
    value.set(CompString ("animation:Fade"));
    list.push_back (value);
    mOptions[AnimationOptions::CloseEffects].value().set (CompOption::TypeString, list);

    // close_durations
    mOptions[AnimationOptions::CloseDurations].setName ("close_durations", CompOption::TypeList);
    mOptions[AnimationOptions::CloseDurations].rest ().set (50, 4000);
    list.clear ();
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    mOptions[AnimationOptions::CloseDurations].value().set (CompOption::TypeInt, list);

    // close_matches
    mOptions[AnimationOptions::CloseMatches].setName ("close_matches", CompOption::TypeList);
    list.clear ();
    value.set(CompMatch ("(type=Normal | Dialog | ModalDialog | Unknown) & !(name=gnome-screensaver)"));
    value.match ().update ();
    list.push_back (value);
    value.set(CompMatch ("(type=Menu | PopupMenu | DropdownMenu | Combo)"));
    value.match ().update ();
    list.push_back (value);
    value.set(CompMatch ("(type=Tooltip | Notification | Utility) & !(name=compiz) & !(title=notify-osd)"));
    value.match ().update ();
    list.push_back (value);
    mOptions[AnimationOptions::CloseMatches].value().set (CompOption::TypeMatch, list);

    // close_options
    mOptions[AnimationOptions::CloseOptions].setName ("close_options", CompOption::TypeList);
    list.clear ();
    value.set(CompString (""));
    list.push_back (value);
    value.set(CompString (""));
    list.push_back (value);
    value.set(CompString (""));
    list.push_back (value);
    mOptions[AnimationOptions::CloseOptions].value().set (CompOption::TypeString, list);

    // close_random_effects
    mOptions[AnimationOptions::CloseRandomEffects].setName ("close_random_effects", CompOption::TypeList);
    list.clear ();
    mOptions[AnimationOptions::CloseRandomEffects].value().set (CompOption::TypeString, list);

    // minimize_effects
    mOptions[AnimationOptions::MinimizeEffects].setName ("minimize_effects", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("animation:Magic Lamp"));
    list.push_back (value);
    mOptions[AnimationOptions::MinimizeEffects].value().set (CompOption::TypeString, list);

    // minimize_durations
    mOptions[AnimationOptions::MinimizeDurations].setName ("minimize_durations", CompOption::TypeList);
    mOptions[AnimationOptions::MinimizeDurations].rest ().set (50, 4000);
    list.clear ();
    value.set((int) 300);
    list.push_back (value);
    mOptions[AnimationOptions::MinimizeDurations].value().set (CompOption::TypeInt, list);

    // minimize_matches
    mOptions[AnimationOptions::MinimizeMatches].setName ("minimize_matches", CompOption::TypeList);
    list.clear ();
    value.set(CompMatch ("(type=Normal | Dialog | ModalDialog | Unknown)"));
    value.match ().update ();
    list.push_back (value);
    mOptions[AnimationOptions::MinimizeMatches].value().set (CompOption::TypeMatch, list);

    // minimize_options
    mOptions[AnimationOptions::MinimizeOptions].setName ("minimize_options", CompOption::TypeList);
    list.clear ();
    value.set(CompString (""));
    list.push_back (value);
    mOptions[AnimationOptions::MinimizeOptions].value().set (CompOption::TypeString, list);

    // minimize_random_effects
    mOptions[AnimationOptions::MinimizeRandomEffects].setName ("minimize_random_effects", CompOption::TypeList);
    list.clear ();
    mOptions[AnimationOptions::MinimizeRandomEffects].value().set (CompOption::TypeString, list);

    // unminimize_effects
    mOptions[AnimationOptions::UnminimizeEffects].setName ("unminimize_effects", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("animation:Magic Lamp"));
    list.push_back (value);
    mOptions[AnimationOptions::UnminimizeEffects].value().set (CompOption::TypeString, list);

    // unminimize_durations
    mOptions[AnimationOptions::UnminimizeDurations].setName ("unminimize_durations", CompOption::TypeList);
    mOptions[AnimationOptions::UnminimizeDurations].rest ().set (50, 4000);
    list.clear ();
    value.set((int) 300);
    list.push_back (value);
    mOptions[AnimationOptions::UnminimizeDurations].value().set (CompOption::TypeInt, list);

    // unminimize_matches
    mOptions[AnimationOptions::UnminimizeMatches].setName ("unminimize_matches", CompOption::TypeList);
    list.clear ();
    value.set(CompMatch ("(type=Normal | Dialog | ModalDialog | Unknown)"));
    value.match ().update ();
    list.push_back (value);
    mOptions[AnimationOptions::UnminimizeMatches].value().set (CompOption::TypeMatch, list);

    // unminimize_options
    mOptions[AnimationOptions::UnminimizeOptions].setName ("unminimize_options", CompOption::TypeList);
    list.clear ();
    value.set(CompString (""));
    list.push_back (value);
    mOptions[AnimationOptions::UnminimizeOptions].value().set (CompOption::TypeString, list);

    // unminimize_random_effects
    mOptions[AnimationOptions::UnminimizeRandomEffects].setName ("unminimize_random_effects", CompOption::TypeList);
    list.clear ();
    mOptions[AnimationOptions::UnminimizeRandomEffects].value().set (CompOption::TypeString, list);

    // shade_effects
    mOptions[AnimationOptions::ShadeEffects].setName ("shade_effects", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("animation:Roll Up"));
    list.push_back (value);
    mOptions[AnimationOptions::ShadeEffects].value().set (CompOption::TypeString, list);

    // shade_durations
    mOptions[AnimationOptions::ShadeDurations].setName ("shade_durations", CompOption::TypeList);
    mOptions[AnimationOptions::ShadeDurations].rest ().set (50, 4000);
    list.clear ();
    value.set((int) 300);
    list.push_back (value);
    mOptions[AnimationOptions::ShadeDurations].value().set (CompOption::TypeInt, list);

    // shade_matches
    mOptions[AnimationOptions::ShadeMatches].setName ("shade_matches", CompOption::TypeList);
    list.clear ();
    value.set(CompMatch ("(type=Normal | Dialog | ModalDialog | Utility | Unknown)"));
    value.match ().update ();
    list.push_back (value);
    mOptions[AnimationOptions::ShadeMatches].value().set (CompOption::TypeMatch, list);

    // shade_options
    mOptions[AnimationOptions::ShadeOptions].setName ("shade_options", CompOption::TypeList);
    list.clear ();
    value.set(CompString (""));
    list.push_back (value);
    mOptions[AnimationOptions::ShadeOptions].value().set (CompOption::TypeString, list);

    // shade_random_effects
    mOptions[AnimationOptions::ShadeRandomEffects].setName ("shade_random_effects", CompOption::TypeList);
    list.clear ();
    mOptions[AnimationOptions::ShadeRandomEffects].value().set (CompOption::TypeString, list);

    // focus_effects
    mOptions[AnimationOptions::FocusEffects].setName ("focus_effects", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("animation:None"));
    list.push_back (value);
    mOptions[AnimationOptions::FocusEffects].value().set (CompOption::TypeString, list);

    // focus_durations
    mOptions[AnimationOptions::FocusDurations].setName ("focus_durations", CompOption::TypeList);
    mOptions[AnimationOptions::FocusDurations].rest ().set (50, 4000);
    list.clear ();
    value.set((int) 300);
    list.push_back (value);
    mOptions[AnimationOptions::FocusDurations].value().set (CompOption::TypeInt, list);

    // focus_matches
    mOptions[AnimationOptions::FocusMatches].setName ("focus_matches", CompOption::TypeList);
    list.clear ();
    value.set(CompMatch ("(type=Normal | Dialog | ModalDialog | Utility | Unknown) & !(name=compiz)"));
    value.match ().update ();
    list.push_back (value);
    mOptions[AnimationOptions::FocusMatches].value().set (CompOption::TypeMatch, list);

    // focus_options
    mOptions[AnimationOptions::FocusOptions].setName ("focus_options", CompOption::TypeList);
    list.clear ();
    value.set(CompString (""));
    list.push_back (value);
    mOptions[AnimationOptions::FocusOptions].value().set (CompOption::TypeString, list);

    // all_random
    mOptions[AnimationOptions::AllRandom].setName ("all_random", CompOption::TypeBool);
    mOptions[AnimationOptions::AllRandom].value().set(false);

    // time_step
    mOptions[AnimationOptions::TimeStep].setName ("time_step", CompOption::TypeInt);
    mOptions[AnimationOptions::TimeStep].rest ().set (1, 400);
    mOptions[AnimationOptions::TimeStep].value().set((int) 10);

    // curved_fold_amp_mult
    mOptions[AnimationOptions::CurvedFoldAmpMult].setName ("curved_fold_amp_mult", CompOption::TypeFloat);
    mOptions[AnimationOptions::CurvedFoldAmpMult].rest ().set (-1.5, 2, 0.05);
    mOptions[AnimationOptions::CurvedFoldAmpMult].value().set((float) 1.0);

    // curved_fold_zoom_to_taskbar
    mOptions[AnimationOptions::CurvedFoldZoomToTaskbar].setName ("curved_fold_zoom_to_taskbar", CompOption::TypeBool);
    mOptions[AnimationOptions::CurvedFoldZoomToTaskbar].value().set(true);

    // dodge_mode
    mOptions[AnimationOptions::DodgeMode].setName ("dodge_mode", CompOption::TypeInt);
    mOptions[AnimationOptions::DodgeMode].rest ().set (0, 1);
    mOptions[AnimationOptions::DodgeMode].value().set((int) 1);

    // dodge_gap_ratio
    mOptions[AnimationOptions::DodgeGapRatio].setName ("dodge_gap_ratio", CompOption::TypeFloat);
    mOptions[AnimationOptions::DodgeGapRatio].rest ().set (0, 1, 0.01);
    mOptions[AnimationOptions::DodgeGapRatio].value().set((float) 0.5);

    // dream_zoom_to_taskbar
    mOptions[AnimationOptions::DreamZoomToTaskbar].setName ("dream_zoom_to_taskbar", CompOption::TypeBool);
    mOptions[AnimationOptions::DreamZoomToTaskbar].value().set(true);

    // glide1_away_position
    mOptions[AnimationOptions::Glide1AwayPosition].setName ("glide1_away_position", CompOption::TypeFloat);
    mOptions[AnimationOptions::Glide1AwayPosition].rest ().set (-2, 1, 0.05);
    mOptions[AnimationOptions::Glide1AwayPosition].value().set((float) 1);

    // glide1_away_angle
    mOptions[AnimationOptions::Glide1AwayAngle].setName ("glide1_away_angle", CompOption::TypeFloat);
    mOptions[AnimationOptions::Glide1AwayAngle].rest ().set (-540, 540, 5);
    mOptions[AnimationOptions::Glide1AwayAngle].value().set((float) 0);

    // glide1_zoom_to_taskbar
    mOptions[AnimationOptions::Glide1ZoomToTaskbar].setName ("glide1_zoom_to_taskbar", CompOption::TypeBool);
    mOptions[AnimationOptions::Glide1ZoomToTaskbar].value().set(false);

    // glide2_away_position
    mOptions[AnimationOptions::Glide2AwayPosition].setName ("glide2_away_position", CompOption::TypeFloat);
    mOptions[AnimationOptions::Glide2AwayPosition].rest ().set (-2, 1, 0.05);
    mOptions[AnimationOptions::Glide2AwayPosition].value().set((float) -0.4);

    // glide2_away_angle
    mOptions[AnimationOptions::Glide2AwayAngle].setName ("glide2_away_angle", CompOption::TypeFloat);
    mOptions[AnimationOptions::Glide2AwayAngle].rest ().set (-540, 540, 5);
    mOptions[AnimationOptions::Glide2AwayAngle].value().set((float) -45);

    // glide2_zoom_to_taskbar
    mOptions[AnimationOptions::Glide2ZoomToTaskbar].setName ("glide2_zoom_to_taskbar", CompOption::TypeBool);
    mOptions[AnimationOptions::Glide2ZoomToTaskbar].value().set(true);

    // horizontal_folds_amp_mult
    mOptions[AnimationOptions::HorizontalFoldsAmpMult].setName ("horizontal_folds_amp_mult", CompOption::TypeFloat);
    mOptions[AnimationOptions::HorizontalFoldsAmpMult].rest ().set (-1, 3, 0.05);
    mOptions[AnimationOptions::HorizontalFoldsAmpMult].value().set((float) 1.0);

    // horizontal_folds_num_folds
    mOptions[AnimationOptions::HorizontalFoldsNumFolds].setName ("horizontal_folds_num_folds", CompOption::TypeInt);
    mOptions[AnimationOptions::HorizontalFoldsNumFolds].rest ().set (1, 50);
    mOptions[AnimationOptions::HorizontalFoldsNumFolds].value().set((int) 3);

    // horizontal_folds_zoom_to_taskbar
    mOptions[AnimationOptions::HorizontalFoldsZoomToTaskbar].setName ("horizontal_folds_zoom_to_taskbar", CompOption::TypeBool);
    mOptions[AnimationOptions::HorizontalFoldsZoomToTaskbar].value().set(true);

    // magic_lamp_moving_end
    mOptions[AnimationOptions::MagicLampMovingEnd].setName ("magic_lamp_moving_end", CompOption::TypeBool);
    mOptions[AnimationOptions::MagicLampMovingEnd].value().set(true);

    // magic_lamp_grid_res
    mOptions[AnimationOptions::MagicLampGridRes].setName ("magic_lamp_grid_res", CompOption::TypeInt);
    mOptions[AnimationOptions::MagicLampGridRes].rest ().set (2, 200);
    mOptions[AnimationOptions::MagicLampGridRes].value().set((int) 100);

    // magic_lamp_open_start_width
    mOptions[AnimationOptions::MagicLampOpenStartWidth].setName ("magic_lamp_open_start_width", CompOption::TypeInt);
    mOptions[AnimationOptions::MagicLampOpenStartWidth].rest ().set (0, 500);
    mOptions[AnimationOptions::MagicLampOpenStartWidth].value().set((int) 30);

    // magic_lamp_wavy_moving_end
    mOptions[AnimationOptions::MagicLampWavyMovingEnd].setName ("magic_lamp_wavy_moving_end", CompOption::TypeBool);
    mOptions[AnimationOptions::MagicLampWavyMovingEnd].value().set(true);

    // magic_lamp_wavy_grid_res
    mOptions[AnimationOptions::MagicLampWavyGridRes].setName ("magic_lamp_wavy_grid_res", CompOption::TypeInt);
    mOptions[AnimationOptions::MagicLampWavyGridRes].rest ().set (4, 200);
    mOptions[AnimationOptions::MagicLampWavyGridRes].value().set((int) 100);

    // magic_lamp_wavy_max_waves
    mOptions[AnimationOptions::MagicLampWavyMaxWaves].setName ("magic_lamp_wavy_max_waves", CompOption::TypeInt);
    mOptions[AnimationOptions::MagicLampWavyMaxWaves].rest ().set (1, 20);
    mOptions[AnimationOptions::MagicLampWavyMaxWaves].value().set((int) 3);

    // magic_lamp_wavy_amp_min
    mOptions[AnimationOptions::MagicLampWavyAmpMin].setName ("magic_lamp_wavy_amp_min", CompOption::TypeFloat);
    mOptions[AnimationOptions::MagicLampWavyAmpMin].rest ().set (200, 2000, 5);
    mOptions[AnimationOptions::MagicLampWavyAmpMin].value().set((float) 200);

    // magic_lamp_wavy_amp_max
    mOptions[AnimationOptions::MagicLampWavyAmpMax].setName ("magic_lamp_wavy_amp_max", CompOption::TypeFloat);
    mOptions[AnimationOptions::MagicLampWavyAmpMax].rest ().set (200, 2000, 5);
    mOptions[AnimationOptions::MagicLampWavyAmpMax].value().set((float) 300);

    // magic_lamp_wavy_open_start_width
    mOptions[AnimationOptions::MagicLampWavyOpenStartWidth].setName ("magic_lamp_wavy_open_start_width", CompOption::TypeInt);
    mOptions[AnimationOptions::MagicLampWavyOpenStartWidth].rest ().set (0, 500);
    mOptions[AnimationOptions::MagicLampWavyOpenStartWidth].value().set((int) 30);

    // rollup_fixed_interior
    mOptions[AnimationOptions::RollupFixedInterior].setName ("rollup_fixed_interior", CompOption::TypeBool);
    mOptions[AnimationOptions::RollupFixedInterior].value().set(false);

    // sidekick_num_rotations
    mOptions[AnimationOptions::SidekickNumRotations].setName ("sidekick_num_rotations", CompOption::TypeFloat);
    mOptions[AnimationOptions::SidekickNumRotations].rest ().set (0, 5, 0.01);
    mOptions[AnimationOptions::SidekickNumRotations].value().set((float) 0.5);

    // sidekick_springiness
    mOptions[AnimationOptions::SidekickSpringiness].setName ("sidekick_springiness", CompOption::TypeFloat);
    mOptions[AnimationOptions::SidekickSpringiness].rest ().set (0, 1, 0.01);
    mOptions[AnimationOptions::SidekickSpringiness].value().set((float) 0.0);

    // sidekick_zoom_from_center
    mOptions[AnimationOptions::SidekickZoomFromCenter].setName ("sidekick_zoom_from_center", CompOption::TypeInt);
    mOptions[AnimationOptions::SidekickZoomFromCenter].rest ().set (0, 3);
    mOptions[AnimationOptions::SidekickZoomFromCenter].value().set((int) 0);

    // wave_width
    mOptions[AnimationOptions::WaveWidth].setName ("wave_width", CompOption::TypeFloat);
    mOptions[AnimationOptions::WaveWidth].rest ().set (0.02, 3, 0.01);
    mOptions[AnimationOptions::WaveWidth].value().set((float) 0.7);

    // wave_amp_mult
    mOptions[AnimationOptions::WaveAmpMult].setName ("wave_amp_mult", CompOption::TypeFloat);
    mOptions[AnimationOptions::WaveAmpMult].rest ().set (-20, 20, 0.1);
    mOptions[AnimationOptions::WaveAmpMult].value().set((float) 1.0);

    // zoom_from_center
    mOptions[AnimationOptions::ZoomFromCenter].setName ("zoom_from_center", CompOption::TypeInt);
    mOptions[AnimationOptions::ZoomFromCenter].rest ().set (0, 3);
    mOptions[AnimationOptions::ZoomFromCenter].value().set((int) 0);

    // zoom_springiness
    mOptions[AnimationOptions::ZoomSpringiness].setName ("zoom_springiness", CompOption::TypeFloat);
    mOptions[AnimationOptions::ZoomSpringiness].rest ().set (0, 1, 0.01);
    mOptions[AnimationOptions::ZoomSpringiness].value().set((float) 0.0);

}

AnimationOptions::~AnimationOptions ()
{
}


CompOption::Vector &
AnimationOptions::getOptions ()
{
    return mOptions;
}

bool
AnimationOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case AnimationOptions::OpenEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::OpenEffects].empty ())
                    mNotify[AnimationOptions::OpenEffects] (o, AnimationOptions::OpenEffects);
                return true;
            }
            break;
        case AnimationOptions::OpenDurations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::OpenDurations].empty ())
                    mNotify[AnimationOptions::OpenDurations] (o, AnimationOptions::OpenDurations);
                return true;
            }
            break;
        case AnimationOptions::OpenMatches:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::OpenMatches].empty ())
                    mNotify[AnimationOptions::OpenMatches] (o, AnimationOptions::OpenMatches);
                return true;
            }
            break;
        case AnimationOptions::OpenOptions:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::OpenOptions].empty ())
                    mNotify[AnimationOptions::OpenOptions] (o, AnimationOptions::OpenOptions);
                return true;
            }
            break;
        case AnimationOptions::OpenRandomEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::OpenRandomEffects].empty ())
                    mNotify[AnimationOptions::OpenRandomEffects] (o, AnimationOptions::OpenRandomEffects);
                return true;
            }
            break;
        case AnimationOptions::CloseEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CloseEffects].empty ())
                    mNotify[AnimationOptions::CloseEffects] (o, AnimationOptions::CloseEffects);
                return true;
            }
            break;
        case AnimationOptions::CloseDurations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CloseDurations].empty ())
                    mNotify[AnimationOptions::CloseDurations] (o, AnimationOptions::CloseDurations);
                return true;
            }
            break;
        case AnimationOptions::CloseMatches:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CloseMatches].empty ())
                    mNotify[AnimationOptions::CloseMatches] (o, AnimationOptions::CloseMatches);
                return true;
            }
            break;
        case AnimationOptions::CloseOptions:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CloseOptions].empty ())
                    mNotify[AnimationOptions::CloseOptions] (o, AnimationOptions::CloseOptions);
                return true;
            }
            break;
        case AnimationOptions::CloseRandomEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CloseRandomEffects].empty ())
                    mNotify[AnimationOptions::CloseRandomEffects] (o, AnimationOptions::CloseRandomEffects);
                return true;
            }
            break;
        case AnimationOptions::MinimizeEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MinimizeEffects].empty ())
                    mNotify[AnimationOptions::MinimizeEffects] (o, AnimationOptions::MinimizeEffects);
                return true;
            }
            break;
        case AnimationOptions::MinimizeDurations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MinimizeDurations].empty ())
                    mNotify[AnimationOptions::MinimizeDurations] (o, AnimationOptions::MinimizeDurations);
                return true;
            }
            break;
        case AnimationOptions::MinimizeMatches:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MinimizeMatches].empty ())
                    mNotify[AnimationOptions::MinimizeMatches] (o, AnimationOptions::MinimizeMatches);
                return true;
            }
            break;
        case AnimationOptions::MinimizeOptions:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MinimizeOptions].empty ())
                    mNotify[AnimationOptions::MinimizeOptions] (o, AnimationOptions::MinimizeOptions);
                return true;
            }
            break;
        case AnimationOptions::MinimizeRandomEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MinimizeRandomEffects].empty ())
                    mNotify[AnimationOptions::MinimizeRandomEffects] (o, AnimationOptions::MinimizeRandomEffects);
                return true;
            }
            break;
        case AnimationOptions::UnminimizeEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::UnminimizeEffects].empty ())
                    mNotify[AnimationOptions::UnminimizeEffects] (o, AnimationOptions::UnminimizeEffects);
                return true;
            }
            break;
        case AnimationOptions::UnminimizeDurations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::UnminimizeDurations].empty ())
                    mNotify[AnimationOptions::UnminimizeDurations] (o, AnimationOptions::UnminimizeDurations);
                return true;
            }
            break;
        case AnimationOptions::UnminimizeMatches:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::UnminimizeMatches].empty ())
                    mNotify[AnimationOptions::UnminimizeMatches] (o, AnimationOptions::UnminimizeMatches);
                return true;
            }
            break;
        case AnimationOptions::UnminimizeOptions:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::UnminimizeOptions].empty ())
                    mNotify[AnimationOptions::UnminimizeOptions] (o, AnimationOptions::UnminimizeOptions);
                return true;
            }
            break;
        case AnimationOptions::UnminimizeRandomEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::UnminimizeRandomEffects].empty ())
                    mNotify[AnimationOptions::UnminimizeRandomEffects] (o, AnimationOptions::UnminimizeRandomEffects);
                return true;
            }
            break;
        case AnimationOptions::ShadeEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ShadeEffects].empty ())
                    mNotify[AnimationOptions::ShadeEffects] (o, AnimationOptions::ShadeEffects);
                return true;
            }
            break;
        case AnimationOptions::ShadeDurations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ShadeDurations].empty ())
                    mNotify[AnimationOptions::ShadeDurations] (o, AnimationOptions::ShadeDurations);
                return true;
            }
            break;
        case AnimationOptions::ShadeMatches:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ShadeMatches].empty ())
                    mNotify[AnimationOptions::ShadeMatches] (o, AnimationOptions::ShadeMatches);
                return true;
            }
            break;
        case AnimationOptions::ShadeOptions:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ShadeOptions].empty ())
                    mNotify[AnimationOptions::ShadeOptions] (o, AnimationOptions::ShadeOptions);
                return true;
            }
            break;
        case AnimationOptions::ShadeRandomEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ShadeRandomEffects].empty ())
                    mNotify[AnimationOptions::ShadeRandomEffects] (o, AnimationOptions::ShadeRandomEffects);
                return true;
            }
            break;
        case AnimationOptions::FocusEffects:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::FocusEffects].empty ())
                    mNotify[AnimationOptions::FocusEffects] (o, AnimationOptions::FocusEffects);
                return true;
            }
            break;
        case AnimationOptions::FocusDurations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::FocusDurations].empty ())
                    mNotify[AnimationOptions::FocusDurations] (o, AnimationOptions::FocusDurations);
                return true;
            }
            break;
        case AnimationOptions::FocusMatches:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::FocusMatches].empty ())
                    mNotify[AnimationOptions::FocusMatches] (o, AnimationOptions::FocusMatches);
                return true;
            }
            break;
        case AnimationOptions::FocusOptions:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::FocusOptions].empty ())
                    mNotify[AnimationOptions::FocusOptions] (o, AnimationOptions::FocusOptions);
                return true;
            }
            break;
        case AnimationOptions::AllRandom:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::AllRandom].empty ())
                    mNotify[AnimationOptions::AllRandom] (o, AnimationOptions::AllRandom);
                return true;
            }
            break;
        case AnimationOptions::TimeStep:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::TimeStep].empty ())
                    mNotify[AnimationOptions::TimeStep] (o, AnimationOptions::TimeStep);
                return true;
            }
            break;
        case AnimationOptions::CurvedFoldAmpMult:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CurvedFoldAmpMult].empty ())
                    mNotify[AnimationOptions::CurvedFoldAmpMult] (o, AnimationOptions::CurvedFoldAmpMult);
                return true;
            }
            break;
        case AnimationOptions::CurvedFoldZoomToTaskbar:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::CurvedFoldZoomToTaskbar].empty ())
                    mNotify[AnimationOptions::CurvedFoldZoomToTaskbar] (o, AnimationOptions::CurvedFoldZoomToTaskbar);
                return true;
            }
            break;
        case AnimationOptions::DodgeMode:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::DodgeMode].empty ())
                    mNotify[AnimationOptions::DodgeMode] (o, AnimationOptions::DodgeMode);
                return true;
            }
            break;
        case AnimationOptions::DodgeGapRatio:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::DodgeGapRatio].empty ())
                    mNotify[AnimationOptions::DodgeGapRatio] (o, AnimationOptions::DodgeGapRatio);
                return true;
            }
            break;
        case AnimationOptions::DreamZoomToTaskbar:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::DreamZoomToTaskbar].empty ())
                    mNotify[AnimationOptions::DreamZoomToTaskbar] (o, AnimationOptions::DreamZoomToTaskbar);
                return true;
            }
            break;
        case AnimationOptions::Glide1AwayPosition:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::Glide1AwayPosition].empty ())
                    mNotify[AnimationOptions::Glide1AwayPosition] (o, AnimationOptions::Glide1AwayPosition);
                return true;
            }
            break;
        case AnimationOptions::Glide1AwayAngle:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::Glide1AwayAngle].empty ())
                    mNotify[AnimationOptions::Glide1AwayAngle] (o, AnimationOptions::Glide1AwayAngle);
                return true;
            }
            break;
        case AnimationOptions::Glide1ZoomToTaskbar:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::Glide1ZoomToTaskbar].empty ())
                    mNotify[AnimationOptions::Glide1ZoomToTaskbar] (o, AnimationOptions::Glide1ZoomToTaskbar);
                return true;
            }
            break;
        case AnimationOptions::Glide2AwayPosition:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::Glide2AwayPosition].empty ())
                    mNotify[AnimationOptions::Glide2AwayPosition] (o, AnimationOptions::Glide2AwayPosition);
                return true;
            }
            break;
        case AnimationOptions::Glide2AwayAngle:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::Glide2AwayAngle].empty ())
                    mNotify[AnimationOptions::Glide2AwayAngle] (o, AnimationOptions::Glide2AwayAngle);
                return true;
            }
            break;
        case AnimationOptions::Glide2ZoomToTaskbar:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::Glide2ZoomToTaskbar].empty ())
                    mNotify[AnimationOptions::Glide2ZoomToTaskbar] (o, AnimationOptions::Glide2ZoomToTaskbar);
                return true;
            }
            break;
        case AnimationOptions::HorizontalFoldsAmpMult:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::HorizontalFoldsAmpMult].empty ())
                    mNotify[AnimationOptions::HorizontalFoldsAmpMult] (o, AnimationOptions::HorizontalFoldsAmpMult);
                return true;
            }
            break;
        case AnimationOptions::HorizontalFoldsNumFolds:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::HorizontalFoldsNumFolds].empty ())
                    mNotify[AnimationOptions::HorizontalFoldsNumFolds] (o, AnimationOptions::HorizontalFoldsNumFolds);
                return true;
            }
            break;
        case AnimationOptions::HorizontalFoldsZoomToTaskbar:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::HorizontalFoldsZoomToTaskbar].empty ())
                    mNotify[AnimationOptions::HorizontalFoldsZoomToTaskbar] (o, AnimationOptions::HorizontalFoldsZoomToTaskbar);
                return true;
            }
            break;
        case AnimationOptions::MagicLampMovingEnd:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampMovingEnd].empty ())
                    mNotify[AnimationOptions::MagicLampMovingEnd] (o, AnimationOptions::MagicLampMovingEnd);
                return true;
            }
            break;
        case AnimationOptions::MagicLampGridRes:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampGridRes].empty ())
                    mNotify[AnimationOptions::MagicLampGridRes] (o, AnimationOptions::MagicLampGridRes);
                return true;
            }
            break;
        case AnimationOptions::MagicLampOpenStartWidth:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampOpenStartWidth].empty ())
                    mNotify[AnimationOptions::MagicLampOpenStartWidth] (o, AnimationOptions::MagicLampOpenStartWidth);
                return true;
            }
            break;
        case AnimationOptions::MagicLampWavyMovingEnd:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampWavyMovingEnd].empty ())
                    mNotify[AnimationOptions::MagicLampWavyMovingEnd] (o, AnimationOptions::MagicLampWavyMovingEnd);
                return true;
            }
            break;
        case AnimationOptions::MagicLampWavyGridRes:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampWavyGridRes].empty ())
                    mNotify[AnimationOptions::MagicLampWavyGridRes] (o, AnimationOptions::MagicLampWavyGridRes);
                return true;
            }
            break;
        case AnimationOptions::MagicLampWavyMaxWaves:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampWavyMaxWaves].empty ())
                    mNotify[AnimationOptions::MagicLampWavyMaxWaves] (o, AnimationOptions::MagicLampWavyMaxWaves);
                return true;
            }
            break;
        case AnimationOptions::MagicLampWavyAmpMin:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampWavyAmpMin].empty ())
                    mNotify[AnimationOptions::MagicLampWavyAmpMin] (o, AnimationOptions::MagicLampWavyAmpMin);
                return true;
            }
            break;
        case AnimationOptions::MagicLampWavyAmpMax:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampWavyAmpMax].empty ())
                    mNotify[AnimationOptions::MagicLampWavyAmpMax] (o, AnimationOptions::MagicLampWavyAmpMax);
                return true;
            }
            break;
        case AnimationOptions::MagicLampWavyOpenStartWidth:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::MagicLampWavyOpenStartWidth].empty ())
                    mNotify[AnimationOptions::MagicLampWavyOpenStartWidth] (o, AnimationOptions::MagicLampWavyOpenStartWidth);
                return true;
            }
            break;
        case AnimationOptions::RollupFixedInterior:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::RollupFixedInterior].empty ())
                    mNotify[AnimationOptions::RollupFixedInterior] (o, AnimationOptions::RollupFixedInterior);
                return true;
            }
            break;
        case AnimationOptions::SidekickNumRotations:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::SidekickNumRotations].empty ())
                    mNotify[AnimationOptions::SidekickNumRotations] (o, AnimationOptions::SidekickNumRotations);
                return true;
            }
            break;
        case AnimationOptions::SidekickSpringiness:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::SidekickSpringiness].empty ())
                    mNotify[AnimationOptions::SidekickSpringiness] (o, AnimationOptions::SidekickSpringiness);
                return true;
            }
            break;
        case AnimationOptions::SidekickZoomFromCenter:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::SidekickZoomFromCenter].empty ())
                    mNotify[AnimationOptions::SidekickZoomFromCenter] (o, AnimationOptions::SidekickZoomFromCenter);
                return true;
            }
            break;
        case AnimationOptions::WaveWidth:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::WaveWidth].empty ())
                    mNotify[AnimationOptions::WaveWidth] (o, AnimationOptions::WaveWidth);
                return true;
            }
            break;
        case AnimationOptions::WaveAmpMult:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::WaveAmpMult].empty ())
                    mNotify[AnimationOptions::WaveAmpMult] (o, AnimationOptions::WaveAmpMult);
                return true;
            }
            break;
        case AnimationOptions::ZoomFromCenter:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ZoomFromCenter].empty ())
                    mNotify[AnimationOptions::ZoomFromCenter] (o, AnimationOptions::ZoomFromCenter);
                return true;
            }
            break;
        case AnimationOptions::ZoomSpringiness:
            if (o->set (value))
            {
                if (!mNotify[AnimationOptions::ZoomSpringiness].empty ())
                    mNotify[AnimationOptions::ZoomSpringiness] (o, AnimationOptions::ZoomSpringiness);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

