/*
 * Decompiled with CFR 0.152.
 */
package jam.util;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class IconUtils {
    public static Image getImage(String name) {
        return IconUtils.getImage(IconUtils.class, name);
    }

    private static void showWarning(final String message) {
        if (EventQueue.isDispatchThread()) {
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, message, "Warning", 2);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static Image getImage(Class resourceClass, String name) {
        URL url = resourceClass.getResource(name);
        if (url != null) {
            return Toolkit.getDefaultToolkit().createImage(url);
        }
        IconUtils.showWarning("Image " + name + " could not be loaded.");
        return null;
    }

    public static BufferedImage getBufferedImage(String name) {
        return IconUtils.getBufferedImage(IconUtils.class, name);
    }

    public static BufferedImage getBufferedImage(Class resourceClass, String name) {
        URL url = resourceClass.getResource(name);
        if (url != null) {
            try {
                return ImageIO.read(url);
            }
            catch (IOException ioe) {
                IconUtils.showWarning("Image " + name + " could not be loaded.");
                return null;
            }
        }
        return null;
    }

    public static Icon getIcon(String name) {
        return IconUtils.getIcon(IconUtils.class, name);
    }

    public static Icon getIcon(Class resourceClass, String name) {
        Image image = IconUtils.getImage(resourceClass, name);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static Icon brighten(Icon icon) {
        BufferedImage img = IconUtils.getBufferedImageFromIcon(icon);
        if (img == null) {
            return icon;
        }
        RescaleOp op = new RescaleOp(1.25f, 0.0f, null);
        return new ImageIcon(op.filter(img, null));
    }

    public static Icon darken(Icon icon) {
        BufferedImage img = IconUtils.getBufferedImageFromIcon(icon);
        if (img == null) {
            return icon;
        }
        RescaleOp op = new RescaleOp(0.75f, 0.0f, null);
        return new ImageIcon(op.filter(img, null));
    }

    public static Icon gray(Icon icon) {
        BufferedImage img = IconUtils.getBufferedImageFromIcon(icon);
        if (img == null) {
            return icon;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(img));
    }

    public static Icon resize(Icon icon, int width, int height) {
        Image image = IconUtils.getImageFromIcon(icon);
        if (image == null) {
            return icon;
        }
        image = image.getScaledInstance(width, height, 4);
        return new ImageIcon(image);
    }

    public static Image getImageFromIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return IconUtils.getBufferedImageFromIcon(icon);
    }

    public static BufferedImage getBufferedImageFromIcon(Icon icon) {
        BufferedImage buffer = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = buffer.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return buffer;
    }
}

