/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.util.IconUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AddRemovePanel
extends JPanel {
    private Icon addIcon = null;
    private Icon addRolloverIcon = null;
    private Icon addPressedIcon = null;
    private Icon removeIcon = null;
    private Icon removeRolloverIcon = null;
    private Icon removePressedIcon = null;
    AbstractAction removeAction = new AbstractAction("-"){

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    };
    private ArrayList panels = new ArrayList();

    public AddRemovePanel() {
        this((JPanel[])null);
    }

    public AddRemovePanel(JPanel[] panels) {
        try {
            this.addIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/plus.png");
            this.addRolloverIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/plusRollover.png");
            this.addPressedIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/plusPressed.png");
            this.removeIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/minus.png");
            this.removeRolloverIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/minusRollover.png");
            this.removePressedIcon = IconUtils.getIcon(AddRemovePanel.class, "images/plusminus/minusPressed.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BoxLayout layout = new BoxLayout(this, 3);
        this.setLayout(layout);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setOpaque(false);
        if (panels != null && panels.length > 0) {
            JPanel last = null;
            int i = 0;
            while (i < panels.length) {
                JPanel contents = panels[i];
                this.addPanel(last, contents);
                last = contents;
                ++i;
            }
        } else {
            this.addPanel(null);
        }
        Dimension dim = super.getPreferredSize();
        dim.height = (int)((double)dim.height + this.getComponent(0).getPreferredSize().getHeight());
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    public List getPanels() {
        return Collections.unmodifiableList(this.panels);
    }

    protected abstract JPanel createPanel();

    private void addPanel(JPanel previousPanel) {
        this.addPanel(previousPanel, this.createPanel());
    }

    private void addPanel(JPanel previousPanel, JPanel contents) {
        RowPanel rowPanel = new RowPanel(contents);
        if (previousPanel != null) {
            int index = this.panels.indexOf(previousPanel);
            this.add((Component)rowPanel, index + 1);
            this.panels.add(index + 1, contents);
        } else {
            this.add((Component)rowPanel, 0);
            this.panels.add(0, contents);
        }
        this.removeAction.setEnabled(this.panels.size() > 1);
        this.validate();
        this.repaint();
    }

    private void removePanel(JPanel panel) {
        int index = this.panels.indexOf(panel);
        this.remove(index);
        this.panels.remove(index);
        this.removeAction.setEnabled(this.panels.size() > 1);
        this.validate();
        this.repaint();
    }

    class RowPanel
    extends JPanel {
        RowPanel(final JPanel contents) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.05f));
            JButton addButton = new JButton("+");
            addButton.putClientProperty("JButton.buttonType", "toolbar");
            addButton.setOpaque(false);
            if (AddRemovePanel.this.addIcon != null) {
                addButton.setIcon(AddRemovePanel.this.addIcon);
                addButton.setPressedIcon(AddRemovePanel.this.addPressedIcon);
                addButton.setRolloverIcon(AddRemovePanel.this.addRolloverIcon);
                addButton.setRolloverEnabled(true);
                addButton.setText(null);
            }
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AddRemovePanel.this.addPanel(contents);
                }
            });
            addButton.setEnabled(true);
            JButton removeButton = new JButton(AddRemovePanel.this.removeAction);
            removeButton.putClientProperty("JButton.buttonType", "toolbar");
            removeButton.setOpaque(false);
            if (AddRemovePanel.this.removeIcon != null) {
                removeButton.setIcon(AddRemovePanel.this.removeIcon);
                removeButton.setPressedIcon(AddRemovePanel.this.removePressedIcon);
                removeButton.setRolloverIcon(AddRemovePanel.this.removeRolloverIcon);
                removeButton.setRolloverEnabled(true);
                removeButton.setText(null);
            }
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AddRemovePanel.this.removePanel(contents);
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 10;
            c.insets = new Insets(1, 2, 0, 2);
            c.gridx = -1;
            c.weightx = 1.0;
            c.fill = 2;
            this.add((Component)contents, c);
            c.fill = 0;
            c.weightx = 0.0;
            this.add((Component)addButton, c);
            this.add((Component)removeButton, c);
        }
    }
}

