/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AboutBox;
import jam.framework.DocumentFrame;
import jam.framework.MenuBarFactory;
import jam.framework.MenuFactory;
import jam.html.HTMLViewer;
import jam.preferences.PreferencesDialog;
import jam.preferences.PreferencesSection;
import jam.util.BrowserLauncher;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;

public abstract class Application {
    private static MenuBarFactory menuBarFactory;
    private static Icon icon;
    private static String nameString;
    private static String titleString;
    private static String aboutString;
    private static String websiteURLString;
    private static String helpURLString;
    private static Application application;
    private JMenu recentFileMenu = null;
    private PreferencesDialog preferencesDialog = null;
    private static final int MAX_RECENT_FILES = 20;
    protected AbstractAction newAction = new AbstractAction("New"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.this.doNew();
        }
    };
    protected AbstractAction openAction = new AbstractAction("Open..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.this.doOpen();
        }
    };
    protected AbstractAction pageSetupAction = new AbstractAction("Page Setup..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.this.doPageSetup();
        }
    };
    protected AbstractAction exitAction = new AbstractAction("Exit"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.this.doQuit();
        }
    };
    protected AbstractAction aboutAction = null;
    protected AbstractAction preferencesAction = new AbstractAction("Preferences..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.this.doPreferences();
        }
    };
    protected AbstractAction helpAction = new AbstractAction("Help..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.this.doHelp();
        }
    };
    protected final AbstractAction websiteAction;

    static {
        application = null;
    }

    public static Application getApplication() {
        return application;
    }

    public static MenuBarFactory getMenuBarFactory() {
        return menuBarFactory;
    }

    public static Icon getIcon() {
        return icon;
    }

    public static String getNameString() {
        return nameString;
    }

    public static String getTitleString() {
        return titleString;
    }

    public static String getAboutString() {
        return aboutString;
    }

    public static String getWebsiteURLString() {
        return websiteURLString;
    }

    public static String getHelpURLString() {
        return helpURLString;
    }

    public Application(MenuBarFactory menuBarFactory, String nameString, String aboutString, Icon icon) {
        this(menuBarFactory, nameString, nameString, aboutString, icon, null, null);
    }

    public Application(MenuBarFactory menuBarFactory, String nameString, String titleString, String aboutString, Icon icon) {
        this(menuBarFactory, nameString, titleString, aboutString, icon, null, null);
    }

    public Application(MenuBarFactory menuBarFactory, String nameString, String aboutString, Icon icon, String websiteURLString, String helpURLString) {
        this(menuBarFactory, nameString, nameString, aboutString, icon, websiteURLString, helpURLString);
    }

    public Application(MenuBarFactory menuBarFactory, String nameString, String titleString, String aboutString, Icon icon, String websiteURLString, String helpURLString) {
        Application.menuBarFactory = menuBarFactory;
        Application.nameString = nameString;
        Application.titleString = titleString;
        Application.aboutString = aboutString;
        Application.websiteURLString = websiteURLString;
        Application.helpURLString = helpURLString;
        Application.icon = icon;
        this.aboutAction = new AbstractAction("About " + nameString + "..."){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Application.this.doAbout();
            }
        };
        this.websiteAction = websiteURLString != null ? new AbstractAction(String.valueOf(Application.nameString) + " website..."){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Application.this.doWebsite();
            }
        } : null;
        if (application != null) {
            throw new RuntimeException("Only on instance of Application is allowed");
        }
        application = this;
        this.preferencesDialog = new PreferencesDialog(this.getDefaultFrame());
    }

    public abstract void initialize();

    public void addMenuFactory(MenuFactory menuFactory) {
        Application.getMenuBarFactory().registerMenuFactory(menuFactory);
    }

    public JMenu getRecentFileMenu() {
        if (this.recentFileMenu == null) {
            this.recentFileMenu = new JMenu("Recent Files");
        }
        this.recentFileMenu.setEnabled(this.getOpenAction().isEnabled());
        return this.recentFileMenu;
    }

    public void addRecentFile(File file) {
        if (this.recentFileMenu != null) {
            if (this.recentFileMenu.getItemCount() == 20) {
                this.recentFileMenu.remove(19);
            }
            this.recentFileMenu.insert(new RecentFileAction(file), 0);
        }
    }

    protected abstract JFrame getDefaultFrame();

    public void doAbout() {
        AboutBox aboutBox = new AboutBox(Application.getTitleString(), Application.getAboutString(), Application.getIcon());
        aboutBox.setVisible(true);
    }

    public void doHelp() {
        if (helpURLString != null) {
            this.displayURL(helpURLString);
        } else {
            try {
                int c;
                InputStream in = this.getClass().getResourceAsStream("/help/application.help");
                if (in == null) {
                    return;
                }
                InputStreamReader reader = new InputStreamReader(in);
                StringWriter writer = new StringWriter();
                while ((c = ((Reader)reader).read()) != -1) {
                    writer.write(c);
                }
                ((Reader)reader).close();
                writer.close();
                HTMLViewer frame = new HTMLViewer(String.valueOf(Application.getNameString()) + " Help", writer.toString());
                frame.setVisible(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doWebsite() {
        if (websiteURLString != null) {
            this.displayURL(websiteURLString);
        }
    }

    public void displayURL(String urlString) {
        try {
            BrowserLauncher.openURL(urlString);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doPageSetup() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.pageDialog(new PageFormat());
    }

    public DocumentFrame doOpen() {
        JFrame frame = this.getDefaultFrame();
        if (frame == null) {
            frame = new JFrame();
        }
        FileDialog dialog = new FileDialog((Frame)frame, "Open Document", 0);
        dialog.setVisible(true);
        if (dialog.getFile() != null) {
            File file = new File(dialog.getDirectory(), dialog.getFile());
            DocumentFrame doc = this.doOpenFile(file);
            this.addRecentFile(file);
            return doc;
        }
        return null;
    }

    public DocumentFrame doOpen(String fileName) {
        if (fileName != null && fileName.length() > 0) {
            File file = new File(fileName);
            DocumentFrame doc = this.doOpenFile(file);
            this.addRecentFile(file);
            return doc;
        }
        return null;
    }

    public abstract DocumentFrame doNew();

    public abstract DocumentFrame doOpenFile(File var1);

    public abstract void doQuit();

    public void doPreferences() {
        this.preferencesDialog.showDialog();
    }

    public void addPreferencesSection(PreferencesSection preferencesSection) {
        this.preferencesDialog.addSection(preferencesSection);
    }

    public Action getNewAction() {
        return this.newAction;
    }

    public Action getOpenAction() {
        return this.openAction;
    }

    public Action getPageSetupAction() {
        return this.pageSetupAction;
    }

    public Action getExitAction() {
        return this.exitAction;
    }

    public Action getAboutAction() {
        return this.aboutAction;
    }

    public Action getPreferencesAction() {
        return this.preferencesAction;
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public Action getWebsiteAction() {
        return this.websiteAction;
    }

    private class RecentFileAction
    extends AbstractAction {
        private final File recentFile;

        public RecentFileAction(File recentFile) {
            super(recentFile.getName());
            this.recentFile = recentFile;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Application.this.doOpenFile(this.recentFile);
        }
    }
}

