/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.BEASTVersion2;
import beast.app.util.Utils;
import beast.util.CollectionUtils;
import beast.util.LogAnalyser;
import beast.util.OutputUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class LogComparator {
    protected List<String> matchedLabels;
    protected Double[] zScore;
    protected LogAnalyser analyser1;
    protected LogAnalyser analyser2;
    final String SPACE = " ";
    final String STAR = "* ";
    final String NON_STAR = "  ";

    public LogComparator(LogAnalyser logAnalyser, LogAnalyser logAnalyser2) {
        assert (logAnalyser != null);
        assert (logAnalyser2 != null);
        this.analyser1 = logAnalyser;
        this.analyser2 = logAnalyser2;
        this.compareLogs();
    }

    public double getZScore(String string) {
        int n = this.matchedLabels.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("Cannot find " + string + " from matched parameter list !");
        }
        return this.zScore[n];
    }

    protected void compareLogs() {
        this.matchedLabels = CollectionUtils.intersection(this.analyser1.getLabels(), this.analyser2.getLabels());
        if (this.matchedLabels.size() < 1) {
            throw new IllegalArgumentException("There is no parameter name matched between log files !");
        }
        this.zScore = new Double[this.matchedLabels.size()];
        for (String string : this.matchedLabels) {
            int n = this.analyser1.indexof(string);
            double d = this.analyser1.getMean(n);
            double d2 = this.analyser1.getStdError(n);
            int n2 = this.analyser2.indexof(string);
            double d3 = this.analyser2.getMean(n2);
            double d4 = this.analyser2.getStdError(n2);
            int n3 = this.matchedLabels.indexOf(string);
            this.zScore[n3] = 2.0 * Math.abs(d - d3) / (d2 + d4);
        }
    }

    public void print(PrintStream printStream, boolean bl) {
        int n;
        String[] stringArray;
        String string;
        String string2 = System.getProperty("prefix");
        String string3 = string = string2 == null ? "" : "prefix ";
        if (string2 != null && (stringArray = string2.trim().split("\\s+")).length > 1) {
            string = "";
            for (n = 0; n < stringArray.length; ++n) {
                string = string + "prefix" + n + " ";
            }
        }
        int n2 = 0;
        for (n = 1; n < this.matchedLabels.size(); ++n) {
            n2 = Math.max(this.matchedLabels.get(n).length(), n2);
        }
        String string4 = "";
        for (int i = 0; i < n2; ++i) {
            string4 = string4 + " ";
        }
        printStream.println("Comparing log " + this.analyser1.getLogFile() + " and " + this.analyser2.getLogFile() + "\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            printStream.println("item" + string4.substring(4) + " " + string + "   " + OutputUtils.format("ZScore") + OutputUtils.format("mean1") + OutputUtils.format("stderr1") + OutputUtils.format("mean2") + OutputUtils.format("stderr2"));
            for (int i = 1; i < this.matchedLabels.size(); ++i) {
                String string5 = this.matchedLabels.get(i);
                int n3 = this.analyser1.indexof(string5);
                double d = this.analyser1.getMean(n3);
                double d2 = this.analyser1.getStdError(n3);
                int n4 = this.analyser2.indexof(string5);
                double d3 = this.analyser2.getMean(n4);
                double d4 = this.analyser2.getStdError(n4);
                printStream.println(string5 + string4.substring(string5.length()) + " " + (string2 == null ? "" : string2 + " ") + (this.zScore[i] > 2.0 ? "* " : "  ") + " " + OutputUtils.format(this.zScore[i]) + " " + OutputUtils.format(d) + " " + OutputUtils.format(d2) + " " + OutputUtils.format(d3) + " " + OutputUtils.format(d4));
                if (!(this.zScore[i] > 2.0)) continue;
                arrayList.add(string5);
            }
        }
        printStream.println("\nThere are " + arrayList.size() + " parameters having significantly different value : " + OutputUtils.toString(arrayList) + "\n\n");
    }

    public static void main(String[] stringArray) {
        Object object;
        LogAnalyser logAnalyser = null;
        LogAnalyser logAnalyser2 = null;
        try {
            if (stringArray.length == 0) {
                object = new BEASTVersion2();
                File file = Utils.getLoadFile("LogComparator " + ((BEASTVersion2)object).getVersionString() + " - Select first log file to analyse", null, "BEAST log (*.log) Files", "log", "txt");
                if (file == null) {
                    return;
                }
                logAnalyser = new LogAnalyser(file.getAbsolutePath());
                file = Utils.getLoadFile("LogComparator " + ((BEASTVersion2)object).getVersionString() + " - Select second log file to analyse", null, "BEAST log (*.log) Files", "log", "txt");
                if (file == null) {
                    return;
                }
                logAnalyser2 = new LogAnalyser(file.getAbsolutePath());
            } else {
                logAnalyser = new LogAnalyser(stringArray[0]);
                logAnalyser2 = new LogAnalyser(stringArray[1]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new LogComparator(logAnalyser, logAnalyser2);
        ((LogComparator)object).print(System.out, true);
    }
}

