/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.Description;
import beast.core.Input;
import beast.core.State;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.speciation.SpeciesTreePrior;
import beast.evolution.speciation.TreeTopFinder;
import beast.evolution.tree.Node;
import beast.evolution.tree.TreeDistribution;
import beast.evolution.tree.TreeInterface;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;

@Description(value="Calculates probability of gene tree conditioned on a species tree (multi-species coalescent)")
public class GeneTreeForSpeciesTreeDistribution
extends TreeDistribution {
    public final Input<TreeInterface> speciesTreeInput = new Input("speciesTree", "species tree containing the associated gene tree", Input.Validate.REQUIRED);
    public final Input<Double> ploidyInput = new Input<Double>("ploidy", "ploidy (copy number) for this gene, typically a whole number or half (default 2 for autosomal_nuclear)", 2.0);
    public final Input<SpeciesTreePrior> speciesTreePriorInput = new Input("speciesTreePrior", "defines population function and its parameters", Input.Validate.REQUIRED);
    public final Input<TreeTopFinder> treeTopFinderInput = new Input("treetop", "calculates height of species tree, required only for linear *beast analysis");
    private PriorityQueue<Double>[] intervalsInput;
    private int[] nrOfLineages;
    protected int[] nrOfLineageToSpeciesMap;
    SpeciesTreePrior.TreePopSizeFunction isConstantPopFunction;
    RealParameter popSizesBottom;
    RealParameter popSizesTop;
    private double ploidy;

    public GeneTreeForSpeciesTreeDistribution() {
        this.treeInput.setRule(Input.Validate.REQUIRED);
    }

    @Override
    public void initAndValidate() {
        int n;
        this.ploidy = this.ploidyInput.get();
        Node[] nodeArray = ((TreeInterface)this.treeInput.get()).getNodesAsArray();
        int n2 = ((TreeInterface)this.treeInput.get()).getLeafNodeCount();
        Node[] nodeArray2 = this.speciesTreeInput.get().getNodesAsArray();
        int n3 = this.speciesTreeInput.get().getNodeCount();
        if (n3 <= 1 && nodeArray2[0].getID().equals("Beauti2DummyTaxonSet")) {
            return;
        }
        this.intervalsInput = new PriorityQueue[n3];
        for (n = 0; n < n3; ++n) {
            this.intervalsInput[n] = new PriorityQueue();
        }
        for (n = 0; n < n2; ++n) {
            if (nodeArray[n].getHeight() == 0.0) continue;
            throw new IllegalArgumentException("Cannot deal with taxon " + nodeArray[n].getID() + ", which has non-zero height + " + nodeArray[n].getHeight());
        }
        this.nrOfLineageToSpeciesMap = new int[n2];
        Arrays.fill(this.nrOfLineageToSpeciesMap, -1);
        for (n = 0; n < n2; ++n) {
            String string = this.getSetID(nodeArray[n].getID());
            if (string == null) {
                throw new IllegalArgumentException("Cannot find species for lineage " + nodeArray[n].getID());
            }
            for (int i = 0; i < n3; ++i) {
                if (!string.equals(nodeArray2[i].getID())) continue;
                this.nrOfLineageToSpeciesMap[n] = i;
                break;
            }
            if (this.nrOfLineageToSpeciesMap[n] >= 0) continue;
            throw new IllegalArgumentException("Cannot find species with name " + string + " in species tree");
        }
        this.nrOfLineages = new int[n3];
        SpeciesTreePrior speciesTreePrior = this.speciesTreePriorInput.get();
        this.isConstantPopFunction = speciesTreePrior.popFunctionInput.get();
        this.popSizesBottom = speciesTreePrior.popSizesBottomInput.get();
        this.popSizesTop = speciesTreePrior.popSizesTopInput.get();
        assert (this.isConstantPopFunction != SpeciesTreePrior.TreePopSizeFunction.linear || this.treeTopFinderInput.get() != null);
    }

    String getSetID(String string) {
        TaxonSet taxonSet = this.speciesTreePriorInput.get().taxonSetInput.get();
        List<Taxon> list = taxonSet.taxonsetInput.get();
        for (Taxon taxon : list) {
            List<Taxon> list2 = ((TaxonSet)taxon).taxonsetInput.get();
            for (Taxon taxon2 : list2) {
                if (!taxon2.getID().equals(string)) continue;
                return taxon.getID();
            }
        }
        return null;
    }

    @Override
    public double calculateLogP() {
        this.logP = 0.0;
        for (PriorityQueue<Double> priorityQueue : this.intervalsInput) {
            priorityQueue.clear();
        }
        Arrays.fill(this.nrOfLineages, 0);
        TreeInterface treeInterface = this.speciesTreeInput.get();
        Node[] nodeArray = treeInterface.getNodesAsArray();
        this.traverseLineageTree(nodeArray, ((TreeInterface)this.treeInput.get()).getRoot());
        if (this.logP == 0.0) {
            this.traverseSpeciesTree(treeInterface.getRoot());
        }
        return this.logP;
    }

    private void traverseSpeciesTree(Node node) {
        int n;
        if (!node.isLeaf()) {
            this.traverseSpeciesTree(node.getLeft());
            this.traverseSpeciesTree(node.getRight());
        }
        int n2 = node.getNr();
        int n3 = this.intervalsInput[n2].size();
        double[] dArray = new double[n3 + 2];
        dArray[0] = node.getHeight();
        for (n = 1; n <= n3; ++n) {
            dArray[n] = this.intervalsInput[n2].poll();
        }
        dArray[n3 + 1] = !node.isRoot() ? node.getParent().getHeight() : (this.isConstantPopFunction == SpeciesTreePrior.TreePopSizeFunction.linear ? this.treeTopFinderInput.get().getHighestTreeHeight() : Math.max(node.getHeight(), ((TreeInterface)this.treeInput.get()).getRoot().getHeight()));
        for (n = 0; n <= n3; ++n) {
            if (!(dArray[n] > dArray[n + 1])) continue;
            Log.warning.println("invalid times");
            this.calculateLogP();
        }
        n = this.nrOfLineages[n2];
        switch (this.isConstantPopFunction) {
            case constant: {
                this.calcConstantPopSizeContribution(n, (Double)this.popSizesBottom.getValue(n2), dArray, n3);
                break;
            }
            case linear: {
                this.logP += this.calcLinearPopSizeContributionJH(n, n2, dArray, n3, node);
                break;
            }
            case linear_with_constant_root: {
                if (node.isRoot()) {
                    double d = this.getTopPopSize(node.getLeft().getNr()) + this.getTopPopSize(node.getRight().getNr());
                    this.calcConstantPopSizeContribution(n, d, dArray, n3);
                    break;
                }
                this.logP += this.calcLinearPopSizeContribution(n, n2, dArray, n3, node);
            }
        }
    }

    private void calcConstantPopSizeContribution(int n, double d, double[] dArray, int n2) {
        double d2 = d * this.ploidy;
        this.logP += (double)(-n2) * Math.log(d2);
        for (int i = 0; i <= n2; ++i) {
            this.logP += -((double)(n - i) * ((double)(n - i) - 1.0) / 2.0) * (dArray[i + 1] - dArray[i]) / d2;
        }
    }

    private double calcLinearPopSizeContribution(int n, int n2, double[] dArray, int n3, Node node) {
        double d;
        int n4;
        double d2 = 0.0;
        double d3 = node.isLeaf() ? (Double)this.popSizesBottom.getValue(n2) * this.ploidy : (this.getTopPopSize(node.getLeft().getNr()) + this.getTopPopSize(node.getRight().getNr())) * this.ploidy;
        double d4 = this.getTopPopSize(n2) * this.ploidy;
        double d5 = (d4 - d3) / (dArray[n3 + 1] - dArray[0]);
        double d6 = d3;
        for (n4 = 0; n4 < n3; ++n4) {
            d = d5 * (dArray[n4 + 1] - dArray[0]) + d6;
            d2 += -Math.log(d);
        }
        for (n4 = 0; n4 <= n3; ++n4) {
            if (Math.abs(d4 - d3) < 1.0E-10) {
                d = d5 * (dArray[n4 + 1] - dArray[0]) + d6;
                d2 += -((double)(n - n4) * ((double)(n - n4) - 1.0) / 2.0) * (dArray[n4 + 1] - dArray[n4]) / d;
                continue;
            }
            d = (d5 * (dArray[n4 + 1] - dArray[0]) + d6) / (d5 * (dArray[n4] - dArray[0]) + d6);
            d2 += -((double)(n - n4) * ((double)(n - n4) - 1.0) / 2.0) * Math.log(d) / d5;
        }
        return d2;
    }

    private double calcLinearPopSizeContributionJH(int n, int n2, double[] dArray, int n3, Node node) {
        double d = 0.0;
        double d2 = node.isLeaf() ? (Double)this.popSizesBottom.getValue(n2) : this.getTopPopSize(node.getLeft().getNr()) + this.getTopPopSize(node.getRight().getNr());
        double d3 = this.getTopPopSize(n2) * this.ploidy;
        double d4 = d3 - (d2 *= this.ploidy);
        double d5 = dArray[0];
        double d6 = d4 / (dArray[n3 + 1] - d5);
        double d7 = d2;
        if (Math.abs(d4) < 1.0E-10) {
            for (int i = 0; i <= n3; ++i) {
                double d8 = dArray[i + 1];
                double d9 = d6 * (d8 - d5) + d7;
                if (i < n3) {
                    d += -Math.log(d9);
                }
                int n4 = n - i;
                d -= (double)n4 * ((double)n4 - 1.0) / 2.0 * (d8 - dArray[i]) / d9;
            }
        } else {
            double d10 = d7 - d6 * d5;
            for (int i = 0; i <= n3; ++i) {
                double d11 = d6 * dArray[i + 1] + d10;
                if (i < n3) {
                    d += -Math.log(d11);
                }
                double d12 = d11 / (d6 * dArray[i] + d10);
                int n5 = n - i;
                d += -((double)n5 * ((double)n5 - 1.0) / 2.0) * Math.log(d12) / d6;
            }
        }
        return d;
    }

    private int traverseLineageTree(Node[] nodeArray, Node node) {
        if (node.isLeaf()) {
            int n;
            int n2 = n = this.nrOfLineageToSpeciesMap[node.getNr()];
            this.nrOfLineages[n2] = this.nrOfLineages[n2] + 1;
            return n;
        }
        int n = this.traverseLineageTree(nodeArray, node.getLeft());
        int n3 = this.traverseLineageTree(nodeArray, node.getRight());
        double d = node.getHeight();
        while (!nodeArray[n].isRoot() && d > nodeArray[n].getParent().getHeight()) {
            int n4 = n = nodeArray[n].getParent().getNr();
            this.nrOfLineages[n4] = this.nrOfLineages[n4] + 1;
        }
        while (!nodeArray[n3].isRoot() && d > nodeArray[n3].getParent().getHeight()) {
            int n5 = n3 = nodeArray[n3].getParent().getNr();
            this.nrOfLineages[n5] = this.nrOfLineages[n5] + 1;
        }
        if (n != n3) {
            this.logP = Double.NEGATIVE_INFINITY;
        }
        this.intervalsInput[n3].add(d);
        return n3;
    }

    private double getTopPopSize(int n) {
        if (n < this.popSizesTop.getDimension()) {
            return this.popSizesTop.getArrayValue(n);
        }
        return this.popSizesTop.getArrayValue(this.speciesTreeInput.get().getRoot().getNr());
    }

    @Override
    public boolean requiresRecalculation() {
        return true;
    }

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }

    @Override
    public void sample(State state, Random random) {
    }
}

