/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.RealParameter;
import beast.util.Randomizer;
import java.text.DecimalFormat;

@Description(value="A random walk operator that selects a random dimension of the real parameter and perturbs the value a random amount within +/- windowSize.")
public class RealRandomWalkOperator
extends Operator {
    public final Input<Double> windowSizeInput = new Input("windowSize", "the size of the window both up and down when using uniform interval OR standard deviation when using Gaussian", Input.Validate.REQUIRED);
    public final Input<RealParameter> parameterInput = new Input("parameter", "the parameter to operate a random walk on.", Input.Validate.REQUIRED);
    public final Input<Boolean> useGaussianInput = new Input<Boolean>("useGaussian", "Use Gaussian to move instead of uniform interval. Default false.", false);
    double windowSize = 1.0;
    boolean useGaussian;

    @Override
    public void initAndValidate() {
        this.windowSize = this.windowSizeInput.get();
        this.useGaussian = this.useGaussianInput.get();
    }

    @Override
    public double proposal() {
        double d;
        RealParameter realParameter = this.parameterInput.get(this);
        int n = Randomizer.nextInt(realParameter.getDimension());
        double d2 = d = ((Double)realParameter.getValue(n)).doubleValue();
        d2 = this.useGaussian ? (d2 += Randomizer.nextGaussian() * this.windowSize) : (d2 += Randomizer.nextDouble() * 2.0 * this.windowSize - this.windowSize);
        if (d2 < (Double)realParameter.getLower() || d2 > (Double)realParameter.getUpper()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d2 == d) {
            return Double.NEGATIVE_INFINITY;
        }
        realParameter.setValue(n, d2);
        return 0.0;
    }

    @Override
    public double getCoercableParameterValue() {
        return this.windowSize;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.windowSize = d;
    }

    @Override
    public void optimize(double d) {
        double d2 = this.calcDelta(d);
        this.windowSize = Math.exp(d2 += Math.log(this.windowSize));
    }

    @Override
    public final String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = this.windowSize * d3;
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting window size to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting window size to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

