/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "splash_options.h"

SplashOptions::SplashOptions (bool init /* = true */) :
    mOptions (SplashOptions::OptionNum),
    mNotify (SplashOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
SplashOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // initiate_key
    mOptions[SplashOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control>F11");
    mOptions[SplashOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SplashOptions::InitiateKey].value ().action ());

    // firststart
    mOptions[SplashOptions::Firststart].setName ("firststart", CompOption::TypeBool);
    mOptions[SplashOptions::Firststart].value().set(true);

    // background
    mOptions[SplashOptions::Background].setName ("background", CompOption::TypeString);
    mOptions[SplashOptions::Background].value().set(CompString ("splash_background.png"));

    // logo
    mOptions[SplashOptions::Logo].setName ("logo", CompOption::TypeString);
    mOptions[SplashOptions::Logo].value().set(CompString ("splash_logo.png"));

    // fade_time
    mOptions[SplashOptions::FadeTime].setName ("fade_time", CompOption::TypeFloat);
    mOptions[SplashOptions::FadeTime].rest ().set (0.0, 100.0, 0.1);
    mOptions[SplashOptions::FadeTime].value().set((float) 1.0);

    // display_time
    mOptions[SplashOptions::DisplayTime].setName ("display_time", CompOption::TypeFloat);
    mOptions[SplashOptions::DisplayTime].rest ().set (0.0, 100.0, 0.1);
    mOptions[SplashOptions::DisplayTime].value().set((float) 2.0);

    // saturation
    mOptions[SplashOptions::Saturation].setName ("saturation", CompOption::TypeFloat);
    mOptions[SplashOptions::Saturation].rest ().set (0.0, 100.0, 0.1);
    mOptions[SplashOptions::Saturation].value().set((float) 50.0);

    // brightness
    mOptions[SplashOptions::Brightness].setName ("brightness", CompOption::TypeFloat);
    mOptions[SplashOptions::Brightness].rest ().set (0.0, 100.0, 0.1);
    mOptions[SplashOptions::Brightness].value().set((float) 50.0);

}

SplashOptions::~SplashOptions ()
{
}


CompOption::Vector &
SplashOptions::getOptions ()
{
    return mOptions;
}

bool
SplashOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case SplashOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::InitiateKey].empty ())
                    mNotify[SplashOptions::InitiateKey] (o, SplashOptions::InitiateKey);
                return true;
            }
            break;
        case SplashOptions::Firststart:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::Firststart].empty ())
                    mNotify[SplashOptions::Firststart] (o, SplashOptions::Firststart);
                return true;
            }
            break;
        case SplashOptions::Background:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::Background].empty ())
                    mNotify[SplashOptions::Background] (o, SplashOptions::Background);
                return true;
            }
            break;
        case SplashOptions::Logo:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::Logo].empty ())
                    mNotify[SplashOptions::Logo] (o, SplashOptions::Logo);
                return true;
            }
            break;
        case SplashOptions::FadeTime:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::FadeTime].empty ())
                    mNotify[SplashOptions::FadeTime] (o, SplashOptions::FadeTime);
                return true;
            }
            break;
        case SplashOptions::DisplayTime:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::DisplayTime].empty ())
                    mNotify[SplashOptions::DisplayTime] (o, SplashOptions::DisplayTime);
                return true;
            }
            break;
        case SplashOptions::Saturation:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::Saturation].empty ())
                    mNotify[SplashOptions::Saturation] (o, SplashOptions::Saturation);
                return true;
            }
            break;
        case SplashOptions::Brightness:
            if (o->set (value))
            {
                if (!mNotify[SplashOptions::Brightness].empty ())
                    mNotify[SplashOptions::Brightness] (o, SplashOptions::Brightness);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

