/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "neg_options.h"

NegOptions::NegOptions (bool init /* = true */) :
    mOptions (NegOptions::OptionNum),
    mNotify (NegOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
NegOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // window_toggle_key
    mOptions[NegOptions::WindowToggleKey].setName ("window_toggle_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>n");
    mOptions[NegOptions::WindowToggleKey].value().set (action);
    if (screen) screen->addAction (&mOptions[NegOptions::WindowToggleKey].value ().action ());

    // activate_at_startup
    mOptions[NegOptions::ActivateAtStartup].setName ("activate_at_startup", CompOption::TypeBool);
    mOptions[NegOptions::ActivateAtStartup].value().set(false);

    // screen_toggle_key
    mOptions[NegOptions::ScreenToggleKey].setName ("screen_toggle_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>m");
    mOptions[NegOptions::ScreenToggleKey].value().set (action);
    if (screen) screen->addAction (&mOptions[NegOptions::ScreenToggleKey].value ().action ());

    // neg_match
    mOptions[NegOptions::NegMatch].setName ("neg_match", CompOption::TypeMatch);
    mOptions[NegOptions::NegMatch].value().set(CompMatch ("any"));
    mOptions[NegOptions::NegMatch].value().match ().update ();

    // exclude_match
    mOptions[NegOptions::ExcludeMatch].setName ("exclude_match", CompOption::TypeMatch);
    mOptions[NegOptions::ExcludeMatch].value().set(CompMatch ("type=Desktop"));
    mOptions[NegOptions::ExcludeMatch].value().match ().update ();

    // neg_decorations
    mOptions[NegOptions::NegDecorations].setName ("neg_decorations", CompOption::TypeBool);
    mOptions[NegOptions::NegDecorations].value().set(false);

}

NegOptions::~NegOptions ()
{
}


CompOption::Vector &
NegOptions::getOptions ()
{
    return mOptions;
}

bool
NegOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case NegOptions::WindowToggleKey:
            if (o->set (value))
            {
                if (!mNotify[NegOptions::WindowToggleKey].empty ())
                    mNotify[NegOptions::WindowToggleKey] (o, NegOptions::WindowToggleKey);
                return true;
            }
            break;
        case NegOptions::ActivateAtStartup:
            if (o->set (value))
            {
                if (!mNotify[NegOptions::ActivateAtStartup].empty ())
                    mNotify[NegOptions::ActivateAtStartup] (o, NegOptions::ActivateAtStartup);
                return true;
            }
            break;
        case NegOptions::ScreenToggleKey:
            if (o->set (value))
            {
                if (!mNotify[NegOptions::ScreenToggleKey].empty ())
                    mNotify[NegOptions::ScreenToggleKey] (o, NegOptions::ScreenToggleKey);
                return true;
            }
            break;
        case NegOptions::NegMatch:
            if (o->set (value))
            {
                if (!mNotify[NegOptions::NegMatch].empty ())
                    mNotify[NegOptions::NegMatch] (o, NegOptions::NegMatch);
                return true;
            }
            break;
        case NegOptions::ExcludeMatch:
            if (o->set (value))
            {
                if (!mNotify[NegOptions::ExcludeMatch].empty ())
                    mNotify[NegOptions::ExcludeMatch] (o, NegOptions::ExcludeMatch);
                return true;
            }
            break;
        case NegOptions::NegDecorations:
            if (o->set (value))
            {
                if (!mNotify[NegOptions::NegDecorations].empty ())
                    mNotify[NegOptions::NegDecorations] (o, NegOptions::NegDecorations);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

