/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "expo_options.h"

ExpoOptions::ExpoOptions (bool init /* = true */) :
    mOptions (ExpoOptions::OptionNum),
    mNotify (ExpoOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ExpoOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;
    unsigned short color[4];

    // expo_key
    mOptions[ExpoOptions::ExpoKey].setName ("expo_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>e");
    mOptions[ExpoOptions::ExpoKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ExpoOptions::ExpoKey].value ().action ());

    // expo_button
    mOptions[ExpoOptions::ExpoButton].setName ("expo_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ExpoOptions::ExpoButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ExpoOptions::ExpoButton].value ().action ());

    // expo_edge
    mOptions[ExpoOptions::ExpoEdge].setName ("expo_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    edge |= (1 << 4);
    action.setEdgeMask (edge);
    mOptions[ExpoOptions::ExpoEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ExpoOptions::ExpoEdge].value ().action ());

    // double_click_time
    mOptions[ExpoOptions::DoubleClickTime].setName ("double_click_time", CompOption::TypeInt);
    mOptions[ExpoOptions::DoubleClickTime].rest ().set (50, 2000);
    mOptions[ExpoOptions::DoubleClickTime].value().set((int) 500);

    // dnd_button
    mOptions[ExpoOptions::DndButton].setName ("dnd_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("Button1");
    mOptions[ExpoOptions::DndButton].value().set (action);

    // exit_button
    mOptions[ExpoOptions::ExitButton].setName ("exit_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("Button3");
    mOptions[ExpoOptions::ExitButton].value().set (action);

    // next_vp_button
    mOptions[ExpoOptions::NextVpButton].setName ("next_vp_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("Button5");
    mOptions[ExpoOptions::NextVpButton].value().set (action);

    // prev_vp_button
    mOptions[ExpoOptions::PrevVpButton].setName ("prev_vp_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("Button4");
    mOptions[ExpoOptions::PrevVpButton].value().set (action);

    // zoom_time
    mOptions[ExpoOptions::ZoomTime].setName ("zoom_time", CompOption::TypeFloat);
    mOptions[ExpoOptions::ZoomTime].rest ().set (0.1, 5.0, 0.1);
    mOptions[ExpoOptions::ZoomTime].value().set((float) 0.5);

    // expo_immediate_move
    mOptions[ExpoOptions::ExpoImmediateMove].setName ("expo_immediate_move", CompOption::TypeBool);
    mOptions[ExpoOptions::ExpoImmediateMove].value().set(false);

    // expo_animation
    mOptions[ExpoOptions::ExpoAnimation].setName ("expo_animation", CompOption::TypeInt);
    mOptions[ExpoOptions::ExpoAnimation].rest ().set (0, 3);
    mOptions[ExpoOptions::ExpoAnimation].value().set((int) 0);

    // deform
    mOptions[ExpoOptions::Deform].setName ("deform", CompOption::TypeInt);
    mOptions[ExpoOptions::Deform].rest ().set (0, 2);
    mOptions[ExpoOptions::Deform].value().set((int) 0);

    // curve
    mOptions[ExpoOptions::Curve].setName ("curve", CompOption::TypeFloat);
    mOptions[ExpoOptions::Curve].rest ().set (0.0, 1.0, 0.01);
    mOptions[ExpoOptions::Curve].value().set((float) 0.50);

    // x_offset
    mOptions[ExpoOptions::XOffset].setName ("x_offset", CompOption::TypeInt);
    mOptions[ExpoOptions::XOffset].rest ().set (MINSHORT, MAXSHORT);
    mOptions[ExpoOptions::XOffset].value().set((int) 0);

    // y_offset
    mOptions[ExpoOptions::YOffset].setName ("y_offset", CompOption::TypeInt);
    mOptions[ExpoOptions::YOffset].rest ().set (MINSHORT, MAXSHORT);
    mOptions[ExpoOptions::YOffset].value().set((int) 0);

    // y_bottom_offset
    mOptions[ExpoOptions::YBottomOffset].setName ("y_bottom_offset", CompOption::TypeInt);
    mOptions[ExpoOptions::YBottomOffset].rest ().set (0, MAXSHORT);
    mOptions[ExpoOptions::YBottomOffset].value().set((int) 0);

    // distance
    mOptions[ExpoOptions::Distance].setName ("distance", CompOption::TypeFloat);
    mOptions[ExpoOptions::Distance].rest ().set (0.0, 1.0, 0.01);
    mOptions[ExpoOptions::Distance].value().set((float) 0.0);

    // vp_distance
    mOptions[ExpoOptions::VpDistance].setName ("vp_distance", CompOption::TypeFloat);
    mOptions[ExpoOptions::VpDistance].rest ().set (0.0, 1.0, 0.01);
    mOptions[ExpoOptions::VpDistance].value().set((float) 0.10);

    // aspect_ratio
    mOptions[ExpoOptions::AspectRatio].setName ("aspect_ratio", CompOption::TypeFloat);
    mOptions[ExpoOptions::AspectRatio].rest ().set (0.0, 1.0, 0.1);
    mOptions[ExpoOptions::AspectRatio].value().set((float) 1.0);

    // hide_docks
    mOptions[ExpoOptions::HideDocks].setName ("hide_docks", CompOption::TypeBool);
    mOptions[ExpoOptions::HideDocks].value().set(false);

    // mipmaps
    mOptions[ExpoOptions::Mipmaps].setName ("mipmaps", CompOption::TypeBool);
    mOptions[ExpoOptions::Mipmaps].value().set(false);

    // multioutput_mode
    mOptions[ExpoOptions::MultioutputMode].setName ("multioutput_mode", CompOption::TypeInt);
    mOptions[ExpoOptions::MultioutputMode].rest ().set (0, 1);
    mOptions[ExpoOptions::MultioutputMode].value().set((int) 0);

    // vp_brightness
    mOptions[ExpoOptions::VpBrightness].setName ("vp_brightness", CompOption::TypeFloat);
    mOptions[ExpoOptions::VpBrightness].rest ().set (0.0, 100.0, 0.1);
    mOptions[ExpoOptions::VpBrightness].value().set((float) 75.0);

    // vp_saturation
    mOptions[ExpoOptions::VpSaturation].setName ("vp_saturation", CompOption::TypeFloat);
    mOptions[ExpoOptions::VpSaturation].rest ().set (0.0, 100.0, 0.1);
    mOptions[ExpoOptions::VpSaturation].value().set((float) 100.0);

    // selected_color
    mOptions[ExpoOptions::SelectedColor].setName ("selected_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xfbfb));
    color[1] = MAX (0, MIN (0xffff, 0x8b8b));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0x0));
    mOptions[ExpoOptions::SelectedColor].value().set(color);

    // reflection
    mOptions[ExpoOptions::Reflection].setName ("reflection", CompOption::TypeBool);
    mOptions[ExpoOptions::Reflection].value().set(true);

    // ground_color1
    mOptions[ExpoOptions::GroundColor1].setName ("ground_color1", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xb333));
    color[1] = MAX (0, MIN (0xffff, 0xb333));
    color[2] = MAX (0, MIN (0xffff, 0xb333));
    color[3] = MAX (0, MIN (0xffff, 0xcccc));
    mOptions[ExpoOptions::GroundColor1].value().set(color);

    // ground_color2
    mOptions[ExpoOptions::GroundColor2].setName ("ground_color2", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xb333));
    color[1] = MAX (0, MIN (0xffff, 0xb333));
    color[2] = MAX (0, MIN (0xffff, 0xb333));
    color[3] = MAX (0, MIN (0xffff, 0x0000));
    mOptions[ExpoOptions::GroundColor2].value().set(color);

    // ground_size
    mOptions[ExpoOptions::GroundSize].setName ("ground_size", CompOption::TypeFloat);
    mOptions[ExpoOptions::GroundSize].rest ().set (0.0, 1.0, 0.01);
    mOptions[ExpoOptions::GroundSize].value().set((float) 0.5);

    // scale_factor
    mOptions[ExpoOptions::ScaleFactor].setName ("scale_factor", CompOption::TypeFloat);
    mOptions[ExpoOptions::ScaleFactor].rest ().set (0.0, 2.0, 0.01);
    mOptions[ExpoOptions::ScaleFactor].value().set((float) 0.75);

}

ExpoOptions::~ExpoOptions ()
{
}


CompOption::Vector &
ExpoOptions::getOptions ()
{
    return mOptions;
}

bool
ExpoOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ExpoOptions::ExpoKey:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ExpoKey].empty ())
                    mNotify[ExpoOptions::ExpoKey] (o, ExpoOptions::ExpoKey);
                return true;
            }
            break;
        case ExpoOptions::ExpoButton:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ExpoButton].empty ())
                    mNotify[ExpoOptions::ExpoButton] (o, ExpoOptions::ExpoButton);
                return true;
            }
            break;
        case ExpoOptions::ExpoEdge:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ExpoEdge].empty ())
                    mNotify[ExpoOptions::ExpoEdge] (o, ExpoOptions::ExpoEdge);
                return true;
            }
            break;
        case ExpoOptions::DoubleClickTime:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::DoubleClickTime].empty ())
                    mNotify[ExpoOptions::DoubleClickTime] (o, ExpoOptions::DoubleClickTime);
                return true;
            }
            break;
        case ExpoOptions::DndButton:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::DndButton].empty ())
                    mNotify[ExpoOptions::DndButton] (o, ExpoOptions::DndButton);
                return true;
            }
            break;
        case ExpoOptions::ExitButton:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ExitButton].empty ())
                    mNotify[ExpoOptions::ExitButton] (o, ExpoOptions::ExitButton);
                return true;
            }
            break;
        case ExpoOptions::NextVpButton:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::NextVpButton].empty ())
                    mNotify[ExpoOptions::NextVpButton] (o, ExpoOptions::NextVpButton);
                return true;
            }
            break;
        case ExpoOptions::PrevVpButton:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::PrevVpButton].empty ())
                    mNotify[ExpoOptions::PrevVpButton] (o, ExpoOptions::PrevVpButton);
                return true;
            }
            break;
        case ExpoOptions::ZoomTime:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ZoomTime].empty ())
                    mNotify[ExpoOptions::ZoomTime] (o, ExpoOptions::ZoomTime);
                return true;
            }
            break;
        case ExpoOptions::ExpoImmediateMove:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ExpoImmediateMove].empty ())
                    mNotify[ExpoOptions::ExpoImmediateMove] (o, ExpoOptions::ExpoImmediateMove);
                return true;
            }
            break;
        case ExpoOptions::ExpoAnimation:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ExpoAnimation].empty ())
                    mNotify[ExpoOptions::ExpoAnimation] (o, ExpoOptions::ExpoAnimation);
                return true;
            }
            break;
        case ExpoOptions::Deform:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::Deform].empty ())
                    mNotify[ExpoOptions::Deform] (o, ExpoOptions::Deform);
                return true;
            }
            break;
        case ExpoOptions::Curve:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::Curve].empty ())
                    mNotify[ExpoOptions::Curve] (o, ExpoOptions::Curve);
                return true;
            }
            break;
        case ExpoOptions::XOffset:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::XOffset].empty ())
                    mNotify[ExpoOptions::XOffset] (o, ExpoOptions::XOffset);
                return true;
            }
            break;
        case ExpoOptions::YOffset:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::YOffset].empty ())
                    mNotify[ExpoOptions::YOffset] (o, ExpoOptions::YOffset);
                return true;
            }
            break;
        case ExpoOptions::YBottomOffset:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::YBottomOffset].empty ())
                    mNotify[ExpoOptions::YBottomOffset] (o, ExpoOptions::YBottomOffset);
                return true;
            }
            break;
        case ExpoOptions::Distance:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::Distance].empty ())
                    mNotify[ExpoOptions::Distance] (o, ExpoOptions::Distance);
                return true;
            }
            break;
        case ExpoOptions::VpDistance:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::VpDistance].empty ())
                    mNotify[ExpoOptions::VpDistance] (o, ExpoOptions::VpDistance);
                return true;
            }
            break;
        case ExpoOptions::AspectRatio:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::AspectRatio].empty ())
                    mNotify[ExpoOptions::AspectRatio] (o, ExpoOptions::AspectRatio);
                return true;
            }
            break;
        case ExpoOptions::HideDocks:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::HideDocks].empty ())
                    mNotify[ExpoOptions::HideDocks] (o, ExpoOptions::HideDocks);
                return true;
            }
            break;
        case ExpoOptions::Mipmaps:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::Mipmaps].empty ())
                    mNotify[ExpoOptions::Mipmaps] (o, ExpoOptions::Mipmaps);
                return true;
            }
            break;
        case ExpoOptions::MultioutputMode:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::MultioutputMode].empty ())
                    mNotify[ExpoOptions::MultioutputMode] (o, ExpoOptions::MultioutputMode);
                return true;
            }
            break;
        case ExpoOptions::VpBrightness:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::VpBrightness].empty ())
                    mNotify[ExpoOptions::VpBrightness] (o, ExpoOptions::VpBrightness);
                return true;
            }
            break;
        case ExpoOptions::VpSaturation:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::VpSaturation].empty ())
                    mNotify[ExpoOptions::VpSaturation] (o, ExpoOptions::VpSaturation);
                return true;
            }
            break;
        case ExpoOptions::SelectedColor:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::SelectedColor].empty ())
                    mNotify[ExpoOptions::SelectedColor] (o, ExpoOptions::SelectedColor);
                return true;
            }
            break;
        case ExpoOptions::Reflection:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::Reflection].empty ())
                    mNotify[ExpoOptions::Reflection] (o, ExpoOptions::Reflection);
                return true;
            }
            break;
        case ExpoOptions::GroundColor1:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::GroundColor1].empty ())
                    mNotify[ExpoOptions::GroundColor1] (o, ExpoOptions::GroundColor1);
                return true;
            }
            break;
        case ExpoOptions::GroundColor2:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::GroundColor2].empty ())
                    mNotify[ExpoOptions::GroundColor2] (o, ExpoOptions::GroundColor2);
                return true;
            }
            break;
        case ExpoOptions::GroundSize:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::GroundSize].empty ())
                    mNotify[ExpoOptions::GroundSize] (o, ExpoOptions::GroundSize);
                return true;
            }
            break;
        case ExpoOptions::ScaleFactor:
            if (o->set (value))
            {
                if (!mNotify[ExpoOptions::ScaleFactor].empty ())
                    mNotify[ExpoOptions::ScaleFactor] (o, ExpoOptions::ScaleFactor);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

