#Skin Shortcuts - 1.0.7

script.skinshortcuts was written with the intention of making user customizable shortcuts on the home page easier for skinners.


## What's New for Skinners

#### Version 1.0.7 - repo version

- Additional properties of the currently selected menu item are now available via window properties in the management dialog - accessing them this way may help in cases where Kodi's property limit is reached - [Read More](./resources/docs/started/Management Dialog.md#label-and-label2)

#### Version 1.0.6 - previous repo version

- Icons and thumbs are now saved on a per-skin basis
- Ability to specify an icon to be displayed with a background - [Read More](./resources/docs/advanced/Managing backgrounds.md#defining-backgrounds)
- Support building variables in templates - [Read More](./resources/docs/advanced/Templates.md#other-template)
- Ability to specify conditions for fallback custom properties - [Read More](./resources/docs/advanced/Custom shortcut properties.md#for-all-shortcuts-without-a-user-set-property)
- Ability to specify a property requires another property to be present, and that a property is only used by templates - [Read More](./resources/docs/advanced/Custom shortcut properties.md#set-options)

Whilst they do not affect how skinners interact with the script, it is worth noting this version introduces changes aimed at the end users. Most notably:-

- Users can now specify that their menus should not be shared between skins
- Support for context menu add-on ([Git](https://github.com/Ignoble61/context.skinshortcuts.addtomenu)) to add items directly to menu
 
## With Thanks - Because their names don't deserve to be at the bottom :)

- Huge thanks to Ronie, whose code for listing plugins is used in this script
- Equally huge thanks to Ronie and 'Black, for their favourites code used in this script
- More huge thanks to BigNoid, for the ability to edit shortcuts, and Jeroen, for so many suggestions each of which just made the script better.
- The thanks remain absolutely huge to the translaters on Transifex for localising the script
- There almost isn't enough thanks for schimi2k for the icon and fanart
- Everyone who has contributed even one idea or line of code
- And the biggest thanks of all to Annie and my family, for feature suggestions, testing and shouting at me when I broke things

## Where To Get Help

Though hopefully Skin Shortcuts will save you a lot of code in the long-run, it is a relatively complex script and so may take some time to get your head around.

To help, it includes a lot of documentation covering the various features of the script

* [What is Skin Shortcuts](./resources/docs/What is Skin Shortcuts.md)
* [Getting Started](./resources/docs/started/Getting Started.md)
* [Providing default shortcuts](./resources/docs/Providing default shortcuts.md)
* [Advanced usage topics](./resources/docs/advanced/Advanced Usage.md)
* [labelID and localisation](./resources/docs/labelID and Localisation.md)

It's highly recommended to take time to read through these documents before you begin.

If you require any assistance post on the Kodi forum and I'll do my best to assist:

[http://forum.kodi.org/showthread.php?tid=178294](http://forum.kodi.org/showthread.php?tid=178294)

## Documentation for different versions

The documentation with Skin Shortcuts is generally updated as features are added or changed. Therefore, the docs on Git refer to the latest build, and will include details of features that are not yet on the repo.

If you are targetting the repo version of the script you can use the tags to browse the documentation for that particular release.
