#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 2 "parse.y"

/*
 * Copyright (c) 2021-2024 Omar Polo <op@omarpolo.com>
 * Copyright (c) 2018 Florian Obser <florian@openbsd.org>
 * Copyright (c) 2004, 2005 Esben Norby <norby@openbsd.org>
 * Copyright (c) 2004 Ryan McBride <mcbride@openbsd.org>
 * Copyright (c) 2002, 2003, 2004 Henning Brauer <henning@openbsd.org>
 * Copyright (c) 2001 Markus Friedl.  All rights reserved.
 * Copyright (c) 2001 Daniel Hartmeier.  All rights reserved.
 * Copyright (c) 2001 Theo de Raadt.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "gmid.h"

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "log.h"

struct conf *conf;

static const char	*default_host = NULL;
static uint16_t		 default_port = 1965;

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;

struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 yyparse(void);
int		 yylex(void);
void		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
void		 yywarn(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

/*
 * #define YYDEBUG 1
 * int yydebug = 1;
 */

TAILQ_HEAD(symhead, sym) symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*name;
	char			*val;
};

int	 symset(const char *, const char *, int);
char	*symget(const char *);

char		*ensure_absolute_path(char*);
int		 check_block_code(int);
char		*check_block_fmt(char*);
int		 check_strip_no(int);
int		 check_prefork_num(int);
void		 advance_loc(void);
void		 advance_proxy(void);
int		 fastcgi_conf(const char *, const char *);
void		 add_param(char *, char *);
int		 getservice(const char *);
void		 listen_on(const char *, const char *);

static struct vhost		*host;
static struct location		*loc;
static struct proxy		*proxy;
static char			*current_media;
static int			 errors;

typedef struct {
	union {
		char	*string;
		int	 number;
	} v;
	int lineno;
} YYSTYPE;

#define YYSTYPE YYSTYPE

#line 131 "y.tab.c"
#define ACCESS 257
#define ALIAS 258
#define AUTO 259
#define BLOCK 260
#define CA 261
#define CERT 262
#define CGI 263
#define CHROOT 264
#define CLIENT 265
#define DEFAULT 266
#define FACILITY 267
#define FASTCGI 268
#define FOR_HOST 269
#define INCLUDE 270
#define INDEX 271
#define IPV6 272
#define KEY 273
#define LANG 274
#define LISTEN 275
#define LOCATION 276
#define LOG 277
#define OCSP 278
#define OFF 279
#define ON 280
#define PARAM 281
#define PORT 282
#define PREFORK 283
#define PROTO 284
#define PROTOCOLS 285
#define PROXY 286
#define RELAY_TO 287
#define REQUIRE 288
#define RETURN 289
#define ROOT 290
#define SERVER 291
#define SNI 292
#define SOCKET 293
#define STRIP 294
#define STYLE 295
#define SYSLOG 296
#define TCP 297
#define TOEXT 298
#define TYPE 299
#define TYPES 300
#define USE_TLS 301
#define USER 302
#define VERIFYNAME 303
#define ERROR 304
#define STRING 305
#define NUM 306
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    6,    1,    1,
    3,    3,    4,    4,    8,    9,    9,    9,    9,    9,
    9,    9,   12,   12,   14,   14,   15,   15,   15,   15,
   15,   16,   10,   10,   17,   17,   17,   17,    5,    5,
   18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
   23,   20,   22,   22,    2,    2,    2,   25,   25,   24,
   24,   26,   26,   26,   26,   26,   26,   26,   26,   27,
   19,   19,   28,   28,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   29,   29,   29,   29,
   30,   30,   31,   31,   31,   31,   31,   31,   11,   32,
   32,   35,   33,   33,   34,   34,   36,    7,    7,   13,
   13,
};
const short yylen[] =
	{                                         2,
    0,    3,    3,    3,    3,    3,    3,    2,    1,    1,
    2,    1,    1,    1,    3,    2,    2,    1,    2,    2,
    2,    2,    5,    2,    0,    3,    2,    2,    3,    2,
    1,    0,    7,    2,    0,    3,    3,    3,    1,    1,
    2,    2,    2,    2,    2,    4,    3,    5,    5,    1,
    0,    7,    0,    2,    0,    2,    2,    2,    3,    0,
    3,    2,    2,    2,    3,    4,    2,    2,    2,    0,
    7,    2,    0,    3,    3,    4,    3,    1,    3,    1,
    2,    2,    2,    4,    2,    2,    5,    2,    2,    2,
    0,    3,    4,    2,    5,    3,    5,    2,    5,    3,
    2,    0,    3,    1,    2,    1,    1,    2,    2,    1,
    0,
};
const short yydefred[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   18,   34,
    0,    0,    7,   12,    0,    8,   10,    9,   17,    0,
    0,    0,    0,   24,   19,   20,    0,    0,    0,    0,
    0,    2,    3,    4,    5,    6,  110,  108,  109,   11,
    0,    0,    0,   30,   25,    0,    0,    0,    0,    0,
    0,  102,  104,    0,    0,   23,    0,   35,    0,   99,
    0,  101,   26,    0,   14,   13,  107,    0,  106,  100,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   70,    0,    0,    0,   51,    0,    0,    0,
   33,    0,    0,    0,   50,   80,  105,   72,    0,    0,
    0,    0,    0,    0,   89,    0,    0,    0,    0,    0,
   88,    0,    0,    0,    0,    0,   83,    0,    0,   53,
    0,    0,   86,   36,   37,   38,   75,    0,    0,    0,
    0,    0,   98,   91,   40,   39,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   54,    0,    0,    0,   87,    0,   48,   49,   73,
    0,    0,   60,   95,    0,   92,    0,    0,   59,    0,
   71,    0,   56,   57,    0,    0,    0,    0,    0,    0,
    0,    0,   52,    0,   74,    0,    0,    0,    0,    0,
    0,   68,   69,   61,   65,    0,    0,
};
const short yydgoto[] =
	{                                       1,
   29,  179,   25,   77,  147,   63,   47,   15,   16,   17,
   18,   19,   48,   60,   34,   56,   74,  102,  103,  104,
  105,  150,  130,  180,  162,  194,  126,  177,  106,  155,
  121,   64,   65,   78,   69,   79,
};
const short yysindex[] =
	{                                      0,
 1116,   -4, -289, -271, -242, -112, -262, -257, -289, -289,
  -64, -289,   -1,    3,    3,    3,    3,    3,    0,    0,
    3,    3,    0,    0, -244,    0,    0,    0,    0, -289,
 -289, -231,    3,    0,    0,    0, -244, -244,    3, -244,
 -289,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -244, -244, -289,    0,    0,  -60, -260, -244, -244,  -92,
    3,    0,    0, -117,    3,    0,    3,    0, -263,    0,
    3,    0,    0, 1176,    0,    0,    0, -263,    0,    0,
  -57, -289, -207, -220, -289, -289, -228, -119, -289, -289,
 -289, -208,    0, -242, -289, -289,    0, -186, -289, -224,
    0,    3,    3,    3,    0,    0,    0,    0, -244, -242,
 -219, -244, -244, -289,    0, -289, -270, -218,    3, -244,
    0, -244, -244, -244,  -37, -289,    0, -244,  -61,    0,
 -175, -244,    0,    0,    0,    0,    0, -289, -244,  -59,
 -289, -244,    0,    0,    0,    0, -193, -120, -289, -114,
 -289, -244, -289, -264,  -52, -254,    3, -244, -289, -289,
    3,    0, -244, -244, -252,    0,    3,    0,    0,    0,
 -258, -244,    0,    0, -244,    0,  -40, -248,    0,  -96,
    0,    3,    0,    0, -289, -289, -289, -289, -174, -289,
 -242, -242,    0,    3,    0, -244, -244, -244, -258, -171,
 -244,    0,    0,    0,    0, -289, -244,};
const short yyrindex[] =
	{                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    1,    1,    0,    0,   15,    0,    0,    0,    0,    0,
    0,   55,  -85,    0,    0,    0,   16,  -31, -255,   18,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   57,   68,    0,    0,    0,    0,    0,   21,   97,    0,
 1209,    0,    0,    0,    0,    0,  -85,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   22,    0,    0,
    0,    0,    0,  362,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1209, 1209, 1209,    0,    0,    0,    0,  410,    0,
    0,  450,  489,    0,    0,    0,    0,    0,  -41,  526,
    0,  572,  605,  644,    0,    0,    0,  683,    0,    0,
    0,  731,    0,    0,    0,    0,    0,  764,  811,    0,
    0,  141,    0,    0,    0,    0,  867,    0,    0,    0,
    0,  904,    0,  180,    0,    0, 1058,  937,    0,    0,
  -86,    0,  985,  252,    0,    0,  -41,    0,    0,    0,
 -111, -106,    0,    0,  303,    0,    0,    0,    0,    0,
    0, 1058,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -86,    0,   36,   46,   56,   73,    0,
   83,    0,    0,    0,    0,    0,   93,};
const short yygindex[] =
	{                                      0,
  -80, -105, 1224,    0,    0,   95,    5,    0,    0,    0,
    0,    0, 1266,    0,   37,    0,    0,    0,    0,    0,
  -79,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -56,    0,   38,    0,    0,   23,
};
#define YYTABLESIZE 1503
const short yytable[] =
	{                                     149,
  111,  153,  157,  119,  146,   21,   23,   70,  161,    4,
   33,   55,   21,  127,  111,   24,   58,  165,   42,   43,
   44,   45,   46,  178,   16,   21,  141,   22,  193,  137,
   15,  103,   66,   26,   24,   53,   27,   28,  111,  111,
   50,   75,   76,   35,   62,   62,   50,   54,   36,  111,
  168,  169,   24,  174,   22,   63,  183,  184,   39,   41,
   50,   22,   61,  110,   31,   64,   27,  108,  111,   72,
  114,  125,  166,   16,   21,   80,   22,   28,  131,   15,
  103,  133,   55,  111,  181,  151,  138,  143,  156,  206,
  200,   32,   67,  205,   62,   14,   67,  182,  167,    0,
  107,   71,   66,    0,   63,    0,   29,    0,    0,    0,
  202,  203,    0,   31,   64,   27,    0,    0,    0,    0,
   20,    0,    0,    0,    0,  111,   28,    0,    0,    0,
    0,   55,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   67,    0,    0,   30,    0,    0,    0,    0,    0,
   94,   66,    4,    0,  159,   29,    0,   55,    0,  115,
   62,  116,   58,    0,   30,  185,    0,    0,    0,  160,
   63,  111,   55,  117,  118,  111,  186,   58,    0,   31,
   64,   27,   31,   32,   50,   24,  111,   62,  187,   96,
  188,  189,   28,    0,    0,  190,    0,   55,  111,   94,
  111,  111,   31,   32,  191,  111,  192,   67,    0,  111,
  111,    0,    0,    0,  111,    0,  111,   66,   83,   84,
    0,   29,    0,    0,    0,   87,    0,   88,  116,    0,
   89,    0,    0,   91,    0,    0,   94,    0,   96,  111,
  117,  118,    0,   50,    0,   50,    0,   98,    0,   99,
    0,  111,  111,  100,    0,    0,  111,  111,  111,  111,
  111,   93,  111,  111,  111,   94,  111,  145,  111,    0,
  111,  111,  111,  111,  111,  111,  111,  111,  111,    0,
    0,  111,  111,  111,    0,  111,  111,  111,  111,    0,
  111,  111,  111,  111,  111,  111,  111,   62,    0,    0,
  111,  111,  111,  111,   96,  111,    0,   63,   62,    0,
   93,   31,   97,   27,    0,    0,    0,   64,   63,    0,
   62,    0,   62,   62,   28,    0,    0,   62,   64,    0,
   63,    0,   63,   63,   55,    0,   62,   63,   62,    0,
   64,    0,   64,   64,   67,   55,   63,   64,   63,   31,
   31,   27,   27,   29,   66,   67,   64,   55,   64,   55,
   55,   97,   28,   28,   55,   66,    0,   67,    0,   67,
   67,   78,    0,   55,   67,   55,   93,   66,    0,   66,
   66,    0,    0,   67,   66,   67,    0,    0,    0,    0,
    0,   29,   29,   66,    0,   66,   94,    0,   94,   94,
   94,    0,   94,   94,    0,    0,   94,    0,   94,    0,
    0,   94,    0,   94,   94,   94,   94,   94,   94,   41,
   78,   94,    0,    0,    0,    0,   94,   97,   94,    0,
   94,    0,    0,   94,   94,   96,    0,   96,   96,   96,
    0,   96,   96,    0,    0,   96,    0,   96,    0,    0,
   96,    0,   96,   96,   96,   96,   96,   96,    0,   42,
   96,    0,    0,    0,    0,   96,    0,   96,   41,   96,
    0,    0,   96,   96,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   78,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   43,    0,
    0,    0,    0,    0,    0,    0,    0,   93,   42,   93,
   93,   93,    0,   93,   93,    0,    0,   93,    0,   93,
    0,    0,   93,    0,   93,   93,   93,   93,   93,   93,
    0,    0,   93,    0,   41,   90,    0,   93,    0,   93,
    0,   93,    0,    0,   93,   93,    0,   43,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   97,    0,
   97,   97,   97,    0,   97,   97,    0,    0,   97,    0,
   97,    0,    0,   97,   42,   97,   97,   97,   97,   97,
   97,   81,    0,   97,   90,    0,    0,    0,   97,    0,
   97,    0,   97,    0,    0,   97,   97,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   43,   44,    0,    0,   78,    0,   78,
   78,   78,    0,   78,   78,    0,    0,   78,    0,   78,
   81,    0,   78,    0,   78,   78,   78,   78,   78,   78,
    0,    0,   78,    0,    0,    0,    0,   78,    0,   78,
   90,   78,    0,   82,    0,   78,    0,    0,    0,    0,
    0,    0,    0,   44,    0,   41,    0,   41,   41,   41,
    0,   41,   41,    0,    0,   41,    0,   41,    0,    0,
   41,    0,   41,   41,   41,   41,   41,   41,    0,    0,
   41,    0,   45,    0,    0,   41,   81,   41,    0,   41,
    0,    0,   82,   41,    0,   42,    0,   42,   42,   42,
    0,   42,   42,    0,    0,   42,    0,   42,    0,    0,
   42,    0,   42,   42,   42,   42,   42,   42,    0,   44,
   42,    0,    0,    0,    0,   42,    0,   42,    0,   42,
   85,   45,    0,   42,   43,    0,   43,   43,   43,    0,
   43,   43,    0,    0,   43,    0,   43,    0,    0,   43,
    0,   43,   43,   43,   43,   43,   43,    0,   82,   43,
    0,    0,    0,   77,   43,    0,   43,    0,   43,    0,
    0,   90,   43,   90,   90,   90,    0,   90,   90,   85,
    0,   90,    0,   90,    0,    0,   90,    0,   90,   90,
   90,   90,   90,   90,    0,    0,   90,   45,    0,    0,
    0,   90,    0,   90,    0,   90,    0,    0,    0,   90,
   79,    0,   77,    0,    0,    0,    0,   81,    0,   81,
   81,   81,    0,   81,   81,    0,    0,   81,    0,   81,
    0,    0,   81,    0,   81,   81,   81,   81,   81,   81,
    0,    0,   81,    0,    0,   85,    0,   81,    0,   81,
   44,   81,   44,   44,   44,   81,   44,   44,    0,   79,
   44,    0,   44,    0,    0,   44,   47,   44,   44,   44,
   44,   44,   44,    0,    0,   44,    0,    0,   77,    0,
   44,    0,   44,    0,   44,    0,    0,    0,   44,   82,
    0,   82,   82,   82,    0,   82,   82,    0,    0,   82,
    0,   82,    0,   76,   82,    0,   82,   82,   82,   82,
   82,   82,    0,    0,   82,   47,    0,    0,    0,   82,
    0,   82,    0,   82,    0,   79,    0,   82,   45,    0,
   45,   45,   45,    0,   45,   45,   46,    0,   45,    0,
   45,    0,    0,   45,    0,   45,   45,   45,   45,   45,
   45,    0,   76,   45,    0,    0,    0,    0,   45,    0,
   45,    0,   45,    0,    0,    0,   45,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   85,    0,   85,   85,
   85,   47,   85,   85,   84,   46,   85,    0,   85,    0,
    0,   85,    0,   85,   85,   85,   85,   85,   85,    0,
    0,   85,    0,    0,    0,    0,   85,    0,   85,   77,
   85,   77,   77,   77,   85,   77,   77,    0,   76,   77,
    0,   77,    0,    0,   77,    0,   77,   77,   77,   77,
   77,   77,    0,   84,   77,    0,    0,    0,    0,   77,
    0,   77,    0,   77,    0,    0,    0,   77,    0,    0,
    0,   46,    0,    0,    0,    0,   79,    0,   79,   79,
   79,    0,   79,   79,    0,    0,   79,    0,   79,    0,
    0,   79,    0,   79,   79,   79,   79,   79,   79,    0,
    0,   79,    0,    0,    0,    0,   79,    0,   79,    0,
   79,    0,    0,    0,   79,    0,    0,    0,    0,   84,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   47,    0,   47,   47,   47,    0,   47,   47,
    0,    0,   47,    0,   47,    0,    0,   47,    0,   47,
   47,   47,   47,   47,   47,    0,    0,   47,    0,    0,
    0,    0,   47,    0,   47,    0,   47,    0,    0,   76,
   47,   76,   76,   76,    0,   76,   76,    0,    0,   76,
    0,   76,    0,    0,   76,    0,   76,   76,   76,   76,
   76,   76,  111,    0,   76,    0,    0,    0,    0,   76,
    0,   76,   46,   76,   46,   46,   46,   76,   46,   46,
    0,    0,   46,    0,   46,    0,    0,   46,    0,   46,
   46,   46,   46,   46,   46,    0,    0,   46,    0,    0,
    0,    0,   46,    0,   46,    0,   46,    0,    0,    0,
   46,    0,   37,   38,    0,   40,    0,    0,    0,    0,
   84,    0,   84,   84,   84,    0,   84,   84,    0,    0,
   84,    0,   84,   51,   52,   84,    0,   84,   84,   84,
   84,   84,   84,    0,   58,   84,    0,    0,    0,    0,
   84,    0,   84,    0,   84,    0,   59,    0,   84,    0,
    0,    0,    0,    0,    0,    0,    0,   49,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   55,    0,
  101,    0,    0,    0,   57,  109,    0,    0,  112,  113,
    0,  120,  122,  123,  124,    0,  111,  111,  128,  129,
    0,    0,  132,  111,    0,  111,   68,    0,  111,    0,
    0,  111,   73,  111,  111,    0,    0,  139,    0,  140,
  142,    0,    0,    0,    0,  111,    0,  111,    0,  148,
    0,  111,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  152,    0,    0,  154,    0,    0,  134,  135,  136,
    0,    2,  158,    0,  163,    0,  164,    0,    0,    3,
    0,    0,  171,  172,  144,    4,    0,    5,  175,    0,
    0,    0,    6,    0,    0,    0,    0,    7,    8,    0,
    9,    0,    0,    0,    0,    0,   10,    0,  196,  197,
  198,  199,    0,  201,    0,   11,    0,   12,    0,    0,
   13,    0,  170,    0,    0,    0,  173,    0,    0,  207,
    0,   81,  176,   82,   83,   84,    0,   85,   86,    0,
    0,   87,    0,   88,    0,    0,   89,  195,   90,   91,
   92,   93,   94,   95,    0,    0,   96,    0,    0,  204,
    0,   97,    0,   98,  111,   99,  111,  111,  111,  100,
  111,  111,    0,    0,  111,    0,  111,    0,    0,  111,
    0,  111,  111,  111,  111,  111,  111,    0,    0,  111,
    0,    0,    0,    0,  111,    0,  111,    0,  111,    0,
    0,    0,  111,
};
const short yycheck[] =
	{                                      61,
    0,   61,  123,  123,   42,   10,    2,  125,  123,  270,
  123,  123,   10,   94,  270,  305,  123,  282,   14,   15,
   16,   17,   18,  282,   10,   10,  297,   10,  125,  110,
   10,   10,  125,  305,  305,  267,  279,  280,  125,  125,
  305,  305,  306,  306,  305,   10,  305,  279,  306,  305,
  305,  306,  305,  306,   59,   10,  305,  306,  123,   61,
  305,   59,  123,  271,   10,   10,   10,  125,  289,   65,
  299,  280,  125,   59,   59,   71,   59,   10,  265,   59,
   59,  306,   10,  125,  125,  261,  306,  306,  282,  261,
  265,  123,   10,  199,   59,    1,   60,  177,  155,   -1,
   78,   64,   10,   -1,   59,   -1,   10,   -1,   -1,   -1,
  191,  192,   -1,   59,   59,   59,   -1,   -1,   -1,   -1,
  125,   -1,   -1,   -1,   -1,  125,   59,   -1,   -1,   -1,
   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   59,   -1,   -1,  257,   -1,   -1,   -1,   -1,   -1,
   10,   59,  270,   -1,  269,   59,   -1,  269,   -1,  279,
  125,  281,  269,   -1,  257,  262,   -1,   -1,   -1,  284,
  125,  257,  284,  293,  294,  262,  273,  284,   -1,  125,
  125,  125,  295,  296,  305,  305,  273,  305,  285,   10,
  287,  288,  125,   -1,   -1,  292,   -1,  125,  285,   59,
  287,  288,  295,  296,  301,  292,  303,  125,   -1,  295,
  296,   -1,   -1,   -1,  301,   -1,  303,  125,  259,  260,
   -1,  125,   -1,   -1,   -1,  266,   -1,  268,  281,   -1,
  271,   -1,   -1,  274,   -1,   -1,  277,   -1,   59,  281,
  293,  294,   -1,  305,   -1,  305,   -1,  288,   -1,  290,
   -1,  293,  294,  294,   -1,   -1,  256,  257,  258,  259,
  260,   10,  262,  263,  264,  125,  266,  305,  268,   -1,
  270,  271,  272,  273,  274,  275,  276,  277,  278,   -1,
   -1,  281,  282,  283,   -1,  285,  286,  287,  288,   -1,
  290,  291,  292,  293,  294,  295,  296,  262,   -1,   -1,
  300,  301,  302,  303,  125,  305,   -1,  262,  273,   -1,
   59,  257,   10,  257,   -1,   -1,   -1,  262,  273,   -1,
  285,   -1,  287,  288,  257,   -1,   -1,  292,  273,   -1,
  285,   -1,  287,  288,  262,   -1,  301,  292,  303,   -1,
  285,   -1,  287,  288,  262,  273,  301,  292,  303,  295,
  296,  295,  296,  257,  262,  273,  301,  285,  303,  287,
  288,   59,  295,  296,  292,  273,   -1,  285,   -1,  287,
  288,   10,   -1,  301,  292,  303,  125,  285,   -1,  287,
  288,   -1,   -1,  301,  292,  303,   -1,   -1,   -1,   -1,
   -1,  295,  296,  301,   -1,  303,  256,   -1,  258,  259,
  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,   10,
   59,  281,   -1,   -1,   -1,   -1,  286,  125,  288,   -1,
  290,   -1,   -1,  293,  294,  256,   -1,  258,  259,  260,
   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,   -1,   10,
  281,   -1,   -1,   -1,   -1,  286,   -1,  288,   59,  290,
   -1,   -1,  293,  294,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   59,  258,
  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,
   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
   -1,   -1,  281,   -1,  125,   10,   -1,  286,   -1,  288,
   -1,  290,   -1,   -1,  293,  294,   -1,   59,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,
  268,   -1,   -1,  271,  125,  273,  274,  275,  276,  277,
  278,   10,   -1,  281,   59,   -1,   -1,   -1,  286,   -1,
  288,   -1,  290,   -1,   -1,  293,  294,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  125,   10,   -1,   -1,  256,   -1,  258,
  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,
   59,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
   -1,   -1,  281,   -1,   -1,   -1,   -1,  286,   -1,  288,
  125,  290,   -1,   10,   -1,  294,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   59,   -1,  256,   -1,  258,  259,  260,
   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,   -1,   -1,
  281,   -1,   10,   -1,   -1,  286,  125,  288,   -1,  290,
   -1,   -1,   59,  294,   -1,  256,   -1,  258,  259,  260,
   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,   -1,  125,
  281,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  290,
   10,   59,   -1,  294,  256,   -1,  258,  259,  260,   -1,
  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,   -1,  125,  281,
   -1,   -1,   -1,   10,  286,   -1,  288,   -1,  290,   -1,
   -1,  256,  294,  258,  259,  260,   -1,  262,  263,   59,
   -1,  266,   -1,  268,   -1,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,   -1,   -1,  281,  125,   -1,   -1,
   -1,  286,   -1,  288,   -1,  290,   -1,   -1,   -1,  294,
   10,   -1,   59,   -1,   -1,   -1,   -1,  256,   -1,  258,
  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,
   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
   -1,   -1,  281,   -1,   -1,  125,   -1,  286,   -1,  288,
  256,  290,  258,  259,  260,  294,  262,  263,   -1,   59,
  266,   -1,  268,   -1,   -1,  271,   10,  273,  274,  275,
  276,  277,  278,   -1,   -1,  281,   -1,   -1,  125,   -1,
  286,   -1,  288,   -1,  290,   -1,   -1,   -1,  294,  256,
   -1,  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,
   -1,  268,   -1,   10,  271,   -1,  273,  274,  275,  276,
  277,  278,   -1,   -1,  281,   59,   -1,   -1,   -1,  286,
   -1,  288,   -1,  290,   -1,  125,   -1,  294,  256,   -1,
  258,  259,  260,   -1,  262,  263,   10,   -1,  266,   -1,
  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,   -1,   59,  281,   -1,   -1,   -1,   -1,  286,   -1,
  288,   -1,  290,   -1,   -1,   -1,  294,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,  258,  259,
  260,  125,  262,  263,   10,   59,  266,   -1,  268,   -1,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,   -1,
   -1,  281,   -1,   -1,   -1,   -1,  286,   -1,  288,  256,
  290,  258,  259,  260,  294,  262,  263,   -1,  125,  266,
   -1,  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,   -1,   59,  281,   -1,   -1,   -1,   -1,  286,
   -1,  288,   -1,  290,   -1,   -1,   -1,  294,   -1,   -1,
   -1,  125,   -1,   -1,   -1,   -1,  256,   -1,  258,  259,
  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,   -1,
   -1,  281,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,
  290,   -1,   -1,   -1,  294,   -1,   -1,   -1,   -1,  125,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,  258,  259,  260,   -1,  262,  263,
   -1,   -1,  266,   -1,  268,   -1,   -1,  271,   -1,  273,
  274,  275,  276,  277,  278,   -1,   -1,  281,   -1,   -1,
   -1,   -1,  286,   -1,  288,   -1,  290,   -1,   -1,  256,
  294,  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,
   -1,  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,  125,   -1,  281,   -1,   -1,   -1,   -1,  286,
   -1,  288,  256,  290,  258,  259,  260,  294,  262,  263,
   -1,   -1,  266,   -1,  268,   -1,   -1,  271,   -1,  273,
  274,  275,  276,  277,  278,   -1,   -1,  281,   -1,   -1,
   -1,   -1,  286,   -1,  288,   -1,  290,   -1,   -1,   -1,
  294,   -1,    9,   10,   -1,   12,   -1,   -1,   -1,   -1,
  256,   -1,  258,  259,  260,   -1,  262,  263,   -1,   -1,
  266,   -1,  268,   30,   31,  271,   -1,  273,  274,  275,
  276,  277,  278,   -1,   41,  281,   -1,   -1,   -1,   -1,
  286,   -1,  288,   -1,  290,   -1,   53,   -1,  294,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   22,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,
  125,   -1,   -1,   -1,   39,   82,   -1,   -1,   85,   86,
   -1,   88,   89,   90,   91,   -1,  259,  260,   95,   96,
   -1,   -1,   99,  266,   -1,  268,   61,   -1,  271,   -1,
   -1,  274,   67,  125,  277,   -1,   -1,  114,   -1,  116,
  117,   -1,   -1,   -1,   -1,  288,   -1,  290,   -1,  126,
   -1,  294,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  138,   -1,   -1,  141,   -1,   -1,  102,  103,  104,
   -1,  256,  149,   -1,  151,   -1,  153,   -1,   -1,  264,
   -1,   -1,  159,  160,  119,  270,   -1,  272,  165,   -1,
   -1,   -1,  277,   -1,   -1,   -1,   -1,  282,  283,   -1,
  285,   -1,   -1,   -1,   -1,   -1,  291,   -1,  185,  186,
  187,  188,   -1,  190,   -1,  300,   -1,  302,   -1,   -1,
  305,   -1,  157,   -1,   -1,   -1,  161,   -1,   -1,  206,
   -1,  256,  167,  258,  259,  260,   -1,  262,  263,   -1,
   -1,  266,   -1,  268,   -1,   -1,  271,  182,  273,  274,
  275,  276,  277,  278,   -1,   -1,  281,   -1,   -1,  194,
   -1,  286,   -1,  288,  256,  290,  258,  259,  260,  294,
  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,   -1,   -1,  281,
   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  290,   -1,
   -1,   -1,  294,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 306
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,"'*'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"';'",0,"'='",0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"ACCESS","ALIAS","AUTO","BLOCK","CA","CERT","CGI","CHROOT","CLIENT","DEFAULT",
"FACILITY","FASTCGI","FOR_HOST","INCLUDE","INDEX","IPV6","KEY","LANG","LISTEN",
"LOCATION","LOG","OCSP","OFF","ON","PARAM","PORT","PREFORK","PROTO","PROTOCOLS",
"PROXY","RELAY_TO","REQUIRE","RETURN","ROOT","SERVER","SNI","SOCKET","STRIP",
"STYLE","SYSLOG","TCP","TOEXT","TYPE","TYPES","USE_TLS","USER","VERIFYNAME",
"ERROR","STRING","NUM",
};
const char * const yyrule[] =
	{"$accept : conf",
"conf :",
"conf : conf include nl",
"conf : conf varset nl",
"conf : conf option nl",
"conf : conf vhost nl",
"conf : conf types nl",
"conf : conf error nl",
"include : INCLUDE STRING",
"bool : ON",
"bool : OFF",
"string : string STRING",
"string : STRING",
"numberstring : NUM",
"numberstring : STRING",
"varset : STRING '=' string",
"option : CHROOT string",
"option : IPV6 bool",
"option : log",
"option : PORT NUM",
"option : PREFORK NUM",
"option : PROTOCOLS string",
"option : USER string",
"log : LOG '{' optnl logopts '}'",
"log : LOG logopt",
"logopts :",
"logopts : logopts logopt optnl",
"logopt : ACCESS string",
"logopt : STYLE string",
"logopt : SYSLOG FACILITY string",
"logopt : SYSLOG OFF",
"logopt : SYSLOG",
"$$1 :",
"vhost : SERVER string $$1 '{' optnl servbody '}'",
"vhost : error '}'",
"servbody :",
"servbody : servbody servopt optnl",
"servbody : servbody location optnl",
"servbody : servbody proxy optnl",
"listen_addr : '*'",
"listen_addr : STRING",
"servopt : ALIAS string",
"servopt : CERT string",
"servopt : CGI string",
"servopt : KEY string",
"servopt : OCSP string",
"servopt : PARAM string '=' string",
"servopt : LISTEN ON listen_addr",
"servopt : LISTEN ON listen_addr PORT STRING",
"servopt : LISTEN ON listen_addr PORT NUM",
"servopt : locopt",
"$$2 :",
"proxy : PROXY $$2 proxy_matches '{' optnl proxy_opts '}'",
"proxy_matches :",
"proxy_matches : proxy_matches proxy_match",
"proxy_port :",
"proxy_port : PORT STRING",
"proxy_port : PORT NUM",
"proxy_match : PROTO string",
"proxy_match : FOR_HOST string proxy_port",
"proxy_opts :",
"proxy_opts : proxy_opts proxy_opt optnl",
"proxy_opt : CERT string",
"proxy_opt : KEY string",
"proxy_opt : PROTOCOLS string",
"proxy_opt : RELAY_TO string proxy_port",
"proxy_opt : REQUIRE CLIENT CA string",
"proxy_opt : SNI string",
"proxy_opt : USE_TLS bool",
"proxy_opt : VERIFYNAME bool",
"$$3 :",
"location : LOCATION $$3 string '{' optnl locopts '}'",
"location : error '}'",
"locopts :",
"locopts : locopts locopt optnl",
"locopt : AUTO INDEX bool",
"locopt : BLOCK RETURN NUM string",
"locopt : BLOCK RETURN NUM",
"locopt : BLOCK",
"locopt : DEFAULT TYPE string",
"locopt : fastcgi",
"locopt : INDEX string",
"locopt : LANG string",
"locopt : LOG bool",
"locopt : REQUIRE CLIENT CA string",
"locopt : ROOT string",
"locopt : STRIP NUM",
"fastcgi : FASTCGI '{' optnl fastcgiopts '}'",
"fastcgi : FASTCGI fastcgiopt",
"fastcgi : FASTCGI OFF",
"fastcgi : FASTCGI string",
"fastcgiopts :",
"fastcgiopts : fastcgiopts fastcgiopt optnl",
"fastcgiopt : PARAM string '=' string",
"fastcgiopt : SOCKET string",
"fastcgiopt : SOCKET TCP string PORT NUM",
"fastcgiopt : SOCKET TCP string",
"fastcgiopt : SOCKET TCP string PORT string",
"fastcgiopt : STRIP NUM",
"types : TYPES '{' optnl mediaopts_l '}'",
"mediaopts_l : mediaopts_l mediaoptsl nl",
"mediaopts_l : mediaoptsl nl",
"$$4 :",
"mediaoptsl : STRING $$4 medianames_l",
"mediaoptsl : include",
"medianames_l : medianames_l medianamesl",
"medianames_l : medianamesl",
"medianamesl : numberstring",
"nl : '\\n' optnl",
"nl : ';' optnl",
"optnl : nl",
"optnl :",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 647 "parse.y"

static const struct keyword {
	const char *word;
	int token;
} keywords[] = {
	/* these MUST be sorted */
	{"access", ACCESS},
	{"alias", ALIAS},
	{"auto", AUTO},
	{"block", BLOCK},
	{"ca", CA},
	{"cert", CERT},
	{"cgi", CGI},
	{"chroot", CHROOT},
	{"client", CLIENT},
	{"default", DEFAULT},
	{"facility", FACILITY},
	{"fastcgi", FASTCGI},
	{"for-host", FOR_HOST},
	{"include", INCLUDE},
	{"index", INDEX},
	{"ipv6", IPV6},
	{"key", KEY},
	{"lang", LANG},
	{"listen", LISTEN},
	{"location", LOCATION},
	{"log", LOG},
	{"ocsp", OCSP},
	{"off", OFF},
	{"on", ON},
	{"param", PARAM},
	{"port", PORT},
	{"prefork", PREFORK},
	{"proto", PROTO},
	{"protocols", PROTOCOLS},
	{"proxy", PROXY},
	{"relay-to", RELAY_TO},
	{"require", REQUIRE},
	{"return", RETURN},
	{"root", ROOT},
	{"server", SERVER},
	{"sni", SNI},
	{"socket", SOCKET},
	{"strip", STRIP},
	{"style", STYLE},
	{"syslog", SYSLOG},
	{"tcp", TCP},
	{"to-ext", TOEXT},
	{"type", TYPE},
	{"types", TYPES},
	{"use-tls", USE_TLS},
	{"user", USER},
	{"verifyname", VERIFYNAME},
};

void
yyerror(const char *msg, ...)
{
	va_list ap;

	file->errors++;

	va_start(ap, msg);
	fprintf(stderr, "%s:%d error: ", config_path, yylval.lineno);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

void
yywarn(const char *msg, ...)
{
	va_list ap;

	va_start(ap, msg);
	fprintf(stderr, "%s:%d warning: ", config_path, yylval.lineno);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

int
kw_cmp(const void *k, const void *e)
{
	return strcmp(k, ((struct keyword *)e)->word);
}

int
lookup(char *s)
{
	const struct keyword	*p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return p->token;
	else
		return STRING;
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return c;
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return EOF;
			return quotec;
		}
		return c;
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return '\n';
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return EOF;
			c = igetc();
		}
	}
	return c;
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			fatal("lungetc");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* Skip to either EOF or the first real EOL. */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return ERROR;
}

int
yylex(void)
{
	char	 buf[8096];
	char	*p, *val;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(0)) == ' ' || c == '\t')
		; /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#')
		while ((c = lgetc(0)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && !expanding) {
		while (1) {
			if ((c = lgetc(0)) == EOF)
				return 0;
			if (p + 1 >= buf + sizeof(buf) -1) {
				yyerror("string too long");
				return findeol();
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro `%s' not defined", buf);
			return findeol();
		}
		yylval.v.string = xstrdup(val);
		return STRING;
	}
	if (c == '@' && !expanding) {
		while (1) {
			if ((c = lgetc(0)) == EOF)
				return 0;

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return findeol();
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return findeol();
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc(*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			if ((c = lgetc(quotec)) == EOF)
				return 0;
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				if ((next = lgetc(quotec)) == EOF)
					return (0);
				if (next == quotec || next == ' ' ||
				    next == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("invalid syntax");
				return findeol();
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return findeol();
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return STRING;
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return findeol();
			}
		} while ((c = lgetc(0)) != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return findeol();
			}
			return NUM;
		} else {
nodigits:
			while (p > buf + 1)
				lungetc(*--p);
			c = *--p;
			if (c == '-')
				return c;
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && \
	x != '!' && x != '=' && x != '#' && \
	x != ',' && x != ';'))

	if (isalnum(c) || c == ':' || c == '_') {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return findeol();
			}
		} while ((c = lgetc(0)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			yylval.v.string = xstrdup(buf);
		return token;
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return 0;
	return c;
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	nfile = xcalloc(1, sizeof(*nfile));
	nfile->name = xstrdup(name);
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		log_warn("can't open %s", nfile->name);
		free(nfile->name);
		free(nfile);
		return NULL;
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = xcalloc(1, nfile->ungetsize);
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return nfile;
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return file ? 0 : EOF;
}

int
parse_conf(struct conf *c, const char *filename)
{
	struct sym		*sym, *next;

	default_host = NULL;
	default_port = 1965;

	conf = c;

	file = pushfile(filename, 0);
	if (file == NULL)
		return -1;
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		/* TODO: warn if !sym->used */
		if (!sym->persist) {
			free(sym->name);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (errors)
		return -1;
	return 0;
}

int
symset(const char *name, const char *val, int persist)
{
	struct sym *sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (!strcmp(name, sym->name))
			break;
	}

	if (sym != NULL) {
		if (sym->persist)
			return 0;
		else {
			free(sym->name);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	sym = xcalloc(1, sizeof(*sym));
	sym->name = xstrdup(name);
	sym->val = xstrdup(val);
	sym->used = 0;
	sym->persist = persist;

	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return 0;
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	 ret;

	if ((val = strrchr(s, '=')) == NULL)
		return -1;
	sym = xcalloc(1, val - s + 1);
	memcpy(sym, s, val - s);
	ret = symset(sym, val + 1, 1);
	free(sym);
	return ret;
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->name) == 0) {
			sym->used = 1;
			return sym->val;
		}
	}
	return NULL;
}

char *
ensure_absolute_path(char *path)
{
	if (path == NULL || *path != '/')
		yyerror("not an absolute path: %s", path);
	return path;
}

int
check_block_code(int n)
{
	if (n < 10 || n >= 70 || (n >= 20 && n <= 29))
		yyerror("invalid block code %d", n);
	return n;
}

char *
check_block_fmt(char *fmt)
{
	char *s;

	for (s = fmt; *s; ++s) {
		if (*s != '%')
			continue;
		switch (*++s) {
		case '%':
		case 'p':
		case 'q':
		case 'P':
		case 'N':
			break;
		default:
			yyerror("invalid format specifier %%%c", *s);
		}
	}

	return fmt;
}

int
check_strip_no(int n)
{
	if (n <= 0)
		yyerror("invalid strip number %d", n);
	return n;
}

int
check_prefork_num(int n)
{
	if (n <= 0 || n >= PROC_MAX_INSTANCES)
		yyerror("invalid prefork number %d", n);
	return n;
}

void
advance_loc(void)
{
	loc = new_location();
	TAILQ_INSERT_TAIL(&host->locations, loc, locations);
}

void
advance_proxy(void)
{
	proxy = new_proxy();
	TAILQ_INSERT_TAIL(&host->proxies, proxy, proxies);
}

int
fastcgi_conf(const char *path, const char *port)
{
	struct fcgi	*f;
	int		i = 0;

	TAILQ_FOREACH(f, &conf->fcgi, fcgi) {
		if (!strcmp(f->path, path) &&
		    ((port == NULL && *f->port == '\0') ||
		     !strcmp(f->port, port)))
			return i;
		++i;
	}

	f = xcalloc(1, sizeof(*f));
	f->id = i;
	(void)strlcpy(f->path, path, sizeof(f->path));
	if (port != NULL)
		(void)strlcpy(f->port, port, sizeof(f->port));
	TAILQ_INSERT_TAIL(&conf->fcgi, f, fcgi);

	return f->id;
}

void
add_param(char *name, char *val)
{
	struct envlist *e;
	struct envhead *h = &loc->params;

	e = xcalloc(1, sizeof(*e));
	(void) strlcpy(e->name, name, sizeof(e->name));
	(void) strlcpy(e->value, val, sizeof(e->value));
	TAILQ_INSERT_TAIL(h, e, envs);
}

int
getservice(const char *n)
{
	struct servent	*s;
	const char	*errstr;
	long long	 llval;

	llval = strtonum(n, 0, UINT16_MAX, &errstr);
	if (errstr) {
		s = getservbyname(n, "tcp");
		if (s == NULL)
			s = getservbyname(n, "udp");
		if (s == NULL)
			return (-1);
		return (ntohs(s->s_port));
	}

	return ((unsigned short)llval);
}

static void
add_to_addr_queue(struct addrhead *a, struct addrinfo *ai, const char *pp)
{
	struct address		*addr;
	struct sockaddr_in	*sin;
	struct sockaddr_in6	*sin6;

	if (ai->ai_addrlen > sizeof(addr->ss))
		fatalx("ai_addrlen larger than a sockaddr_storage");

	TAILQ_FOREACH(addr, a, addrs) {
		if (addr->ai_flags == ai->ai_flags &&
		    addr->ai_family == ai->ai_family &&
		    addr->ai_socktype == ai->ai_socktype &&
		    addr->ai_protocol == ai->ai_protocol &&
		    addr->slen == ai->ai_addrlen &&
		    !memcmp(&addr->ss, ai->ai_addr, addr->slen))
			return;
	}

	addr = xcalloc(1, sizeof(*addr));
	addr->ai_flags = ai->ai_flags;
	addr->ai_family = ai->ai_family;
	addr->ai_socktype = ai->ai_socktype;
	addr->ai_protocol = ai->ai_protocol;
	addr->slen = ai->ai_addrlen;
	memcpy(&addr->ss, ai->ai_addr, ai->ai_addrlen);
	strlcpy(addr->pp, pp, sizeof(addr->pp));

	/* for commodity */
	switch (addr->ai_family) {
	case AF_INET:
		sin = (struct sockaddr_in *)&addr->ss;
		addr->port = ntohs(sin->sin_port);
		break;
	case AF_INET6:
		sin6 = (struct sockaddr_in6 *)&addr->ss;
		addr->port = ntohs(sin6->sin6_port);
		break;
	default:
		fatalx("unknown socket family %d", addr->ai_family);
	}

	addr->sock = -1;

	TAILQ_INSERT_HEAD(a, addr, addrs);
}

void
listen_on(const char *hostname, const char *servname)
{
	struct addrinfo hints, *res, *res0;
	char pp[NI_MAXHOST];
	int error;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE;
	error = getaddrinfo(hostname, servname, &hints, &res0);
	if (error) {
		yyerror("listen on \"%s\" port %s: %s", hostname, servname,
		    gai_strerror(errno));
		return;
	}

	for (res = res0; res; res = res->ai_next) {
		if (getnameinfo(res->ai_addr, res->ai_addrlen, pp, sizeof(pp),
		    NULL, 0, NI_NUMERICHOST) == -1) {
			yyerror("getnameinfo failed: %s", strerror(errno));
			break;
		}

		add_to_addr_queue(&host->addrs, res, pp);
		add_to_addr_queue(&conf->addrs, res, pp);
	}

	freeaddrinfo(res0);
}
#line 1482 "y.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = (short *)realloc(yyss, newsize * sizeof *newss);
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs);
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 7:
#line 156 "parse.y"
{ file->errors++; }
break;
case 8:
#line 159 "parse.y"
{
			struct file	*nfile;

			if ((nfile = pushfile(yyvsp[0].v.string, 0)) == NULL) {
				yyerror("failed to include file %s", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			file = nfile;
			lungetc('\n');
		}
break;
case 9:
#line 174 "parse.y"
{ yyval.v.number = 1; }
break;
case 10:
#line 175 "parse.y"
{ yyval.v.number = 0; }
break;
case 11:
#line 178 "parse.y"
{
			if (asprintf(&yyval.v.string, "%s%s", yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				yyerror("string: asprintf: %s", strerror(errno));
				YYERROR;
			}
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 13:
#line 191 "parse.y"
{
			char *s;
			if (asprintf(&s, "%d", yyvsp[0].v.number) == -1) {
				yyerror("asprintf: number");
				YYERROR;
			}
			yyval.v.string = s;
		}
break;
case 15:
#line 202 "parse.y"
{
			char *s = yyvsp[-2].v.string;
			while (*s++) {
				if (isspace((unsigned char)*s)) {
					yyerror("macro name cannot contain "
					    "whitespaces");
					free(yyvsp[-2].v.string);
					free(yyvsp[0].v.string);
					YYERROR;
				}
			}
			symset(yyvsp[-2].v.string, yyvsp[0].v.string, 0);
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 16:
#line 219 "parse.y"
{
			if (strlcpy(conf->chroot, yyvsp[0].v.string, sizeof(conf->chroot)) >=
			    sizeof(conf->chroot))
				yyerror("chroot path too long");
			free(yyvsp[0].v.string);
		}
break;
case 17:
#line 225 "parse.y"
{
			yywarn("option `ipv6' is deprecated,"
			    " please use `listen on'");
			if (yyvsp[0].v.number)
				default_host = NULL;
			else
				default_host = "0.0.0.0";
		}
break;
case 19:
#line 234 "parse.y"
{
			yywarn("option `port' is deprecated,"
			    " please use `listen on'");
			default_port = yyvsp[0].v.number;
		}
break;
case 20:
#line 239 "parse.y"
{ conf->prefork = check_prefork_num(yyvsp[0].v.number); }
break;
case 21:
#line 240 "parse.y"
{
			if (tls_config_parse_protocols(&conf->protos, yyvsp[0].v.string) == -1)
				yyerror("invalid protocols string \"%s\"", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 22:
#line 245 "parse.y"
{
			if (strlcpy(conf->user, yyvsp[0].v.string, sizeof(conf->user)) >=
			    sizeof(conf->user))
				yyerror("user name too long");
			free(yyvsp[0].v.string);
		}
break;
case 27:
#line 261 "parse.y"
{
			free(conf->log_access);
			conf->log_access = yyvsp[0].v.string;
		}
break;
case 28:
#line 265 "parse.y"
{
			if (!strcmp("combined", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_COMBINED;
			else if (!strcmp("common", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_COMMON;
			else if (!strcmp("condensed", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_CONDENSED;
			else if (!strcmp("legacy", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_LEGACY;
			else
				yyerror("unknown log style: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 29:
#line 278 "parse.y"
{
			const char *str = yyvsp[0].v.string;

			conf->log_syslog = 1;

			if (!strncasecmp(str, "LOG_", 4))
				str += 4;

			if (!strcasecmp(str, "daemon"))
				conf->log_facility = LOG_DAEMON;
#ifdef LOG_FTP
			else if (!strcasecmp(str, "ftp"))
				conf->log_facility = LOG_FTP;
#endif
			else if (!strcasecmp(str, "local1"))
				conf->log_facility = LOG_LOCAL1;
			else if (!strcasecmp(str, "local2"))
				conf->log_facility = LOG_LOCAL2;
			else if (!strcasecmp(str, "local3"))
				conf->log_facility = LOG_LOCAL3;
			else if (!strcasecmp(str, "local4"))
				conf->log_facility = LOG_LOCAL4;
			else if (!strcasecmp(str, "local5"))
				conf->log_facility = LOG_LOCAL5;
			else if (!strcasecmp(str, "local6"))
				conf->log_facility = LOG_LOCAL6;
			else if (!strcasecmp(str, "local7"))
				conf->log_facility = LOG_LOCAL7;
			else if (!strcasecmp(str, "user"))
				conf->log_facility = LOG_USER;
			else
				yywarn("unknown syslog facility `%s'",
				    yyvsp[0].v.string);

			free(yyvsp[0].v.string);
		}
break;
case 30:
#line 314 "parse.y"
{
			conf->log_syslog = 0;
		}
break;
case 31:
#line 317 "parse.y"
{
			conf->log_syslog = 1;
		}
break;
case 32:
#line 322 "parse.y"
{
			host = new_vhost();
			TAILQ_INSERT_HEAD(&conf->hosts, host, vhosts);

			loc = new_location();
			TAILQ_INSERT_HEAD(&host->locations, loc, locations);

			TAILQ_INIT(&host->proxies);

			(void) strlcpy(loc->match, "*", sizeof(loc->match));
			(void) strlcpy(host->domain, yyvsp[0].v.string, sizeof(host->domain));

			if (strstr(yyvsp[0].v.string, "xn--") != NULL) {
				yywarn("\"%s\" looks like punycode: you "
				    "should use the decoded hostname", yyvsp[0].v.string);
			}

			free(yyvsp[0].v.string);
		}
break;
case 33:
#line 340 "parse.y"
{
			if (host->cert_path == NULL ||
			    host->key_path == NULL)
				yyerror("invalid vhost definition: %s",
				    host->domain);
			if (TAILQ_EMPTY(&host->addrs)) {
				char portno[32];
				int r;

				r = snprintf(portno, sizeof(portno), "%d",
				    default_port);
				if (r < 0 || (size_t)r >= sizeof(portno))
					fatal("snprintf");

				yywarn("missing `listen on' in server %s,"
				    " assuming %s port %d", host->domain,
				    default_host ? default_host : "*",
				    default_port);
				listen_on(default_host, portno);
			}
		}
break;
case 34:
#line 361 "parse.y"
{ yyerror("bad server directive"); }
break;
case 39:
#line 370 "parse.y"
{ yyval.v.string = NULL; }
break;
case 41:
#line 374 "parse.y"
{
			struct alist *a;

			a = xcalloc(1, sizeof(*a));
			(void) strlcpy(a->alias, yyvsp[0].v.string, sizeof(a->alias));
			free(yyvsp[0].v.string);
			TAILQ_INSERT_TAIL(&host->aliases, a, aliases);
		}
break;
case 42:
#line 382 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			free(host->cert_path);
			host->cert_path = yyvsp[0].v.string;
		}
break;
case 43:
#line 387 "parse.y"
{
			free(yyvsp[0].v.string);
			yyerror("`cgi' was removed in gmid 2.0."
			    "  Please use fastcgi or proxy instead.");
		}
break;
case 44:
#line 392 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			free(host->key_path);
			host->key_path = yyvsp[0].v.string;
		}
break;
case 45:
#line 397 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			free(host->ocsp_path);
			host->ocsp_path = yyvsp[0].v.string;
		}
break;
case 46:
#line 402 "parse.y"
{
			yywarn("the top-level `param' directive is deprecated."
			    "  Please use `fastcgi { param ... }`");
			add_param(yyvsp[-2].v.string, yyvsp[0].v.string);
		}
break;
case 47:
#line 407 "parse.y"
{
			listen_on(yyvsp[0].v.string, "1965");
			free(yyvsp[0].v.string);
		}
break;
case 48:
#line 411 "parse.y"
{
			listen_on(yyvsp[-2].v.string, yyvsp[0].v.string);
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 49:
#line 416 "parse.y"
{
			char portno[32];
			int r;

			r = snprintf(portno, sizeof(portno), "%d", yyvsp[0].v.number);
			if (r < 0 || (size_t)r >= sizeof(portno))
				fatal("snprintf");

			listen_on(yyvsp[-2].v.string, portno);
			free(yyvsp[-2].v.string);
		}
break;
case 51:
#line 430 "parse.y"
{ advance_proxy(); }
break;
case 52:
#line 431 "parse.y"
{
			if (*proxy->host == '\0')
				yyerror("invalid proxy block: missing `relay-to' option");

			if ((proxy->cert_path == NULL && proxy->key_path != NULL) ||
			    (proxy->cert_path != NULL && proxy->key_path == NULL))
				yyerror("invalid proxy block: missing cert or key");
		}
break;
case 55:
#line 445 "parse.y"
{ yyval.v.number = 1965; }
break;
case 56:
#line 446 "parse.y"
{
			if ((yyval.v.number = getservice(yyvsp[0].v.string)) == -1)
				yyerror("invalid port number %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 57:
#line 451 "parse.y"
{ yyval.v.number = yyvsp[0].v.number; }
break;
case 58:
#line 454 "parse.y"
{
			(void) strlcpy(proxy->match_proto, yyvsp[0].v.string, sizeof(proxy->match_proto));
			free(yyvsp[0].v.string);
		}
break;
case 59:
#line 458 "parse.y"
{
			(void) strlcpy(proxy->match_host, yyvsp[-1].v.string, sizeof(proxy->match_host));
			(void) snprintf(proxy->match_port, sizeof(proxy->match_port),
			    "%d", yyvsp[0].v.number);
			free(yyvsp[-1].v.string);
		}
break;
case 62:
#line 470 "parse.y"
{
			free(proxy->cert);
			ensure_absolute_path(yyvsp[0].v.string);
			proxy->cert_path = yyvsp[0].v.string;
		}
break;
case 63:
#line 475 "parse.y"
{
			free(proxy->key);
			ensure_absolute_path(yyvsp[0].v.string);
			proxy->key_path = yyvsp[0].v.string;
		}
break;
case 64:
#line 480 "parse.y"
{
			if (tls_config_parse_protocols(&proxy->protocols, yyvsp[0].v.string) == -1)
				yyerror("invalid protocols string \"%s\"", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 65:
#line 485 "parse.y"
{
			(void) strlcpy(proxy->host, yyvsp[-1].v.string, sizeof(proxy->host));
			(void) snprintf(proxy->port, sizeof(proxy->port),
			    "%d", yyvsp[0].v.number);
			free(yyvsp[-1].v.string);
		}
break;
case 66:
#line 491 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			proxy->reqca_path = yyvsp[0].v.string;
		}
break;
case 67:
#line 495 "parse.y"
{
			(void) strlcpy(proxy->sni, yyvsp[0].v.string, sizeof(proxy->sni));
			free(yyvsp[0].v.string);
		}
break;
case 68:
#line 499 "parse.y"
{
			proxy->notls = !yyvsp[0].v.number;
		}
break;
case 69:
#line 502 "parse.y"
{
			proxy->noverifyname = !yyvsp[0].v.number;
		}
break;
case 70:
#line 507 "parse.y"
{ advance_loc(); }
break;
case 71:
#line 507 "parse.y"
{
			/* drop the starting '/' if any */
			if (*yyvsp[-4].v.string == '/')
				memmove(yyvsp[-4].v.string, yyvsp[-4].v.string+1, strlen(yyvsp[-4].v.string));
			(void) strlcpy(loc->match, yyvsp[-4].v.string, sizeof(loc->match));
			free(yyvsp[-4].v.string);
		}
break;
case 75:
#line 521 "parse.y"
{ loc->auto_index = yyvsp[0].v.number ? 1 : -1; }
break;
case 76:
#line 522 "parse.y"
{
			check_block_fmt(yyvsp[0].v.string);
			(void) strlcpy(loc->block_fmt, yyvsp[0].v.string, sizeof(loc->block_fmt));
			loc->block_code = check_block_code(yyvsp[-1].v.number);
			free(yyvsp[0].v.string);
		}
break;
case 77:
#line 528 "parse.y"
{
			(void) strlcpy(loc->block_fmt, "temporary failure",
			    sizeof(loc->block_fmt));
			loc->block_code = check_block_code(yyvsp[0].v.number);
			if (yyvsp[0].v.number >= 30 && yyvsp[0].v.number < 40)
				yyerror("missing `meta' for block return %d", yyvsp[0].v.number);
		}
break;
case 78:
#line 535 "parse.y"
{
			(void) strlcpy(loc->block_fmt, "temporary failure",
			    sizeof(loc->block_fmt));
			loc->block_code = 40;
		}
break;
case 79:
#line 540 "parse.y"
{
			(void) strlcpy(loc->default_mime, yyvsp[0].v.string,
			    sizeof(loc->default_mime));
			free(yyvsp[0].v.string);
		}
break;
case 81:
#line 546 "parse.y"
{
			(void) strlcpy(loc->index, yyvsp[0].v.string, sizeof(loc->index));
			free(yyvsp[0].v.string);
		}
break;
case 82:
#line 550 "parse.y"
{
			(void) strlcpy(loc->lang, yyvsp[0].v.string,
			    sizeof(loc->lang));
			free(yyvsp[0].v.string);
		}
break;
case 83:
#line 555 "parse.y"
{ loc->disable_log = !yyvsp[0].v.number; }
break;
case 84:
#line 556 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			loc->reqca_path = yyvsp[0].v.string;
		}
break;
case 85:
#line 560 "parse.y"
{
			(void) strlcpy(loc->dir, yyvsp[0].v.string, sizeof(loc->dir));
			free(yyvsp[0].v.string);
		}
break;
case 86:
#line 564 "parse.y"
{ loc->strip = check_strip_no(yyvsp[0].v.number); }
break;
case 89:
#line 569 "parse.y"
{
			loc->fcgi = -1;
			loc->nofcgi = 1;
		}
break;
case 90:
#line 573 "parse.y"
{
			yywarn("`fastcgi path' is deprecated.  "
			    "Please use `fastcgi socket path' instead.");
			loc->fcgi = fastcgi_conf(yyvsp[0].v.string, NULL);
			free(yyvsp[0].v.string);
		}
break;
case 93:
#line 585 "parse.y"
{
			add_param(yyvsp[-2].v.string, yyvsp[0].v.string);
		}
break;
case 94:
#line 588 "parse.y"
{
			loc->fcgi = fastcgi_conf(yyvsp[0].v.string, NULL);
			free(yyvsp[0].v.string);
		}
break;
case 95:
#line 592 "parse.y"
{
			char *c;

			if (asprintf(&c, "%d", yyvsp[0].v.number) == -1)
				fatal("asprintf");
			loc->fcgi = fastcgi_conf(yyvsp[-2].v.string, c);
			free(yyvsp[-2].v.string);
			free(c);
		}
break;
case 96:
#line 601 "parse.y"
{
			loc->fcgi = fastcgi_conf(yyvsp[0].v.string, "9000");
		}
break;
case 97:
#line 604 "parse.y"
{
			loc->fcgi = fastcgi_conf(yyvsp[-2].v.string, yyvsp[0].v.string);
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 98:
#line 609 "parse.y"
{
			loc->fcgi_strip = yyvsp[0].v.number;
		}
break;
case 102:
#line 620 "parse.y"
{
			free(current_media);
			current_media = yyvsp[0].v.string;
		}
break;
case 107:
#line 631 "parse.y"
{
			if (add_mime(&conf->mime, current_media, yyvsp[0].v.string) == -1)
				fatal("add_mime");
			free(yyvsp[0].v.string);
		}
break;
#line 2273 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
