/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorageEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSStorage.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<StorageEvent::Init>> convertDictionary<StorageEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    StorageEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue keyValue;
    if (isNullOrUndefined)
        keyValue = jsUndefined();
    else {
        keyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "key"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto keyConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(lexicalGlobalObject, keyValue, [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (UNLIKELY(keyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.key = keyConversionResult.releaseReturnValue();
    JSValue newValueValue;
    if (isNullOrUndefined)
        newValueValue = jsUndefined();
    else {
        newValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "newValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto newValueConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(lexicalGlobalObject, newValueValue, [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (UNLIKELY(newValueConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.newValue = newValueConversionResult.releaseReturnValue();
    JSValue oldValueValue;
    if (isNullOrUndefined)
        oldValueValue = jsUndefined();
    else {
        oldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "oldValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto oldValueConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(lexicalGlobalObject, oldValueValue, [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (UNLIKELY(oldValueConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.oldValue = oldValueConversionResult.releaseReturnValue();
    JSValue storageAreaValue;
    if (isNullOrUndefined)
        storageAreaValue = jsUndefined();
    else {
        storageAreaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storageArea"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto storageAreaConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<Storage>>>(lexicalGlobalObject, storageAreaValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<Storage>>> { return typename Converter<IDLNullable<IDLInterface<Storage>>>::ReturnType { nullptr }; });
    if (UNLIKELY(storageAreaConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.storageArea = storageAreaConversionResult.releaseReturnValue();
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto urlConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, urlValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (UNLIKELY(urlConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.url = urlConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsStorageEventPrototypeFunction_initStorageEvent);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStorageEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_key);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_oldValue);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_newValue);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_url);
static JSC_DECLARE_CUSTOM_GETTER(jsStorageEvent_storageArea);

class JSStorageEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStorageEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStorageEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSStorageEventPrototype>(vm)) JSStorageEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStorageEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageEventPrototype, JSStorageEventPrototype::Base);

using JSStorageEventDOMConstructor = JSDOMConstructor<JSStorageEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSStorageEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSStorageEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<StorageEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = StorageEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<StorageEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<StorageEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSStorageEventDOMConstructorConstruct, JSStorageEventDOMConstructor::construct);

template<> const ClassInfo JSStorageEventDOMConstructor::s_info = { "StorageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEventDOMConstructor) };

template<> JSValue JSStorageEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSStorageEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StorageEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStorageEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSStorageEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEventConstructor, 0 } },
    { "key"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_key, 0 } },
    { "oldValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_oldValue, 0 } },
    { "newValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_newValue, 0 } },
    { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_url, 0 } },
    { "storageArea"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageEvent_storageArea, 0 } },
    { "initStorageEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStorageEventPrototypeFunction_initStorageEvent, 1 } },
};

const ClassInfo JSStorageEventPrototype::s_info = { "StorageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEventPrototype) };

void JSStorageEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStorageEvent::info(), JSStorageEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStorageEvent::s_info = { "StorageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageEvent) };

JSStorageEvent::JSStorageEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StorageEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<StorageEvent> JSStorageEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, StorageEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStorageEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStorageEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSStorageEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSStorageEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStorageEvent>(vm, globalObject);
}

JSValue JSStorageEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageEventDOMConstructor, DOMConstructorID::StorageEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStorageEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStorageEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsStorageEvent_keyGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.key())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_key, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_keyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_oldValueGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.oldValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_oldValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_oldValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_newValueGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.newValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_newValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_newValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_urlGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStorageEvent_storageAreaGetter(JSGlobalObject& lexicalGlobalObject, JSStorageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Storage>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.storageArea())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageEvent_storageArea, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStorageEvent>::get<jsStorageEvent_storageAreaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsStorageEventPrototypeFunction_initStorageEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSStorageEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto bubblesConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto cancelableConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto keyConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (UNLIKELY(keyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto oldValueConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument4.value(), [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (UNLIKELY(oldValueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto newValueConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, argument5.value(), [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (UNLIKELY(newValueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto urlConversionResult = convertOptionalWithDefault<IDLUSVString>(*lexicalGlobalObject, argument6.value(), [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (UNLIKELY(urlConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto storageAreaConversionResult = convert<IDLNullable<IDLInterface<Storage>>>(*lexicalGlobalObject, argument7.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 7, "storageArea"_s, "StorageEvent"_s, "initStorageEvent"_s, "Storage"_s); });
    if (UNLIKELY(storageAreaConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.initStorageEvent(typeConversionResult.releaseReturnValue(), bubblesConversionResult.releaseReturnValue(), cancelableConversionResult.releaseReturnValue(), keyConversionResult.releaseReturnValue(), oldValueConversionResult.releaseReturnValue(), newValueConversionResult.releaseReturnValue(), urlConversionResult.releaseReturnValue(), storageAreaConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStorageEventPrototypeFunction_initStorageEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSStorageEvent>::call<jsStorageEventPrototypeFunction_initStorageEventBody>(*lexicalGlobalObject, *callFrame, "initStorageEvent");
}

JSC::GCClient::IsoSubspace* JSStorageEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStorageEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStorageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStorageEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStorageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStorageEvent = std::forward<decltype(space)>(space); }
    );
}

void JSStorageEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStorageEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7StorageEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12StorageEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, StorageEvent>, void>> static inline void verifyVTable(StorageEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7StorageEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12StorageEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // StorageEvent has subclasses. If StorageEvent has subclasses that get passed
        // to toJS() we currently require StorageEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StorageEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<StorageEvent>(impl.ptr());
#endif
    return createWrapper<StorageEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StorageEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
