/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyboardEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<KeyboardEvent::Init>> convertDictionary<KeyboardEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    KeyboardEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detailConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, detailValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (UNLIKELY(detailConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.detail = detailConversionResult.releaseReturnValue();
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<WindowProxy>>> { return typename Converter<IDLNullable<IDLInterface<WindowProxy>>>::ReturnType { nullptr }; });
    if (UNLIKELY(viewConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto altKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, altKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(altKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.altKey = altKeyConversionResult.releaseReturnValue();
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ctrlKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(ctrlKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.ctrlKey = ctrlKeyConversionResult.releaseReturnValue();
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto metaKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, metaKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(metaKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.metaKey = metaKeyConversionResult.releaseReturnValue();
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierAltGraphConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(modifierAltGraphConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.modifierAltGraph = modifierAltGraphConversionResult.releaseReturnValue();
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierCapsLockConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(modifierCapsLockConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.modifierCapsLock = modifierCapsLockConversionResult.releaseReturnValue();
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto shiftKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, shiftKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(shiftKeyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.shiftKey = shiftKeyConversionResult.releaseReturnValue();
    JSValue charCodeValue;
    if (isNullOrUndefined)
        charCodeValue = jsUndefined();
    else {
        charCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "charCode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto charCodeConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, charCodeValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (UNLIKELY(charCodeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.charCode = charCodeConversionResult.releaseReturnValue();
    JSValue codeValue;
    if (isNullOrUndefined)
        codeValue = jsUndefined();
    else {
        codeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "code"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto codeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, codeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(codeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.code = codeConversionResult.releaseReturnValue();
    JSValue isComposingValue;
    if (isNullOrUndefined)
        isComposingValue = jsUndefined();
    else {
        isComposingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isComposing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto isComposingConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, isComposingValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(isComposingConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.isComposing = isComposingConversionResult.releaseReturnValue();
    JSValue keyValue;
    if (isNullOrUndefined)
        keyValue = jsUndefined();
    else {
        keyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "key"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto keyConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, keyValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(keyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.key = keyConversionResult.releaseReturnValue();
    JSValue keyCodeValue;
    if (isNullOrUndefined)
        keyCodeValue = jsUndefined();
    else {
        keyCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyCode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto keyCodeConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, keyCodeValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (UNLIKELY(keyCodeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.keyCode = keyCodeConversionResult.releaseReturnValue();
    JSValue keyIdentifierValue;
    if (isNullOrUndefined)
        keyIdentifierValue = jsUndefined();
    else {
        keyIdentifierValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyIdentifier"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto keyIdentifierConversionResult = convertOptionalWithDefault<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, keyIdentifierValue, [&]() -> ConversionResult<IDLAtomStringAdaptor<IDLDOMString>> { return Converter<IDLAtomStringAdaptor<IDLDOMString>>::ReturnType { emptyAtom() }; });
    if (UNLIKELY(keyIdentifierConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.keyIdentifier = keyIdentifierConversionResult.releaseReturnValue();
    JSValue locationValue;
    if (isNullOrUndefined)
        locationValue = jsUndefined();
    else {
        locationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "location"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto locationConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, locationValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (UNLIKELY(locationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.location = locationConversionResult.releaseReturnValue();
    JSValue repeatValue;
    if (isNullOrUndefined)
        repeatValue = jsUndefined();
    else {
        repeatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "repeat"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto repeatConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, repeatValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(repeatConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.repeat = repeatConversionResult.releaseReturnValue();
    JSValue whichValue;
    if (isNullOrUndefined)
        whichValue = jsUndefined();
    else {
        whichValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "which"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto whichConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, whichValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (UNLIKELY(whichConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.which = whichConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsKeyboardEventPrototypeFunction_getModifierState);
static JSC_DECLARE_HOST_FUNCTION(jsKeyboardEventPrototypeFunction_initKeyboardEvent);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_key);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_code);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_location);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_ctrlKey);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_shiftKey);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_altKey);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_metaKey);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_repeat);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_isComposing);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_keyIdentifier);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_charCode);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyboardEvent_keyCode);

class JSKeyboardEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSKeyboardEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyboardEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyboardEventPrototype>(vm)) JSKeyboardEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyboardEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKeyboardEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyboardEventPrototype, JSKeyboardEventPrototype::Base);

using JSKeyboardEventDOMConstructor = JSDOMConstructor<JSKeyboardEvent>;

/* Hash table for constructor */

static const HashTableValue JSKeyboardEventConstructorTableValues[] =
{
    { "DOM_KEY_LOCATION_STANDARD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00 } },
    { "DOM_KEY_LOCATION_LEFT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "DOM_KEY_LOCATION_RIGHT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
    { "DOM_KEY_LOCATION_NUMPAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x03 } },
};

static_assert(KeyboardEvent::DOM_KEY_LOCATION_STANDARD == 0x00, "DOM_KEY_LOCATION_STANDARD in KeyboardEvent does not match value from IDL");
static_assert(KeyboardEvent::DOM_KEY_LOCATION_LEFT == 0x01, "DOM_KEY_LOCATION_LEFT in KeyboardEvent does not match value from IDL");
static_assert(KeyboardEvent::DOM_KEY_LOCATION_RIGHT == 0x02, "DOM_KEY_LOCATION_RIGHT in KeyboardEvent does not match value from IDL");
static_assert(KeyboardEvent::DOM_KEY_LOCATION_NUMPAD == 0x03, "DOM_KEY_LOCATION_NUMPAD in KeyboardEvent does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSKeyboardEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSKeyboardEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<KeyboardEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = KeyboardEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<KeyboardEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<KeyboardEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSKeyboardEventDOMConstructorConstruct, JSKeyboardEventDOMConstructor::construct);

template<> const ClassInfo JSKeyboardEventDOMConstructor::s_info = { "KeyboardEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyboardEventDOMConstructor) };

template<> JSValue JSKeyboardEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSKeyboardEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "KeyboardEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSKeyboardEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSKeyboardEvent::info(), JSKeyboardEventConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSKeyboardEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEventConstructor, 0 } },
    { "key"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_key, 0 } },
    { "code"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_code, 0 } },
    { "location"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_location, 0 } },
    { "ctrlKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_ctrlKey, 0 } },
    { "shiftKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_shiftKey, 0 } },
    { "altKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_altKey, 0 } },
    { "metaKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_metaKey, 0 } },
    { "repeat"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_repeat, 0 } },
    { "isComposing"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_isComposing, 0 } },
    { "keyIdentifier"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_keyIdentifier, 0 } },
    { "charCode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_charCode, 0 } },
    { "keyCode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyboardEvent_keyCode, 0 } },
    { "getModifierState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsKeyboardEventPrototypeFunction_getModifierState, 1 } },
    { "initKeyboardEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsKeyboardEventPrototypeFunction_initKeyboardEvent, 1 } },
    { "DOM_KEY_LOCATION_STANDARD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00 } },
    { "DOM_KEY_LOCATION_LEFT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "DOM_KEY_LOCATION_RIGHT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
    { "DOM_KEY_LOCATION_NUMPAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x03 } },
};

const ClassInfo JSKeyboardEventPrototype::s_info = { "KeyboardEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyboardEventPrototype) };

void JSKeyboardEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKeyboardEvent::info(), JSKeyboardEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSKeyboardEvent::s_info = { "KeyboardEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyboardEvent) };

JSKeyboardEvent::JSKeyboardEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KeyboardEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<KeyboardEvent> JSKeyboardEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, KeyboardEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSKeyboardEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSKeyboardEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSKeyboardEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSKeyboardEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSKeyboardEvent>(vm, globalObject);
}

JSValue JSKeyboardEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyboardEventDOMConstructor, DOMConstructorID::KeyboardEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyboardEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSKeyboardEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsKeyboardEvent_keyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.key())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_key, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_keyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_codeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.code())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_code, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_codeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_locationGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.location())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_location, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_locationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_ctrlKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ctrlKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_ctrlKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_ctrlKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_shiftKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shiftKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_shiftKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_shiftKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_altKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.altKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_altKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_altKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_metaKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.metaKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_metaKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_metaKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_repeatGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.repeat())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_repeat, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_repeatGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_isComposingGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isComposing())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_isComposing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_isComposingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_keyIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.keyIdentifier())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_keyIdentifier, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_keyIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_charCodeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.charCode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_charCode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_charCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsKeyboardEvent_keyCodeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.keyCode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyboardEvent_keyCode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEvent_keyCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsKeyboardEventPrototypeFunction_getModifierStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyboardEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyArgConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(keyArgConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.getModifierState(keyArgConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsKeyboardEventPrototypeFunction_getModifierState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSKeyboardEvent>::call<jsKeyboardEventPrototypeFunction_getModifierStateBody>(*lexicalGlobalObject, *callFrame, "getModifierState");
}

static inline JSC::EncodedJSValue jsKeyboardEventPrototypeFunction_initKeyboardEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyboardEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto canBubbleConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(canBubbleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto cancelableConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto viewConversionResult = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, argument3.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "view"_s, "KeyboardEvent"_s, "initKeyboardEvent"_s, "WindowProxy"_s); });
    if (UNLIKELY(viewConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto keyIdentifierConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(keyIdentifierConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto locationConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(locationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto ctrlKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument6.value());
    if (UNLIKELY(ctrlKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto altKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument7.value());
    if (UNLIKELY(altKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument8 = callFrame->argument(8);
    auto shiftKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument8.value());
    if (UNLIKELY(shiftKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument9 = callFrame->argument(9);
    auto metaKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument9.value());
    if (UNLIKELY(metaKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.initKeyboardEvent(typeConversionResult.releaseReturnValue(), canBubbleConversionResult.releaseReturnValue(), cancelableConversionResult.releaseReturnValue(), viewConversionResult.releaseReturnValue(), keyIdentifierConversionResult.releaseReturnValue(), locationConversionResult.releaseReturnValue(), ctrlKeyConversionResult.releaseReturnValue(), altKeyConversionResult.releaseReturnValue(), shiftKeyConversionResult.releaseReturnValue(), metaKeyConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsKeyboardEventPrototypeFunction_initKeyboardEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSKeyboardEvent>::call<jsKeyboardEventPrototypeFunction_initKeyboardEventBody>(*lexicalGlobalObject, *callFrame, "initKeyboardEvent");
}

JSC::GCClient::IsoSubspace* JSKeyboardEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSKeyboardEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForKeyboardEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForKeyboardEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForKeyboardEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForKeyboardEvent = std::forward<decltype(space)>(space); }
    );
}

void JSKeyboardEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSKeyboardEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7KeyboardEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13KeyboardEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, KeyboardEvent>, void>> static inline void verifyVTable(KeyboardEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7KeyboardEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13KeyboardEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // KeyboardEvent has subclasses. If KeyboardEvent has subclasses that get passed
        // to toJS() we currently require KeyboardEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<KeyboardEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<KeyboardEvent>(impl.ptr());
#endif
    return createWrapper<KeyboardEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KeyboardEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
