/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.msghistory;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.msghistory.MessageHistoryActivator;
import net.java.sip.communicator.impl.msghistory.MessageHistoryServiceImpl;
import net.java.sip.communicator.impl.msghistory.MessageSourceContact;
import net.java.sip.communicator.impl.msghistory.MessageSourceContactQuery;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.event.MetaContactListAdapter;
import net.java.sip.communicator.service.contactlist.event.MetaContactRenamedEvent;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.QueryResultSet;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.service.msghistory.MessageSourceContactPresenceStatus;
import net.java.sip.communicator.service.muc.ChatRoomPresenceStatus;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesEvent;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesListener;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;

public class MessageSourceService
extends MetaContactListAdapter
implements ContactSourceService,
ContactPresenceStatusListener,
ContactCapabilitiesListener,
ProviderPresenceStatusListener,
SubscriptionListener,
LocalUserChatRoomPresenceListener,
MessageListener,
ChatRoomMessageListener,
AdHocChatRoomMessageListener {
    private static Logger logger = Logger.getLogger(MessageSourceService.class);
    private final String MESSAGE_HISTORY_NAME;
    private int sourceServiceType = 3;
    private static final String IN_HISTORY_PROPERTY = "net.java.sip.communicator.impl.msghistory.contactsrc.IN_HISTORY";
    private static final String NUMBER_OF_RECENT_MSGS_PROP = "net.java.sip.communicator.impl.msghistory.contactsrc.MSG_NUMBER";
    private static final String VER_OF_RECENT_MSGS_PROP = "net.java.sip.communicator.impl.msghistory.contactsrc.MSG_VER";
    private static final String IS_MESSAGE_SUBTYPE_SMS_PROP = "net.java.sip.communicator.impl.msghistory.contactsrc.IS_SMS_ENABLED";
    private static final int NUMBER_OF_MSGS_IN_HISTORY = 100;
    private int numberOfMessages = 10;
    private static final String[] STRUCTURE_NAMES = new String[]{"provider", "contact", "timestamp", "ver"};
    private static String RECENT_MSGS_VER = "2";
    private static final HistoryRecordStructure recordStructure = new HistoryRecordStructure(STRUCTURE_NAMES);
    private static final HistoryID historyID = HistoryID.createFromRawID((String[])new String[]{"recent_messages"});
    private History history = null;
    private final List<ComparableEvtObj> recentMessages = new LinkedList<ComparableEvtObj>();
    private Date oldestRecentMessage = null;
    private MessageSourceContactQuery recentQuery = null;
    private boolean isSMSEnabled = false;
    private MessageHistoryServiceImpl messageHistoryService;

    MessageSourceService(MessageHistoryServiceImpl messageHistoryService) {
        this.messageHistoryService = messageHistoryService;
        ConfigurationService conf = MessageHistoryActivator.getConfigurationService();
        if (conf.getBoolean(IN_HISTORY_PROPERTY, false)) {
            this.sourceServiceType = 2;
        }
        this.MESSAGE_HISTORY_NAME = MessageHistoryActivator.getResources().getI18NString("service.gui.RECENT_MESSAGES");
        this.numberOfMessages = conf.getInt(NUMBER_OF_RECENT_MSGS_PROP, this.numberOfMessages);
        this.isSMSEnabled = conf.getBoolean(IS_MESSAGE_SUBTYPE_SMS_PROP, this.isSMSEnabled);
        RECENT_MSGS_VER = conf.getString(VER_OF_RECENT_MSGS_PROP, RECENT_MSGS_VER);
        MessageSourceContactPresenceStatus.MSG_SRC_CONTACT_ONLINE.setStatusIcon(MessageHistoryActivator.getResources().getImageInBytes("service.gui.icons.SMS_STATUS_ICON"));
    }

    public String getDisplayName() {
        return this.MESSAGE_HISTORY_NAME;
    }

    public int getType() {
        return this.sourceServiceType;
    }

    public int getIndex() {
        return 0;
    }

    public ContactQuery createContactQuery(String queryString) {
        this.recentQuery = (MessageSourceContactQuery)this.createContactQuery(queryString, this.numberOfMessages);
        return this.recentQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecentMessages() {
        if (this.recentQuery == null) {
            return;
        }
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            List currentContactsInQuery = this.recentQuery.getQueryResults();
            for (ComparableEvtObj evtObj : this.recentMessages) {
                if (currentContactsInQuery.contains(evtObj)) continue;
                MessageSourceContact newSourceContact = new MessageSourceContact(evtObj.getEventObject(), this);
                newSourceContact.initDetails(evtObj.getEventObject());
                this.recentQuery.addQueryResult(newSourceContact);
            }
        }
    }

    private List<ComparableEvtObj> getCachedRecentMessages(ProtocolProviderService provider, boolean isStatusChanged) {
        String providerID = provider.getAccountID().getAccountUniqueID();
        List<String> recentMessagesContactIDs = this.getRecentContactIDs(providerID, this.recentMessages.size() < this.numberOfMessages ? null : this.oldestRecentMessage);
        ArrayList<ComparableEvtObj> cachedRecentMessages = new ArrayList<ComparableEvtObj>();
        for (String contactID : recentMessagesContactIDs) {
            Collection<EventObject> res = this.messageHistoryService.findRecentMessagesPerContact(this.numberOfMessages, providerID, contactID, this.isSMSEnabled);
            this.processEventObjects(res, cachedRecentMessages, isStatusChanged);
        }
        return cachedRecentMessages;
    }

    private void processEventObjects(Collection<EventObject> res, List<ComparableEvtObj> cachedRecentMessages, boolean isStatusChanged) {
        for (EventObject obj : res) {
            ComparableEvtObj oldMsg = MessageSourceService.findRecentMessage(obj, this.recentMessages);
            if (oldMsg != null) {
                oldMsg.update(obj);
                if (isStatusChanged && this.recentQuery != null) {
                    this.recentQuery.updateCapabilities((Object)oldMsg, obj);
                }
                if (cachedRecentMessages.contains(oldMsg)) continue;
                cachedRecentMessages.add(oldMsg);
                continue;
            }
            oldMsg = MessageSourceService.findRecentMessage(obj, cachedRecentMessages);
            if (oldMsg != null) continue;
            oldMsg = new ComparableEvtObj(obj);
            if (isStatusChanged && this.recentQuery != null) {
                this.recentQuery.updateCapabilities((Object)oldMsg, obj);
            }
            cachedRecentMessages.add(oldMsg);
        }
    }

    boolean isSMSEnabled() {
        return this.isSMSEnabled;
    }

    /*
     * WARNING - void declaration
     */
    private void addNewRecentMessages(List<ComparableEvtObj> contactsToAdd) {
        ArrayList<ComparableEvtObj> duplicates = new ArrayList<ComparableEvtObj>();
        for (ComparableEvtObj comparableEvtObj : contactsToAdd) {
            if (!this.recentMessages.contains(comparableEvtObj)) continue;
            duplicates.add(comparableEvtObj);
            this.updateRecentMessageToHistory(comparableEvtObj);
        }
        this.recentMessages.removeAll(duplicates);
        boolean changed = this.recentMessages.addAll(contactsToAdd);
        if (changed) {
            Collections.sort(this.recentMessages);
            if (this.recentQuery != null) {
                for (ComparableEvtObj obj : duplicates) {
                    this.recentQuery.updateContact(obj, obj.getEventObject());
                }
            }
        }
        if (!this.recentMessages.isEmpty()) {
            this.oldestRecentMessage = this.recentMessages.get(this.recentMessages.size() - 1).getTimestamp();
        }
        Object var4_8 = null;
        if (this.recentMessages.size() > this.numberOfMessages) {
            ArrayList<ComparableEvtObj> arrayList = new ArrayList<ComparableEvtObj>(this.recentMessages.subList(this.numberOfMessages, this.recentMessages.size()));
            this.recentMessages.removeAll(arrayList);
        }
        if (this.recentQuery != null) {
            void var4_10;
            if (var4_10 != null) {
                for (ComparableEvtObj msc : var4_10) {
                    if (contactsToAdd.contains(msc)) continue;
                    this.recentQuery.fireContactRemoved(msc);
                }
            }
            for (ComparableEvtObj msc : contactsToAdd) {
                if (var4_10 != null && var4_10.contains(msc) || duplicates.contains(msc)) continue;
                MessageSourceContact newSourceContact = new MessageSourceContact(msc.getEventObject(), this);
                newSourceContact.initDetails(msc.getEventObject());
                this.recentQuery.addQueryResult(newSourceContact);
            }
            if (changed) {
                this.recentQuery.fireContactChanged(this.recentMessages.get(this.recentMessages.size() - 1));
            }
        }
    }

    void handleProviderAdded(final ProtocolProviderService provider, final boolean isStatusChanged) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MessageSourceService.this.handleProviderAddedInSeparateThread(provider, isStatusChanged);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProviderAddedInSeparateThread(ProtocolProviderService provider, boolean isStatusChanged) {
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            List<ComparableEvtObj> cachedRecentMessages = this.getCachedRecentMessages(provider, isStatusChanged);
            if (cachedRecentMessages.isEmpty()) {
                Collection<EventObject> res = this.messageHistoryService.findRecentMessagesPerContact(this.numberOfMessages, provider.getAccountID().getAccountUniqueID(), null, this.isSMSEnabled);
                ArrayList<ComparableEvtObj> newMsc = new ArrayList<ComparableEvtObj>();
                this.processEventObjects(res, newMsc, isStatusChanged);
                this.addNewRecentMessages(newMsc);
                for (ComparableEvtObj msc : newMsc) {
                    this.saveRecentMessageToHistory(msc);
                }
            } else {
                this.addNewRecentMessages(cachedRecentMessages);
            }
        }
    }

    private static ComparableEvtObj findRecentMessage(EventObject obj, List<ComparableEvtObj> list) {
        Contact contact = null;
        ChatRoom chatRoom = null;
        if (obj instanceof MessageDeliveredEvent) {
            contact = ((MessageDeliveredEvent)obj).getDestinationContact();
        } else if (obj instanceof MessageReceivedEvent) {
            contact = ((MessageReceivedEvent)obj).getSourceContact();
        } else if (obj instanceof ChatRoomMessageDeliveredEvent) {
            chatRoom = ((ChatRoomMessageDeliveredEvent)obj).getSourceChatRoom();
        } else if (obj instanceof ChatRoomMessageReceivedEvent) {
            chatRoom = ((ChatRoomMessageReceivedEvent)obj).getSourceChatRoom();
        }
        for (ComparableEvtObj evt : list) {
            if ((contact == null || !contact.equals(evt.getContact())) && (chatRoom == null || !chatRoom.equals(evt.getRoom()))) continue;
            return evt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleProviderRemoved(ProtocolProviderService provider) {
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            if (provider != null) {
                ArrayList<ComparableEvtObj> removedItems = new ArrayList<ComparableEvtObj>();
                for (ComparableEvtObj msc : this.recentMessages) {
                    if (!msc.getProtocolProviderService().equals(provider)) continue;
                    removedItems.add(msc);
                }
                this.recentMessages.removeAll(removedItems);
                this.oldestRecentMessage = !this.recentMessages.isEmpty() ? this.recentMessages.get(this.recentMessages.size() - 1).getTimestamp() : null;
                if (this.recentQuery != null) {
                    for (ComparableEvtObj msc : removedItems) {
                        this.recentQuery.fireContactRemoved(msc);
                    }
                }
            }
            if (!this.messageHistoryService.isHistoryLoggingEnabled()) {
                return;
            }
            ArrayList<ComparableEvtObj> contactsToAdd = new ArrayList<ComparableEvtObj>();
            for (ProtocolProviderService pps : this.messageHistoryService.getCurrentlyAvailableProviders()) {
                contactsToAdd.addAll(this.getCachedRecentMessages(pps, true));
            }
            this.addNewRecentMessages(contactsToAdd);
        }
    }

    List<String> getRecentContactIDs(String provider, Date after) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            History history = this.getHistory();
            if (history != null) {
                QueryResultSet recs = history.getReader().findLast(100);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                while (recs.hasNext()) {
                    HistoryRecord hr = (HistoryRecord)recs.next();
                    String contact = null;
                    String recordProvider = null;
                    Date timestamp = null;
                    for (int i = 0; i < hr.getPropertyNames().length; ++i) {
                        String propName = hr.getPropertyNames()[i];
                        if (propName.equals(STRUCTURE_NAMES[0])) {
                            recordProvider = hr.getPropertyValues()[i];
                            continue;
                        }
                        if (propName.equals(STRUCTURE_NAMES[1])) {
                            contact = hr.getPropertyValues()[i];
                            continue;
                        }
                        if (!propName.equals(STRUCTURE_NAMES[2])) continue;
                        try {
                            timestamp = sdf.parse(hr.getPropertyValues()[i]);
                            continue;
                        }
                        catch (ParseException e) {
                            timestamp = new Date(Long.parseLong(hr.getPropertyValues()[i]));
                        }
                    }
                    if (recordProvider == null || contact == null || after != null && timestamp != null && timestamp.before(after) || !recordProvider.equals(provider)) continue;
                    res.add(contact);
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)"cannot create recent_messages history", (Throwable)ex);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private History getHistory() throws IOException {
        HistoryID historyID = MessageSourceService.historyID;
        synchronized (historyID) {
            HistoryService historyService = MessageHistoryActivator.getMessageHistoryService().getHistoryService();
            if (this.history == null) {
                this.history = historyService.createHistory(MessageSourceService.historyID, recordStructure);
                HistoryReader reader = this.history.getReader();
                boolean delete = false;
                QueryResultSet res = reader.findLast(1);
                if (res != null && res.hasNext()) {
                    HistoryRecord hr = (HistoryRecord)res.next();
                    if (hr.getPropertyValues().length >= 4) {
                        if (!hr.getPropertyValues()[3].equals(RECENT_MSGS_VER)) {
                            delete = true;
                        }
                    } else {
                        delete = true;
                    }
                }
                if (delete) {
                    try {
                        historyService.purgeLocallyStoredHistory(MessageSourceService.historyID);
                        this.history = historyService.createHistory(MessageSourceService.historyID, recordStructure);
                    }
                    catch (IOException ex) {
                        logger.error((Object)"Cannot delete recent_messages history", (Throwable)ex);
                    }
                }
            }
            return this.history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex(MessageSourceContact messageSourceContact) {
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            for (int i = 0; i < this.recentMessages.size(); ++i) {
                if (!this.recentMessages.get(i).equals(messageSourceContact)) continue;
                return i;
            }
            return -1;
        }
    }

    public ContactQuery createContactQuery(String queryString, int contactCount) {
        if (!StringUtils.isNullOrEmpty((String)queryString)) {
            return null;
        }
        this.recentQuery = new MessageSourceContactQuery(this);
        return this.recentQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        if (this.recentQuery == null) {
            return;
        }
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            for (ComparableEvtObj msg : this.recentMessages) {
                if (msg.getContact() == null || !msg.getContact().equals(evt.getSourceContact())) continue;
                this.recentQuery.updateContactStatus(msg, evt.getNewStatus());
            }
        }
    }

    public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
        if (!evt.getNewStatus().isOnline() || evt.getOldStatus().isOnline()) {
            return;
        }
        this.handleProviderAdded(evt.getProvider(), true);
    }

    public void providerStatusMessageChanged(PropertyChangeEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localUserPresenceChanged(LocalUserChatRoomPresenceChangeEvent evt) {
        if (this.recentQuery == null) {
            return;
        }
        ComparableEvtObj srcContact = null;
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            for (ComparableEvtObj msg : this.recentMessages) {
                if (msg.getRoom() == null || !msg.getRoom().equals(evt.getChatRoom())) continue;
                srcContact = msg;
                break;
            }
        }
        if (srcContact == null) {
            return;
        }
        String eventType = evt.getEventType();
        if ("LocalUserJoined".equals(eventType)) {
            this.recentQuery.updateContactStatus(srcContact, (PresenceStatus)ChatRoomPresenceStatus.CHAT_ROOM_ONLINE);
        } else if ("LocalUserLeft".equals(eventType) || "LocalUserKicked".equals(eventType) || "LocalUserDropped".equals(eventType)) {
            this.recentQuery.updateContactStatus(srcContact, (PresenceStatus)ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(EventObject obj, ProtocolProviderService provider, String id) {
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            ComparableEvtObj existingMsc = null;
            for (ComparableEvtObj msc : this.recentMessages) {
                if (!msc.getProtocolProviderService().equals(provider) || !msc.getContactAddress().equals(id)) continue;
                msc.update(obj);
                this.updateRecentMessageToHistory(msc);
                existingMsc = msc;
            }
            if (existingMsc != null) {
                Collections.sort(this.recentMessages);
                this.oldestRecentMessage = this.recentMessages.get(this.recentMessages.size() - 1).getTimestamp();
                if (this.recentQuery != null) {
                    this.recentQuery.updateContact(existingMsc, existingMsc.getEventObject());
                    this.recentQuery.fireContactChanged(existingMsc);
                }
                return;
            }
            MessageSourceContact newSourceContact = new MessageSourceContact(obj, this);
            newSourceContact.initDetails(obj);
            ComparableEvtObj newMsg = new ComparableEvtObj(obj);
            this.recentMessages.add(newMsg);
            Collections.sort(this.recentMessages);
            this.oldestRecentMessage = this.recentMessages.get(this.recentMessages.size() - 1).getTimestamp();
            ArrayList<ComparableEvtObj> removedItems = null;
            if (this.recentMessages.size() > this.numberOfMessages) {
                removedItems = new ArrayList<ComparableEvtObj>(this.recentMessages.subList(this.numberOfMessages, this.recentMessages.size()));
                this.recentMessages.removeAll(removedItems);
            }
            this.saveRecentMessageToHistory(newMsg);
            if (this.recentQuery == null) {
                return;
            }
            if (removedItems != null) {
                for (ComparableEvtObj msc : removedItems) {
                    this.recentQuery.fireContactRemoved(msc);
                }
            }
            this.recentQuery.addQueryResult(newSourceContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRecentMessageToHistory(ComparableEvtObj msc) {
        HistoryID historyID = MessageSourceService.historyID;
        synchronized (historyID) {
            try {
                History history = this.getHistory();
                HistoryWriter writer = history.getWriter();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                writer.addRecord(new String[]{msc.getProtocolProviderService().getAccountID().getAccountUniqueID(), msc.getContactAddress(), sdf.format(msc.getTimestamp()), RECENT_MSGS_VER}, 100);
            }
            catch (IOException ex) {
                logger.error((Object)"cannot create recent_messages history", (Throwable)ex);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecentMessageToHistory(final ComparableEvtObj msg) {
        HistoryID historyID = MessageSourceService.historyID;
        synchronized (historyID) {
            try {
                History history = this.getHistory();
                HistoryWriter writer = history.getWriter();
                writer.updateRecord(new HistoryWriter.HistoryRecordUpdater(){
                    HistoryRecord hr;

                    public void setHistoryRecord(HistoryRecord historyRecord) {
                        this.hr = historyRecord;
                    }

                    public boolean isMatching() {
                        boolean providerFound = false;
                        boolean contactFound = false;
                        for (int i = 0; i < this.hr.getPropertyNames().length; ++i) {
                            String propName = this.hr.getPropertyNames()[i];
                            if (propName.equals(STRUCTURE_NAMES[0])) {
                                if (!msg.getProtocolProviderService().getAccountID().getAccountUniqueID().equals(this.hr.getPropertyValues()[i])) continue;
                                providerFound = true;
                                continue;
                            }
                            if (!propName.equals(STRUCTURE_NAMES[1]) || !msg.getContactAddress().equals(this.hr.getPropertyValues()[i])) continue;
                            contactFound = true;
                        }
                        return contactFound && providerFound;
                    }

                    public Map<String, String> getUpdateChanges() {
                        HashMap<String, String> map = new HashMap<String, String>();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                        for (int i = 0; i < this.hr.getPropertyNames().length; ++i) {
                            String propName = this.hr.getPropertyNames()[i];
                            if (propName.equals(STRUCTURE_NAMES[0])) {
                                map.put(propName, msg.getProtocolProviderService().getAccountID().getAccountUniqueID());
                                continue;
                            }
                            if (propName.equals(STRUCTURE_NAMES[1])) {
                                map.put(propName, msg.getContactAddress());
                                continue;
                            }
                            if (propName.equals(STRUCTURE_NAMES[2])) {
                                map.put(propName, sdf.format(msg.getTimestamp()));
                                continue;
                            }
                            if (!propName.equals(STRUCTURE_NAMES[3])) continue;
                            map.put(propName, RECENT_MSGS_VER);
                        }
                        return map;
                    }
                });
            }
            catch (IOException ex) {
                logger.error((Object)"cannot create recent_messages history", (Throwable)ex);
                return;
            }
        }
    }

    public void messageReceived(MessageReceivedEvent evt) {
        if (this.isSMSEnabled && evt.getEventType() != 3) {
            return;
        }
        this.handle((EventObject)evt, evt.getSourceContact().getProtocolProvider(), evt.getSourceContact().getAddress());
    }

    public void messageDelivered(MessageDeliveredEvent evt) {
        if (this.isSMSEnabled && !evt.isSmsMessage()) {
            return;
        }
        this.handle((EventObject)evt, evt.getDestinationContact().getProtocolProvider(), evt.getDestinationContact().getAddress());
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(ChatRoomMessageReceivedEvent evt) {
        if (this.isSMSEnabled) {
            return;
        }
        if (evt.getEventType() != 1) {
            return;
        }
        this.handle((EventObject)evt, evt.getSourceChatRoom().getParentProvider(), evt.getSourceChatRoom().getIdentifier());
    }

    public void messageDelivered(ChatRoomMessageDeliveredEvent evt) {
        if (this.isSMSEnabled) {
            return;
        }
        this.handle((EventObject)evt, evt.getSourceChatRoom().getParentProvider(), evt.getSourceChatRoom().getIdentifier());
    }

    public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(AdHocChatRoomMessageReceivedEvent evt) {
    }

    public void messageDelivered(AdHocChatRoomMessageDeliveredEvent evt) {
    }

    public void messageDeliveryFailed(AdHocChatRoomMessageDeliveryFailedEvent evt) {
    }

    public void subscriptionCreated(SubscriptionEvent evt) {
    }

    public void subscriptionFailed(SubscriptionEvent evt) {
    }

    public void subscriptionRemoved(SubscriptionEvent evt) {
    }

    public void subscriptionMoved(SubscriptionMovedEvent evt) {
    }

    public void subscriptionResolved(SubscriptionEvent evt) {
    }

    public void contactModified(ContactPropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("DisplayName")) {
            return;
        }
        Contact contact = evt.getSourceContact();
        if (contact == null) {
            return;
        }
        for (ComparableEvtObj msc : this.recentMessages) {
            if (!contact.equals(msc.getContact())) continue;
            if (this.recentQuery != null) {
                this.recentQuery.updateContactDisplayName(msc, contact.getDisplayName());
            }
            return;
        }
    }

    public void metaContactRenamed(MetaContactRenamedEvent evt) {
        for (ComparableEvtObj msc : this.recentMessages) {
            if (!evt.getSourceMetaContact().containsContact(msc.getContact()) || this.recentQuery == null) continue;
            this.recentQuery.updateContactDisplayName(msc, evt.getNewDisplayName());
        }
    }

    public void supportedOperationSetsChanged(ContactCapabilitiesEvent event) {
        Contact contact = event.getSourceContact();
        if (contact == null) {
            return;
        }
        for (ComparableEvtObj msc : this.recentMessages) {
            if (!contact.equals(msc.getContact())) continue;
            if (this.recentQuery != null) {
                this.recentQuery.updateCapabilities((Object)msc, contact);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLocallyStoredHistory() throws IOException {
        ArrayList<ComparableEvtObj> toRemove = null;
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            toRemove = new ArrayList<ComparableEvtObj>(this.recentMessages);
            this.recentMessages.clear();
        }
        if (this.recentQuery != null) {
            for (ComparableEvtObj msc : toRemove) {
                this.recentQuery.fireContactRemoved(msc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLocallyStoredHistory(MetaContact contact) throws IOException {
        ArrayList<ComparableEvtObj> toRemove = null;
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            toRemove = new ArrayList<ComparableEvtObj>();
            Iterator iter = contact.getContacts();
            while (iter.hasNext()) {
                Contact item = (Contact)iter.next();
                String id = item.getAddress();
                ProtocolProviderService provider = item.getProtocolProvider();
                for (ComparableEvtObj msc : this.recentMessages) {
                    if (!msc.getProtocolProviderService().equals(provider) || !msc.getContactAddress().equals(id)) continue;
                    toRemove.add(msc);
                }
            }
            this.recentMessages.removeAll(toRemove);
        }
        if (this.recentQuery != null) {
            for (ComparableEvtObj msc : toRemove) {
                this.recentQuery.fireContactRemoved(msc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLocallyStoredHistory(ChatRoom room) {
        ComparableEvtObj toRemove = null;
        List<ComparableEvtObj> list = this.recentMessages;
        synchronized (list) {
            for (ComparableEvtObj msg : this.recentMessages) {
                if (msg.getRoom() == null || !msg.getRoom().equals(room)) continue;
                toRemove = msg;
                break;
            }
            if (toRemove == null) {
                return;
            }
            this.recentMessages.remove(toRemove);
        }
        if (this.recentQuery != null) {
            this.recentQuery.fireContactRemoved(toRemove);
        }
    }

    private class ComparableEvtObj
    implements Comparable<ComparableEvtObj> {
        private EventObject eventObject;
        private ProtocolProviderService ppService = null;
        private String address = null;
        private Date timestamp = null;
        private Contact contact = null;
        private ChatRoom room = null;

        ComparableEvtObj(EventObject source) {
            this.update(source);
        }

        public void update(EventObject source) {
            this.eventObject = source;
            if (source instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent e = (MessageDeliveredEvent)source;
                this.contact = e.getDestinationContact();
                this.address = this.contact.getAddress();
                this.ppService = this.contact.getProtocolProvider();
                this.timestamp = e.getTimestamp();
            } else if (source instanceof MessageReceivedEvent) {
                MessageReceivedEvent e = (MessageReceivedEvent)source;
                this.contact = e.getSourceContact();
                this.address = this.contact.getAddress();
                this.ppService = this.contact.getProtocolProvider();
                this.timestamp = e.getTimestamp();
            } else if (source instanceof ChatRoomMessageDeliveredEvent) {
                ChatRoomMessageDeliveredEvent e = (ChatRoomMessageDeliveredEvent)source;
                this.room = e.getSourceChatRoom();
                this.address = this.room.getIdentifier();
                this.ppService = this.room.getParentProvider();
                this.timestamp = e.getTimestamp();
            } else if (source instanceof ChatRoomMessageReceivedEvent) {
                ChatRoomMessageReceivedEvent e = (ChatRoomMessageReceivedEvent)source;
                this.room = e.getSourceChatRoom();
                this.address = this.room.getIdentifier();
                this.ppService = this.room.getParentProvider();
                this.timestamp = e.getTimestamp();
            }
        }

        public String toString() {
            return "ComparableEvtObj{address='" + this.address + '\'' + ", ppService=" + this.ppService + '}';
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public Contact getContact() {
            return this.contact;
        }

        public ChatRoom getRoom() {
            return this.room;
        }

        public ProtocolProviderService getProtocolProviderService() {
            return this.ppService;
        }

        public String getContactAddress() {
            if (this.address != null) {
                return this.address;
            }
            return null;
        }

        public EventObject getEventObject() {
            return this.eventObject;
        }

        @Override
        public int compareTo(ComparableEvtObj o) {
            if (o == null || o.getTimestamp() == null) {
                return 1;
            }
            return o.getTimestamp().compareTo(this.getTimestamp());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof MessageSourceContact) && this.getClass() != o.getClass()) {
                return false;
            }
            if (o instanceof ComparableEvtObj) {
                ComparableEvtObj that = (ComparableEvtObj)o;
                if (!this.address.equals(that.address)) {
                    return false;
                }
                if (!this.ppService.equals(that.ppService)) {
                    return false;
                }
            } else if (o instanceof MessageSourceContact) {
                MessageSourceContact that = (MessageSourceContact)o;
                if (!this.address.equals(that.getContactAddress())) {
                    return false;
                }
                if (!this.ppService.equals(that.getProtocolProviderService())) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = 31 * result + this.ppService.hashCode();
            return result;
        }
    }
}

