/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindow;
import net.java.sip.communicator.impl.gui.main.menus.ToolsMenu;
import net.java.sip.communicator.util.ConfigurationUtils;

public class ChatToolsMenu
extends ToolsMenu
implements ActionListener {
    private ChatWindow chatWindow = null;
    private JCheckBoxMenuItem viewToolBar = new JCheckBoxMenuItem(GuiActivator.getResources().getI18NString("service.gui.VIEW_TOOLBAR"));
    private static final String ACTCMD_VIEW_TOOLBAR = "ACTCMD_VIEW_TOOLBAR";
    private JCheckBoxMenuItem viewSmileys = new JCheckBoxMenuItem(GuiActivator.getResources().getI18NString("service.gui.VIEW_SMILEYS"));
    private static final String ACTCMD_VIEW_SMILEYS = "ACTCMD_VIEW_SMILEYS";
    private JCheckBoxMenuItem chatSimpleTheme = new JCheckBoxMenuItem(GuiActivator.getResources().getI18NString("service.gui.VIEW_SIMPLE_CHAT_THEME"));
    private static final String ACTCMD_VIEW_SIMPLE_THEME = "ACTCMD_VIEW_SIMPLE_THEME";

    public ChatToolsMenu(ChatWindow chatWindow) {
        super(true);
        this.chatWindow = chatWindow;
        this.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.TOOLS"));
        this.addSeparator();
        this.viewToolBar.setActionCommand(ACTCMD_VIEW_TOOLBAR);
        this.viewToolBar.addActionListener(this);
        this.add(this.viewToolBar);
        this.viewSmileys.setActionCommand(ACTCMD_VIEW_SMILEYS);
        this.viewSmileys.addActionListener(this);
        this.add(this.viewSmileys);
        this.chatSimpleTheme.setActionCommand(ACTCMD_VIEW_SIMPLE_THEME);
        this.chatSimpleTheme.addActionListener(this);
        this.add(this.chatSimpleTheme);
        this.initValues();
    }

    private void initValues() {
        this.viewToolBar.setSelected(ConfigurationUtils.isChatToolbarVisible());
        this.viewSmileys.setSelected(ConfigurationUtils.isShowSmileys());
        this.chatSimpleTheme.setSelected(ConfigurationUtils.isChatSimpleThemeEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String action = e.getActionCommand();
        if (action.equals(ACTCMD_VIEW_TOOLBAR)) {
            this.chatWindow.setToolbarVisible(this.viewToolBar.isSelected());
            ConfigurationUtils.setChatToolbarVisible((boolean)this.viewToolBar.isSelected());
        } else if (action.equals(ACTCMD_VIEW_SMILEYS)) {
            ConfigurationUtils.setShowSmileys((boolean)this.viewSmileys.isSelected());
        } else if (action.equals(ACTCMD_VIEW_SIMPLE_THEME)) {
            ConfigurationUtils.setChatSimpleThemeEnabled((boolean)this.chatSimpleTheme.isSelected());
            List<ChatPanel> currentChats = this.chatWindow.getChats();
            if (currentChats != null) {
                Iterator<ChatPanel> chatsIter = currentChats.iterator();
                while (chatsIter.hasNext()) {
                    chatsIter.next().loadSkin();
                }
            }
        }
    }
}

