/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database database) {
        this.database = database;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new LongKeyHashMap(10000);
        this.txModel = 2;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n;
            int n2 = session.rowActionList.size();
            for (n = 0; n < n2; ++n) {
                object = (RowAction)session.rowActionList.get(n);
                if (((RowAction)object).canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            for (n = 0; n < n2; ++n) {
                object = (RowAction)session.rowActionList.get(n);
                ((RowAction)object).prepareCommit(session);
            }
            for (n = 0; n < session.tempSet.size(); ++n) {
                object = ((RowActionBase)session.tempSet.get((int)n)).session;
                ((Session)object).abortTransaction = true;
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n;
            int n2 = session.rowActionList.size();
            for (n = 0; n < n2; ++n) {
                object = (RowAction)session.rowActionList.get(n);
                if (object.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (n = 0; n < n2; ++n) {
                object = (RowAction)session.rowActionList.get(n);
                object.commit(session);
            }
            for (n = 0; n < session.tempSet.size(); ++n) {
                object = ((RowActionBase)session.tempSet.get((int)n)).session;
                object.abortTransaction = true;
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            n = session.rowActionList.size();
            if (n > n2) {
                object = session.rowActionList.getArray();
                this.mergeTransaction((Object[])object, n2, n, session.actionTimestamp);
                this.finaliseRows(session, (Object[])object, n2, n);
                session.rowActionList.setSize(n2);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                object = session.rowActionList.getArray();
                this.mergeTransaction((Object[])object, 0, n2, session.actionTimestamp);
                this.finaliseRows(session, (Object[])object, 0, n2);
            } else if (session.rowActionList.size() > 0) {
                object = session.rowActionList.toArray();
                this.addToCommittedQueue(session, (Object[])object);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int n, long l) {
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i);
            if (rowAction == null) {
                throw Error.runtimeError(458, "TXManager - null rollback action ");
            }
            rowAction.rollback(session, l);
        }
        this.writeLock.lock();
        try {
            Object[] objectArray = session.rowActionList.getArray();
            this.mergeRolledBackTransaction(session, l, objectArray, n, n2);
        }
        finally {
            this.writeLock.unlock();
        }
        session.rowActionList.setSize(n);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = this.addDeleteActionToRow(session, table, persistentStore, row, nArray);
        Session session2 = null;
        boolean bl = true;
        if (rowAction == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.tempSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.tempSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl2 = bl = !session.tempSet.isEmpty();
                if (bl) {
                    session2 = ((RowActionBase)session.tempSet.get((int)0)).session;
                    session.tempSet.clear();
                    if (session2 != null) {
                        bl = this.checkDeadlock(session, session2);
                    }
                }
                if (bl) {
                    session.redoAction = true;
                    if (session2 != null) {
                        session2.waitingSessions.add(session);
                        session.waitedSessions.add(session2);
                        session.latch.countUp();
                    }
                    ++this.redoCount;
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        Session session2 = null;
        boolean bl = false;
        boolean bl2 = true;
        HsqlException hsqlException = null;
        if (rowAction == null) {
            throw Error.runtimeError(458, "TXManager - null insert action ");
        }
        try {
            persistentStore.indexRow(session, row);
        }
        catch (HsqlException hsqlException2) {
            if (session.tempSet.isEmpty()) {
                throw hsqlException2;
            }
            bl = true;
            hsqlException = hsqlException2;
        }
        if (!bl) {
            session.rowActionList.add(rowAction);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase rowActionBase = (RowActionBase)session.tempSet.get(0);
            session2 = rowActionBase.session;
            session.tempSet.clear();
            if (rowActionBase.commitTimestamp != 0L) {
                bl2 = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    bl = false;
                    break;
                }
                default: {
                    bl = this.checkDeadlock(session, session2);
                }
            }
            if (bl) {
                session.redoAction = true;
                if (bl2) {
                    session2.waitingSessions.add(session);
                    session.waitedSessions.add(session2);
                    session.latch.countUp();
                }
                ++this.redoCount;
            } else {
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(hsqlException, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        if (rowAction.table.tableType == 3) {
            return true;
        }
        if (n == 0) {
            return rowAction.canRead(session, 0);
        }
        if (n == 2) {
            return rowAction.canRead(session, 0);
        }
        return rowAction.canRead(session, n);
    }

    @Override
    public boolean canRead(Session session, PersistentStore persistentStore, long l, int n) {
        if (persistentStore.getTable().tableType == 3) {
            return true;
        }
        RowAction rowAction = (RowAction)this.rowActionMap.get(l);
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n);
    }

    @Override
    public void addTransactionInfo(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        if (row.getTable().tableType == 5) {
            RowAction rowAction = (RowAction)this.rowActionMap.get(cachedObject.getPos());
            if (rowAction != null) {
                HsqlException hsqlException = Error.error(4871, "TXManager - row exists");
                this.database.logger.logSevereEvent("TXManager MVROWS", hsqlException);
                throw hsqlException;
            }
            this.rowActionMap.put(cachedObject.getPos(), row.rowAction);
        }
    }

    @Override
    public void setTransactionInfo(PersistentStore persistentStore, CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        if (row.getTable().tableType == 5) {
            RowAction rowAction;
            row.rowAction = rowAction = (RowAction)this.rowActionMap.get(row.getPos());
        }
    }

    @Override
    public void removeTransactionInfo(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        if (row.getTable().tableType == 5) {
            this.rowActionMap.remove(row.getPos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionInfo(long l) {
        this.rowActionMap.getWriteLock().lock();
        try {
            RowAction rowAction;
            RowAction rowAction2 = rowAction = (RowAction)this.rowActionMap.get(l);
            synchronized (rowAction2) {
                if (rowAction.type == 0) {
                    this.rowActionMap.remove(l);
                }
            }
        }
        finally {
            this.rowActionMap.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] objectArray;
            long l2;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionTimestamps.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        if (session.isTransaction) {
            return;
        }
        if (statement == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = statement = session.statementManager.getStatement(session, statement);
                if (statement == null) {
                    return;
                }
            }
            session.isPreTransaction = true;
            if (!this.isLockedMode && !statement.isCatalogLock()) {
                return;
            }
            this.beginActionTPL(session, statement);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
            session.isPreTransaction = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowAction addDeleteActionToRow(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = null;
        Row row2 = row;
        synchronized (row2) {
            switch (table.tableType) {
                case 5: {
                    this.rowActionMap.getWriteLock().lock();
                    try {
                        rowAction = (RowAction)this.rowActionMap.get(row.getPos());
                        if (rowAction == null) {
                            rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                            if (rowAction == null) break;
                            this.addTransactionInfo(row);
                            break;
                        }
                        row.rowAction = rowAction;
                        rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                        break;
                    }
                    finally {
                        this.rowActionMap.getWriteLock().unlock();
                    }
                }
                case 3: {
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                    persistentStore.delete(session, row);
                    row.rowAction = null;
                    break;
                }
                default: {
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                }
            }
        }
        return rowAction;
    }

    void endTransaction(Session session) {
        long l = session.transactionTimestamp;
        int n = this.liveTransactionTimestamps.indexOf(l);
        if (n >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            session2.waitedSessions.remove(session);
            session2.latch.countDown();
        }
        session.waitingSessions.clear();
    }

    void getTransactionSessions(HashSet hashSet) {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            long l = sessionArray[i].getTransactionTimestamp();
            if (this.liveTransactionTimestamps.contains(l)) {
                hashSet.add(sessionArray[i]);
                continue;
            }
            if (sessionArray[i].isPreTransaction) {
                hashSet.add(sessionArray[i]);
                continue;
            }
            if (!sessionArray[i].isTransaction) continue;
            hashSet.add(sessionArray[i]);
        }
    }

    @Override
    void endTransactionTPL(Session session) {
        Session session2;
        int n;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session session3 = null;
        session.waitingSessions.size();
        for (n = 0; n < session.waitingSessions.size(); ++n) {
            session2 = (Session)session.waitingSessions.get(n);
            Statement statement = session2.sessionContext.currentStatement;
            if (statement == null || !statement.isCatalogLock()) continue;
            session3 = session2;
            break;
        }
        if (session3 == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (n = 0; n < session.waitingSessions.size(); ++n) {
                session2 = (Session)session.waitingSessions.get(n);
                if (session2 == session3) continue;
                session2.waitedSessions.add(session3);
                session3.waitingSessions.add(session2);
                session2.latch.countUp();
            }
            this.catalogWriteSession = session3;
        }
        this.unlockTxTs = session.actionTimestamp;
        this.unlockSessionId = session.getId();
    }

    boolean beginActionTPL(Session session, Statement statement) {
        if (statement == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        if (session == this.catalogWriteSession) {
            return true;
        }
        session.tempSet.clear();
        if (statement.isCatalogLock() && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionTimestamp;
            this.lockSessionId = session.getId();
            this.getTransactionSessions(session.tempSet);
            session.tempSet.remove(session);
            if (!session.tempSet.isEmpty()) {
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        if (statement.getTableNamesForWrite().length > 0) {
            if (statement.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                return true;
            }
        } else if (statement.getTableNamesForRead().length > 0) {
            if (statement.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                return true;
            }
        } else {
            return true;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession)) {
            return true;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.countUp();
        }
        return true;
    }
}

