/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.keybindings;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public enum Persistence {
    SERIAL_HASH,
    SERIAL_INPUT,
    PROPERTIES_PAIRS,
    PROPERTIES_XML;

    private static final String PROPERTIES_COMMENT = "Keybindings (mapping of KeyStrokes to string representations of actions)";

    public static Persistence fromString(String str) {
        for (Persistence type : Persistence.values()) {
            if (!str.equals(type.toString())) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    public LinkedHashMap<KeyStroke, String> load(String path) throws IOException, ParseException {
        return this.load(new FileInputStream(path));
    }

    public LinkedHashMap<KeyStroke, String> load(InputStream input) throws IOException, ParseException {
        LinkedHashMap<KeyStroke, String> output = new LinkedHashMap<KeyStroke, String>();
        if (this == SERIAL_HASH || this == SERIAL_INPUT) {
            Serializable mapping;
            Object instance = null;
            try {
                ObjectInputStream objectInput = new ObjectInputStream(input);
                instance = objectInput.readObject();
                objectInput.close();
            }
            catch (ClassNotFoundException exc) {
                throw new ParseException("Unable to load serialized content", 0);
            }
            if (this == SERIAL_HASH) {
                if (!(instance instanceof HashMap)) {
                    throw new ParseException("Serialized resource doesn't represent a HashMap", 0);
                }
                mapping = (HashMap)instance;
                for (Object key : ((HashMap)mapping).keySet()) {
                    Object value = ((HashMap)mapping).get(key);
                    if (key instanceof KeyStroke && value instanceof String) {
                        output.put((KeyStroke)key, (String)value);
                        continue;
                    }
                    if (key == null || value == null) {
                        throw new ParseException("Unable to load null content", 0);
                    }
                    StringBuilder message = new StringBuilder();
                    message.append("Entry doesn't represent a keybinding: ");
                    message.append(key.getClass().getName());
                    message.append(" -> ");
                    message.append(value.getClass().getName());
                    message.append("\nMust match KeyStroke -> String mapping");
                    throw new ParseException(message.toString(), 0);
                }
            } else {
                if (!(instance instanceof InputMap)) {
                    throw new ParseException("Serialized resource doesn't represent an InputMap", 0);
                }
                mapping = (InputMap)instance;
                if (((InputMap)mapping).keys() != null) {
                    for (KeyStroke shortcut : ((InputMap)mapping).keys()) {
                        if (shortcut == null || ((InputMap)mapping).get(shortcut) == null) {
                            throw new ParseException("Unable to load null content", 0);
                        }
                        output.put(shortcut, ((InputMap)mapping).get(shortcut).toString());
                    }
                }
            }
        } else if (this == PROPERTIES_PAIRS || this == PROPERTIES_XML) {
            Properties properties = new Properties();
            if (this == PROPERTIES_PAIRS) {
                properties.load(input);
            } else if (this == PROPERTIES_XML) {
                properties.loadFromXML(input);
            }
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                if (key instanceof String && value instanceof String) {
                    KeyStroke keystroke = KeyStroke.getKeyStroke((String)key);
                    if (keystroke == null) {
                        StringBuilder message = new StringBuilder();
                        message.append("Unable to parse keystroke, see the getKeyStroke(String) method of ");
                        message.append(KeyStroke.class.getName());
                        message.append(" for proper format");
                        throw new ParseException(message.toString(), 0);
                    }
                    output.put(keystroke, (String)value);
                    continue;
                }
                if (key == null || value == null) {
                    throw new ParseException("Unable to load null content", 0);
                }
                StringBuilder message = new StringBuilder();
                message.append("Entry doesn't represent a keybinding: ");
                message.append(key.getClass().getName());
                message.append(" -> ");
                message.append(value.getClass().getName());
                message.append("\nMust match String -> String mapping where the first string represents a keystroke");
                throw new ParseException(message.toString(), 0);
            }
        }
        input.close();
        return output;
    }

    public void save(OutputStream output, Map<KeyStroke, String> bindings) throws IOException {
        for (KeyStroke key : bindings.keySet()) {
            if (key != null && bindings.get(key) != null) continue;
            throw new UnsupportedOperationException("Invalid binding: Shortcuts and actions cannot be null");
        }
        if (this == SERIAL_HASH || this == SERIAL_INPUT) {
            Object mapping;
            if (this == SERIAL_HASH) {
                mapping = bindings;
            } else {
                InputMap inputMap = new InputMap();
                for (KeyStroke shortcut : bindings.keySet()) {
                    inputMap.put(shortcut, bindings.get(shortcut));
                }
                mapping = inputMap;
            }
            ObjectOutputStream objectOutput = new ObjectOutputStream(output);
            objectOutput.writeObject(mapping);
            objectOutput.flush();
            objectOutput.close();
        } else if (this == PROPERTIES_PAIRS || this == PROPERTIES_XML) {
            Properties properties = new Properties();
            for (KeyStroke shortcut : bindings.keySet()) {
                properties.setProperty(shortcut.toString(), bindings.get(shortcut));
            }
            if (this == PROPERTIES_PAIRS) {
                properties.store(output, PROPERTIES_COMMENT);
            } else {
                properties.storeToXML(output, PROPERTIES_COMMENT);
            }
        }
    }

    public void save(String path, Map<KeyStroke, String> bindings) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        try {
            this.save(output, bindings);
            output.flush();
            output.close();
        }
        catch (IOException exc) {
            output.flush();
            output.close();
            throw exc;
        }
        catch (UnsupportedOperationException exc) {
            output.flush();
            output.close();
            throw exc;
        }
    }

    public String getOutput(Map<KeyStroke, String> bindings) {
        PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream();
        Scanner scanner = new Scanner(pipeIn);
        try {
            pipeOut.connect(pipeIn);
            this.save(pipeOut, bindings);
            pipeOut.flush();
            pipeOut.close();
            StringBuilder builder = new StringBuilder();
            if (scanner.hasNextLine()) {
                builder.append(scanner.nextLine());
            }
            while (scanner.hasNextLine()) {
                builder.append("\n");
                builder.append(scanner.nextLine());
            }
            scanner.close();
            pipeIn.close();
            return builder.toString();
        }
        catch (IOException exc) {
            return null;
        }
        catch (UnsupportedOperationException exc) {
            return null;
        }
    }

    public String toString() {
        if (this == SERIAL_HASH) {
            return "Serialized Hash Map";
        }
        if (this == SERIAL_INPUT) {
            return "Serialized Input Map";
        }
        if (this == PROPERTIES_XML) {
            return "Properties XML";
        }
        return Persistence.getReadableConstant(this.name());
    }

    public static String getReadableConstant(String input) {
        char[] name = input.toCharArray();
        boolean isStartOfWord = true;
        for (int i = 0; i < name.length; ++i) {
            char chr = name[i];
            name[i] = chr == '_' ? 32 : (isStartOfWord ? Character.toUpperCase(chr) : Character.toLowerCase(chr));
            isStartOfWord = chr == '_';
        }
        return new String(name);
    }
}

