/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.control;

import java.awt.Component;
import javax.media.Format;
import javax.media.Player;
import javax.media.Time;
import javax.media.Track;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.Reparentable;

public class FramePositioningAdapter
implements FramePositioningControl,
Reparentable {
    Object owner;
    Player player;
    Track master = null;
    long frameStep = -1L;

    public static Track getMasterTrack(Track[] tracks) {
        Track master = null;
        float rate = -1.0f;
        for (int i = 0; i < tracks.length; ++i) {
            Format f;
            if (tracks[i] == null || (f = tracks[i].getFormat()) == null || !(f instanceof VideoFormat)) continue;
            master = tracks[i];
            rate = ((VideoFormat)f).getFrameRate();
            if (rate == -1.0f || rate == 0.0f) continue;
            return master;
        }
        if (master != null && master.mapTimeToFrame(new Time(0L)) != Integer.MAX_VALUE) {
            return master;
        }
        return null;
    }

    public FramePositioningAdapter(Player p, Track track) {
        float rate;
        this.player = p;
        this.master = track;
        Format f = track.getFormat();
        if (f instanceof VideoFormat && (rate = ((VideoFormat)f).getFrameRate()) != -1.0f && rate != 0.0f) {
            this.frameStep = (long)(1.0E9f / rate);
        }
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    @Override
    public Time mapFrameToTime(int frameNumber) {
        return this.master.mapFrameToTime(frameNumber);
    }

    @Override
    public int mapTimeToFrame(Time mediaTime) {
        return this.master.mapTimeToFrame(mediaTime);
    }

    @Override
    public int seek(int frameNumber) {
        Time seekTo = this.master.mapFrameToTime(frameNumber);
        if (seekTo != null && seekTo != FramePositioningControl.TIME_UNKNOWN) {
            this.player.setMediaTime(seekTo);
            return this.master.mapTimeToFrame(seekTo);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }

    @Override
    public int skip(int framesToSkip) {
        if (this.frameStep != -1L) {
            long t = this.player.getMediaNanoseconds() + (long)framesToSkip * this.frameStep;
            this.player.setMediaTime(new Time(t));
            return framesToSkip;
        }
        int currentFrame = this.master.mapTimeToFrame(this.player.getMediaTime());
        if (currentFrame != 0 && currentFrame != Integer.MAX_VALUE) {
            int newFrame = this.seek(currentFrame + framesToSkip);
            return newFrame - currentFrame;
        }
        return Integer.MAX_VALUE;
    }
}

