/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.TimestampUtils;
import org.jitsi.util.Logger;

class InterArrival {
    private static final int kBurstDeltaThresholdMs = 5;
    private static final Logger logger = Logger.getLogger(InterArrival.class);
    private boolean burstGrouping;
    private TimestampGroup currentTimestampGroup = new TimestampGroup();
    private final long kTimestampGroupLengthTicks;
    private TimestampGroup prevTimestampGroup = new TimestampGroup();
    private double timestampToMsCoeff;

    private static boolean isNewerTimestamp(long timestamp, long prevTimestamp) {
        return TimestampUtils.isNewerTimestamp(timestamp, prevTimestamp);
    }

    private static long latestTimestamp(long timestamp1, long timestamp2) {
        return TimestampUtils.latestTimestamp(timestamp1, timestamp2);
    }

    public InterArrival(long timestampGroupLengthTicks, double timestampToMsCoeff, boolean enableBurstGrouping) {
        this.kTimestampGroupLengthTicks = timestampGroupLengthTicks;
        this.timestampToMsCoeff = timestampToMsCoeff;
        this.burstGrouping = enableBurstGrouping;
    }

    private boolean belongsToBurst(long arrivalTimeMs, long timestamp) {
        if (!this.burstGrouping) {
            return false;
        }
        if (this.currentTimestampGroup.completeTimeMs < 0L) {
            throw new IllegalStateException("currentTimestampGroup.completeTimeMs");
        }
        long arrivalTimeDeltaMs = arrivalTimeMs - this.currentTimestampGroup.completeTimeMs;
        long timestampDiff = timestamp - this.currentTimestampGroup.timestamp;
        long tsDeltaMs = (long)(this.timestampToMsCoeff * (double)timestampDiff + 0.5);
        if (tsDeltaMs == 0L) {
            return true;
        }
        long propagationDeltaMs = arrivalTimeDeltaMs - tsDeltaMs;
        return propagationDeltaMs < 0L && arrivalTimeDeltaMs <= 5L;
    }

    public boolean computeDeltas(long timestamp, long arrivalTimeMs, int packetSize, long[] deltas) {
        if (deltas == null) {
            throw new NullPointerException("deltas");
        }
        if (deltas.length != 3) {
            throw new IllegalArgumentException("deltas.length");
        }
        boolean calculatedDeltas = false;
        if (this.currentTimestampGroup.isFirstPacket()) {
            this.currentTimestampGroup.timestamp = timestamp;
            this.currentTimestampGroup.firstTimestamp = timestamp;
        } else {
            if (!this.isPacketInOrder(timestamp)) {
                return false;
            }
            if (this.isNewTimestampGroup(arrivalTimeMs, timestamp)) {
                if (this.prevTimestampGroup.completeTimeMs >= 0L) {
                    deltas[0] = this.currentTimestampGroup.timestamp - this.prevTimestampGroup.timestamp;
                    deltas[1] = this.currentTimestampGroup.completeTimeMs - this.prevTimestampGroup.completeTimeMs;
                    long arrivalTimeDeltaMs = deltas[1];
                    if (arrivalTimeDeltaMs < 0L) {
                        logger.warn("Packets are being reordered on the path from the socket to the bandwidth estimator. Ignoring this packet for bandwidth estimation.");
                        return false;
                    }
                    deltas[2] = (int)(this.currentTimestampGroup.size - this.prevTimestampGroup.size);
                    calculatedDeltas = true;
                }
                this.prevTimestampGroup.copy(this.currentTimestampGroup);
                this.currentTimestampGroup.firstTimestamp = timestamp;
                this.currentTimestampGroup.timestamp = timestamp;
                this.currentTimestampGroup.size = 0L;
            } else {
                this.currentTimestampGroup.timestamp = InterArrival.latestTimestamp(this.currentTimestampGroup.timestamp, timestamp);
            }
        }
        this.currentTimestampGroup.size += (long)packetSize;
        this.currentTimestampGroup.completeTimeMs = arrivalTimeMs;
        return calculatedDeltas;
    }

    private boolean isNewTimestampGroup(long arrivalTimeMs, long timestamp) {
        if (this.currentTimestampGroup.isFirstPacket()) {
            return false;
        }
        if (this.belongsToBurst(arrivalTimeMs, timestamp)) {
            return false;
        }
        long timestampDiff = timestamp - this.currentTimestampGroup.firstTimestamp;
        return timestampDiff > this.kTimestampGroupLengthTicks;
    }

    private boolean isPacketInOrder(long timestamp) {
        if (this.currentTimestampGroup.isFirstPacket()) {
            return true;
        }
        long timestampDiff = TimestampUtils.subtractAsUnsignedInt32(timestamp, this.currentTimestampGroup.firstTimestamp);
        return timestampDiff < 0x80000000L;
    }

    private static class TimestampGroup {
        public long completeTimeMs = -1L;
        public long size = 0L;
        public long firstTimestamp = 0L;
        public long timestamp = 0L;

        private TimestampGroup() {
        }

        public void copy(TimestampGroup source) {
            this.completeTimeMs = source.completeTimeMs;
            this.firstTimestamp = source.firstTimestamp;
            this.size = source.size;
            this.timestamp = source.timestamp;
        }

        public boolean isFirstPacket() {
            return this.completeTimeMs == -1L;
        }
    }
}

