/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules;

import net.java.sip.communicator.impl.protocol.sip.xcap.model.XmlUtils;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ActionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.CommonPolicyParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.TransformationsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ClassType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.OccurrenceIdType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvideDevicePermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvidePersonPermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvideServicePermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.SubHandlingType;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PresRulesParser {
    private static String NAMESPACE = "urn:ietf:params:xml:ns:pres-rules";
    private static String SUBHANDLING_ELEMENT = "sub-handling";
    private static String OCCURRENCE_ID_ELEMENT = "occurrence-id";
    private static String CLASS_ELEMENT = "class";
    private static String PROVIDE_DEVICES_ELEMENT = "provide-devices";
    private static String PROVIDE_DEVICES_ALL_ELEMENT = "all-devices";
    private static String PROVIDE_DEVICES_DEVICEID_ELEMENT = "deviceID";
    private static String PROVIDE_SERVICES_ELEMENT = "provide-services";
    private static String PROVIDE_SERVICES_ALL_ELEMENT = "all-services";
    private static String PROVIDE_SERVICES_SERBICE_URI_ELEMENT = "service-uri";
    private static String PROVIDE_SERVICES_SERBICE_URI_SCHEME_ELEMENT = "service-uri-scheme";
    private static String PROVIDE_PERSONS_ELEMENT = "provide-persons";
    private static String PROVIDE_PERSONS_ALL_ELEMENT = "all-persons";

    public static ActionsType actionsFromElement(Element element) throws Exception {
        ActionsType actions = new ActionsType();
        if (!CommonPolicyParser.NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !CommonPolicyParser.ACTIONS_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("actions element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("actions element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("actions element is invalid");
        }
        SubHandlingType subHandling = null;
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (CommonPolicyParser.NAMESPACE.equals(namespaceUri)) {
                throw new Exception("actions element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri)) {
                if (!SUBHANDLING_ELEMENT.equals(localName) || subHandling != null) {
                    throw new Exception("actions element is invalid");
                }
                subHandling = SubHandlingType.fromString(childElement.getTextContent().toLowerCase());
                continue;
            }
            actions.getAny().add(childElement);
        }
        actions.setSubHandling(subHandling);
        return actions;
    }

    public static Element elementFromActions(Document document, ActionsType actions) throws Exception {
        Element element = document.createElementNS(CommonPolicyParser.NAMESPACE, CommonPolicyParser.ACTIONS_ELEMENT);
        if (actions.getSubHandling() != null) {
            Element subHandlingElement = document.createElementNS(NAMESPACE, SUBHANDLING_ELEMENT);
            subHandlingElement.setTextContent(actions.getSubHandling().value());
            element.appendChild(subHandlingElement);
        }
        XmlUtils.processAny(element, actions.getAny());
        return element;
    }

    public static TransformationsType transformationsFromElement(Element element) throws Exception {
        TransformationsType transfomations = new TransformationsType();
        if (!CommonPolicyParser.NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !CommonPolicyParser.TRANSFORMATIONS_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("transfomations element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("transfomations element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("transfomations element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (CommonPolicyParser.NAMESPACE.equals(namespaceUri)) {
                throw new Exception("transfomations element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri)) {
                if (PROVIDE_DEVICES_ELEMENT.equals(localName)) {
                    transfomations.setDevicePermission(PresRulesParser.devicePermissionFromElement(childElement));
                    continue;
                }
                if (PROVIDE_SERVICES_ELEMENT.equals(localName)) {
                    transfomations.setServicePermission(PresRulesParser.servicePermissionFromElement(childElement));
                    continue;
                }
                if (PROVIDE_PERSONS_ELEMENT.equals(localName)) {
                    transfomations.setPersonPermission(PresRulesParser.personPermissionFromElement(childElement));
                    continue;
                }
                transfomations.getAny().add(childElement);
                continue;
            }
            transfomations.getAny().add(childElement);
        }
        return transfomations;
    }

    public static Element elementFromTransfomations(Document document, TransformationsType transformations) throws Exception {
        Element element = document.createElementNS(CommonPolicyParser.NAMESPACE, CommonPolicyParser.TRANSFORMATIONS_ELEMENT);
        if (transformations.getDevicePermission() != null) {
            element.appendChild(PresRulesParser.elementFromDevicePermission(document, transformations.getDevicePermission()));
        }
        if (transformations.getPersonPermission() != null) {
            element.appendChild(PresRulesParser.elementFromPersonPermission(document, transformations.getPersonPermission()));
        }
        if (transformations.getServicePermission() != null) {
            element.appendChild(PresRulesParser.elementFromServicePermission(document, transformations.getServicePermission()));
        }
        XmlUtils.processAny(element, transformations.getAny());
        return element;
    }

    private static ProvideServicePermissionType servicePermissionFromElement(Element element) throws Exception {
        ProvideServicePermissionType servicePermission = new ProvideServicePermissionType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !PROVIDE_SERVICES_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("provide-services element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("provide-services element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("provide-services element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (NAMESPACE.equals(namespaceUri)) {
                if (PROVIDE_SERVICES_ALL_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("all-services element is invalid");
                    }
                    servicePermission.setAllServices(new ProvideServicePermissionType.AllServicesType());
                    continue;
                }
                if (PROVIDE_SERVICES_SERBICE_URI_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("service-uri element is invalid");
                    }
                    servicePermission.getServiceUriList().add(new ProvideServicePermissionType.ServiceUriType(childElement.getTextContent()));
                    continue;
                }
                if (PROVIDE_SERVICES_SERBICE_URI_SCHEME_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("service-scheme-uri element is invalid");
                    }
                    servicePermission.getServiceUriSchemeList().add(new ProvideServicePermissionType.ServiceUriSchemeType(childElement.getTextContent()));
                    continue;
                }
                if (OCCURRENCE_ID_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("occurrence-id element is invalid");
                    }
                    servicePermission.getOccurrences().add(new OccurrenceIdType(childElement.getTextContent()));
                    continue;
                }
                if (CLASS_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("class element is invalid");
                    }
                    servicePermission.getClasses().add(new ClassType(childElement.getTextContent()));
                    continue;
                }
                throw new Exception("provide-services element is invalid");
            }
            servicePermission.getAny().add(childElement);
        }
        return servicePermission;
    }

    public static Element elementFromServicePermission(Document document, ProvideServicePermissionType serviceService) throws Exception {
        Element element = document.createElementNS(NAMESPACE, PROVIDE_SERVICES_ELEMENT);
        if (serviceService.getAllServices() != null) {
            Element allServices = document.createElementNS(NAMESPACE, PROVIDE_SERVICES_ALL_ELEMENT);
            element.appendChild(allServices);
        } else {
            Element serviceUriElement;
            for (ProvideServicePermissionType.ServiceUriType serviceUri : serviceService.getServiceUriList()) {
                serviceUriElement = document.createElementNS(NAMESPACE, PROVIDE_SERVICES_SERBICE_URI_ELEMENT);
                serviceUriElement.setTextContent(serviceUri.getValue());
                element.appendChild(serviceUriElement);
            }
            for (ProvideServicePermissionType.ServiceUriSchemeType serviceUriSheme : serviceService.getServiceUriSchemeList()) {
                serviceUriElement = document.createElementNS(NAMESPACE, PROVIDE_SERVICES_SERBICE_URI_SCHEME_ELEMENT);
                serviceUriElement.setTextContent(serviceUriSheme.getValue());
                element.appendChild(serviceUriElement);
            }
            for (ClassType classType : serviceService.getClasses()) {
                Element classElement = document.createElementNS(NAMESPACE, CLASS_ELEMENT);
                classElement.setTextContent(classType.getValue());
                element.appendChild(classElement);
            }
            for (OccurrenceIdType occurrence : serviceService.getOccurrences()) {
                Element occurrenceElement = document.createElementNS(NAMESPACE, OCCURRENCE_ID_ELEMENT);
                occurrenceElement.setTextContent(occurrence.getValue());
                element.appendChild(occurrenceElement);
            }
        }
        XmlUtils.processAny(element, serviceService.getAny());
        return element;
    }

    private static ProvideDevicePermissionType devicePermissionFromElement(Element element) throws Exception {
        ProvideDevicePermissionType devicePermission = new ProvideDevicePermissionType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !PROVIDE_DEVICES_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("provide-devices element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("provide-devices element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("provide-devices element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (NAMESPACE.equals(namespaceUri)) {
                if (PROVIDE_DEVICES_ALL_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("all-devices element is invalid");
                    }
                    devicePermission.setAllDevices(new ProvideDevicePermissionType.AllDevicesType());
                    continue;
                }
                if (PROVIDE_DEVICES_DEVICEID_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("deviceID element is invalid");
                    }
                    devicePermission.getDevices().add(new ProvideDevicePermissionType.DeviceIdType(childElement.getTextContent()));
                    continue;
                }
                if (OCCURRENCE_ID_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("occurrence-id element is invalid");
                    }
                    devicePermission.getOccurrences().add(new OccurrenceIdType(childElement.getTextContent()));
                    continue;
                }
                if (CLASS_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("class element is invalid");
                    }
                    devicePermission.getClasses().add(new ClassType(childElement.getTextContent()));
                    continue;
                }
                throw new Exception("provide-devices element is invalid");
            }
            devicePermission.getAny().add(childElement);
        }
        return devicePermission;
    }

    public static Element elementFromDevicePermission(Document document, ProvideDevicePermissionType devicePermission) throws Exception {
        Element element = document.createElementNS(NAMESPACE, PROVIDE_DEVICES_ELEMENT);
        if (devicePermission.getAllDevices() != null) {
            Element allDevices = document.createElementNS(NAMESPACE, PROVIDE_DEVICES_ALL_ELEMENT);
            element.appendChild(allDevices);
        } else {
            for (ProvideDevicePermissionType.DeviceIdType device : devicePermission.getDevices()) {
                Element deviceElement = document.createElementNS(NAMESPACE, PROVIDE_DEVICES_DEVICEID_ELEMENT);
                deviceElement.setTextContent(device.getValue());
                element.appendChild(deviceElement);
            }
            for (ClassType classType : devicePermission.getClasses()) {
                Element classElement = document.createElementNS(NAMESPACE, CLASS_ELEMENT);
                classElement.setTextContent(classType.getValue());
                element.appendChild(classElement);
            }
            for (OccurrenceIdType occurrence : devicePermission.getOccurrences()) {
                Element occurrenceElement = document.createElementNS(NAMESPACE, OCCURRENCE_ID_ELEMENT);
                occurrenceElement.setTextContent(occurrence.getValue());
                element.appendChild(occurrenceElement);
            }
        }
        XmlUtils.processAny(element, devicePermission.getAny());
        return element;
    }

    private static ProvidePersonPermissionType personPermissionFromElement(Element element) throws Exception {
        ProvidePersonPermissionType personPermission = new ProvidePersonPermissionType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !PROVIDE_PERSONS_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("provide-persons element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("provide-persons element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("provide-persons element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (NAMESPACE.equals(namespaceUri)) {
                if (PROVIDE_PERSONS_ALL_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("all-persons element is invalid");
                    }
                    personPermission.setAllPersons(new ProvidePersonPermissionType.AllPersonsType());
                    continue;
                }
                if (OCCURRENCE_ID_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("occurrence-id element is invalid");
                    }
                    personPermission.getOccurrences().add(new OccurrenceIdType(childElement.getTextContent()));
                    continue;
                }
                if (CLASS_ELEMENT.equals(localName)) {
                    if (XMLUtils.hasChildElements((Element)childElement)) {
                        throw new Exception("class element is invalid");
                    }
                    personPermission.getClasses().add(new ClassType(childElement.getTextContent()));
                    continue;
                }
                throw new Exception("provide-persons element is invalid");
            }
            personPermission.getAny().add(childElement);
        }
        return personPermission;
    }

    public static Element elementFromPersonPermission(Document document, ProvidePersonPermissionType personPermission) throws Exception {
        Element element = document.createElementNS(NAMESPACE, PROVIDE_PERSONS_ELEMENT);
        if (personPermission.getAllPersons() != null) {
            Element allPersons = document.createElementNS(NAMESPACE, PROVIDE_PERSONS_ALL_ELEMENT);
            element.appendChild(allPersons);
        } else {
            for (ClassType classType : personPermission.getClasses()) {
                Element classElement = document.createElementNS(NAMESPACE, CLASS_ELEMENT);
                classElement.setTextContent(classType.getValue());
                element.appendChild(classElement);
            }
            for (OccurrenceIdType occurrence : personPermission.getOccurrences()) {
                Element occurrenceElement = document.createElementNS(NAMESPACE, OCCURRENCE_ID_ELEMENT);
                occurrenceElement.setTextContent(occurrence.getValue());
                element.appendChild(occurrenceElement);
            }
        }
        XmlUtils.processAny(element, personPermission.getAny());
        return element;
    }
}

