/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTabbedPaneUI;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommTabbedPaneEnhancedUI
extends SIPCommTabbedPaneUI
implements Skinnable {
    private static Color TAB_HIGHLIGHT_FOREGROUND_COLOR = new Color(DesktopUtilActivator.getResources().getColor("service.gui.TAB_TITLE_HIGHLIGHT"));
    private static Color TAB_SELECTED_FOREGROUND_COLOR = new Color(DesktopUtilActivator.getResources().getColor("service.gui.TAB_TITLE_SELECTED"));
    private static final int TAB_OVERLAP = Integer.parseInt(DesktopUtilActivator.getResources().getSettingsString("impl.gui.TAB_OVERLAP"));
    private static final int PREFERRED_WIDTH = 150;
    private static final String SELECTED_TAB_LEFT_BG = "service.gui.lookandfeel.SELECTED_TAB_LEFT_BG";
    private static final String SELECTED_TAB_MIDDLE_BG = "service.gui.lookandfeel.SELECTED_TAB_MIDDLE_BG";
    private static final String SELECTED_TAB_RIGHT_BG = "service.gui.lookandfeel.SELECTED_TAB_RIGHT_BG";
    private static final String TAB_LEFT_BG = "service.gui.lookandfeel.TAB_LEFT_BG";
    private static final String TAB_MIDDLE_BG = "service.gui.lookandfeel.TAB_MIDDLE_BG";
    private static final String TAB_RIGHT_BG = "service.gui.lookandfeel.TAB_RIGHT_BG";
    protected final List<Integer> highlightedTabs = new Vector<Integer>();

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommTabbedPaneEnhancedUI();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x, y, x + w - 2, y);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x, y, x, y + h - 3);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x + 1, y + h - 3, x + w - 2, y + h - 3);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.setColor(this.shadow.brighter());
        g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabCount() < 1) {
            return;
        }
        g.setColor(this.shadow);
        g.drawLine(x + w - 3, y + 1, x + w - 3, y + h - 3);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
        g.setColor(this.shadow.brighter());
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g = g.create();
        try {
            this.internalPaintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        BufferedImage leftImg = null;
        BufferedImage middleImg = null;
        BufferedImage rightImg = null;
        Graphics2D g2 = (Graphics2D)g;
        AntialiasingManager.activateAntialiasing(g2);
        int tabOverlap = 0;
        if (isSelected) {
            if (this.tabPane.isEnabledAt(tabIndex)) {
                leftImg = DesktopUtilActivator.getImage(SELECTED_TAB_LEFT_BG);
                middleImg = DesktopUtilActivator.getImage(SELECTED_TAB_MIDDLE_BG);
                rightImg = DesktopUtilActivator.getImage(SELECTED_TAB_RIGHT_BG);
                tabOverlap = TAB_OVERLAP;
            } else {
                leftImg = DesktopUtilActivator.getImage(TAB_LEFT_BG);
                middleImg = DesktopUtilActivator.getImage(TAB_MIDDLE_BG);
                rightImg = DesktopUtilActivator.getImage(TAB_RIGHT_BG);
            }
        } else {
            leftImg = DesktopUtilActivator.getImage(TAB_LEFT_BG);
            middleImg = DesktopUtilActivator.getImage(TAB_MIDDLE_BG);
            rightImg = DesktopUtilActivator.getImage(TAB_RIGHT_BG);
        }
        ++y;
        if (!isSelected) {
            y += 2;
        }
        g2.drawImage((Image)leftImg, x, y, null);
        g2.drawImage(middleImg, x + leftImg.getWidth(), y, w - leftImg.getWidth() - rightImg.getWidth() + tabOverlap, leftImg.getHeight(), null);
        g2.drawImage((Image)rightImg, x + w - rightImg.getWidth() + tabOverlap, y, null);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        int titleWidth = SwingUtilities.computeStringWidth(metrics, title);
        int preferredWidth = 0;
        if (this.isOneActionButtonEnabled()) {
            preferredWidth = this.calculateTabWidth(tabPlacement, tabIndex, metrics) - 1 - 15;
            if (this.isCloseEnabled()) {
                preferredWidth -= 15;
            }
            if (this.isMaxEnabled()) {
                preferredWidth -= 15;
            }
        } else {
            preferredWidth = titleWidth;
        }
        while (titleWidth > preferredWidth) {
            title = title.endsWith("...") ? title.substring(0, title.indexOf("...") - 1).concat("...") : title.substring(0, title.length() - 4).concat("...");
            titleWidth = SwingUtilities.computeStringWidth(metrics, title);
        }
        textRect.width = titleWidth;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    g.setColor(TAB_SELECTED_FOREGROUND_COLOR);
                } else if (this.isTabHighlighted(tabIndex)) {
                    g.setColor(TAB_HIGHLIGHT_FOREGROUND_COLOR);
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                BasicGraphicsUtils.drawString(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    private boolean isScrollTabVisible(int tabIndex) {
        Rectangle tabRect = this.rects[tabIndex];
        Rectangle viewRect = this.tabScroller.viewport.getViewRect();
        return tabRect.x + tabRect.width - 15 >= viewRect.x && tabRect.x + 15 <= viewRect.x + viewRect.width;
    }

    @Override
    protected SIPCommTabbedPaneUI.ScrollableTabButton createScrollableTabButton(int direction) {
        return new ScrollableTabButton(direction);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int width = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        if (this.isOneActionButtonEnabled() && width > 150) {
            width = 150;
        }
        return width + 1;
    }

    public void tabAddHightlight(int tabIndex) {
        this.highlightedTabs.add(tabIndex);
    }

    public void tabRemoveHighlight(int tabIndex) {
        Iterator<Integer> highlightedIter = this.highlightedTabs.iterator();
        while (highlightedIter.hasNext()) {
            if (highlightedIter.next() != tabIndex) continue;
            highlightedIter.remove();
            break;
        }
    }

    public boolean isTabHighlighted(int tabIndex) {
        return this.highlightedTabs.contains(tabIndex);
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        TAB_HIGHLIGHT_FOREGROUND_COLOR = new Color(DesktopUtilActivator.getResources().getColor("service.gui.TAB_TITLE_HIGHLIGHT"));
        TAB_SELECTED_FOREGROUND_COLOR = new Color(DesktopUtilActivator.getResources().getColor("service.gui.TAB_TITLE_SELECTED"));
    }

    protected class ScrollableTabButton
    extends SIPCommTabbedPaneUI.ScrollableTabButton {
        private static final long serialVersionUID = 0L;

        public ScrollableTabButton(int direction) {
            super(direction);
            this.setRolloverEnabled(true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, SIPCommTabbedPaneEnhancedUI.this.calculateMaxTabHeight(0));
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isRollOver = this.getModel().isRollover();
            boolean isEnabled = this.isEnabled();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            g.setColor(SIPCommTabbedPaneEnhancedUI.this.shadow);
            if (this.direction == 7) {
                g.drawLine(0, 0, 0, h - 1);
                g.drawLine(w - 1, 0, w - 1, 0);
            } else {
                g.drawLine(w - 2, h - 1, w - 2, 0);
            }
            g.drawLine(0, 0, w - 2, 0);
            if (isRollOver) {
                Color color1;
                Color color2;
                if (isPressed) {
                    color2 = Color.WHITE;
                    color1 = SIPCommTabbedPaneEnhancedUI.this.shadow;
                } else {
                    color1 = Color.WHITE;
                    color2 = SIPCommTabbedPaneEnhancedUI.this.shadow;
                }
                g.setColor(color1);
                if (this.direction == 7) {
                    g.drawLine(1, 1, 1, h - 1);
                    g.drawLine(1, 1, w - 2, 1);
                    g.setColor(color2);
                    g.drawLine(w - 1, h - 1, w - 1, 1);
                } else {
                    g.drawLine(0, 1, 0, h - 1);
                    g.drawLine(0, 1, w - 3, 1);
                    g.setColor(color2);
                    g.drawLine(w - 3, h - 1, w - 3, 1);
                }
            }
            if (h < 5 || w < 5) {
                g.setColor(origColor);
                return;
            }
            if (isPressed) {
                g.translate(1, 1);
            }
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            boolean highlight = false;
            if (!SIPCommTabbedPaneEnhancedUI.this.highlightedTabs.isEmpty() && (this.direction == 7 && SIPCommTabbedPaneEnhancedUI.this.tabScroller.scrollBackwardButton.isEnabled() || this.direction == 3 && SIPCommTabbedPaneEnhancedUI.this.tabScroller.scrollForwardButton.isEnabled())) {
                int i;
                int leadingTabIndex;
                Rectangle viewRect = SIPCommTabbedPaneEnhancedUI.this.tabScroller.viewport.getViewRect();
                if (this.direction == 7) {
                    leadingTabIndex = SIPCommTabbedPaneEnhancedUI.this.getClosestTab(viewRect.x, viewRect.y);
                    for (i = 0; i < leadingTabIndex; ++i) {
                        if (!SIPCommTabbedPaneEnhancedUI.this.highlightedTabs.contains(i) || SIPCommTabbedPaneEnhancedUI.this.isScrollTabVisible(i)) continue;
                        highlight = true;
                        break;
                    }
                } else {
                    for (i = leadingTabIndex = SIPCommTabbedPaneEnhancedUI.this.getClosestTab(viewRect.x + viewRect.y, viewRect.y); i < SIPCommTabbedPaneEnhancedUI.this.tabPane.getTabCount(); ++i) {
                        if (!SIPCommTabbedPaneEnhancedUI.this.highlightedTabs.contains(i) || SIPCommTabbedPaneEnhancedUI.this.isScrollTabVisible(i)) continue;
                        highlight = true;
                        break;
                    }
                }
                if (highlight) {
                    BufferedImage img = DesktopUtilActivator.getImage(this.direction == 7 ? "service.gui.icons.TAB_UNREAD_BACKWARD_ICON" : "service.gui.icons.TAB_UNREAD_FORWARD_ICON");
                    int wi = ((Image)img).getWidth(null);
                    g.drawImage(img, (w - wi) / 2, (h - size) / 2 - 2, null);
                }
            }
            if (!highlight) {
                this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
            }
            if (isPressed) {
                g.translate(-1, -1);
            }
            g.setColor(origColor);
        }
    }
}

