/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.SingleWindowContainer;
import net.java.sip.communicator.impl.gui.main.contactlist.SearchField;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListContainer;
import net.java.sip.communicator.service.gui.UIGroup;

public class ContactListSearchKeyDispatcher
implements KeyEventDispatcher {
    private KeyboardFocusManager keyManager;
    private ContactList contactList;
    private final SearchField searchField;
    private final ContactListContainer contactListContainer;

    public ContactListSearchKeyDispatcher(KeyboardFocusManager keyManager, SearchField searchField, ContactListContainer container) {
        this.keyManager = keyManager;
        this.searchField = searchField;
        this.contactListContainer = container;
    }

    public void setContactList(ContactList contactList) {
        this.contactList = contactList;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        boolean singleWindowRule;
        if (!this.contactListContainer.isFocused()) {
            return false;
        }
        int id = e.getID();
        if (id != 401 && id != 400) {
            return false;
        }
        SingleWindowContainer singleWindowContainer = GuiActivator.getUIService().getSingleWindowContainer();
        if (singleWindowContainer != null && singleWindowContainer.containsFocusOwner()) {
            return false;
        }
        Component focusOwner = this.keyManager.getFocusOwner();
        if (focusOwner != null && !this.searchField.isFocusOwner() && focusOwner instanceof JTextComponent) {
            return false;
        }
        if (this.contactListContainer.isMenuSelected()) {
            return false;
        }
        int keyCode = e.getKeyCode();
        if (keyCode == 10 && (e.isControlDown() || e.isMetaDown())) {
            this.contactListContainer.ctrlEnterKeyTyped();
            return false;
        }
        if (keyCode == 10 && focusOwner.equals(this.keyManager.getPermanentFocusOwner())) {
            this.contactListContainer.enterKeyTyped();
            return false;
        }
        if (this.searchField.isFocusOwner() && (keyCode == 38 || keyCode == 40 || keyCode == 33 || keyCode == 34)) {
            this.contactList.selectFirstContact();
            if (this.contactList instanceof TreeContactList) {
                ((TreeContactList)this.contactList).setAutoSectionAllowed(false);
            }
            this.contactList.getComponent().requestFocus();
            return false;
        }
        if (this.contactList.getComponent().isFocusOwner() && keyCode == 27) {
            this.contactList.removeSelection();
            if (this.contactList instanceof TreeContactList) {
                ((TreeContactList)this.contactList).setAutoSectionAllowed(false);
            }
            if (this.searchField.getText() != null) {
                this.searchField.requestFocus();
            }
            return false;
        }
        char keyChar = e.getKeyChar();
        UIGroup selectedGroup = this.contactList.getSelectedGroup();
        if (keyChar == '\uffff' || keyCode == 10 || keyCode == 127 || keyCode == 8 || keyCode == 9 || e.getKeyChar() == '\t' || keyCode == 32 || selectedGroup != null && (keyChar == '+' || keyChar == '-')) {
            return false;
        }
        boolean bl = singleWindowRule = singleWindowContainer == null || this.contactList.getComponent().isFocusOwner();
        if (!this.searchField.isFocusOwner() && focusOwner != null && singleWindowRule && focusOwner.equals(this.keyManager.getPermanentFocusOwner())) {
            this.searchField.requestFocusInWindow();
            this.keyManager.redispatchEvent((Component)((Object)this.searchField), e);
            return true;
        }
        return false;
    }
}

