/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.AbstractCallToggleButton;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.SoundFileUtils;

public class RecordButton
extends AbstractCallToggleButton {
    private static final Logger logger = Logger.getLogger(RecordButton.class);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd@HH.mm.ss");
    private static final ConfigurationService configuration = GuiActivator.getConfigurationService();
    private static final ResourceManagementService resources = GuiActivator.getResources();
    private static final int MAX_FILENAME_LENGTH = 64;
    private String callFilename;
    private SipCommFileChooser callFileChooser;
    private Recorder recorder;

    public RecordButton(Call call) {
        this(call, false);
    }

    public RecordButton(Call call, boolean selected) {
        super(call, true, selected, ImageLoader.RECORD_BUTTON, ImageLoader.RECORD_BUTTON_PRESSED, null);
        String toolTip = resources.getI18NString("service.gui.RECORD_BUTTON_TOOL_TIP");
        String saveDir = configuration.getString("net.java.sip.communicator.impl.neomedia.SAVED_CALLS_PATH");
        if (saveDir != null && saveDir.length() != 0) {
            toolTip = toolTip + " (" + saveDir + ")";
        }
        this.setToolTipText(toolTip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buttonPressed() {
        if (this.call != null) {
            if (this.isSelected()) {
                boolean startedRecording = false;
                try {
                    startedRecording = this.startRecording();
                }
                finally {
                    if (!startedRecording && this.recorder != null) {
                        try {
                            this.recorder.stop();
                        }
                        finally {
                            this.recorder = null;
                        }
                    }
                    this.setSelected(startedRecording);
                }
            }
            if (this.recorder != null) {
                try {
                    this.recorder.stop();
                }
                finally {
                    this.recorder = null;
                    this.setSelected(false);
                }
            }
        }
    }

    private String createDefaultFilename(String savedCallsPath) {
        String ext;
        if (savedCallsPath == null) {
            try {
                savedCallsPath = GuiActivator.getFileAccessService().getDefaultDownloadDirectory().getAbsolutePath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((ext = configuration.getString("net.java.sip.communicator.impl.neomedia.Recorder.FORMAT")) == null || ext.length() == 0 || !this.isSupportedFormat(ext)) {
            ext = "mp3";
        }
        return (savedCallsPath == null ? "" : savedCallsPath + File.separator) + this.generateCallFilename(ext);
    }

    private String generateCallFilename(String ext) {
        String filename = FORMAT.format(new Date()) + "-call";
        int maxLength = 62 - filename.length() - ext.length();
        String peerName = this.getCallPeerName(maxLength);
        filename = filename + (!peerName.equals("") ? "-" : "") + peerName + "." + ext;
        return filename;
    }

    private String getCallPeerName(int maxLength) {
        List callPeers = this.call.getConference().getCallPeers();
        CallPeer callPeer = null;
        String peerName = "";
        if (!callPeers.isEmpty() && (callPeer = (CallPeer)callPeers.get(0)) != null) {
            peerName = callPeer.getDisplayName();
            if ((peerName = peerName.replaceAll("[^\\da-zA-Z\\_\\-@\\.]", "")).length() > maxLength) {
                peerName = peerName.substring(0, maxLength);
            }
        }
        return peerName;
    }

    private Recorder getRecorder() throws OperationFailedException {
        if (this.recorder == null) {
            OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)this.call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            this.recorder = telephony.createRecorder(this.call);
        }
        return this.recorder;
    }

    private boolean isSupportedFormat(File file) {
        String extension = SoundFileUtils.getExtension((File)file);
        return extension != null && extension.length() != 0 && this.isSupportedFormat(extension);
    }

    private boolean isSupportedFormat(String format) {
        Recorder recorder;
        try {
            recorder = this.getRecorder();
        }
        catch (OperationFailedException ofex) {
            logger.error((Object)"Failed to get Recorder", (Throwable)ofex);
            return false;
        }
        List supportedFormats = recorder.getSupportedFormats();
        return supportedFormats != null && supportedFormats.contains(format);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean startRecording() {
        String callFormat;
        String savedCallsPath = configuration.getString("net.java.sip.communicator.impl.neomedia.SAVED_CALLS_PATH");
        if (savedCallsPath == null || savedCallsPath.length() == 0) {
            if (this.callFileChooser == null) {
                this.callFileChooser = GenericFileDialog.create(null, (String)resources.getI18NString("plugin.callrecordingconfig.SAVE_CALL"), (int)1);
                this.callFileChooser.addFilter(new SipCommFileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || RecordButton.this.isSupportedFormat(f);
                    }

                    public String getDescription() {
                        List supportedFormats;
                        Recorder recorder;
                        StringBuilder description = new StringBuilder();
                        description.append("Recorded call");
                        try {
                            recorder = RecordButton.this.getRecorder();
                        }
                        catch (OperationFailedException ofex) {
                            logger.error((Object)"Failed to get Recorder", (Throwable)ofex);
                            recorder = null;
                        }
                        if (recorder != null && (supportedFormats = recorder.getSupportedFormats()) != null) {
                            description.append(" (");
                            boolean firstSupportedFormat = true;
                            for (String supportedFormat : supportedFormats) {
                                if (firstSupportedFormat) {
                                    firstSupportedFormat = false;
                                } else {
                                    description.append(", ");
                                }
                                description.append("*.");
                                description.append(supportedFormat);
                            }
                            description.append(')');
                        }
                        return description.toString();
                    }
                });
            }
            this.callFileChooser.setStartPath(this.createDefaultFilename(null));
            File selectedFile = this.callFileChooser.getFileFromDialog();
            if (selectedFile == null) return false;
            this.callFilename = selectedFile.getAbsolutePath();
            callFormat = SoundFileUtils.getExtension((File)selectedFile);
            if (callFormat != null && callFormat.length() != 0) {
                if (!this.isSupportedFormat(selectedFile)) {
                    String configuredFormat;
                    if (SoundFileUtils.isSoundFile((File)selectedFile)) {
                        this.callFilename = this.callFilename.substring(0, this.callFilename.lastIndexOf(46));
                    }
                    callFormat = (configuredFormat = configuration.getString("net.java.sip.communicator.impl.neomedia.Recorder.FORMAT")) != null && configuredFormat.length() != 0 ? configuredFormat : "mp3";
                    this.callFilename = this.callFilename + '.' + callFormat;
                }
                configuration.setProperty("net.java.sip.communicator.impl.neomedia.Recorder.FORMAT", (Object)callFormat);
            }
        } else {
            this.callFilename = this.createDefaultFilename(savedCallsPath);
            callFormat = SoundFileUtils.getExtension((File)new File(this.callFilename));
        }
        Throwable exception = null;
        try {
            Recorder recorder = this.getRecorder();
            if (recorder != null) {
                if (callFormat == null || callFormat.length() <= 0) {
                    callFormat = "mp3";
                }
                recorder.start(callFormat, this.callFilename);
            }
            this.recorder = recorder;
        }
        catch (IOException ioex) {
            exception = ioex;
        }
        catch (MediaException mex) {
            exception = mex;
        }
        catch (OperationFailedException ofex) {
            exception = ofex;
        }
        if (this.recorder != null && exception == null) return true;
        logger.error((Object)("Failed to start recording call " + this.call + " into file " + this.callFilename), exception);
        return false;
    }
}

