/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.securityconfig;

import java.awt.Component;
import java.util.Collection;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.securityconfig.SecurityConfigActivator;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class SecurityConfigurationPanel
extends SIPCommTabbedPane
implements ServiceListener {
    private static final long serialVersionUID = 0L;

    public SecurityConfigurationPanel() {
        this.init();
        SecurityConfigActivator.bundleContext.addServiceListener((ServiceListener)this);
    }

    private void init() {
        Collection confFormsRefs;
        String osgiFilter = "(FORM_TYPE=SECURITY_TYPE)";
        try {
            confFormsRefs = SecurityConfigActivator.bundleContext.getServiceReferences(ConfigurationForm.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            confFormsRefs = null;
        }
        if (confFormsRefs != null && !confFormsRefs.isEmpty()) {
            for (ServiceReference sr : confFormsRefs) {
                ConfigurationForm form = (ConfigurationForm)SecurityConfigActivator.bundleContext.getService(sr);
                Object formComponent = form.getForm();
                if (!(formComponent instanceof Component)) continue;
                this.addConfigForm(form);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        Object service;
        ServiceReference ref = event.getServiceReference();
        Object property = ref.getProperty("FORM_TYPE");
        if (!"SECURITY_TYPE".equals(property)) {
            return;
        }
        try {
            service = SecurityConfigActivator.bundleContext.getService(ref);
        }
        catch (IllegalStateException ex) {
            return;
        }
        if (!(service instanceof ConfigurationForm)) {
            return;
        }
        ConfigurationForm cfgForm = (ConfigurationForm)service;
        if (!cfgForm.isAdvanced()) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                Object formComponent = cfgForm.getForm();
                if (!(formComponent instanceof Component)) break;
                this.addConfigForm(cfgForm);
                break;
            }
            case 4: {
                Object formComponent = cfgForm.getForm();
                if (!(formComponent instanceof Component)) break;
                this.remove((Component)formComponent);
            }
        }
    }

    private void addConfigForm(ConfigurationForm form) {
        int index = form.getIndex();
        String title = form.getTitle();
        Component component = (Component)form.getForm();
        if (index >= this.getTabCount()) {
            this.addTab(title, component);
        } else {
            this.insertTab(title, null, component, title, index);
        }
    }
}

