/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DNSStateTask
extends DNSTask {
    static Logger logger1 = Logger.getLogger(DNSStateTask.class.getName());
    private final int _ttl;
    private static int _defaultTTL = 3600;
    private DNSState _taskState = null;

    public abstract String getTaskDescription();

    public static int defaultTTL() {
        return _defaultTTL;
    }

    public static void setDefaultTTL(int value) {
        _defaultTTL = value;
    }

    public DNSStateTask(JmDNSImpl jmDNSImpl, int ttl) {
        super(jmDNSImpl);
        this._ttl = ttl;
    }

    public int getTTL() {
        return this._ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(DNSState state) {
        JmDNSImpl jmDNSImpl = this.getDns();
        synchronized (jmDNSImpl) {
            this.getDns().associateWithTask(this, state);
        }
        for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
            ((ServiceInfoImpl)serviceInfo).associateWithTask(this, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociation() {
        JmDNSImpl jmDNSImpl = this.getDns();
        synchronized (jmDNSImpl) {
            this.getDns().removeAssociationWithTask(this);
        }
        for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
            ((ServiceInfoImpl)serviceInfo).removeAssociationWithTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DNSOutgoing out = new DNSOutgoing(0);
        try {
            if (!this.checkRunCondition()) {
                this.cancel();
                return;
            }
            ArrayList<DNSStatefulObject> stateObjects = new ArrayList<DNSStatefulObject>();
            JmDNSImpl jmDNSImpl = this.getDns();
            synchronized (jmDNSImpl) {
                if (this.getDns().isAssociatedWithTask(this, this.getTaskState())) {
                    logger1.finer(this.getName() + ".run() JmDNS " + this.getTaskDescription() + " " + this.getDns().getName());
                    stateObjects.add(this.getDns());
                    out = this.buildOutgoingForDNS(out);
                }
            }
            for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
                ServiceInfoImpl info;
                ServiceInfoImpl serviceInfoImpl = info = (ServiceInfoImpl)serviceInfo;
                synchronized (serviceInfoImpl) {
                    if (info.isAssociatedWithTask(this, this.getTaskState())) {
                        logger1.fine(this.getName() + ".run() JmDNS " + this.getTaskDescription() + " " + info.getQualifiedName());
                        stateObjects.add(info);
                        out = this.buildOutgoingForInfo(info, out);
                    }
                }
            }
            if (out.isEmpty()) {
                this.advanceObjectsState(stateObjects);
                this.cancel();
                return;
            }
            logger1.finer(this.getName() + ".run() JmDNS " + this.getTaskDescription() + " #" + (Object)((Object)this.getTaskState()));
            this.getDns().send(out);
            this.advanceObjectsState(stateObjects);
        }
        catch (Throwable e) {
            logger1.log(Level.WARNING, this.getName() + ".run() exception ", e);
            this.recoverTask(e);
        }
        this.advanceTask();
    }

    protected abstract boolean checkRunCondition();

    protected abstract DNSOutgoing buildOutgoingForDNS(DNSOutgoing var1) throws IOException;

    protected abstract DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl var1, DNSOutgoing var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void advanceObjectsState(List<DNSStatefulObject> list) {
        if (list != null) {
            Iterator<DNSStatefulObject> i$ = list.iterator();
            while (i$.hasNext()) {
                DNSStatefulObject object;
                DNSStatefulObject dNSStatefulObject = object = i$.next();
                synchronized (dNSStatefulObject) {
                    object.advanceState(this);
                }
            }
        }
    }

    protected abstract void recoverTask(Throwable var1);

    protected abstract void advanceTask();

    protected DNSState getTaskState() {
        return this._taskState;
    }

    protected void setTaskState(DNSState taskState) {
        this._taskState = taskState;
    }
}

