/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.loggingutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.java.sip.communicator.plugin.loggingutils.LoggingUtilsActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.util.OSUtils;

public class LogsCollector {
    private static final Logger logger = Logger.getLogger(LogsCollector.class);
    static final String LOGGING_DIR_NAME = "log";
    private static final String JAVA_ERROR_LOG_PREFIX = "hs_err_pid";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd@HH.mm.ss");
    private static Pattern JAVA_ERROR_LOG_PATTERN = Pattern.compile(Pattern.quote("sip.communicator"), 2);

    public static File collectLogs(File destination, File optional) {
        if (destination == null) {
            return null;
        }
        if (!destination.isDirectory()) {
            if (!destination.getName().endsWith("zip")) {
                destination = new File(destination.getParentFile(), destination.getName() + ".zip");
            }
        } else {
            destination = new File(destination, LogsCollector.getDefaultFileName());
        }
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(destination));
            LogsCollector.collectHomeFolderLogs(out);
            LogsCollector.collectJavaCrashLogs(out);
            if (optional != null) {
                LogsCollector.addFileToZip(optional, out);
            }
            out.close();
            return destination;
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)"Error creating logs file archive", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)"Error closing archive file", (Throwable)ex);
        }
        return null;
    }

    public static String getDefaultFileName() {
        return FORMAT.format(new Date()) + "-logs.zip";
    }

    private static void collectHomeFolderLogs(ZipOutputStream out) {
        try {
            File[] fs;
            for (File f : fs = LoggingUtilsActivator.getFileAccessService().getPrivatePersistentDirectory(LOGGING_DIR_NAME, FileCategory.LOG).listFiles()) {
                if (f.getName().endsWith(".lck")) continue;
                LogsCollector.addFileToZip(f, out);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error obtaining logs folder", (Throwable)e);
        }
    }

    private static void addFileToZip(File file, ZipOutputStream out) {
        byte[] buf = new byte[1024];
        try {
            int len;
            FileInputStream in = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(LOGGING_DIR_NAME + File.separator + file.getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)"Error obtaining file to archive", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)"Error saving file to archive", (Throwable)ex);
        }
    }

    private static void collectJavaCrashLogs(ZipOutputStream out) {
        LogsCollector.addCrashFilesToArchive(new File(".").listFiles(), JAVA_ERROR_LOG_PREFIX, out);
        String homeDir = System.getProperty("user.home");
        if (OSUtils.IS_WINDOWS) {
            File[] desktopFiles = new File(homeDir + File.separator + "Desktop").listFiles();
            LogsCollector.addCrashFilesToArchive(desktopFiles, JAVA_ERROR_LOG_PREFIX, out);
        }
        if (OSUtils.IS_MAC) {
            String[] locations;
            String logDir = "/Library/Logs/";
            for (String location : locations = new String[]{logDir + "CrashReporter", homeDir + logDir + "CrashReporter", homeDir + logDir + "DiagnosticReports"}) {
                File[] crashLogs = new File(location).listFiles();
                LogsCollector.addCrashFilesToArchive(crashLogs, null, out);
            }
        } else {
            File[] tempFiles = new File(System.getProperty("java.io.tmpdir")).listFiles();
            LogsCollector.addCrashFilesToArchive(tempFiles, JAVA_ERROR_LOG_PREFIX, out);
        }
    }

    private static void addCrashFilesToArchive(File[] files, String filterStartsWith, ZipOutputStream out) {
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (filterStartsWith != null && !f.getName().startsWith(filterStartsWith) || !LogsCollector.isOurCrashLog(f)) continue;
            LogsCollector.addFileToZip(f, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isOurCrashLog(File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!JAVA_ERROR_LOG_PATTERN.matcher(line).find());
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

