/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.util;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import org.ice4j.util.QueueStatistics;

public abstract class PacketQueue<T> {
    private static final Logger logger = Logger.getLogger(PacketQueue.class.getName());
    private static final int DEFAULT_CAPACITY = 256;
    private static final int CACHE_CAPACITY = 100;
    private final Queue<T> queue;
    private final boolean copy;
    private final int capacity;
    private final QueueStatistics queueStatistics;
    private final Thread thread;
    private final PacketHandler<T> handler;
    private final String id;
    private boolean closed = false;
    private int numDroppedPackets = 0;

    public static boolean logDroppedPacket(int numDroppedPackets) {
        return numDroppedPackets == 1 || numDroppedPackets <= 1000 && numDroppedPackets % 100 == 0 || numDroppedPackets % 1000 == 0;
    }

    public PacketQueue() {
        this(false, "PacketQueue", null);
    }

    public PacketQueue(boolean enableStatistics, String id, PacketHandler<T> packetHandler) {
        this(256, true, enableStatistics, id, packetHandler);
    }

    public PacketQueue(int capacity, boolean copy, boolean enableStatistics, String id, PacketHandler<T> packetHandler) {
        this.copy = copy;
        this.capacity = capacity;
        this.id = id;
        this.queue = new ArrayBlockingQueue<T>(capacity);
        QueueStatistics queueStatistics = this.queueStatistics = enableStatistics ? new QueueStatistics(id) : null;
        if (packetHandler != null) {
            this.handler = packetHandler;
            this.thread = new Thread(){

                @Override
                public void run() {
                    PacketQueue.this.runInReadingThread();
                }
            };
            this.thread.setName(this.getClass().getName() + "-" + id);
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.thread = null;
            this.handler = null;
        }
        logger.fine("Initialized a PacketQueue instance with ID " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInReadingThread() {
        if (Thread.currentThread() != this.thread) {
            logger.warning("runInReadingThread executing in " + Thread.currentThread());
            return;
        }
        if (this.handler == null) {
            logger.warning("No handler set, the reading thread will be stopped.");
            return;
        }
        while (!this.closed) {
            T pkt;
            Queue<T> queue = this.queue;
            synchronized (queue) {
                pkt = this.queue.poll();
                if (pkt == null) {
                    try {
                        this.queue.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.queueStatistics != null) {
                this.queueStatistics.remove(System.currentTimeMillis());
            }
            try {
                this.handler.handlePacket(pkt);
            }
            catch (Exception e) {
                logger.warning("Failed to handle packet: " + e);
            }
        }
    }

    public void add(byte[] buf, int off, int len) {
        this.add(buf, off, len, null);
    }

    public void add(byte[] buf, int off, int len, Object context) {
        if (this.copy) {
            byte[] newBuf = this.getByteArray(len);
            System.arraycopy(buf, off, newBuf, 0, len);
            this.doAdd(this.createPacket(newBuf, 0, len, context));
        } else {
            this.doAdd(this.createPacket(buf, off, len, context));
        }
    }

    public void add(T pkt) {
        if (this.copy) {
            this.add(this.getBuffer(pkt), this.getOffset(pkt), this.getLength(pkt), this.getContext(pkt));
        } else {
            this.doAdd(pkt);
        }
    }

    private byte[] getByteArray(int len) {
        return new byte[len];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(T pkt) {
        if (this.closed) {
            return;
        }
        Queue<T> queue = this.queue;
        synchronized (queue) {
            T p;
            if (this.queue.size() >= this.capacity && (p = this.queue.poll()) != null) {
                if (this.queueStatistics != null) {
                    this.queueStatistics.remove(System.currentTimeMillis());
                }
                if (PacketQueue.logDroppedPacket(++this.numDroppedPackets)) {
                    logger.warning("Packets dropped (id=" + this.id + "): " + this.numDroppedPackets);
                }
            }
            if (this.queueStatistics != null) {
                this.queueStatistics.add(System.currentTimeMillis());
            }
            this.queue.offer(pkt);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.handler != null) {
            throw new IllegalStateException("Trying to read from a queue with a configured handler.");
        }
        while (!this.closed) {
            Queue<T> queue = this.queue;
            synchronized (queue) {
                T pkt = this.queue.poll();
                if (pkt != null) {
                    if (this.queueStatistics != null) {
                        this.queueStatistics.remove(System.currentTimeMillis());
                    }
                    return pkt;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        if (this.closed) {
            return null;
        }
        if (this.handler != null) {
            throw new IllegalStateException("Trying to read from a queue with a configured handler.");
        }
        Queue<T> queue = this.queue;
        synchronized (queue) {
            T pkt = this.queue.poll();
            if (pkt != null && this.queueStatistics != null) {
                this.queueStatistics.remove(System.currentTimeMillis());
            }
            return pkt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            this.closed = true;
            Queue<T> queue = this.queue;
            synchronized (queue) {
                this.queue.notifyAll();
            }
        }
    }

    public abstract byte[] getBuffer(T var1);

    public abstract int getOffset(T var1);

    public abstract int getLength(T var1);

    public abstract Object getContext(T var1);

    protected abstract T createPacket(byte[] var1, int var2, int var3, Object var4);

    public static interface PacketHandler<T> {
        public boolean handlePacket(T var1);
    }
}

